<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par un script autorisé
if ( !defined('OK') )  exit();

// Ce fichier est la page d'accueil de l'interface d'administration. Il ne peut
//  être lancé que par index.php, si aucun argument n'est fourni. On est donc
//  déjà passé par debut.php et la connexion MySQL est déjà ouverte.

//////////////
//// HTML ////
//////////////
// Haut de page, menu et message
$p = 'monaccueil';
$t = 'Mon Cahier de Prépa';
$mysqli = new mysqli($serveur,$base,$mdp,$base);
$mysqli->set_charset('utf8');
include('haut.php');

// Récupération de l'identifiant de la matière
$resultat = $mysqli->query("SELECT id, colles, cdt, docs FROM matieres WHERE cle='${_SESSION['mat']}'");
$r = $resultat->fetch_assoc();
$resultat->free();
$mat = $r['id'];
?>

  <div class="item">
    <p>Bienvenue sur l'interface d'administration de Cahier de Prépa.</p>
    <p>Cette page propose des possibilités de modifications rapide, mais vous pouvez gérer beaucoup plus de choses grâce aux liens du menu&nbsp;!</p>
  </div>

  <div class="annonce">
    <ul>
      <li>Les problèmes de connexion sécurisée via Internet Explorer sont normalement réparés.</li>
      <li>Nouvelle fonctionnalité&nbsp;: si vous souhaitez entrer une formule en LaTex, cela fonctionne&nbsp;! Par exemple, si vous tapez <code>$x=\sqrt(2)$</code>, cela devrait donner $x=\sqrt(2)$. Fonctionne aussi en mode paragraphe avec <code>$$x=\sqrt(2)$$</code> ou <code>\[x=\sqrt(2)\]</code>.</li>
    </ul>
  </div>
  
<?php
////////////////////////////////
// Nouveau programme de colle //
////////////////////////////////
// Fonction d'affichage des semaines
function format_date($date)  {
  $semaine = array('dimanche','lundi','mardi','mercredi','jeudi','vendredi','samedi');
  $mois = array('','janvier','février','mars','avril','mai','juin','juillet','août','septembre','octobre','novembre','décembre');
  return $semaine[substr($date,0,1)].' '.substr($date,7).' '.$mois[intval(substr($date,5,2))].' '.substr($date,1,4);
}

// Récupération des semaines
$resultat = $mysqli->query("SELECT s.id AS sid, DATE_FORMAT(s.debut,'%w%Y%m%e') AS d, s.colle, s.vacances, c.id AS cid, c.cache
                            FROM semaines AS s
                            LEFT JOIN (SELECT id, semaine, cache FROM colles WHERE matiere = $mat) AS c ON c.semaine=s.id");
$select_semaines = '';
if ( $resultat->num_rows )  {
  while ( $r = $resultat->fetch_assoc() )  {
    switch ( $r['vacances'] )  {
      case 0:
        if ( $r['colle'] )  {
          if ( is_null($r['cid']) )
            $select_semaines .= "\n        <option value=\"${r['sid']}\">".format_date($r['d']).' (à remplir)</option>';
          elseif ( $r['cache'] )
            $select_semaines .= "\n        <option value=\"${r['sid']}\">".format_date($r['d']).' (caché)</option>';
          else
            $select_semaines .= "\n        <option value=\"${r['sid']}\">".format_date($r['d']).'</option>';
        }
        else
          $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>".format_date($r['d']).' (pas de colle)</option>';
        break;
      case 1:
        $select_semaines .= "        <option value=\"${r['sid']}\" disabled>Vacances de Toussaint</option>\n";
        break;
      case 2:
        $select_semaines .= "        <option value=\"${r['sid']}\" disabled>Vacances de Noël</option>\n";
        break;
      case 3:
        $select_semaines .= "        <option value=\"${r['sid']}\" disabled>Vacances d'hiver</option>\n";
        break;
      case 4:
        $select_semaines .= "        <option value=\"${r['sid']}\" disabled>Vacances de Pâques</option>\n";
        break;
    }
  }
  $resultat->free();
}
else  {
  $mysqli->close();
  include('installation.php');
}
?>

  <div class="item admin">
  <form action="colles?<?php echo "${_SESSION['mat']}$urladmin"; ?>" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications">
    <h3>Enregistrer un programme de colles</h3>
    <p class="ligne"><label for="id">Semaine&nbsp;: </label>
      <select name="id">
<?php echo $select_semaines; ?>
      </select>
    </p>
    <textarea name="texte" rows="10" cols="100"></textarea>
    <p class="ligne"><label for="cache">N'est pas diffusé sur la partie publique&nbsp;: </label><input type="checkbox" id="cache" name="cache" value="1"></p>
  </form>
  </div>
<?php
///////////////////////
// Envoi de document //
///////////////////////
// Récupération des répertoires, dans le bon ordre pour un select
function liste($rid,$n)  {
  $resultat = $GLOBALS['mysqli']->query("SELECT id, nom, parents FROM reps WHERE parent = $rid");
  while ( $r = $resultat->fetch_assoc() )  {
    $GLOBALS['select_reps'] .= "        <option value=\"${r['id']}\">".str_repeat('&rarr;',$n)."${r['nom']}</option>\n";
    liste($r['id'],$n+1);
  }
  $resultat->free();
}
$select_reps = '';
liste(0,0);
// Sélection automatique du répertoire racine de la matière
$resultat = $mysqli->query("SELECT id FROM reps WHERE matiere = $mat AND parent = 0");
$r = $resultat->fetch_assoc();
$resultat->free();
$select_reps = str_replace("\"${r['id']}\"","\"${r['id']}\" selected",$select_reps);
?>

  <div class="item admin">
  <form action="docs_admin" method="post" enctype="multipart/form-data">
    <input class="bouton" type="submit" name="envoie" value="Envoyer">
    <h3>Déposer un fichier</h3>
    <p class="ligne"><label for="nom">Nom à afficher&nbsp;: </label><input type="text" id="nom" name="nom" value="" size="50"></p>
    <p class="ligne"><label for="fichier">Fichier&nbsp;: </label><input type="file" name="fichier"></p>
    <p class="ligne"><label for="rep">Répertoire&nbsp;: </label>
      <select id="rep" name="rep">
<?php echo $select_reps; ?>
      </select>
    </p>
    <p class="ligne"><label for="protection">Accès&nbsp;: </label>
      <select id="protection" name="protection"><option value="0">Visible de tous</option><option value="1">Avec mot de passe</option><option value="2">Caché</option></select>
    </p>
  </form>
  </div>
<?php
//////////////////////////
// Nouvelle information //
//////////////////////////
$resultat = $mysqli->query('SELECT cle, nom FROM pages');
$select_pages = '';
while ( $r = $resultat->fetch_assoc() )
  $select_pages .= "        <option value=\"${r['cle']}\">${r['nom']}</option>\n";
$resultat->free();
?>

  <div class="item admin">
  <form action=".<?php echo str_replace('&amp;','?',$urladmin); ?>" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications sur le titre ou le texte">
    <h3>Enregistrer une nouvelle information</h3>
    <p class="ligne"><label for="page">Page&nbsp;: </label>
      <select id="page" name="page">
<?php echo $select_pages; ?>
      </select>
    </p>
    <input class="ligne" type="text" name="titre" size=50 maxlength=65533 value="Titre">
    <textarea name="texte" rows="6" cols="100"><p>Texte</p></textarea>
    <p class="ligne"><label for="cache">Ne pas publier immédiatement (information cachée)&nbsp;: </label><input type="checkbox" id="cache" name="cache" value="1"></p>
    <input type="hidden" name="id" value="">
  </form>
  </div>
<?php
//////////////////
// Mot de passe //
//////////////////
// Récupération de l'identifiant de l'utilisateur
$resultat = $mysqli->query("SELECT id FROM utilisateurs WHERE nom = '${_SESSION['user']}'");
$r = $resultat->fetch_assoc();
$resultat->free();
?>

  <div class="item admin">
  <form action="utilisateurs" method="post">
    <input class="bouton" type="submit" name="modifie_mdp" value="Valider" title="Valider les modifications">
    <h3>Modifier mon mot de passe</h3>
    <p class="ligne"><label for="mdp0">Mot de passe actuel&nbsp;: </label><input type="password" id="mdp0" name="mdp0" value=""></p>
    <p class="ligne"><label for="mdp1">Nouveau&nbsp;: </label><input type="password" id="mdp1" name="mdp1" value=""></p>
    <p class="ligne"><label for="mdp2">Confirmation&nbsp;: </label><input type="password" id="mdp2" name="mdp2" value=""></p>
    <input type="hidden" name="id" value="<?php echo $r['id']; ?>">
  </form>
  </div>
<?php
////////////////////////////////////
// Matière concernée et affichage //
////////////////////////////////////
// Récupération des données de la matière
$resultat = $mysqli->query("SELECT cle, nom, colles, cdt FROM matieres WHERE id = $mat");
$r = $resultat->fetch_assoc();
$resultat->free();
$colles = str_replace("${r['colles']}\"","${r['colles']}\" selected",'<option value="0">Ne pas afficher</option><option value="1">Afficher sans mot de passe</option><option value="2">Afficher avec mot de passe</option>');
$cdt = str_replace("${r['cdt']}\"","${r['cdt']}\" selected",'<option value="0">Ne pas afficher</option><option value="1">Afficher sans mot de passe</option><option value="2">Afficher avec mot de passe</option>');
?>

  <div class="item admin">
  <form action="matieres" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications">
    <h3>Modifier l'affichage de ma matière</h3>
    <p class="ligne"><label for="nom">Nom complet&nbsp;: </label><input type="text" id="nom" name="nom" value="<?php echo $r['nom']; ?>" size="50"></p>
    <p class="ligne"><label for="cle">Clé dans l'adresse&nbsp;: </label><input type="text" id="cle" name="cle" value="<?php echo $r['cle']; ?>" size="30"></p>
    <p class="ligne"><label for="colles">Programme de colles</label>
      <select id="colles" name="colles"><?php echo $colles; ?></select>
    </p>
    <p class="ligne"><label for="cdt">Cahier de texte</label>
      <select id="cdt" name="cdt"><?php echo $cdt; ?></select>
    </p>
    <input type="hidden" name="id" value="<?php echo $mat; ?>">
  </form>
  </div>

  <script type="text/javascript">
$( function() {
  $('.item h3').append(' <span>[déplier]</span>');
  $(".item h3 span").css('cursor','pointer').click( function () {
    $(this).parent().parent().find('.bouton,.ligne,textarea').toggle();
    $(this).text($(this).text() == '[déplier]' ? '[replier]' : '[déplier]');
  });
  $('form').find('.bouton,.ligne,textarea').hide();
});
  </script>

  <script type="text/javascript" src="js/textarea.js"></script>

<?php
$mysqli->close();
// Bas de page
include('bas.php');
exit();
?>
