<?php
// Sécurité et récupération des données de configuration
// Mode admin obligatoire (OK=2)
define('OK',2);
include('debut.php');

// Recherche de la matière concernée
$mysqli = premiere_connexion();
$mysqli->set_charset('utf8');
$resultat = $mysqli->query('SELECT id, cle, nom FROM matieres WHERE cdt');
if ( $resultat->num_rows )  {
  if ( !empty($_REQUEST) )
    while ( $r = $resultat->fetch_assoc() )
      if ( isset($_REQUEST[$r['cle']]) )  {
        $matiere = $r;
        break;
      }
  // Matière par défaut : la première
  if ( !isset($matiere) )  {
    $resultat->data_seek(0);
    $matiere = $resultat->fetch_assoc();
  }
  $resultat->free();
}
// Si aucune matière présentant son programme de colles n'est enregistrée
else
  exit('Cette page ne contient aucune information.');

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
  $mysqli->set_charset('utf8');
  
  // Traitement d'un ajout/modification
  if ( isset($_REQUEST['modifie']) )  {
    // Vérification des données envoyées
    if ( !strlen($_REQUEST['nom']) )
      $message = 'Il n\'est pas possible de valider un nom vide. Pour supprimer un raccourci, il faut cliquer sur Supprimer.';
    else  {
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('cdt-seances');
      // Validation des données envoyées
      $nom = $mysqli->real_escape_string($_REQUEST['nom']);
      $jour = ( is_numeric($_REQUEST['jour']) ) ? $_REQUEST['jour'] : 1;
      $h_debut = preg_replace('/(\d{1,2})h(\d{2})/','$1:$2',$_REQUEST['h_debut']);
      $h_fin = preg_replace('/(\d{1,2})h(\d{2})/','$1:$2',$_REQUEST['h_fin']);
      $type = ( is_numeric($_REQUEST['tid']) ) ? $_REQUEST['tid'] : "(SELECT t.id FROM `cdt-types` AS t WHERE t.matiere=${matiere['id']} LIMIT 1)";
      $demigroupe = ( isset($_REQUEST['demigroupe']) ) ? 1 : 0;
      // Si identifiant, modification d'un raccourci existant
      if ( $id )
        $message = ( $mysqli->query("UPDATE `cdt-seances` SET nom = '$nom', jour = $jour, h_debut = '$h_debut', h_fin = '$h_fin',
                                     type = $type, demigroupe = $demigroupe WHERE id = $id")
        ) ? 'Le raccourci «&nbsp;'.stripslashes($nom).'&nbsp;» a bien été modifiée.' : 'Le raccourci «&nbsp;'.stripslashes($nom).'&nbsp;» n\'a pas pu être modifiée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      // Sinon, nouveau raccourci
      else  {
        $message = ( $mysqli->query("INSERT INTO `cdt-seances` SET matiere = ${matiere['id']},
                                     ordre = (SELECT IFNULL(max(cs.ordre)+1,1) FROM `cdt-seances` AS cs WHERE cs.matiere = ${matiere['id']}),
                                     nom = '$nom', jour = $jour, h_debut = '$h_debut', h_fin = '$h_fin', type = $type, demigroupe = $demigroupe")
                  && $mysqli->query('ALTER TABLE `cdt-seances` ORDER BY ordre,matiere')
        ) ? 'Le raccourci «&nbsp;'.stripslashes($nom).'&nbsp;» a bien été ajouté.' : 'Le raccourci «&nbsp;'.stripslashes($nom).'&nbsp;» n\'a pas pu être ajouté. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      }
    }
  }

  // Traitement d'une transformation/suppression
  else  {
    
    // Vérification de l'existence et récupération de l'ordre d'affichage
    $resultat = $mysqli->query("SELECT ordre, nom, (SELECT max(ordre) FROM `cdt-seances` WHERE matiere = ${matiere['id']}) AS max
                                FROM `cdt-seances` WHERE id = $id");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $ordre = $r['ordre'];
      $resultat->free();

      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('cdt-seances');

      // Déplacement vers le haut
      if ( isset($_REQUEST['monte']) && ( $ordre > 1 ) )
        $message = ( $mysqli->query("UPDATE `cdt-seances` SET ordre = (2*$ordre-1-ordre) WHERE ( ordre = $ordre OR ordre = ($ordre-1) ) AND matiere = ${matiere['id']}")
                  && $mysqli->query('ALTER TABLE `cdt-seances` ORDER BY ordre,matiere')
        ) ? "Le raccourci «&nbsp;${r['nom']}&nbsp;» a bien été monté d'une place." : "Le raccourci «&nbsp;${r['nom']}&nbsp;» n'a pas pu être déplacé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

      // Déplacement vers le bas
      elseif ( isset($_REQUEST['descend']) && ( $ordre < $r['max'] ) )
        $message = ( $mysqli->query("UPDATE `cdt-seances` SET ordre = (2*$ordre+1-ordre) WHERE ( ordre = $ordre OR ordre = ($ordre+1) ) AND matiere = ${matiere['id']}")
                  && $mysqli->query('ALTER TABLE `cdt-seances` ORDER BY ordre,matiere')
        ) ? "Le raccourci «&nbsp;${r['nom']}&nbsp;» a bien été descendu d'une place." : "Le raccourci «&nbsp;${r['nom']}&nbsp;» n'a pas pu être déplacé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

      // Suppression
      elseif ( isset($_REQUEST['supprime']) )
        $message =  ( $mysqli->query("DELETE FROM `cdt-seances` WHERE id = $id")
                   && $mysqli->query("UPDATE `cdt-seances` SET ordre = (ordre-1) WHERE ordre > $ordre AND matiere = ${matiere['id']}")
        ) ? "Le raccourci «&nbsp;${r['nom']}&nbsp;» a bien été supprimé." : "Le raccourci «&nbsp;${r['nom']}&nbsp;» n'a pas pu être supprimé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }
  }

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = new mysqli($serveur,$base,$mdp,$base);
  $mysqli->set_charset('utf8');
}

//////////////
//// HTML ////
//////////////
$p = "cdt?${matiere['cle']}";
$t = "Modification du cahier de texte - ${matiere['nom']}";
// Haut de page, menu et message
include('haut.php');

// Aide générale
echo <<<FIN

  <div class="item aide">
    <p>Vous pouvez ci-dessous modifier les différentes séances de votre semaine, les déplacer, les supprimer. L'intérêt est que chaque séance correspondra, sur vos page de saisie du cahier de texte, à un bouton de raccourci qui saisira automatiquement les champs type, date, heures et demi-groupe. Ces modifications sont propres à votre matière.</p>
    <p>Le <em>nom</em> sera affiché sur le bouton. L'ordre définit leur ordre d'apparition.</p>
  </div>
  <div class="item">
    <p>Vous pouvez aussi <a href="cdt-types?${matiere['cle']}$urladmin">modifier les types d'entrées</a> de votre cahier de texte. Pour revenir à votre cahier de texte, <a href="cdt?${matiere['cle']}$urladmin">c'est par ici&nbsp;!</a></p>
  </div>


FIN;

// Selects pour les formulaires
$semaine = '
        <option value="1">Lundi</option>
        <option value="2">Mardi</option>
        <option value="3">Mercredi</option>
        <option value="4">Jeudi</option>
        <option value="5">Vendredi</option>
        <option value="6">Samedi</option>
        <option value="0">Dimanche</option>
';
$types = '';
$resultat = $mysqli->query("SELECT id, cle FROM `cdt-types` WHERE matiere = ${matiere['id']}");
while ( $r = $resultat->fetch_assoc() )
  $types .= "\n        <option value=\"${r['id']}\">".ucfirst($r['cle']).'</option>';
$resultat->free();

// Fonction d'affichage
function affichage($r)  {
  if ( $r['id'] )  {
    $debut = "Raccourci n°${r['ordre']}";
    $valide1 = '';
    $valide = "\n      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $monte = ( $r['ordre'] == 1 ) ? '' : "\n      <input type=\"submit\" name=\"monte\" value=\"&uarr;\" title=\"Remonter le raccourci dans l'ordre d'apparition\">";
    $descend = ( $r['ordre'] == $GLOBALS['max'] ) ? '' : "\n      <input type=\"submit\" name=\"descend\" value=\"&darr;\" title=\"Descendre le raccourci dans l'ordre d'apparition\">";
    $suppr = ( $GLOBALS['max'] == 1 ) ? '' : "\n      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer le raccourci\">";
    $types = str_replace("\"${r['type']}\"","\"${r['type']}\" selected",$GLOBALS['types']);
    $semaine = str_replace("\"${r['jour']}\"","\"${r['jour']}\" selected",$GLOBALS['semaine']);
  }
  else  {
    $debut = 'Nouveau raccourci';
    $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $valide = $monte = $descend = $suppr = '';
    $types = $GLOBALS['types'];
    $semaine = $GLOBALS['semaine'];
  }
  echo <<<FIN
  <div class="item admin">
  <form action="?${GLOBALS['mat']}${GLOBALS['urladmin']}" method="post">$valide1
    <h3>$debut</h3>
    <p class="boutons">$valide$monte$descend$suppr
    </p>
    <p class="ligne"><label for="nom">Nom&nbsp;: </label><input type="input" id="nom" name="nom" value="${r['nom']}" size="50"></p>
    <p class="ligne"><label for="tid">Type&nbsp;:</label>
      <select id="tid" name="tid">$types
      </select>
    </p>
    <p class="ligne"><label for="jour">Jour&nbsp;:</label>
      <select id="jour" name="jour">$semaine
      </select>
    </p>
    <p class="ligne"><label for="h_debut">Heure de début&nbsp;: </label><input type="text" class="heure" id="h_debut" name="h_debut" value="${r['h_debut']}" size="5"></p>
    <p class="ligne"><label for="h_fin">Heure de fin&nbsp;: </label><input type="text" class="heure" id="h_fin" name="h_fin" value="${r['h_fin']}" size="5"></p>
    <p class="ligne"><label for="demigroupe">Séance en demi-groupe&nbsp;: </label><input type="checkbox" id="demigroupe" name="demigroupe" value="1"${r['demigroupe']}></p>
    <input type="hidden" name="id" value="${r['id']}">
  </form>
  </div>


FIN;
  
}

// Formulaire vide pour un nouveau type
$mat = $matiere['cle'];
affichage(array('id' => 0, 'nom' => '', 'jour' => 1, 'type' => 0, 'h_debut' => '08h00', 'h_fin' => '10h00', 'demigroupe' => ''));

// Affichage des types
$resultat = $mysqli->query("SELECT max(ordre) FROM `cdt-seances` WHERE matiere = ${matiere['id']}");
if ( $resultat->num_rows )  {
  $r = $resultat->fetch_row();
  $max = $r[0];
  $resultat->free();
  $resultat = $mysqli->query("SELECT id, ordre, nom, jour, type, IF(demigroupe=1,' checked','') AS demigroupe,
                              TIME_FORMAT(h_debut,'%Hh%i') AS h_debut, TIME_FORMAT(h_fin,'%Hh%i') AS h_fin
                              FROM `cdt-seances` WHERE matiere = ${matiere['id']}");
  $mysqli->close();
  while ( $r = $resultat->fetch_assoc() )
    affichage($r);
  $resultat->free();
}

echo <<<FIN

  <script type="text/javascript">
$( function() {
  $('.heure').timeEntry({timeSteps: [1, 30, 0],separator: 'h'});
});
  </script>

FIN;
// Bas de page
include('bas.php');
?>
