<?php
// Sécurité et récupération des données de configuration
// Mode admin obligatoire (OK=2)
define('OK',2);
include('debut.php');

// Recherche de la matière concernée
$mysqli = premiere_connexion();
$mysqli->set_charset('utf8');
$resultat = $mysqli->query('SELECT id, cle, nom FROM matieres WHERE cdt');
if ( $resultat->num_rows )  {
  if ( !empty($_REQUEST) )
    while ( $r = $resultat->fetch_assoc() )
      if ( isset($_REQUEST[$r['cle']]) )  {
        $matiere = $r;
        break;
      }
  // Matière par défaut : la première
  if ( !isset($matiere) )  {
    $resultat->data_seek(0);
    $matiere = $resultat->fetch_assoc();
  }
  $resultat->free();
}
// Si aucune matière présentant son programme de colles n'est enregistrée
else
  exit('Cette page ne contient aucune information.');

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
  $mysqli->set_charset('utf8');
  
  // Traitement d'un ajout/modification
  if ( isset($_REQUEST['modifie']) )  {
    // Vérification des données envoyées
    if ( !strlen($_REQUEST['titre']) ||  !strlen($_REQUEST['cle']) )
      $message = 'Il n\'est pas possible de valider un titre ou une clé vide. Pour supprimer un type, il faut cliquer sur Supprimer (et il faut qu\'aucune entrée de ce type-là soit dans le cahier de texte pour voir ce bouton).';
    else  {
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('cdt-types');
      // Validation des données envoyées
      $titre = $mysqli->real_escape_string($_REQUEST['titre']);
      $cle = $mysqli->real_escape_string($_REQUEST['cle']);
      $h_fin = ( isset($_REQUEST['h_fin']) ) ? 1 : 0;
      // Si identifiant, modification d'un type existant
      if ( $id )
        $message = ( $mysqli->query("UPDATE `cdt-types` SET titre = '$titre', cle = '$cle', h_fin = $h_fin WHERE id = $id")
        ) ? 'Le type «&nbsp;'.stripslashes($titre).'&nbsp;» a bien été modifiée.' : 'Le type «&nbsp;'.stripslashes($titre).'&nbsp;» n\'a pas pu être modifiée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      // Sinon, nouveau type
      else  {
        $message = ( $mysqli->query("INSERT INTO `cdt-types` SET matiere = ${matiere['id']},
                                     ordre = (SELECT max(ct.ordre)+1 FROM `cdt-types` AS ct WHERE ct.matiere = ${matiere['id']}),
                                     titre = '$titre', cle = '$cle', h_fin = $h_fin")
                  && $mysqli->query('ALTER TABLE `cdt-types` ORDER BY ordre,matiere')
        ) ? 'Le type «&nbsp;'.stripslashes($titre).'&nbsp;» a bien été ajouté.' : 'Le type «&nbsp;'.stripslashes($titre).'&nbsp;» n\'a pas pu être ajouté. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      }
    }
  }

  // Traitement d'une transformation/suppression
  else  {
    
    // Vérification de l'existence et récupération de l'ordre d'affichage
    $resultat = $mysqli->query("SELECT ordre, titre, (SELECT max(ordre) FROM `cdt-types` WHERE matiere = ${matiere['id']}) AS max
                                FROM `cdt-types` WHERE id = $id");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $ordre = $r['ordre'];
      $resultat->free();

      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('cdt-types');

      // Déplacement vers le haut
      if ( isset($_REQUEST['monte']) && ( $ordre > 1 ) )
        $message = ( $mysqli->query("UPDATE `cdt-types` SET ordre = (2*$ordre-1-ordre) WHERE ( ordre = $ordre OR ordre = ($ordre-1) ) AND matiere = ${matiere['id']}")
                  && $mysqli->query('ALTER TABLE `cdt-types` ORDER BY ordre,matiere')
        ) ? "Le type «&nbsp;${r['titre']}&nbsp;» a bien été monté d'une place." : "Le type «&nbsp;${r['titre']}&nbsp;» n'a pas pu être déplacé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

      // Déplacement vers le bas
      elseif ( isset($_REQUEST['descend']) && ( $ordre < $r['max'] ) )
        $message = ( $mysqli->query("UPDATE `cdt-types` SET ordre = (2*$ordre+1-ordre) WHERE ( ordre = $ordre OR ordre = ($ordre+1) ) AND matiere = ${matiere['id']}")
                  && $mysqli->query('ALTER TABLE `cdt-types` ORDER BY ordre,matiere')
        ) ? "Le type «&nbsp;${r['titre']}&nbsp;» a bien été descendu d'une place." : "Le type «&nbsp;${r['titre']}&nbsp;» n'a pas pu être déplacé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

      // Suppression
      elseif ( isset($_REQUEST['supprime']) && ( $r['max'] > 1 ) )  {
        // Ne pas supprimer un type utilisé dans le cahier de texte.
        $resultat = $mysqli->query("SELECT id FROM cdt WHERE type = $id AND matiere = ${matiere['id']}");
        if ( $resultat->num_rows )  {
          $resultat->free();
          $message = "Le type «&nbsp;${r['titre']}&nbsp;» n'a pas pu être supprimé car des entrées du cahier de texte sont de ce type. Il faut d'abord les supprimer.";
        }
        else
          $message =  ( $mysqli->query("DELETE FROM `cdt-types` WHERE id = $id")
                     && $mysqli->query("UPDATE `cdt-types` SET ordre = (ordre-1) WHERE ordre > $ordre AND matiere = ${matiere['id']}")
          ) ? "Le type «&nbsp;${r['titre']}&nbsp;» a bien été supprimé." : "Le type «&nbsp;${r['titre']}&nbsp;» n'a pas pu être supprimé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      }
    }
  }

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = new mysqli($serveur,$base,$mdp,$base);
  $mysqli->set_charset('utf8');
}

//////////////
//// HTML ////
//////////////
$p = "cdt?${matiere['cle']}";
$t = "Modification du cahier de texte - ${matiere['nom']}";
// Haut de page, menu et message
include('haut.php');

// Aide générale
echo <<<FIN

  <div class="item aide">
    <p>Vous pouvez ci-dessous modifier les différents types d'entrée de votre cahier de texte, les déplacer, les supprimer. Ces modifications sont propres à votre matière.</p>
    <p>Le <em>titre</em> sera affiché au début de chaque entrée. Il doit s'agit d'un nom singulier et commençant par une majuscule. Il peut être relativement long. Par exemple&nbsp;: «&nbsp;Séance de travaux pratiques&nbsp;», «&nbsp;Interrogation de cours&nbsp;»</p>
    <p>La <em>clé</em> sera affichée dans le menu déroulant de recherche, précédé de «&nbsp;les&nbsp», ainsi que dans l'adresse des pages qui affichent ce type d'entrée&nbsp;: il faut donc que ce soit un pluriel, court, en un mot, sans majucule au début (sauf s'il le faut). Par exemple, «&nbsp;TP&nbsp;», «&nbsp;interros&nbsp;»</p>
    <p>Si la case <em>Affiche l'heure de fin</em> est décoché, les entrées de ce type n'auront qu'une heure de début&nbsp;: ce peut être le cas pour les événements qui ne durent pas (interrogations de cours par exemple).</p>
    <p>Pour supprimer un type, il faut qu'aucune entrée de ce type n'existe dans le cahier de texte.</p>
  </div>
  <div class="item">
    <p>Vous pouvez aussi <a href="cdt-seances?${matiere['cle']}$urladmin">définir vos séances hebdomadaires</a>, et créer ainsi des boutons de raccourcis qui pré-rempliront les champs type, date, heures et demi-groupe. Pour revenir à votre cahier de texte, <a href="cdt?${matiere['cle']}$urladmin">c'est par ici&nbsp;!</a></p>
  </div>


FIN;

// Fonction d'affichage
function affichage($r)  {
  if ( $r['id'] )  {
    $debut = "Type n°${r['ordre']}";
    if ( $r['n'] )
      $debut .= ( $r['n'] > 1 ) ? " (${r['n']} entrées dans le cahier de texte)" : " (${r['n']} entrée dans le cahier de texte)";
    $valide1 = '';
    $valide = "\n      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $monte = ( $r['ordre'] == 1 ) ? '' : "\n      <input type=\"submit\" name=\"monte\" value=\"&uarr;\" title=\"Remonter le type dans l'ordre d'apparition\">";
    $descend = ( $r['ordre'] == $GLOBALS['max'] ) ? '' : "\n      <input type=\"submit\" name=\"descend\" value=\"&darr;\" title=\"Descendre le type dans l'ordre d'apparition\">";
    $suppr = ( ( $GLOBALS['max'] == 1 ) || ( $r['n'] ) ) ? '' : "\n      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer le type\">";
  }
  else  {
    $debut = 'Nouveau type';
    $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $valide = $monte = $descend = $suppr = '';
  }
  echo <<<FIN
  <div class="item admin">
  <form action="?${GLOBALS['mat']}${GLOBALS['urladmin']}" method="post">$valide1
    <h3>$debut</h3>
    <p class="boutons">$valide$monte$descend$suppr
    </p>
    <p class="ligne"><label for="titre">Titre (singulier)&nbsp;: </label><input type="input" id="titre" name="titre" value="${r['titre']}" size="50"></p>
    <p class="ligne"><label for="cle">Clé (pluriel)&nbsp;: </label><input type="input" id="cle" name="cle" value="${r['cle']}" size="50"></p>
    <p class="ligne"><label for="h_fin">Affiche une heure de fin de séance&nbsp;: </label><input type="checkbox" id="h_fin" name="h_fin" value="1"${r['h_fin']}></p>
    <input type="hidden" name="id" value="${r['id']}">
  </form>
  </div>


FIN;
  
}

// Formulaire vide pour un nouveau type
$mat = $matiere['cle'];
affichage(array('id' => 0, 'titre' => '', 'cle' => '', 'h_fin' => ''));

// Affichage des types
$resultat = $mysqli->query("SELECT max(ordre) FROM `cdt-types` WHERE matiere = ${matiere['id']}");
$r = $resultat->fetch_row();
$max = $r[0];
$resultat->free();
$resultat = $mysqli->query("SELECT ct.id, ct.ordre, ct.titre, ct.cle, IF(ct.h_fin=1,' checked','') AS h_fin, COUNT(cdt.id) AS n
                            FROM `cdt-types` AS ct LEFT JOIN cdt ON cdt.type = ct.id 
                            WHERE ct.matiere = ${matiere['id']} GROUP BY ct.ordre");
$mysqli->close();
if ( $resultat->num_rows )  {
  while ( $r = $resultat->fetch_assoc() )
    affichage($r);
  $resultat->free();
}

// Bas de page
include('bas.php');
?>
