<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php');

///////////////////////////////////////////////
// Validation de la requête : matière, n, nb //
///////////////////////////////////////////////

// Recherche de la matière concernée
$mysqli = premiere_connexion();
$mysqli->set_charset('utf8');
$resultat = $mysqli->query('SELECT id, cle, nom, cdt FROM matieres WHERE cdt');
if ( $resultat->num_rows )  {
  if ( !empty($_REQUEST) )
    while ( $r = $resultat->fetch_assoc() )
      if ( isset($_REQUEST[$r['cle']]) )  {
        $matiere = $r;
        break;
      }
  // Matière par défaut : la première
  if ( !isset($matiere) )  {
    $resultat->data_seek(0);
    $matiere = $resultat->fetch_assoc();
  }
  $resultat->free();
}
// Si aucune matière présentant son programme de colles n'est enregistrée
else
  exit('Cette page ne contient aucune information.');

// Fonction d'affichage des semaines
function format_date($date)  {
  $semaine = array('dimanche','lundi','mardi','mercredi','jeudi','vendredi','samedi');
  $mois = array('','janvier','février','mars','avril','mai','juin','juillet','août','septembre','octobre','novembre','décembre');
  return $semaine[substr($date,0,1)].' '.substr($date,7).' '.$mois[intval(substr($date,5,2))].' '.substr($date,1,4);
}

// Récupération des semaines
$resultat = $mysqli->query("SELECT id, DATE_FORMAT(debut,'%w%Y%m%e') AS debut, vacances FROM semaines");
$semaines = '';
if ( $resultat->num_rows )  {
  while ( $r = $resultat->fetch_assoc() )  {
    switch ( $r['vacances'] )  {
      case 0:
        $semaines .= "\n        <option value=\"${r['id']}\">".format_date($r['debut']).'</option>';
        $sid[] = $r['id'];
        break;
      case 1:
        $semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances de Toussaint</option>";
        break;
      case 2:
        $semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances de Noël</option>";
        break;
      case 3:
        $semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances d'hiver</option>";
        break;
      case 4:
        $semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances de Pâques</option>";
        break;
    }
  }
  $resultat->free();
}
else  {
  $mysqli->close();
  include('installation.php');
}

// Validation de n (numéro de semaine à voir)
if ( isset($_REQUEST['n']) && is_numeric($n = $_REQUEST['n']) )  {
  if ( !in_array($n,$sid) )
    $n = 1;
}
// Sans argument, on souhaite afficher la semaine actuelle
else {
 $date = ( isset($_REQUEST['date']) && preg_match('/\d{4}-\d{2}-\d{2}/',$_REQUEST['date']) ) ? '\''.trim($_REQUEST['date'],'\'').'\'' : 'NOW()';
  $resultat = $mysqli->query("SELECT IF(vacances,(SELECT id FROM semaines WHERE debut > $date AND vacances = 0 LIMIT 1),id) AS id
                              FROM semaines WHERE debut < $date ORDER BY debut DESC LIMIT 1");
  if ( $resultat->num_rows )  {
    $r = $resultat->fetch_assoc();
    $n = $r['id'];
    $resultat->free();
  }
  else
    $n = 1;
}
$m = array_search($n,$sid);

// Validation de nb (nombre de semaines à voir)
if ( isset($_REQUEST['nb']) && is_numeric($nb = $_REQUEST['nb']) )  {
  if ( $nb < 1 )
    $nb = 1;
  if ( $nb > count($sid) - $m )
    $nb = count($sid) - $m;
}
else
  // Par défaut : affichage d'une seule semaine
  $nb = 1;

///////////////////
// Modifications //
///////////////////
if ( ( $admin ) && isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
  $mysqli->set_charset('utf8');

  // Traitement d'un ajout/modification
  if ( isset($_REQUEST['modifie']) && strlen($_REQUEST['texte']) )  {
    
    // Validation du jour : à mettre dans la bonne semaine
    $jour = preg_replace('/(\d{2})\/(\d{2})\/(\d{4})/','$3-$2-$1',$_REQUEST['jour']);
    $resultat = $mysqli->query("SELECT id FROM semaines WHERE debut <= '$jour' ORDER BY debut DESC LIMIT 1");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $resultat->free();
      // Correction évetuelle de n et nb pour que l'entrée soit visible après enregistrement
      $s = array_search($r['id'],$sid);
      if ( ( $s < $m ) || ( $m+$nb <= $s ) )  {
        echo $n = $r['id'];
        echo $m = array_search($n,$sid);
        $nb = 1;
      }
      
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('cdt');
      
      // Validation des autres données envoyées
      $h_debut = preg_replace('/(\d{1,2})h(\d{2})/','$1:$2',$_REQUEST['h_debut']);
      $h_fin = preg_replace('/(\d{1,2})h(\d{2})/','$1:$2',$_REQUEST['h_fin']);
      $pour = preg_replace('/(\d{2})\/(\d{2})\/(\d{4})/','$3-$2-$1',$_REQUEST['pour']);
      $tid = ( is_numeric($_REQUEST['tid']) ) ? $_REQUEST['tid'] : "(SELECT t.id FROM `cdt-types` AS t WHERE t.matiere=${matiere['id']} LIMIT 1)";
      $texte = $mysqli->real_escape_string($_REQUEST['texte']);
      $demigroupe = ( isset($_REQUEST['demigroupe']) ) ? 1 : 0;

      // Si $id > 0 : modification d'une entrée existante. Si $id = 0, nouvelle entrée
      if ( $id )
        $message = ( $mysqli->query("UPDATE cdt SET semaine = ${r['id']},
                                     jour = '$jour', h_debut = '$h_debut', h_fin = '$h_fin', pour = '$pour',
                                     type = $tid, texte = '$texte', demigroupe = $demigroupe WHERE id = $id")
                  && $mysqli->query("ALTER TABLE cdt ORDER BY jour,matiere,h_debut,type")
        ) ? 'L\'entrée du cahier de texte a bien été modifiée.' : 'L\'entrée du cahier de texte n\'a pas pu être modifiée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      else  {
        $cache = ( isset($_REQUEST['cache']) ) ? 1 : 0;
        $message = ( $mysqli->query("INSERT INTO cdt SET semaine = ${r['id']}, matiere = ${matiere['id']},
                                     jour = '$jour', h_debut = '$h_debut', h_fin = '$h_fin', pour = '$pour',
                                     type = $tid, texte = '$texte', demigroupe = $demigroupe, cache = $cache")
                  && $mysqli->query("ALTER TABLE cdt ORDER BY jour,matiere,h_debut,type")
        ) ? 'L\'entrée du cahier de texte a bien été ajoutée.' : 'L\'entrée du cahier de texte n\'a pas pu être ajoutée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      }
    }
    else
      $message = 'La date demandée n\'est pas valable.';
  }
  
  // Traitement d'une transformation/suppression
  elseif ( isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )  {

    // Vérification que l'identifiant est valide
    $resultat = $mysqli->query("SELECT id FROM cdt WHERE matiere = ${matiere['id']} AND id = $id");
    if ( $resultat->num_rows ) {
      $r = $resultat->fetch_assoc();
      $resultat->free();
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('cdt');

      // Positionnement "montré" (apparaît publiquement)
      if ( isset($_REQUEST['montre']) )
        $message = ( $mysqli->query("UPDATE cdt SET cache = 0 WHERE id = $id")
        ) ? 'L\'entrée du cahier de texte a bien été réaffichée&nbsp;: elle apparaît à nouveau dans la partie publique.' : 'L\'entrée du cahier de texte n\'a pas pu être réaffichée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';

      // Positionnement "caché" (n'apparaît plus publiquement)
      elseif ( isset($_REQUEST['cache']) )
        $message = ( $mysqli->query("UPDATE cdt SET cache = 1 WHERE id = $id")
        ) ? 'L\'entrée du cahier de texte a bien été cachée&nbsp;: elle n\'apparaît plus dans la partie publique.' : 'L\'entrée du cahier de texte n\'a pas pu être cachée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';

      // Suppression
      elseif ( isset($_REQUEST['supprime']) || !strlen($texte) )
        $message = ( $mysqli->query("DELETE FROM cdt WHERE id = $id")
        ) ? 'L\'entrée du cahier de texte a bien été supprimée.' : 'L\'entrée du cahier de texte n\'a pas pu être supprimée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }
  }
  
  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = new mysqli($serveur,$base,$mdp,$base);
  $mysqli->set_charset('utf8');
}

////////////
/// HTML ///
////////////
$p = "cdt?${matiere['cle']}";
$t = "Cahier de texte - ${matiere['nom']}";

// Demander l'authentification si la page est protégée et l'utilisateur non connecté
if ( ( $matiere['cdt'] == 2 ) && !$admin && !$lecteur )
  include('login_lecture.php');
// Haut de page, menu et message
include('haut.php');

// Formulaire de demande d'affichage
$semaines = str_replace("\"$n\"","\"$n\" selected",$semaines);
$types = $recherche_types = '';
$resultat = $mysqli->query("SELECT cle FROM `cdt-types` WHERE matiere = ${matiere['id']}");
if ( isset($_REQUEST['type']) )
  while ( $r = $resultat->fetch_assoc() )  {
    if ( $r['cle'] == $_REQUEST['type'] )  {
      $types .= "\n        <option value=\"${r['cle']}\" selected>les ${r['cle']}</option>";
      $recherche_types = " AND t.cle = '${r['cle']}'";
    }
    else
      $types .= "\n        <option value=\"${r['cle']}\">les ${r['cle']}</option>"; 
  }
else
  while ( $r = $resultat->fetch_assoc() )
    $types .= "\n        <option value=\"${r['cle']}\">les ${r['cle']}</option>";  
$resultat->free();

$u = strlen($urladmin) ? "\n    <input type=\"hidden\" name=\"admin\" value=\"\">" : '';
echo <<<FIN
  <div class="item" id="recherche">
  <form action="" method="get">
    <input type="hidden" name="${matiere['cle']}" value="">
    <p>Afficher&nbsp;
      <select name="type">
        <option value="tout">tout</option>$types
      </select>
      pendant&nbsp;<input type="text" name="nb" value="$nb" size="2">&nbsp;semaine(s) à partir du&nbsp;
      <select name="n">$semaines
      </select>
      <input type="submit" name="" value="OK">
    </p>$u
  </form>
  </div>


FIN;

// Aide générale pour l'interface d'administration
if ( $admin )  {
  $u = str_replace('&amp;','?',$urladmin);
  echo <<<FIN
  <div class="item aide">
    <p>Vous pouvez ci-dessous modifier votre cahier de texte. Vous pouvez choisir les semaines à afficher ci-dessus.</p>
    <p>Les semaines sont réglables <a href="semaines">ici</a>.</p>
    <p>Il est possible de garder caché une entrée, pour prendre de l'avance et l'afficher plus tard par exemple.</p>
    <p>La page affichant ce cahier de texte peut être protégée par mot de passe. Ceci est réglable <a href=".$u">en bas de votre page d'accueil</a> ou <a href="matiere?${matiere['cle']}$urladmin">sur la page de votre matière</a>.</p>
    <p>Vous pouvez supprimer une entrée par le bouton <em>Supprimer</em> ou en validant un texte vide.</p>
  </div>
  <div class="item">
    <p>Vous pouvez <a href="cdt-types?${matiere['cle']}$urladmin">modifier les types d'entrées</a> de votre cahier de texte. Vous pouvez aussi <a href="cdt-seances?${matiere['cle']}$urladmin">définir vos séances hebdomadaires</a>, et créer ainsi des boutons de raccourcis qui pré-rempliront les champs type, date, heures et demi-groupe. Toutes ces modifications ne concerneront que votre matière, et n'impacteront pas vos collègues.</p>
  </div>


FIN;

  // Select des types d'entrée différent du précédent
  $types = '';
  $resultat = $mysqli->query("SELECT id, cle FROM `cdt-types` WHERE matiere = ${matiere['id']}");
  while ( $r = $resultat->fetch_assoc() )
    $types .= "\n        <option value=\"${r['id']}\">".ucfirst($r['cle']).'</option>';
  $resultat->free();
}

// Liens de navigation vers semaines précédentes/suivantes
$nav = '  <div class="item">';
if ( $m )
  $nav .= "\n    <a id=\"prec\" href=\"?${matiere['cle']}&amp;n=". $sid[max($m-$nb,0)] ."&amp;nb=$nb$urladmin\">Semaines précédentes</a>";
if (  $m+$nb < count($sid) )
  $nav .= "\n    <a id=\"suiv\" href=\"?${matiere['cle']}&amp;n=". $sid[$m+$nb] ."&amp;nb=$nb$urladmin\">Semaines suivantes</a>";
$nav .= "\n  </div>\n\n";
echo $nav;

// Fonction d'affichage
function affichage($r)  {
  $semaine = array('','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi');
    // Formatage des horaires
    if ( substr($r['pour'],0,2) == '00' )  {
      $pour = '';
      $heure = ( strlen($r['h_fin']) ) ? " de ${r['h_debut']} à ${r['h_fin']}" : " à ${r['h_debut']}";
    }
    else  {
      $pour = " pour le ${r['pour']}";
      $heure = '';
    }
  // Affichage partie administrative
  if ( $GLOBALS['admin'] )  {
    if ( $r['id'] )  {
      $debut = "${semaine[$r['jour']]} ${r['date']}$heure&nbsp;: ${r['titre']}${r['demigroupe']}$pour";
      $valide1 = '';
      $valide = "\n      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
      $suppr = "\n      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer l'entrée\">";
      $cache_nouveau = '';
      if ( $r['cache'] )  {
        $debut .= ' (entrée cachée, non présente sur le site public)';
        $cache_classe = ' cache';
        $cache = "\n      <input type=\"submit\" name=\"montre\" value=\"Montrer\" title=\"Montrer l'entrée, la rendre visible depuis le site public\">";
      }
      else  {
        $cache_classe = '';
        $cache = "\n      <input type=\"submit\" name=\"cache\" value=\"Cacher\" title=\"Cacher l'entrée, la rendre invisible depuis le site public\">";
      }
    }
    else  {
      $debut = 'Nouvelle entrée du cahier';
      $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
      $valide = $cache = $cache_classe = $suppr = '';
      $cache_nouveau = "\n    <p class=\"ligne\"><label for=\"cache\">Ne pas publier immédiatement (entrée cachée)&nbsp;: </label><input type=\"checkbox\" id=\"cache\" name=\"cache\" value=\"1\"></p>";
    }
    $demigroupe = ( strlen($r['demigroupe']) ) ? ' checked' : '';
    $types = str_replace("\"${r['tid']}\"","\"${r['tid']}\" selected",$GLOBALS['types']);
    $type = ( isset($_REQUEST['type']) ) ? "&amp;type=${_REQUEST['type']}" : '';
    echo <<<FIN
  <div class="item cdt admin$cache_classe">
  <form action="${GLOBALS['p']}&amp;n=${GLOBALS['n']}&amp;nb=${GLOBALS['nb']}$type${GLOBALS['urladmin']}" method="post">$valide1
    <p class="titre">$debut</p>
    <p class="boutons">$valide$cache$suppr
    </p>
    <p class="ligne"><label for="tid">Type&nbsp;:</label>
      <select id="tid" name="tid">$types
      </select>
    </p>
    <p class="ligne"><label for="jour">Jour&nbsp;: </label><input type="text" class="date" id="jour" name="jour" value="${r['date']}" size="8"></p>
    <p class="ligne"><label for="h_debut">Heure de début&nbsp;: </label><input type="text" class="heure" id="h_debut" name="h_debut" value="${r['h_debut']}" size="5"></p>
    <p class="ligne"><label for="h_fin">Heure de fin&nbsp;: </label><input type="text" class="heure" id="h_fin" name="h_fin" value="${r['h_fin']}" size="5"></p>
    <p class="ligne"><label for="pour">Pour le&nbsp;: </label><input type="text" class="date" name="pour" value="${r['pour']}" size="8"></p>
    <p class="ligne"><label for="demigroupe">Séance en demi-groupe&nbsp;: </label><input type="checkbox" id="demigroupe" name="demigroupe" value="1"$demigroupe></p>
    <textarea name="texte" rows="10" cols="100">${r['texte']}</textarea>$cache_nouveau
    <input type="hidden" name="id" value="${r['id']}">
  </form>
  </div>


FIN;
  }
  elseif ( !$r['cache'] )
    // Affichage partie publique
    echo <<<FIN
    <div class="item cdt">
      <p class="titre">${semaine[$r['jour']]} ${r['date']}$heure&nbsp;: ${r['titre']}${r['demigroupe']}$pour</p>
      <div>
  ${r['texte']}
      </div>
    </div>


FIN;
}

// Gestion des titres de nouvelles semaines
$resultat = $mysqli->query("SELECT id, DATE_FORMAT(debut,'%w%Y%m%e') AS debut, vacances 
                            FROM semaines WHERE id BETWEEN $n AND ${sid[$m+$nb-1]}" );
$semaines = array(0=>'');
while ( $r = $resultat->fetch_assoc() )
  switch ( $r['vacances'] )  {
    case 0:
      $semaines[$r['id']] = 'Semaine du '.format_date($r['debut']);
      break;
    case 1:
      $semaines[$r['id']] = ucfirst(format_date($r['debut']))."&nbsp;: Vacances de Toussaint";
      break;
    case 2:
      $semaines[$r['id']] = ucfirst(format_date($r['debut']))."&nbsp;: Vacances de Noël";
      break;
    case 3:
      $semaines[$r['id']] = ucfirst(format_date($r['debut']))."&nbsp;: Vacances d'hiver";
      break;
    case 4:
      $semaines[$r['id']] = ucfirst(format_date($r['debut']))."&nbsp;: Vacances de Pâques";
      break;
  }
$resultat->free();

// Récupération des entrées
$resultat = $mysqli->query("SELECT cdt.id, cdt.texte, cdt.semaine, DATE_FORMAT(cdt.pour,'%d/%m/%Y') AS pour,
                            DATE_FORMAT(cdt.jour,'%w') AS jour, DATE_FORMAT(cdt.jour,'%d/%m/%Y') AS date,
                            TIME_FORMAT(cdt.h_debut,'%kh%i') AS h_debut, IF(t.h_fin,TIME_FORMAT(cdt.h_fin,'%kh%i'),'') AS h_fin,
                            IF(cdt.demigroupe,' (en demi-groupe)','') AS demigroupe, cdt.cache, t.id AS tid, t.titre
                            FROM cdt LEFT JOIN `cdt-types` AS t ON t.matiere = ${matiere['id']} AND t.id = cdt.type
                            WHERE cdt.semaine BETWEEN $n AND ${sid[$m+$nb-1]} AND cdt.matiere = ${matiere['id']} $recherche_types");

// Affichage des résultats
if ( $resultat->num_rows )  {
  $s = $j = 0;
  $semaine = array('','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi');

  while ( $r = $resultat->fetch_assoc() )  {
    
    // Affichage d'une div par jour
    if ( ( $j != $r['jour'] ) || ( $s != $r['semaine'] ) )  {
      if ( $j )
        echo "  </div>\n\n";
        // Nouvelle semaine
        while ( ( $s != $r['semaine'] ) && next($semaines) )  {
          echo '  <h2 class="cdtsemaine">'.current($semaines)."</h2>\n\n";
          $s = key($semaines);
        }
      echo "  <div class=\"cdtjour\">\n\n";
      $j = $r['jour'];
    }
    affichage($r);
  }
  $resultat->free();
  echo "  </div>\n\n";
  // Liens de navigation vers semaines précédentes/suivantes
  echo $nav;
}
else  {
  if ( !isset($_REQUEST['type']) || ( $_REQUEST['type'] == 'tout' ) )
    echo "  <h2>Le cahier de texte est vide pour les semaines choisies.</h2>\n\n";
  else
    echo "  <h2>Le cahier de texte ne contient pas de «&nbsp;${_REQUEST['type']}&nbsp;» pour les semaines choisies.</h2>\n\n";
}

// Formulaire vide et javascript pour le pliage/dépliage des items
if ( $admin )  {
  affichage(array('id' => 0, 'texte' => '&lt;p&gt;Texte&lt;/p&gt;', 'pour' => '00/00/0000', 'date' => date('d/m/Y'),
                  'h_debut' => '08h00', 'h_fin' => '10h00', 'demigroupe' => '', 'cache' => 0, 'tid' => ''));

  // Récupération des boutons
  $resultat = $mysqli->query("SELECT id, nom, jour, TIME_FORMAT(h_debut,'%Hh%i') AS h_debut, TIME_FORMAT(h_fin,'%Hh%i') AS h_fin,
                              type, demigroupe FROM `cdt-seances` WHERE matiere = ${matiere['id']}");
  $raccourcis = '';
  $raccourcisjs = '';
  if ( $resultat->num_rows )  {
    while ( $r = $resultat->fetch_assoc() )  {
      $raccourcis .= "<input type=\"button\" id=\"rac${r['id']}\" value=\"${r['nom']}\"> ";
      $r['demigroupe'] = ( $r['demigroupe'] ) ? 'true' : 'false';
      $raccourcisjs .= "
  \$('#rac${r['id']}').click(function() {
    \$(this).parent().parent().parent().find('#tid').val('${r['type']}');
    \$(this).parent().parent().parent().find('#h_debut').val('${r['h_debut']}');
    \$(this).parent().parent().parent().find('#h_fin').val('${r['h_fin']}');
    \$(this).parent().parent().parent().find('#demigroupe').attr('checked', ${r['demigroupe']});
    var today=new Date();
    var t=today.getDay();
    t = ${r['jour']}-t;
    if ( t>0 ) { t-=7; }
    \$(this).parent().parent().parent().find('#jour').datepick('setDate',t+'d');
  });";
    }
    $resultat->free();  
  }
  echo <<<FIN

  <script type="text/javascript" src="js/textarea.js"></script>
  
  <script type="text/javascript">

$( function() {

  $('<p class="boutons" id="raccourcis">$raccourcis</p>').clone().insertBefore($('.admin form').find('.ligne:first'));
$raccourcisjs

  $('.titre').append(' <span>[déplier]</span>');
  $(".titre span").css('cursor','pointer').click( function () {
    $(this).parent().parent().find('.bouton,.boutons,.ligne,textarea').toggle();
    $(this).text($(this).text() == '[déplier]' ? '[replier]' : '[déplier]');
  });
  $('.cdt form').find('.bouton,.boutons,.ligne,textarea').hide();

  $('.date').datepick({dateFormat: 'dd/mm/yyyy', showTrigger: '<img src="js/calendar-blue.gif">'});
  $('.heure').timeEntry({timeSteps: [1, 30, 0],separator: 'h'});

});

  </script>

FIN;
}
$mysqli->close();

// Bas de page
include('bas.php');
?>
