<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php');

// Recherche de la matière concernée
$mysqli = premiere_connexion();
$resultat = $mysqli->query('SELECT id, cle, nom, colles FROM matieres WHERE colles');
if ( $resultat->num_rows )  {
  if ( !empty($_REQUEST) )
    while ( $r = $resultat->fetch_assoc() )
      if ( isset($_REQUEST[$r['cle']]) )  {
        $matiere = $r;
        break;
      }
  // Matière par défaut : la première
  if ( !isset($matiere) )  {
    $resultat->data_seek(0);
    $matiere = $resultat->fetch_assoc();
  }
  $resultat->free();
}
// Si aucune matière présentant son programme de colles n'est enregistrée
else
  exit('Cette page ne contient aucune information.');

///////////////////
// Modifications //
///////////////////
if ( ( $admin ) && isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
  $mysqli->set_charset('utf8');

  // Vérification que l'identifiant est valide
  $resultat = $mysqli->query("SELECT DATE_FORMAT(s.debut,'%e/%m/%Y') AS debut, c.id, c.cache FROM semaines AS s
                              LEFT JOIN (SELECT id, texte, semaine, cache FROM colles WHERE matiere = ${matiere['id']}) AS c ON c.semaine=s.id
                              WHERE s.id = $id AND s.colle = 1");
  if ( $resultat->num_rows ) {
    $r = $resultat->fetch_assoc();
    $cid = $r['id'];
    $resultat->free();
    // Sauvegarde de la table contenant les données
    sauvegarde_mysql('colles');

    // Ajout d'un nouveau programme de colles. Il ne faut pas pouvoir insérer un programme vide par erreur
    if ( is_null($cid) && strlen($_REQUEST['texte']) )  {
      // Validation des données envoyées
      $texte = $mysqli->real_escape_string($_REQUEST['texte']);
      $cache = ( isset($_REQUEST['cache']) ) ? 1 : 0;
      if ( $mysqli->query("INSERT INTO colles SET texte = '$texte', semaine = $id, matiere = ${matiere['id']}, cache = $cache") && ( $cid = $mysqli->insert_id ) )  {
        $message = "Le programme de colles de la semaine du ${r['debut']} a bien été ajouté.";
        // Ajout d'une information en page d'accueil si programme non caché
        if ( !$cache )  {
          // Sauvegarde de la table contenant les données
          sauvegarde_mysql('infos');
          $message .= ( $mysqli->query('UPDATE infos SET ordre = (ordre+1) WHERE page = 0') 
                     && $mysqli->query("INSERT INTO infos SET ordre = 1, page = 0, auto = 'colle-$cid', cache = 0, texte = '<p>Nouveau programme de colles en ".addslashes($matiere['nom']).' pour la semaine du <a href="colles?'.addslashes($matiere['cle'])."&amp;n=$id\">${r['debut']}</a></p>', titre = '".date('d/m/y').'&nbsp;: nouveau programme de colles\'')
                     && $mysqli->query('ALTER TABLE infos ORDER BY ordre,page')
          ) ? "<br>Un lien vers ce programme de colles a été ajouté en haut de la page d'accueil. Ce lien est <a href=\".?accueil$urladmin\">modifiable/supprimable.</a>." : '';
        }
      }
      else
        $message = "Le programme de colles de la semaine du ${r['debut']} n'a pas pu être ajouté. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }

    // Positionnement "montré" (apparaît publiquement)
    elseif ( isset($_REQUEST['montre']) )  {
      if ( $mysqli->query("UPDATE colles SET cache = 0 WHERE id = $cid") )  {
        $message = 'Le programme de colles a bien été réaffiché&nbsp;: il apparaît à nouveau dans la partie publique.';
        // Sauvegarde de la table contenant les données
        sauvegarde_mysql('infos');
        // Sauvegarde de la table contenant les données
        sauvegarde_mysql('infos');
        $message .= ( $mysqli->query('UPDATE infos SET ordre = (ordre+1) WHERE page = 0') 
                   && $mysqli->query("INSERT INTO infos SET ordre = 1, page = 0, auto = 'colle-$cid', cache = 0, texte = '<p>Nouveau programme de colles en ".addslashes($matiere['nom']).' pour la semaine du <a href="colles?'.addslashes($matiere['cle'])."&amp;n=$id\">${r['debut']}</a></p>', titre = '".date('d/m/y').'&nbsp;: nouveau programme de colles\'')
                   && $mysqli->query('ALTER TABLE infos ORDER BY ordre,page')
        ) ? "<br>Un lien vers ce programme de colles a été ajouté en haut de la page d'accueil. Ce lien est <a href=\".?accueil$urladmin\">modifiable/supprimable.</a>." : '';
      }
      else
        $message = "Le programme de colles de la semaine du ${r['debut']} n'a pas pu être réaffiché. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }

    // Positionnement "caché" (n'apparaît plus publiquement)
    elseif ( isset($_REQUEST['cache']) )  {
      if ( $mysqli->query("UPDATE colles SET cache = 1 WHERE id = $cid") )  {
        $message = "Le programme de colles du ${r['debut']} a bien été caché&nbsp;: il n'apparaît plus dans la partie publique mais est toujours disponible ici pour modification ou réaffichage.";
        // Suppression de l'éventuelle information en page d'accueil
        $resultat = $mysqli->query("SELECT id, ordre FROM infos WHERE auto = 'colle-$cid'");
        if ( $resultat->num_rows )  {
          $r = $resultat->fetch_assoc();
          $resultat->free();
          $message .= ( $mysqli->query("DELETE FROM infos WHERE id = '${r['id']}'")
                     && $mysqli->query("UPDATE infos SET ordre = (ordre-1) WHERE ordre > ${r['ordre']} AND page = 0")
          ) ? '<br>Le lien existant depuis la page d\'accueil a été automatiquement supprimé.' : '';
        }
      }
      else
        $message = "Le programme de colles de la semaine du ${r['debut']} n'a pas pu être caché. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }

    // Suppression
    elseif ( isset($_REQUEST['supprime']) || !strlen($_REQUEST['texte']) )  {
      if ( $mysqli->query("DELETE FROM colles WHERE id = $cid") )  {
        $message = "Le programme de colles de la semaine du ${r['debut']} a bien été supprimé.";
        // Sauvegarde de la table contenant les données
        sauvegarde_mysql('infos');
        // Suppression de l'information en page d'accueil
        $resultat = $mysqli->query("SELECT id, ordre FROM infos WHERE auto = 'colle-$cid'");
        if ( $resultat->num_rows ) {
          $r = $resultat->fetch_assoc();
          $resultat->free();
          $message .= ( $mysqli->query("DELETE FROM infos WHERE id = '${r['id']}'")
                     && $mysqli->query("UPDATE infos SET ordre = (ordre-1) WHERE ordre > ${r['ordre']} AND page = 0")
          ) ? '<br>Le lien existant depuis la page d\'accueil a aussi été supprimé.' : '';
        }
      }
      else
        $message = "Le programme de colles de la semaine du ${r['debut']} n'a pas pu être modifié. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }
    
    // Modification du texte d'un programme de colles existant
    else  {
      $texte = $mysqli->real_escape_string($_REQUEST['texte']);
      if ( $mysqli->query("UPDATE colles SET texte = '$texte' WHERE id = $cid") )  {
        $message = "Le programme de colles de la semaine du ${r['debut']} a bien été modifié.";
        // Ajout d'une information en page d'accueil
        if ( !$r['cache'] )  {
          // Sauvegarde de la table contenant les données
          sauvegarde_mysql('infos');
          $texte = '<p>Modification du programme de colles en '.addslashes($matiere['nom']).' pour la semaine du <a href="colles?'.addslashes($matiere['cle'])."&amp;n=$id\">${r['debut']}</a></p>";
          $titre = date('d/m/y').'&nbsp;: modification d\\\'un programme de colles';
          $resultat = $mysqli->query("SELECT id, ordre FROM infos WHERE auto = 'colle-$cid'");
          // Si elle existe déjà, on la met à jour et on la remonte
          if ( $resultat->num_rows ) {
            $r = $resultat->fetch_assoc();
            $resultat->free();
            $message .= ( $mysqli->query("UPDATE infos SET ordre = (ordre+1) WHERE page = 0 AND ordre < ${r['ordre']}")
                       && $mysqli->query("UPDATE infos SET ordre = 1, texte = '$texte', titre = '$titre' WHERE id = ${r['id']}")
                       && $mysqli->query('ALTER TABLE infos ORDER BY ordre,page')
            ) ? "<br>Le lien sur la page d'accueil vers ce programme de colles a été remonté en haut de la page. Ce lien est <a href=\".?accueil$urladmin\">modifiable/supprimable.</a>." : '';
          }
          else
            $message .= ( $mysqli->query('UPDATE infos SET ordre = (ordre+1) WHERE page = 0')
                       && $mysqli->query("INSERT INTO infos SET ordre = 1, page = 0, cache = 0, texte='$texte', titre='$titre', auto='colle-$cid'")
                       && $mysqli->query('ALTER TABLE infos ORDER BY ordre,page')
            ) ? "<br>Un lien vers ce programme de colles a été ajouté en haut de la page d'accueil. Ce lien est <a href=\".?accueil$urladmin\">modifiable/supprimable.</a>." : '';
        }
      }
      else
        $message = "Le programme de colles de la semaine du ${r['debut']} n'a pas pu être modifié. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }

  }
  
  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = new mysqli($serveur,$base,$mdp,$base);
  $mysqli->set_charset('utf8');
}

////////////
/// HTML ///
////////////
$p = "colles?${matiere['cle']}";
$t = "Programme de colles - ${matiere['nom']}";

// Demander l'authentification si la page est protégée et l'utilisateur non connecté
if ( ( $matiere['colles'] == 2 ) && !$admin && !$lecteur )
  include('login_lecture.php');

// Haut de page, menu et message
include('haut.php');

// Fonction d'affichage des semaines
function format_date($date)  {
  $semaine = array('dimanche','lundi','mardi','mercredi','jeudi','vendredi','samedi');
  $mois = array('','janvier','février','mars','avril','mai','juin','juillet','août','septembre','octobre','novembre','décembre');
  return $semaine[substr($date,0,1)].' '.substr($date,7).' '.$mois[intval(substr($date,5,2))].' '.substr($date,1,4);
}

// Récupération des semaines
$resultat = $mysqli->query("SELECT s.id AS sid, DATE_FORMAT(s.debut,'%w%Y%m%e') AS d, s.colle, s.vacances, c.id AS cid, c.cache
                            FROM semaines AS s
                            LEFT JOIN (SELECT id, semaine, cache FROM colles WHERE matiere = ${matiere['id']}) AS c ON c.semaine=s.id");
$semaines = '';
if ( $resultat->num_rows )  {
  while ( $r = $resultat->fetch_assoc() )  {
    switch ( $r['vacances'] )  {
      case 0:
        if ( $admin )  {
          if ( $r['colle'] )  {
            if ( is_null($r['cid']) )
              $semaines .= "\n        <option value=\"${r['sid']}\">".format_date($r['d']).' (à remplir)</option>';
            elseif ( $r['cache'] )
              $semaines .= "\n        <option value=\"${r['sid']}\">".format_date($r['d']).' (caché)</option>';
            else
              $semaines .= "\n        <option value=\"${r['sid']}\">".format_date($r['d']).'</option>';
          }
          else
            $semaines .= "\n        <option value=\"${r['sid']}\" disabled>".format_date($r['d']).' (pas de colle)</option>';
        }
        else
          $semaines .= ( is_null($r['cid']) || $r['cache'] ) ? "\n        <option value=\"${r['sid']}\" disabled>".format_date($r['d']).'</option>' : "\n        <option value=\"${r['sid']}\">".format_date($r['d']).'</option>';
        $sid[] = $r['sid'];
        break;
      case 1:
        $semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances de Toussaint</option>";
        break;
      case 2:
        $semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances de Noël</option>";
        break;
      case 3:
        $semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances d'hiver</option>";
        break;
      case 4:
        $semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances de Pâques</option>";
        break;
    }
  }
  $resultat->free();
}
else  {
  $mysqli->close();
  include('installation.php');
}

// Validation de n (numéro de semaine à voir)
if ( isset($_REQUEST['n']) && is_numeric($n = $_REQUEST['n']) )  {
  if ( !in_array($n,$sid) )
    $n = 1;
}
// Sans argument, on souhaite afficher le programme de colles de la semaine actuelle
else {
  $date = ( isset($_REQUEST['date']) && preg_match('/\d{4}-\d{2}-\d{2}/',$_REQUEST['date']) ) ? '\''.trim($_REQUEST['date'],'\'').'\'' : 'NOW()';
  $resultat = $mysqli->query("SELECT IF(vacances,(SELECT id FROM semaines WHERE debut > ADDDATE($date,3) AND vacances = 0 LIMIT 1),id) AS id
                              FROM semaines WHERE debut < ADDDATE($date,3) ORDER BY debut DESC LIMIT 1");
  if ( $resultat->num_rows )  {
    $r = $resultat->fetch_assoc();
    $n = $r['id'];
    $resultat->free();
    if ( $admin && ( $m = array_search($n,$sid) ) )
      $n = $sid[$m-1];
  }
  // Aucun résultat : l'année n'a pas encore commencé
  else
    $n = 0;
}
$m = array_search($n,$sid);

// Validation de nb (nombre de semaines à voir)
if ( isset($_REQUEST['nb']) && is_numeric($nb = $_REQUEST['nb']) )  {
  if ( $nb < 1 )
    $nb = 1;
  if ( $nb > count($sid) - $m )
    $nb = count($sid) - $m;
}
else
  // Par défaut : affichage de la semaine courante en partie publique, affichage
  // aussi des semaines précédente et suivante sur l'interface d'administration
  $nb = 1 + 2*$admin;

// Formulaire de demande d'affichage
$semaines = str_replace("\"$n\"","\"$n\" selected",$semaines);
$u = strlen($urladmin) ? "\n    <input type=\"hidden\" name=\"admin\" value=\"\">" : '';
echo <<<FIN
  <div class="item" id="recherche">
  <form action="" method="get">
    <input type="hidden" name="${matiere['cle']}" value="">
    <p>Afficher&nbsp;<input type="text" name="nb" value="$nb" size="2">&nbsp;semaine(s) à partir du&nbsp;
      <select name="n">$semaines
      </select>
      <input type="submit" name="" value="OK">
    </p>$u
  </form>
  </div>


FIN;

// Aide générale pour l'interface d'administration
if ( $admin )  {
  $u = str_replace('&amp;','?',$urladmin);
  echo <<<FIN
  <div class="item aide">
    <p>Vous pouvez ci-dessous modifier les programmes de colles. Vous pouvez choisir les semaines à afficher ci-dessus.</p>
    <p>Les semaines sont réglables <a href="semaines">ici</a>.</p>
    <p>Il est possible de garder caché un programme de colles (pour le valider plus tard par exemple).</p>
    <p>La page affichant ces programmes de colles peut être protégé par mot de passe. Ceci est réglable <a href=".$u">en bas de votre page d'accueil</a> ou <a href="matiere?${matiere['cle']}$urladmin">sur la page de votre matière</a>.</p>
    <p>Vous pouvez supprimer un programme de colles par le bouton <em>Supprimer</em> ou en validant un texte vide.</p>
    <p>À chaque nouveau programme de colle non caché (ou lorsqu'un programme de colles passe de «&nbsp;caché&nbsp;» à «&nbsp;montré&nbsp;»), une information est automatiquement écrite en haut de la page d'accueil. Elle est <a href=".?accueil$urladmin">modifiable</a>.</p>
  </div>
  
FIN;
}

// Affichage des semaines concernées
if ( $n )  {

  // Liens de navigation vers semaines précédentes/suivantes
  $nav = '  <div class="item">';
  if ( $m )
    $nav .= "\n    <a id=\"prec\" href=\"?${matiere['cle']}&amp;n=". $sid[max($m-$nb,0)] ."&amp;nb=$nb$urladmin\">Semaines précédentes</a>";
  if (  $m+$nb < count($sid) )
    $nav .= "\n    <a id=\"suiv\" href=\"?${matiere['cle']}&amp;n=". $sid[$m+$nb] ."&amp;nb=$nb$urladmin\">Semaines suivantes</a>";
  $nav .= "\n  </div>\n\n";
  if ( $nb > 1 )
    echo $nav;

  // Récupération des données à afficher
  if ( $admin )
    $resultat = $mysqli->query("SELECT DATE_FORMAT(s.debut,'%w%Y%m%e') AS d, s.colle, s.vacances, c.texte, s.id, IF(c.cache,' checked','') AS cache 
                                FROM semaines AS s
                                LEFT JOIN (SELECT texte, semaine, cache FROM colles WHERE matiere = ${matiere['id']}) AS c ON c.semaine=s.id
                                WHERE s.id BETWEEN $n AND ${sid[$m+$nb-1]}" );
  else
    $resultat = $mysqli->query("SELECT DATE_FORMAT(s.debut,'%w%Y%m%e') AS d, s.colle, s.vacances, c.texte 
                                FROM semaines AS s
                                LEFT JOIN (SELECT texte, semaine FROM colles WHERE matiere = ${matiere['id']} AND cache = 0) AS c ON c.semaine=s.id
                                WHERE s.id BETWEEN $n AND ${sid[$m+$nb-1]}" );
  // Gestion du titre
  while ( $r = $resultat->fetch_assoc() )  {
    switch ( $r['vacances'] )  {
      case 0:
        $titre = 'Semaine du '.format_date($r['d']);
        break;
      case 1:
        $titre = ucfirst(format_date($r['d']))."&nbsp;: Vacances de Toussaint";
        break;
      case 2:
        $titre = ucfirst(format_date($r['d']))."&nbsp;: Vacances de Noël";
        break;
      case 3:
        $titre = ucfirst(format_date($r['d']))."&nbsp;: Vacances d'hiver";
        break;
      case 4:
        $titre = ucfirst(format_date($r['d']))."&nbsp;: Vacances de Pâques";
        break;
    }
    // Affichage, différent en partie publique/interface d'administration, et pour
    //  une semaine avec ou sans colles
    if ( $admin )  {
      if ( $r['colle'] )  {
        if ( is_null($r['texte']) )  {
          $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
          $classe_cache = $boutons = '';
          $cache = "\n    <p class=\"ligne\"><label for=\"cache\">N'est pas diffusé sur la partie publique&nbsp;: </label><input type=\"checkbox\" id=\"cache\" name=\"cache\" value=\"1\"></p>";
        }
        else  {
          if ( $r['cache'] )  {
            $valide1 = $cache = '';
            $classe_cache = ' cache';
            $titre .= ' (caché, non visible sur le site public)';
            $boutons = "
    <p class=\"boutons\">
      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications sur le texte\">
      <input type=\"submit\" name=\"montre\" value=\"Montrer\" title=\"Montrer le programme, le rendre visible depuis le site public\">
      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer le programme de colles\">
    </p>";
          }
          else  {
            $valide1 = $cache = $classe_cache = '';
            $boutons = "
    <p class=\"boutons\">
      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications sur le texte\">
      <input type=\"submit\" name=\"cache\" value=\"Cacher\" title=\"Cacher le programme, le rendre invisible depuis le site public (le programme sera encore visible ici, par exemple pour un affichage ultérieur)\">
      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer le programme de colles\">
    </p>";
          }
        }
        echo <<<FIN
  <div class="item admin$classe_cache">
  <form action="" method="post">$valide1
    <h3>$titre</h3>$boutons
    <textarea name="texte" rows="15" cols="100">${r['texte']}</textarea>$cache
    <input type="hidden" name="id" value="${r['id']}">
  </form>
  </div>


FIN;
      }
      else  {
        $texte = ( $r['vacances'] ) ? '' : "\n    <p>Il n'y a normalement pas de colles cette semaine-là. S'il s'agit d'une erreur, cela est modifiable <a href=\"semaines\">sur la page des semaines</a></p>";
        echo <<<FIN
  <div class="item admin">
    <h3>$titre</h3>$texte
  </div>


FIN;
      }
    }
    else  {
      if ( $r['colle'] )  {
        $texte = ( is_null($r['texte']) ) ? '    <p>Le programme de colles de cette semaine n\'est pas défini.</p>' : $r['texte'];
        echo <<<FIN
  <div class="item colle">
    <h3>$titre</h3>
$texte
  </div>


FIN;
      }
      else  {
        $texte = ( $r['vacances'] ) ? '' : "\n    <p>Il n'y a pas de colles cette semaine.</p>";
        echo <<<FIN
  <div class="item admin">
    <h3>$titre</h3>$texte
  </div>


FIN;
      }
    }
  }
  $resultat->free();
  // Liens de navigation vers semaines précédentes/suivantes
  echo $nav;
}
else
  echo "  <h2>L'année n'a pas encore commencé... Revenez à la rentrée&nbsp;!</h2>\n\n";
$mysqli->close();

if ( $admin )
  echo "  <script type=\"text/javascript\" src=\"js/textarea.js\"></script>\n\n";

// Bas de page
include('bas.php');
?>
