<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par un script autorisé
if ( !defined('OK') )  exit();
// Affichage des erreurs : à commenter en production
//ini_set('display_errors',1);

// Récupération de la configuration statique
include('config.php');

// Fonction de connexion à la base MySQL "mysqli(hote,user,mdp,base)" et vérification de la connexion
function premiere_connexion()  {
  $mysqli = new mysqli($GLOBALS['serveur'],$GLOBALS['base'],$GLOBALS['mdp'],$GLOBALS['base']);
  // Vérification de la connexion
  if ( $mysqli->connect_errno )
    include('installation.php');
  $mysqli->set_charset('utf8');
  return $mysqli;
}

///////////////////////////////////////////
// Bascule en interface d'administration //
///////////////////////////////////////////
// Accès à l'interface d'administration :
//  * Si on se connecte à un script qui l'oblige (par OK=2)
//  * Si on se connecte à $siteadmin
//  * Si $siteadmin est vide et qu'on ajoute "&admin" aux urls
if ( ( OK == 2 ) || ( $_SERVER['SERVER_NAME'].dirname($_SERVER['SCRIPT_NAME']) == $siteadmin ) || isset($_REQUEST['admin']) )  {

  // Mode https ou non
  if ( $https && ( $_SERVER['HTTPS'] != 'on' ) )  {
    header("Location: https://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}");
    exit();
  }

  // Gestion de la session
  $admin = false;
  $s = ( strlen($siteadmin) ) ? $siteadmin : $site;
  session_name(md5("$site-admin"));
  session_set_cookie_params(0,strchr($s,'/').'/',str_replace(strchr($s,'/'),'',$s));
  session_start();
  
  // Si l'utilisateur est déjà connecté, on vérifie ses données
  if ( isset($_SESSION[md5($site)]) )  {
    $admin = true;
    if ( ( $_SESSION['client'] != $_SERVER['HTTP_USER_AGENT'] ) || ( $_SESSION['ip'] != $_SERVER['REMOTE_ADDR'] ) )  {
      $admin = false;
      $message = 'Vous avez été déconnecté automatiquement suite à une action anormale. Si cela se reproduit, n\'hésitez pas à le signaler.';
    }
    // Si l'utilisateur veut se déconnecter, on le déconnecte
    elseif ( isset($_REQUEST['deconnexion']) )  {
      $admin = false;
      $message = 'Vous avez bien été déconnecté.';
    }
    elseif ( $_SESSION['time'] < time() )  {
      $admin = false;
      $message = 'Vous avez été déconnecté automatiquement suite à une longue durée d\'inactivité. Merci de vous connecter à nouveau.';
    }
    // Déconnexion : suppression du cookie et des données de session
    if ( !$admin )  {
      $_SESSION = array();
      setcookie(session_name(),'',time()-3600);
      session_regenerate_id(true);
    }
    // Tout est ok : session valide pour 15 minutes encore
    else  {
      $_SESSION['time'] = time()+900;
      session_write_close();
    }
  }
  
  // Gestion de la connexion
  if ( !$admin )
    include('login_admin.php');

  // Fonction de sauvegarde des données MySQL
  function sauvegarde_mysql($table)  {
    if ( !is_dir('sauvegarde') || !is_executable('sauvegarde') || !is_writable('sauvegarde') )
      return;
    // Vérification que la sauvegarde est nécessaire (pas encore faite aujourd'hui)
    $jour = date('Y-m-d');
    if ( file_exists("sauvegarde/$table.$jour.php") )
      return;
    $s = <<<FIN
<?php exit(); ?>
------------------------------------------
-- Sauvegarde de la table $table  | $jour
------------------------------------------


FIN;
    // Connexion à la base
    $mysqli = new mysqli($GLOBALS['serveur'],$GLOBALS['base'],$GLOBALS['mdp'],$GLOBALS['base']);
    $mysqli->set_charset('utf8');

    // Récupération de la structure complète si besoin
    $resultat = $mysqli->query("SHOW CREATE TABLE `$table`");
    $r = $resultat->fetch_row();
    $s .= "${r[1]}\n\n";
    $resultat->free();

    // Récupération de la structure
    $resultat = $mysqli->query("SHOW COLUMNS FROM `$table`");
    $s1 = "\nINSERT INTO $table (";
    while ( $r = $resultat->fetch_row() )
      $s1 .= "`${r[0]}`,";
    $s1 = substr($s1,0,-1).') VALUES';
    $resultat->free();
    
    // Récupération des données
    $resultat = $mysqli->query("SELECT * FROM `$table`");
    if ( $resultat->num_rows )  {
      while ( $r = $resultat->fetch_row() )
        $s1 .= "\n  ('".  str_replace('SEPARATEUR','\',\'',addslashes(implode('SEPARATEUR',$r)))  .'\'),';
      $s1 = substr($s1,0,-1);
      $resultat->free();
    }
    else
      $s1 = '';
    $mysqli->close();
    
    // Écriture dans le fichier de sauvegarde
    $fichier = fopen("sauvegarde/$table.$jour.php",'wb');
    fwrite($fichier, $s.$s1);
    fclose($fichier);
  }
  
  // Paramètre supplémentaire "&admin" à passer dans les urls si $siteadmin est vide
  $urladmin = ( strlen($siteadmin) ) ? '' : '&amp;admin';
}

/////////////////////////////////////////////////
// Protection en lecture de la partie publique //
/////////////////////////////////////////////////
if ( !isset($admin) )  {
  $admin = $lecteur = false;
  $urladmin = '';

  session_name(md5($site));
  session_set_cookie_params(0,strchr($site,'/').'/',str_replace(strchr($site,'/'),'',$site));
  session_start();
  if ( isset($_SESSION[md5("$site-lecture")]) )  {
    $lecteur = true;
    if ( ( $_SESSION['time'] < time() ) || ( $_SESSION['client'] != $_SERVER['HTTP_USER_AGENT'] ) || ( $_SESSION['ip'] != $_SERVER['REMOTE_ADDR'] ) || ( isset($_REQUEST['deconnexion']) ) )  {
      $lecteur = false;
      $message2 = 'Vous devez vous connecter à nouveau, suite à une longue durée d\'inactivité.';
      // Suppression du cookie et des données de session
      $_SESSION = array();
      setcookie(session_name(),'',time()-3600);
      session_regenerate_id(true);
    }
    // Tout est ok : session valide pour 1 heure encore
    else  {
      $_SESSION['time'] = time()+3600;
      session_write_close();
    }
  }
}
?>
