<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php');

//////////
// HTML //
//////////

// Recherche et affichage récursif
function affichage($r, $n)  {
  $indent = str_pad('',2*$n);

  // Affichage du répertoire considéré
  $indication = array();
  if ( $r['nbrep'] )
    $indication[] = ( $r['nbrep'] > 1 ) ? "${r['nbrep']} répertoires" : "${r['nbrep']} répertoire";
  if ( $r['nbfic'] )
    $indication[] = ( $r['nbfic'] > 1 ) ? "${r['nbfic']} fichiers" : "${r['nbfic']} fichier";
  $indication = ( empty($indication) ) ? '' : ' ('.implode(', ',$indication).')';
  $protection = ( !$GLOBALS['lecteur'] ) ? "IF(protection,'-lock','')" : '\'\'';
  echo "
$indent<div class=\"rep\">
$indent  <p class=\"rep\"><img class=\"icone\" src=\"icones/rep${r['protection']}.png\"><a href=\"?rep=${r['id']}\">${r['nom']}</a>$indication</p>";

  // Pas de protection sur ce répertoire, affichage de son contenu
  if ( !strlen($r['protection']) )  {
    // Sous-répertoires et récursivité
    $resultat = $GLOBALS['mysqli']->query("SELECT id, nom, nbfic, nbrep, $protection AS protection FROM reps WHERE parent = ${r['id']}");
    if ( $resultat->num_rows )  {
      while ( $s = $resultat->fetch_assoc() )
        affichage($s,$n+1);
      $resultat->free();
    }
    // Fichiers
    $resultat = $GLOBALS['mysqli']->query("SELECT id, nom, taille, DATE_FORMAT(upload,'%d/%m/%Y') AS upload, ext, $protection AS protection FROM docs WHERE parent = ${r['id']} AND protection < 2");
    if ( $resultat->num_rows )  {
      while ( $s = $resultat->fetch_assoc() )  {
        switch ( $s['ext'] )  {
          case '.pdf':
            $icone = 'pdf';
            break;
          case '.doc':
          case '.odt':
          case '.docx':
            $icone = 'doc';
            break;
          case '.xls':
          case '.ods':
          case '.xlsx':
            $icone = 'xls';
            break;
          case '.ppt':
          case '.odp':
          case '.pptx':
            $icone = 'ppt';
            break;
          case '.jpg':
          case '.jpeg':
          case '.png':
          case '.gif':
          case '.svg':
          case '.tif':
          case '.tiff':
          case '.bmp':
          case '.ps':
          case '.eps':
            $icone = 'jpg';
            break;
          case '.avi':
          case '.mpeg':
          case '.mpg':
          case '.wmv':
          case '.mp4':
          case '.ogv':
          case '.qt':
          case '.mov':
          case '.mkv':
            $icone = 'avi';
            break;
          case '.mp3':
          case '.ogg':
          case '.oga':
          case '.wma':
          case '.wav':
          case '.ra':
          case '.rm':
            $icone = 'mp3';
            break;
          case '.txt':
          case '.rtf':
            $icone = 'txt';
            break;
          case '.zip':
          case '.rar':
          case '.7z':
            $icone = 'zip';
            break;
          case '.exe':
          case '.sh':
          case '':
            $icone = 'exe';
            break;
          default :
            $icone = 'defaut';
        }
        echo "
$indent  <p class=\"fic\"><a href=\"download?id=${s['id']}\"><img class=\"icone\" src=\"icones/$icone${s['protection']}.png\">${s['nom']}</a> (${s['upload']}, ${s['taille']})</p>";
      }
      $resultat->free();
    }
  }
  echo "
$indent</div>";
}

// Récupération de l'identifiant de répertoire demandé
$mysqli = premiere_connexion();
if ( isset($_REQUEST['rep']) && is_numeric($_REQUEST['rep']) )
  $rep = $_REQUEST['rep'];
else  {
  // Si une matière est demandée
  if ( !empty($_REQUEST) )  {
    $resultat = $mysqli->query('SELECT r.id, m.cle FROM reps AS r LEFT JOIN matieres AS m ON r.matiere = m.id');
    if ( $resultat->num_rows )  {
      while ( $r = $resultat->fetch_assoc() )
      if ( isset($_REQUEST[$r['cle']]) )  {
        $rep = $r['id'];
        break;
      }
      $resultat->free();
    }
  }
  if ( !isset($rep) )
    $rep = 1;
}

// Récupération des données, vérification de la protection, répertoires parents
$resultat = $mysqli->query("SELECT r.id, r.parents, r.nom, r.nbfic, r.nbrep, r.protection, m.cle, m.nom AS mat
                            FROM reps AS r LEFT JOIN matieres AS m ON r.matiere = m.id
                            WHERE r.id = $rep");
if ( $resultat->num_rows )  {
  $rep = $resultat->fetch_assoc();
  $resultat->free();

  $p = ( is_null($rep['cle']) ) ? 'docs' : "docs?${rep['cle']}";
  $t = ( is_null($rep['cle']) ) ? 'Documents à télécharger' : "Documents à télécharger - ${rep['mat']}";

  // Répertoires parents
  $resultat = $mysqli->query("SELECT id, nom FROM reps WHERE FIND_IN_SET(id,'${rep['parents']}')");
  if ( $resultat->num_rows )  {
    $icone = 'home';
    $parents = "\n  <div class=\"item\" id=\"parents\">";
    while ( $r = $resultat->fetch_assoc() )  {
      $parents .= "\n    <a href=\"?rep=${r['id']}\"><img class=\"icone\" src=\"icones/$icone.png\">${r['nom']}</a>";
      $icone = 'next';
    }
    $parents .= "\n  </div>\n";
    $resultat->free();
  }
  else
    $parents = "\n  <div id=\"parents-vide\"> </div>\n";

  // Gestion de la protection : demande de login si le répertoire affiché est protégé
  if ( $rep['protection'] && !$lecteur )
    include('login_lecture.php');
  $rep['protection'] = '';

  // Haut de page, menu et message
  include('haut.php');
  echo $parents;

  // Affichage du répertoire et de son contenu
  affichage($rep,1);
}
else  {
  // Haut de page, menu et message
  $p = 'docs';
  $t = 'Documents à télécharger';
  include('haut.php');
  echo "\n<h2>Ce répertoire n'existe pas.</h2>";
}

$mysqli->close();
?>


  <script type="text/javascript">
$( function() {
  $('p.rep img').css('cursor','pointer').click( function () {
    $(this).parent().parent().find('.fic,div.rep').toggle();
  });

  $('#contenu > .rep').find('.fic,div.rep').toggle().toggle();
  $('#contenu > .rep').before('<p>Vous pouvez ouvrir ou fermer des répertoires en cliquant sur leur icone.</p>');
});
  </script>

<?php
// Bas de page
include('bas.php');
?>
