<?php
// Sécurité et récupération des données de configuration
// Mode admin obligatoire (OK=2)
define('OK',2);
include('debut.php');

// Récupération de l'identifiant de répertoire demandé
$mysqli = premiere_connexion();
if ( isset($_REQUEST['rep']) && is_numeric($_REQUEST['rep']) )
  $rid = $_REQUEST['rep'];
else  {
  // Si une matière est demandée
  if ( !empty($_REQUEST) )  {
    $resultat = $mysqli->query('SELECT r.id, m.cle FROM reps AS r LEFT JOIN matieres AS m ON r.matiere = m.id');
    if ( $resultat->num_rows )  {
      while ( $r = $resultat->fetch_assoc() )
      if ( isset($_REQUEST[$r['cle']]) )  {
        $rid = $r['id'];
        break;
      }
      $resultat->free();
    }
  }
  // Valeur par défaut
  if ( !isset($rid) )
    $rid = 1;
}

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['nom']) || isset($_REQUEST['id']) )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
  $mysqli->set_charset('utf8');

  // Récupération des données du répertoire
  $resultat = $mysqli->query("SELECT nom, parent, protection FROM reps WHERE id = $rid");
  $rep = $resultat->fetch_assoc();
  $resultat->free();

  // Récupération des liens de parenté entre répertoires
  $resultat = $mysqli->query("SELECT id, parents FROM reps");
  while ( $r = $resultat->fetch_assoc() )
    $parents[$r['id']] = $r['parents'];
  $resultat->free();

  // Traitement d'une modification du répertoire
  if ( isset($_REQUEST['modifie']) )  {
    // Sauvegarde de la table contenant les données
    sauvegarde_mysql('reps');
    $message = '';

    // Modification du nom
    if ( strlen($nom = $_REQUEST['nom']) && ( $rep['nom'] != $nom ) )  {
      $nom = $mysqli->real_escape_string($_REQUEST['nom']);
      $message = ( $mysqli->query("UPDATE reps SET nom = '$nom' WHERE id = $rid")
                && $mysqli->query('ALTER TABLE docs ORDER BY parents,nom')
      ) ? 'Le nom du répertoire a bien été modifié.' : 'Le nom du répertoire n\'a pas pu être modifié. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }

    // Traitement du déplacement du répertoire
    // Impossible si $rep[parent] est nul (répertoires de niveau 1 ou si on cherche à déplacer vers un sous-répertoire
    if ( isset($_REQUEST['parent']) && isset($parents[$parent=$_REQUEST['parent']]) && ( $parent != $rep['parent'] ) && ( $rep['parent'] ) && ( !in_array($rid,explode(',',$parents[$parent])) ) )  {
      // Récupération de l'éventuelle nouvelle matière
      $resultat = $mysqli->query("SELECT matiere FROM reps WHERE id = $parent");
      $r = $resultat->fetch_assoc();
      $resultat->free();
      $mat = $r['matiere'];
      $parents = "${parents[$parent]},$parent";
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('docs');
      // Modifications
      $message .= ( $mysqli->query("UPDATE reps SET matiere = $mat, parent = $parent, parents = '$parents' WHERE id = $rid")
                 && $mysqli->query("UPDATE reps SET nbrep = (nbrep + 1) WHERE id = $parent")
                 && $mysqli->query("UPDATE reps SET nbrep = (nbrep - 1) WHERE id = ${rep['parent']}")
                 && $mysqli->query("UPDATE reps SET matiere = $mat, parents = '$parents,$rid' WHERE parent = $rid")
                 && $mysqli->query("UPDATE docs SET matiere = $mat, parents = '$parents,$rid' WHERE parent = $rid")
      ) ? ' Le répertoire a bien été déplacé.' : ' Le répertoire n\'a pas pu être déplacé. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }

    // Traitement de la protection par mot de passe du répertoire
    $protection = isset($_REQUEST['protection']) ? 1 : 0;
    if ( $protection != $rep['protection'] )  {
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('docs');
      $message .=  ( $mysqli->query("UPDATE reps SET protection = $protection WHERE id = $rid OR FIND_IN_SET($rid,parents)")
                  && $mysqli->query("UPDATE docs SET protection = $protection WHERE FIND_IN_SET($rid,parents) AND protection < 2")
      ) ? ' La protection par mot de passe du répertoire ainsi que tout ce qu\'il contient (sous-répertoires et fichiers) a bien été modifiée.' : ' La protection par mot de passe du répertoire n\'a pas pu être modifiée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }
    
    if ( !strlen($message) )
      unset($message);
  }

  // Traiment d'une suppression d'un répertoire
  elseif ( isset($_REQUEST['supprime']) && ( isset($parents[$id=$_REQUEST['id']]) ) && ( $parents[$id] != '0' ) )  {
    // Récupération du nom du répertoire
    $resultat = $mysqli->query("SELECT nom, parent FROM reps WHERE id = $id");
    $r = $resultat->fetch_assoc();
    $resultat->free();
    // Demande de confirmation
    if ( !isset($_REQUEST['confirme']) )  {
      $message = "
    <form action=\"\" method=\"post\">
      <p>Souhaitez-vous réellement supprimer le répertoire «&nbsp;${r['nom']}&nbsp;» et tout son contenu&nbsp;? Les documents concernés seront effacés définitivement.</p>
      <input type=\"submit\" name=\"confirme\" value=\"Oui\">
      <input type=\"hidden\" name=\"supprime\" value=\"Supprimer\">
      <input type=\"hidden\" name=\"id\" value=\"$id\">
    </form>\n";
    }
    else  {
      // Sauvegarde des tables contenant les données
      sauvegarde_mysql('reps');
      sauvegarde_mysql('docs');
      // Liste des fichiers à supprimer
      $resultat = $mysqli->query("SELECT GROUP_CONCAT(CONCAT('documents/',lien) SEPARATOR ' ') FROM docs WHERE FIND_IN_SET($id,parents)");
      $s = $resultat->fetch_row();
      $resultat->free();
      if ( $mysqli->query("DELETE FROM reps WHERE id = $id OR FIND_IN_SET($id,parents)")
        && $mysqli->query("DELETE FROM docs WHERE FIND_IN_SET($id,parents)")
        && $mysqli->query("UPDATE reps SET nbrep = (nbrep - 1) WHERE id = ${r['parent']}") )  {
        $message = "La suppression du répertoire «&nbsp;${r['nom']}&nbsp;» et de tout ce qu'il contient (sous-répertoires et fichiers) a bien été effectuée.";
        // Suppression physique
        if ( strlen($s[0]) )
          exec("rm -rf ${s[0]}");
        // Mise à jour des données : afficher le répertoire parent si on a supprimé le répertoire à afficher
        if ( $id == $rid )
          $rid = $rep['parent'];
      }
      else
        $message = "La suppression du répertoire «&nbsp;${r['nom']}&nbsp;» n'a pas pu être effectuée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }
  }

  // Traiment d'une création d'un sous-répertoire
  elseif ( isset($_REQUEST['cree']) )  {
    $nom = $mysqli->real_escape_string($_REQUEST['nom']);
    $protection = isset($_REQUEST['protection']) ? 1 : 0;
    // Sauvegarde de la table contenant les données
    sauvegarde_mysql('reps');
    $message = ( $mysqli->query("INSERT INTO reps SET parent = $rid, parents = '${parents[$rid]},$rid', nom = '$nom', matiere = (SELECT r.matiere FROM reps AS r WHERE r.id = $rid), nbrep = 0, nbfic = 0, protection = $protection")
              && $mysqli->query("UPDATE reps SET nbrep = (nbrep + 1) WHERE id = $rid")
              && $mysqli->query('ALTER TABLE reps ORDER BY parents,nom')
    ) ? 'Le répertoire «&nbsp;'.stripslashes($nom).'&nbsp;» a bien été créé.' : 'Le répertoire «&nbsp;'.stripslashes($nom).'&nbsp;» n\'a pas pu être créé. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
  }

  // Traitement d'un envoi de fichier
  elseif ( isset($_REQUEST['envoie']) )  {
    // Vérifications des données envoyées (on fait confiance aux utilisateurs connectés pour ne pas envoyer de scripts malsains)
    $nom = $_FILES['fichier']['name'];
    $ext = ( strpos($nom,'.') ) ? strrchr($nom,'.') : '';
    $nom = ( strlen($_REQUEST['nom']) ) ? $_REQUEST['nom'] : $nom;
    $nom = preg_replace('#[\x00-\x1F\x7F-\x9F/\\\\]#','',basename(str_replace($ext,'',$nom)));
    $protection = ( in_array($_REQUEST['protection'],array(0,1,2)) ) ? $_REQUEST['protection'] : 0;
    $lien = substr(sha1(mt_rand()),0,15);
    // Déplacement du document uploadé au bon endroit
    if ( mkdir("documents/$lien") && move_uploaded_file($_FILES['fichier']['tmp_name'],"documents/$lien/$nom$ext") )  {
      // Gestion de la taille
      $taille = intval($_FILES['fichier']['size']/1024);
      $taille = ( $taille < 1024 ) ? "$taille&nbsp;ko" : intval($taille/1024).'&nbsp;Mo';
      // Écriture MySQL
      if ( $mysqli->query("INSERT INTO docs SET parent = $rid, parents = '${parents[$rid]},$rid',
                           matiere = (SELECT matiere FROM reps WHERE id = $rid), nom = '".$mysqli->real_escape_string($nom)."',
                           upload = DATE(NOW()), taille = '$taille', lien = '$lien', ext='$ext', protection = $protection") )  {
        $id = $mysqli->insert_id;
        $mysqli->query('ALTER TABLE docs ORDER BY parents,nom');
        $message = "Le document «&nbsp;$nom$ext&nbsp;» a bien été mis en ligne.";
        // Si le fichier n'est pas caché : mise à jour du nb de fichiers, information en page d'accueil
        if ( $protection < 2 )  {
          $mysqli->query("UPDATE reps SET nbfic = (nbfic + 1) WHERE id = $rid");
          // Sauvegarde de la table contenant les données
          sauvegarde_mysql('infos');
          $message .= ( $mysqli->query('UPDATE infos SET ordre = (ordre+1) WHERE page = 0') 
                     && $mysqli->query("INSERT INTO infos SET ordre = 1, page = 0, auto = 'doc-$id', cache = 0, texte = '<p>Nouveau document&nbsp;: «&nbsp;<a href=\"download?id=$id\">".$mysqli->real_escape_string($nom)."</a>&nbsp;» dans le répertoire <a href=\"docs?rep=$rid\">".addslashes($rep['nom']).'</a>.</p>\', titre = \''.date('d/m/y').'&nbsp;: nouveau document à télécharger\'')
                     && $mysqli->query('ALTER TABLE infos ORDER BY ordre,page')
          ) ? "<br>Un lien vers ce document a été ajouté en haut de la page d'accueil. Ce lien est <a href=\".?accueil$urladmin\">modifiable/supprimable.</a>." : '';
        }
      }
      else  {
        // Retour en arrière
        exec("rm -rf documents/$lien");
        $message = "Le document «&nbsp;$nom$ext&nbsp;» n'a pas été mis en ligne à cause d'une erreur lors des modifications dans la base de données MySQL. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      }
    }
    else
      $message = "Le document «&nbsp;$nom$ext&nbsp;» n'a pas été mis en ligne car le fichier envoyé n'est pas valide.";
  }

  // Traitement d'une modification d'un fichier
  elseif ( isset($_REQUEST['modifie_fichier']) && is_numeric($id = $_REQUEST['id']) )  {
    // Récupération des données relatives au fichier
    $resultat = $mysqli->query("SELECT nom, protection, parent, ext, lien FROM docs WHERE id = $id");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $resultat->free();
      if ( !strlen($_REQUEST['nom']) )
        $message = 'Il n\'est pas possible de valider un nom de fichier vide. Pour supprimer un fichier, il faut cliquer sur Supprimer.';
      else  {
        $message = '';
        // Sauvegarde de la table contenant les données
        sauvegarde_mysql('docs');
        // Validation des données envoyées (real_escape_string à appliquer seulement dans les requêtes !)
        $nom = preg_replace('#[\x00-\x1F\x7F-\x9F/\\\\]#','',basename(str_replace($r['ext'],'',$_REQUEST['nom'])));
        $protection = ( in_array($_REQUEST['protection'],array(0,1,2)) ) ? $_REQUEST['protection'] : 0;

        // Modification du nom
        if ( $nom != $r['nom'] )  {
          setlocale(LC_CTYPE, "fr_FR.UTF-8");
          if ( $mysqli->query('UPDATE docs SET nom = \''.$mysqli->real_escape_string($nom)."' WHERE id = $id") )  {
            exec('mv documents/'.escapeshellarg("${r['lien']}/${r['nom']}${r['ext']}").' documents/'.escapeshellarg("${r['lien']}/$nom${r['ext']}"));
              $message = " Le nom du fichier «&nbsp;${r['nom']}${r['ext']}&nbsp;» a bien été modifié.";
          }
          else
            $message ="Le nom du fichier «&nbsp;${r['nom']}${r['ext']}&nbsp;» n'a pas pu être modifié. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
        }

        // Modification de la protection
        if ( $protection != $r['protection'] )  {
          if ( $mysqli->query("UPDATE docs SET protection = $protection WHERE id = $id") )  {
            $message .= " La protection par mot de passe du fichier «&nbsp;${r['nom']}${r['ext']}&nbsp;» a bien été modifiée.";
            // Si une des deux valeurs vaut 2, le fichier apparaît ou disparaît du listing public 
            if ( $protection + $r['protection'] > 1 )  {
              // Sauvegarde de la table contenant les données
              sauvegarde_mysql('reps');
              if ( $protection == 2 )  {
                // Le fichier disparaît du décompte du répertoire et des informations de la page d'accueil
                $mysqli->query("UPDATE reps SET nbfic = (nbfic - 1) WHERE id = ${r['parent']}");
                $resultat = $mysqli->query("SELECT id, ordre FROM infos WHERE auto = 'doc-$id'");
                if ( $resultat->num_rows )  {
                  $s = $resultat->fetch_assoc();
                  $resultat->free();
                  $message .= ( $mysqli->query("DELETE FROM infos WHERE id = ${s['id']}")
                             && $mysqli->query("UPDATE infos SET ordre = (ordre-1) WHERE ordre > ${s['ordre']} AND page = 0")
                  ) ? '<br>Le lien existant depuis la page d\'accueil a été automatiquement supprimé.' : '';
                }
              }
              else {
                // Le fichier réapparaît du décompte du répertoire et des informations de la page d'accueil
                $mysqli->query("UPDATE reps SET nbfic = (nbfic + 1) WHERE id = ${r['parent']}");
                $message .= ( $mysqli->query('UPDATE infos SET ordre = (ordre+1) WHERE page = 0') 
                           && $mysqli->query("INSERT INTO infos SET ordre = 1, page = 0, auto = 'doc-$id', cache = 0, texte = CONCAT('<p>Nouveau document&nbsp;: «&nbsp;<a href=\"download?id=$id\">".$mysqli->real_escape_string($nom)."</a>&nbsp;» dans le répertoire <a href=\"docs?rep=${r['parent']}\">',(SELECT reps.nom FROM reps WHERE reps.id = ${r['parent']}),'</a>.</p>'), titre = '".date('d/m/y').'&nbsp;: nouveau document à télécharger\'')
                           && $mysqli->query('ALTER TABLE infos ORDER BY ordre,page')
                ) ? "<br>Un lien vers ce document a été ajouté en haut de la page d\'accueil. Ce lien est <a href=\".?accueil$urladmin\">modifiable/supprimable.</a>." : '';
              }
            }
          }
          else
            $message .= " La protection par mot de passe du fichier «&nbsp;${r['nom']}${r['ext']}&nbsp;» n'a pas pu être modifiée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
        }
        
        // Déplacement d'un répertoire à un répertoire
        if ( isset($parents[$parent = $_REQUEST['parent']]) && ( $parent != $r['parent'] ) )  {
          // Sauvegarde de la table contenant les données
          sauvegarde_mysql('reps');
          if ( $mysqli->query("UPDATE docs SET parent = '$parent', parents = '${parents[$parent]},$parent',
                               matiere = (SELECT matiere FROM reps WHERE id = $parent) WHERE id = $id") )  {
            if ( $protection < 2 )  {
              $mysqli->query("UPDATE reps SET nbfic = (nbfic - 1) WHERE id = ${r['parent']}");
              $mysqli->query("UPDATE reps SET nbfic = (nbfic + 1) WHERE id = $parent");
            }
            $message .= " Le fichier «&nbsp;${r['nom']}${r['ext']}&nbsp;» a bien été déplacé.";
          }
          else
            $message .= " Le fichier «&nbsp;${r['nom']}${r['ext']}&nbsp;» n'a pas pu être déplacé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
        }
        
        if ( !strlen($message) )
          unset($message);
      }
    }
  }
  
  // Traitement d'une suppression d'un fichier
  elseif ( isset($_REQUEST['supprime_fichier']) && is_numeric($id = $_REQUEST['id']) )  {
    // Récupération des données relatives au fichier
    $resultat = $mysqli->query("SELECT nom, parent, lien, ext, protection FROM docs WHERE id = $id");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $resultat->free();
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('docs');
      if ( $mysqli->query("DELETE FROM docs WHERE id = $id") )  {
        $message = "Le fichier «&nbsp;${r['nom']}${r['ext']}&nbsp;» a bien été supprimé.";
        // Suppression physique
        exec("rm -rf documents/${r['lien']}");
        if ( $r['protection'] < 2 )  {
          // Sauvegarde de la table contenant les données
          sauvegarde_mysql('reps');
          $mysqli->query("UPDATE reps SET nbfic = (nbfic - 1) WHERE id = ${r['parent']}");
          // Suppression de l'éventuelle information en page d'accueil
          $resultat = $mysqli->query("SELECT id, ordre FROM infos WHERE auto = 'doc-$id'");
          if ( $resultat->num_rows )  {
            $r = $resultat->fetch_assoc();
            $resultat->free();
            $message .= ( $mysqli->query("DELETE FROM infos WHERE id = ${r['id']}")
                       && $mysqli->query("UPDATE infos SET ordre = (ordre-1) WHERE ordre > ${r['ordre']} AND page = 0")
            ) ? '<br>Le lien existant depuis la page d\'accueil a été automatiquement supprimé.' : '';
          }
        }
      }
      else
        $message = "Le fichier «&nbsp;${r['nom']}${r['ext']}&nbsp;» n'a pas pu être supprimé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }
  }

  // Mise à jour des champs 'docs' dans la table 'matieres' (pour le menu)
  $mysqli->query('UPDATE matieres SET docs = (SELECT IF(nbfic+nbrep,1,0) FROM reps WHERE parent=0 AND matiere = matieres.id)');
    
  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = new mysqli($serveur,$base,$mdp,$base);
  $mysqli->set_charset('utf8');
}

//////////
// HTML //
//////////

// Récupération des données du répertoire
$resultat = $mysqli->query("SELECT r.id, r.parent, r.parents, r.nom, r.protection, m.cle
                            FROM reps AS r LEFT JOIN matieres AS m ON r.matiere = m.id
                            WHERE r.id = $rid");
$rep = $resultat->fetch_assoc();
$resultat->free();

// Récupération des répertoires, dans le bon ordre pour un select
function liste($rid,$n)  {
  $resultat = $GLOBALS['mysqli']->query("SELECT id, nom, parents, IF(FIND_IN_SET(".$GLOBALS['rid'].",parents),' disabled','') AS disabled
                                         FROM reps WHERE parent = $rid");
  while ( $r = $resultat->fetch_assoc() )  {
    $GLOBALS['select_reps'] .= "\n        <option value=\"${r['id']}\"${r['disabled']}>".str_repeat('&rarr;',$n)."${r['nom']}</option>";
    liste($r['id'],$n+1);
  }
  $resultat->free();
}
$select_reps = '';
liste(0,0);

// Recherche et affichage récursif
$select = str_replace(' disabled','',$select_reps);
function affichage($rid, $n)  {
  $indent = str_pad('',2*$n);
  // Pour les form, préciser le rep dans action
  $lien = "?rep=${GLOBALS['rid']}";
  
  // Récupération des données du répertoire
  $resultat = $GLOBALS['mysqli']->query("SELECT nom, parent, IF(protection,'-lock','') AS protection, IF(nbrep+nbfic=0,' (répertoire vide)','') AS vide
                                         FROM reps WHERE id = $rid");
  $r = $resultat->fetch_assoc();
  $resultat->free();

  // Affichage du répertoire considéré
  $suppr = ( $r['parent'] ) ? "\n$indent    <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer ce répertoire\">" : '';
  echo "
$indent<div class=\"rep\">
$indent  <form action=\"$lien\" method=\"post\"><p class=\"rep\"><img class=\"icone\" src=\"icones/rep${r['protection']}.png\">$suppr
$indent    <input type=\"hidden\" name=\"id\" value=\"$rid\">
$indent    <a href=\"?rep=$rid\">${r['nom']}</a>${r['vide']}</p></form>";

  // Recherche de sous-répertoire et récursivité
  $resultat = $GLOBALS['mysqli']->query("SELECT id FROM reps WHERE parent = $rid");
  if ( $resultat->num_rows )  {
    while ( $s = $resultat->fetch_assoc() )
      affichage($s['id'],$n+1);
    $resultat->free();
  }
  // Fichiers
  $resultat = $GLOBALS['mysqli']->query("SELECT id, nom, lien, ext, protection FROM docs WHERE parent = $rid");
  if ( $resultat->num_rows )  {
    while ( $s = $resultat->fetch_assoc() )  {
      switch ( $s['ext'] )  {
        case '.pdf':
          $icone = 'pdf';
          break;
        case '.doc':
        case '.odt':
        case '.docx':
          $icone = 'doc';
          break;
        case '.xls':
        case '.ods':
        case '.xlsx':
          $icone = 'xls';
          break;
        case '.ppt':
        case '.odp':
        case '.pptx':
          $icone = 'ppt';
          break;
        case '.jpg':
        case '.jpeg':
        case '.png':
        case '.gif':
        case '.svg':
        case '.tif':
        case '.tiff':
        case '.bmp':
        case '.ps':
        case '.eps':
          $icone = 'jpg';
          break;
        case '.avi':
        case '.mpeg':
        case '.mpg':
        case '.wmv':
        case '.mp4':
        case '.ogv':
        case '.qt':
        case '.mov':
        case '.mkv':
          $icone = 'avi';
          break;
        case '.mp3':
        case '.ogg':
        case '.oga':
        case '.wma':
        case '.wav':
        case '.ra':
        case '.rm':
          $icone = 'mp3';
          break;
        case '.txt':
        case '.rtf':
          $icone = 'txt';
          break;
        case '.zip':
        case '.rar':
        case '.7z':
          $icone = 'zip';
          break;
        case '.exe':
        case '.sh':
        case '':
          $icone = 'exe';
          break;
        default :
          $icone = 'defaut';
      }
      switch ( $s['protection'] )  {
        case 1:
          $icone .= '-lock';
        case 0:
          $protection = '';
          break;
        case 2:
          $protection = ' (non visible)';
      }
      $select = str_replace(array("\"$rid\"",'      '),array("\"$rid\" selected","$indent      "),$GLOBALS['select']);
      $select_protection = str_replace("\"${s['protection']}\"","\"${s['protection']}\" selected",'<option value="0">Visible de tous</option><option value="1">Avec mot de passe</option><option value="2">Caché</option>');
      echo "
$indent  <div class=\"fic\">
$indent    <span><img class=\"icone\" src=\"icones/$icone.png\">${s['nom']}</span>$protection
$indent    <form action=\"$lien\" method=\"post\">
$indent      <p class=\"boutons\"><input type=\"submit\" name=\"modifie_fichier\" value=\"Valider\"><input type=\"submit\" name=\"supprime_fichier\" value=\"Supprimer\" title=\"Supprimer ce fichier\"></p>
$indent      <p class=\"ligne\"><label for=\"nom\">Renommer&nbsp;: </label><input type=\"text\" id=\"nom\" name=\"nom\" value=\"${s['nom']}\" size=\"50\"></p>
$indent      <p class=\"ligne\"><label for=\"parent\">Déplacer&nbsp;: </label><select id=\"parent\" name=\"parent\">$select
$indent      </select></p>
$indent      <p class=\"ligne\"><label for=\"protection\">Accès&nbsp;: </label><select id=\"protection\" name=\"protection\">
$indent        $select_protection
$indent      </select></p>
$indent      <input type=\"hidden\" name=\"id\" value=\"${s['id']}\">
$indent      <p class=\"ligne\"><label>Lien&nbsp;: </label><code>&lt;a href=\"download?id=${s['id']}\"&gt;${s['nom']}&lt;/a&gt;</code></p>
$indent    </form>
$indent  </div>";
    }
    $resultat->free();
  }
  echo "
$indent</div>";
}

// Haut de page, menu et message
$p = ( is_null($rep['cle']) ) ? 'docs_admin' : "docs_admin?${rep['cle']}";
$t = "Gestion des répertoires et documents - «&nbsp;${rep['nom']}&nbsp;»";
include('haut.php');

// Répertoires parents
$resultat = $mysqli->query("SELECT id, nom, IF(protection,'-lock','') AS protection FROM reps WHERE FIND_IN_SET(id,'${rep['parents']}')");
if ( $resultat->num_rows )  {
  $icone = 'home';
  echo "\n  <div class=\"item\" id=\"parents\">";
  while ( $r = $resultat->fetch_assoc() )  {
    echo "\n    <a href=\"?rep=${r['id']}\"><img class=\"icone\" src=\"icones/$icone${r['protection']}.png\">${r['nom']}</a>";
    $icone = 'repopen';
  }
  echo "\n  </div>\n";
  $resultat->free();
}
else
  echo "\n  <div id=\"parents-vide\"> </div>\n";

// Affichage du répertoire et de son contenu
affichage($rid,1);
$mysqli->close();

// Formulaires :
// * modification du répertoire
// * envoi de fichier
// * création de sous-répertoire
// Vérification de la quantité de données téléchargeable
$taille = min(ini_get('upload_max_filesize'),ini_get('post_max_size'));
if ( stristr($taille,'m') )
  $taille = substr($taille,0,-1)*1048576;
elseif ( stristr($taille,'k') )
  $taille = substr($taille,0,-1)*1024;
$message = ( $taille < 1048576 ) ? intval($taille/1024).'&nbsp;ko.' : intval($taille/1048576).'&nbsp;Mo.';
if ( $taille < 2097152 )
  $message .= ' Cela pourrait être insuffisant si vous souhaitez envoyer des documents conséquents, mais n\'interdit pas l\'envoi de petits documents.';
// Protection par défaut pour les nouveaux répertoires/fichiers si le répertoire est protégé
$protection = ( $rep['protection'] ) ? ' checked' : '';
$select_protection = str_replace("\"${rep['protection']}\"","\"${rep['protection']}\" selected",'<option value="0">Visible de tous</option><option value="1">Avec mot de passe</option><option value="2">Caché</option>');
// Pour le déplacement : sélection du bon répertoire ; ne pas déplacer les répertoires de niveau 1 (Général et matières)
$select_reps = str_replace(array("\"$rid\"","\"${rep['parent']}\""),array("\"$rid\" disabled","\"${rep['parent']}\" selected"),$select_reps);
$select_reps = ( $rep['parent'] ) ? '<select id="parent" name="parent">'.$select_reps : '<select id="parent" name="parent" disabled>'.$select_reps;
?>

  <div class="item aide">
    <p>Vous pouvez ici modifier les répertoires et les documents contenus. Les répertoires s'ouvrent en cliquant sur leur icone, les propriétés modifiables des fichiers s'affichent lorsque l'on clique sur leur nom.</p>
    <p>Un fichier peut être caché de la partie publique&nbsp;: il n'apparaît qu'ici, il est strictement indisponible au téléchargement. Cela peut être intéressant pour s'avancer (un sujet de devoir ou un corrigé par exemple).</p>
    <p>Après avoir cliqué sur un répertoire, vous pouvez ci-dessous modifier son nom ou son accès, y ajouter un sous-répertoire ou un fichier. Un répertoire dont l'<em>Accès avec mot de passe</em> est activé ne pourra être vu uniquement par les utilisateurs ayant entré un mot de passe. Les utilisateurs sont modifiables <a href"utilisateurs">ici</a>.</p>
    <p>En changeant l'accès avec mot de passe ou non d'un répertoire, tous les sous-répertoires et fichiers contenus auront automatiquement la même protection, excepté les fichiers cachés (qui restent toujours cachés).</p>
    <p>Lorsque vous envoyez un fichier, son nom est automatiquement récupéré, sauf si vous remplissez la case <em>Nom à afficher</em>. La taille d'un fichier est limitée à <?php echo $message; ?></p>
    <p>Les liens vers les fichiers et les répertoires ne sont jamais modifiés par un déplacement ou un changement de nom.</p>
    <p>À chaque nouveau fichier envoyé et non caché (ou lorsqu'un fichier passe de «&nbsp;caché&nbsp;» à «&nbsp;montré&nbsp;»), une information est automatiquement écrite en haut de la page d'accueil. Elle est <a href="?accueil<?php echo $urladmin; ?>">modifiable</a>.</p>
  </div>

  <div class="item admin">
  <form action="<?php echo "?rep=$rid"; ?>" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications">
<!--    <input class="bouton" type="submit" name="supprime" value="Supprimer" title="Supprimer ce répertoire et son contenu">-->
    <h3>Modification du répertoire</h3>
    <p class="ligne"><label for="nom">Nom&nbsp;: </label><input type="text" id="nom" name="nom" value="<?php echo $rep['nom']; ?>" size="50"></p>
    <p class="ligne"><label for="parent">Déplacer&nbsp;: </label>
      <?php echo $select_reps; ?>

      </select>
    </p>
    <p class="ligne"><label for="protection">Accès avec mot de passe&nbsp;: </label><input type="checkbox" id="protection" name="protection" value="1"<?php echo $protection; ?>></p>
  </form>
  </div>

  <div class="item admin">
  <form action="<?php echo "?rep=$rid"; ?>" method="post" enctype="multipart/form-data">
    <input class="bouton" type="submit" name="envoie" value="Envoyer">
    <h3>Déposer un fichier</h3>
    <p class="ligne"><label for="nom">Nom à afficher&nbsp;: </label><input type="text" id="nom" name="nom" value="" size="50"></p>
    <p class="ligne"><label for="fichier">Fichier&nbsp;: </label><input type="file" name="fichier"></p>
    <p class="ligne"><label for="protection">Accès&nbsp;: </label>
      <select id="protection" name="protection"><?php echo $select_protection; ?></select>
    </p>
  </form>
  </div>

  <div class="item admin">
  <form action="<?php echo "?rep=$rid"; ?>" method="post" enctype="multipart/form-data">
    <input class="bouton" type="submit" name="cree" value="Créer">
    <h3>Créer un sous-répertoire</h3>
    <p class="ligne"><label for="nom">Nom&nbsp;: </label><input type="text" id="nom" name="nom" value="" size="50"></p>
    <p class="ligne"><label for="protection">Accès avec mot de passe&nbsp;: </label><input type="checkbox" id="protection" name="protection" value="1"<?php echo $protection; ?>></p>
  </form>
  </div>

  <script type="text/javascript">
$( function() {
  $('p.rep img').css('cursor','pointer').click( function () {
    $(this).parent().parent().parent().find('.fic,div.rep').toggle();
  });
  $('#contenu > .rep').find('.fic,div.rep').toggle().toggle();
  $('.fic').find('form').hide();
  $('.fic span').replaceWith(function() { return '<a href="">'+$(this).html()+'</a>'; });
  $('.fic a').click( function () {
    $(this).parent().find('form').toggle();
    $(this).parent().toggleClass('admin');
    return false;
  });
});
  </script>

<?php
// Bas de page
include('bas.php');
?>
