<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php');

// Vérification du document, de la protection et récupération du lien
if ( isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )  {
  $mysqli = premiere_connexion();
  $resultat = $mysqli->query("SELECT id, parents, matiere, nom, lien, ext, protection FROM docs WHERE id = $id AND protection < 2");
  if ( $resultat->num_rows )  {
    $f = $resultat->fetch_assoc();
    $resultat->free();

    // Si protection
    if ( $f['protection'] && !$lecteur )  {

      // $p et $t à définir pour le menu et le titre
      $resultat = $mysqli->query("SELECT cle FROM matieres WHERE id = ${f['matiere']}");
      if ( $resultat->num_rows )  {
        $r = $resultat->fetch_assoc();
        $p = "docs?${r['cle']}";
        $resultat->free();
      }
      else
        $p = 'docs';
      $t = "Documents à télécharger - ${f['nom']}";

      // Répertoires parents
      $resultat = $mysqli->query("SELECT id, nom FROM reps WHERE FIND_IN_SET(id,'${f['parents']}') AND protection = 0");
      if ( $resultat->num_rows )  {
        $icone = 'home';
        $parents = "\n  <div class=\"item rep\" id=\"parents\">";
        while ( $r = $resultat->fetch_assoc() )  {
          $parents .= "\n    <a href=\"docs?rep=${r['id']}\"><img class=\"icone\" src=\"icones/$icone.png\">${r['nom']}</a>";
          $icone = 'next';
        }
        $parents .= "\n  </div>\n";
        $resultat->free();
      }
      
      // Vérification et formulaire éventuel
      include('login_lecture.php');
    }

    // Définition du type de fichier (entête HTML à envoyer)
    switch ( $f['ext'] )  {
      case '.pdf':
        $type = 'application/pdf';
        break;
      case '.doc':
        $type = 'application/msword';
        break;
      case '.odt':
        $type = 'application/vnd.oasis.opendocument.text';
        break;
      case '.docx':
        $type = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document';
        break;
      case '.xls':
        $type = 'application/vnd.ms-excel';
        break;
      case '.ods':
        $type = 'application/vnd.oasis.opendocument.spreadsheet';
        break;
      case '.xlsx':
        $type = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
        break;
      case '.ppt':
        $type = 'application/vnd.ms-powerpoint';
        break;
      case '.odp':
        $type = 'application/vnd.oasis.opendocument.presentation';
        break;
      case '.pptx':
        $type = 'application/vnd.openxmlformats-officedocument.presentationml.presentation';
        break;
      case '.jpg':
      case '.jpeg':
        $type = 'image/jpeg';
        break;
      case '.png':
        $type = 'image/png';
        break;
      case '.gif':
        $type = 'image/gif';
        break;
      case '.svg':
        $type = 'image/svg+xml';
        break;
      case '.tif':
      case '.tiff':
        $type = 'image/tiff';
        break;
      case '.bmp':
        $type = 'image/x-ms-bmp';
        break;
      case '.ps':
      case '.eps':
        $type = 'application/postscript';
        break;
      case '.avi':
        $type = 'video/x-msvideo';
        break;
      case '.mpeg':
      case '.mpg':
        $type = 'video/mpeg';
        break;
      case '.wmv':
        $type = 'video/x-ms-wmv';
        break;
      case '.mp4':
        $type = 'video/mp4';
        break;
      case '.ogv':
        $type = 'video/ogg';
        break;
      case '.qt':
      case '.mov':
        $type = 'video/quicktime';
        break;
      case '.mkv':
        $type = 'video/x-matroska';
        break;
      case '.mp3':
        $type = 'audio/mpeg';
        break;
      case '.ogg':
      case '.oga':
        $type = 'audio/ogg';
        break;
      case '.wma':
        $type = 'audio/x-ms-wma';
        break;
      case '.wav':
        $type = 'audio/x-wav';
        break;
      case '.ra':
      case '.rm':
        $type = 'audio/x-pn-realaudio';
        break;
      case '.txt':
        $type = 'text/plain';
        break;
      case '.rtf':
        $type = 'application/rtf';
        break;
      case '.zip':
        $type = 'application/zip';
        break;
      case '.rar':
        $type = 'application/rar';
        break;
      case '.7z':
        $type = 'application/x-7z-compressed';
        break;
      case '.sh':
        $type = 'text/x-sh';
        break;
      default :
        $type = 'application/octet-stream';
    }

    // Mise à disposition du fichier
    header("Content-Type: $type");
    header("Content-Disposition: attachment; filename=\"${f['nom']}${f['ext']}\"");
    header("Location: documents/${f['lien']}/${f['nom']}${f['ext']}");
  }
}
?>
