<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php');

// Recherche de la page concernée
$mysqli = premiere_connexion();
$resultat = $mysqli->query('SELECT id, cle, titre, nom, bandeau, protection FROM pages');
if ( $resultat->num_rows )  {
  if ( !empty($_REQUEST) )  {
    // Argument donné sous la forme page=cle valable (pour admin.php, en POST)
    if ( isset($_REQUEST['page']) )
      $_REQUEST[$_REQUEST['page']] = '';
    while ( $r = $resultat->fetch_assoc() )
      if ( isset($_REQUEST[$r['cle']]) )  {
        $page = $r;
        $pid = $page['id'];
        break;
      }
  }
  // Page par défaut pour la partie publique : la page d'accueil
  if ( !isset($page) )  {
    // Page par défaut pour l'interface d'administration : admin.php
    if ( $admin )
      include('admin.php');
    $resultat->data_seek(0);
    $page = $resultat->fetch_assoc();
    $pid = $page['id'];
  }
  $resultat->free();
}
else
  include('installation.php');

///////////////////
// Modifications //
///////////////////
if ( ( $admin ) && isset($_REQUEST['titre']) )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
  $mysqli->set_charset('utf8');
  
  // Traitement d'un ajout/modification
  if ( isset($_REQUEST['modifie']) )  {
    // Vérification des données envoyées
    if ( !strlen($_REQUEST['texte']) )
      $message = 'Il n\'est pas possible de valider un texte vide. Pour supprimer une information, il faut cliquer sur Supprimer.';
    else  {
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('infos');
      // Validation des données envoyées
      $texte = $mysqli->real_escape_string($_REQUEST['texte']);
      $titre = $mysqli->real_escape_string($_REQUEST['titre']);
      // Si identifiant, modification d'une info existante (pas de lien en page d'accueil)
      if ( isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )
        $message = ( $mysqli->query("UPDATE infos SET texte = '$texte', titre = '$titre', auto = '' WHERE id = $id")
        ) ? 'L\'information a bien été modifiée.' : 'L\'information n\'a pas pu être modifiée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      // Sinon, nouvelle information (lien en page d'accueil)
      else  {
        $cache = ( isset($_REQUEST['cache']) ) ? 1 : 0;
        $message = ( $mysqli->query("UPDATE infos SET ordre = (ordre+1) WHERE page = $pid")
                  && $mysqli->query("INSERT INTO infos SET ordre = 1, page = $pid, texte = '$texte', titre = '$titre', cache = $cache, auto = ''")
                  && ( $id = $mysqli->insert_id )
                  && $mysqli->query('ALTER TABLE infos ORDER BY ordre,page')
        ) ? 'L\'information a bien été ajoutée.' : 'L\'information n\'a pas pu être ajoutée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
        // Si l'identifiant de la page est non nul, ce n'est pas la page d'accueil : lien vers la nouvelle info (si non cachée)
        if ( $pid && $id && !$cache )
          $message .= ( $mysqli->query('UPDATE infos SET ordre = (ordre+1) WHERE page = 0') 
                     && $mysqli->query("INSERT INTO infos SET ordre = 1, page = 0, auto = 'info-$id', cache = 0, texte = '<p>Nouvelle information sur la page <a href=\".?".addslashes("${page['cle']}\">${page['nom']}")."</a>&nbsp;: $titre</p>', titre = '".date('d/m/y').'&nbsp;: nouvelle information\'')
                     && $mysqli->query('ALTER TABLE infos ORDER BY ordre,page')
          ) ? "<br>Un lien vers cette nouvelle information a été ajouté en haut de la page d'accueil. Ce lien est <a href=\".?accueil$urladmin\">modifiable/supprimable.</a>." : '';
      }
    }
  }

  // Traitement d'une transformation/suppression
  elseif ( isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )  {
    
    // Vérification de l'existence et récupération de l'ordre d'affichage
    $resultat = $mysqli->query("SELECT ordre, titre FROM infos WHERE id = $id");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $ordre = $r['ordre'];
      $resultat->free();

      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('infos');

      // Déplacement vers le haut
      if ( isset($_REQUEST['monte']) && ( $ordre > 1 ) )
        $message = ( $mysqli->query("UPDATE infos SET ordre = (2*$ordre-1-ordre) WHERE ( ordre = $ordre OR ordre = ($ordre-1) ) AND page = $pid")
                  && $mysqli->query('ALTER TABLE infos ORDER BY ordre,page')
        ) ? 'L\'information a bien été montée d\'une place.' : 'L\'information n\'a pas pu être déplacée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';

      // Déplacement vers le bas
      elseif ( isset($_REQUEST['descend']) )
        $message = ( $mysqli->query("UPDATE infos SET ordre = (2*$ordre+1-ordre) WHERE ( ordre = $ordre OR ordre = ($ordre+1) ) AND page = $pid")
                  && $mysqli->query('ALTER TABLE infos ORDER BY ordre,page')
        ) ? 'L\'information a bien été descendue d\'une place.' : 'L\'information n\'a pas pu être déplacée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';

      // Positionnement "montré" (apparaît publiquement)
      elseif ( isset($_REQUEST['montre']) )  {
        if ( $mysqli->query("UPDATE infos SET cache = 0 WHERE id = $id") )  {
          $message = 'L\'information a bien été réaffichée&nbsp;: elle apparaît à nouveau dans la partie publique.';
          // Si l'identifiant de la page est non nul : lien vers la nouvelle info
          if ( $pid )  {
            $message .= ( $mysqli->query('UPDATE infos SET ordre = (ordre+1) WHERE page = 0') 
                       && $mysqli->query("INSERT INTO infos SET ordre = 1, page = 0, auto = 'info-$id', cache = 0, texte = '<p>Nouvelle information sur la page <a href=\".?".addslashes("${page['cle']}\">${page['nom']}</a>&nbsp;: ${r['titre']}").'</p>\', titre = \''.date('d/m/y').'&nbsp;: nouvelle information\'')
                       && $mysqli->query('ALTER TABLE infos ORDER BY ordre,page')
            ) ? "<br>Un lien vers cette nouvelle information a été ajouté en haut de la page d'accueil. Ce lien est <a href=\".?accueil$urladmin\">modifiable/supprimable.</a>." : '';
          }
        }
        else
          $message = 'L\'information n\'a pas pu être réaffichée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      }

      // Positionnement "caché" (n'apparaît plus publiquement)
      elseif ( isset($_REQUEST['cache']) )  {
        if ( $mysqli->query("UPDATE infos SET cache = 1 WHERE id = $id") )  {
          $message = 'L\'information a bien été cachée&nbsp;: elle n\'apparaît plus dans la partie publique mais est toujours disponible ici pour modification ou réaffichage.';
          // Suppression de l'éventuelle information en page d'accueil
          $resultat = $mysqli->query("SELECT id, ordre FROM infos WHERE auto = 'info-$id'");
          if ( $resultat->num_rows )  {
            $r = $resultat->fetch_assoc();
            $resultat->free();
            $message .= ( $mysqli->query("DELETE FROM infos WHERE id = ${r['id']}")
                       && $mysqli->query("UPDATE infos SET ordre = (ordre-1) WHERE ordre > ${r['ordre']} AND page = 0")
            ) ? '<br>Le lien existant depuis la page d\'accueil a été automatiquement supprimé.' : '';
          }
        }
        else
          $message = 'L\'information n\'a pas pu être cachée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      }

      // Suppression
      elseif ( isset($_REQUEST['supprime']) )  {
        if ( $mysqli->query("DELETE FROM infos WHERE id = $id") && $mysqli->query("UPDATE infos SET ordre = (ordre-1) WHERE ordre > $ordre AND page = $pid") )  {
          $message = 'L\'information a bien été supprimée.';
          // Suppression de l'éventuelle information en page d'accueil
          $resultat = $mysqli->query("SELECT id, ordre FROM infos WHERE auto = 'info-$id'");
          if ( $resultat->num_rows )  {
            $r = $resultat->fetch_assoc();
            $resultat->free();
            $message .= ( $mysqli->query("DELETE FROM infos WHERE id = ${r['id']}")
                       && $mysqli->query("UPDATE infos SET ordre = (ordre-1) WHERE ordre > ${r['ordre']} AND page = 0")
            ) ? '<br>Le lien existant depuis la page d\'accueil a aussi été supprimé.' : '';
          }
        }
        else
          $message = 'L\'information n\'a pas pu être supprimée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      }
    }
  }

  // Traitement des modifications de la page
  elseif ( isset($_REQUEST['modifie_page']) )  {
    if ( !strlen($_REQUEST['nom']) )
      $message = 'Il n\'est pas possible de valider une page sans clé ou sans nom. Pour supprimer une page, il faut cliquer sur Supprimer.';
    else  {
      // Vérifications des données envoyées
      $nom = $mysqli->real_escape_string($_REQUEST['nom']);
      $titre = $mysqli->real_escape_string($_REQUEST['titre']);
      $bandeau = $mysqli->real_escape_string($_REQUEST['bandeau']);
      $protection = ( isset($_REQUEST['protection']) ) ? 1 : 0;
      // Envoi des données
      $message = ( $mysqli->query("UPDATE pages SET nom = '$nom', titre = '$titre',
                                   bandeau = '$bandeau', protection = $protection WHERE cle = '${page['cle']}'")
      ) ? 'Les données de la page ont bien été modifiées.' : 'Les données de la page n\'ont pas pu être modifiées. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      // Mise à jour pour l'affichage
      $resultat = $mysqli->query("SELECT cle, titre, nom, bandeau, protection FROM pages WHERE id = $pid");
      $page = $resultat->fetch_assoc();
      $resultat->free();
    }
  }

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = new mysqli($serveur,$base,$mdp,$base);
  $mysqli->set_charset('utf8');
}

//////////////
//// HTML ////
//////////////
$p = $page['cle'];
$t = $page['titre'];

// Interface d'administration
if ( $admin ) {

  // Haut de page, menu et message
  $t = "Modification de la page «&nbsp;${page['nom']}&nbsp;»";
  include('haut.php');
  // Formulaire de modification des données de la page et aide générale
  $protection = ( $page['protection'] ) ? ' checked' : '';
  $message = ( $pid ) ? "
    <p>Ajouter une nouvelle information sur cette page créera automatiquement une information sur la page d'accueil, avec un lien vers cette page. Cette information «&nbsp;automatique&nbsp;» sera modifiable <a href=\"?accueil$urladmin\">en éditant la page d'accueil</a>.</p>" : '';
  echo <<<FIN
  <div class="item admin">
  <form action="?$p$urladmin" method="post">
    <input class="bouton" type="submit" name="modifie_page" value="Valider">
    <h3>Modification de l'affichage de la page</h3>
    <p class="ligne"><label for="titre">Titre&nbsp;: </label><input type="text" id="titre" name="titre" value="${page['titre']}" size="80"></p>
    <p class="ligne"><label for="nom">Nom dans le menu&nbsp;: </label><input type="text" id="nom" name="nom" value="${page['nom']}" size="50"></p>
    <p class="ligne"><label for="bandeau">Texte de début&nbsp;:</label></p>
    <textarea id="bandeau" name="bandeau" rows="2" cols="100">${page['bandeau']}</textarea>
    <p class="ligne"><label for="protection">Accès avec mot de passe&nbsp;: </label><input type="checkbox" id="protection" name="protection" value="1"$protection></p>
  </form>
  </div>

  <div class="item aide">
    <p>Vous pouvez ci-dessus modifier l'affichage de la page. Pour modifier les autres pages, il faut aller <a href="pages">ici</a>. Si vous cochez l'<em>Accès avec mot de passe</em>, cette page ne pourra être vue que par les utilisateurs ayant entré un mot de passe. Les utilisateurs sont modifiables <a href"utilisateurs">ici</a>.</p>
    <p>Vous pouvez ci-dessous ajouter une information sur cette page ou modifier les existantes. Toute nouvelle information apparaîtra automatiquement en haut de la page. L'ordre de l'ensemble des informations est modifiable.</p>
    <p>Il est possible de «&nbsp;cacher&nbsp;» une information de la partie publique du site sans la supprimer réellement de la base de données. Cela peut être utile pour une information qui n'est plus d'actualité mais qui pourrait servir à nouveau ultérieurement.</p>$message
  </div>


FIN;

  // Fonction d'affichage
  function affichage($r)  {
    if ( $r['id'] )  {
      $debut = "Information n°${r['ordre']}";
      $valide1 = '';
      $valide = "\n      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications sur le titre ou le texte\">";
      $monte = ( $r['ordre'] == 1 ) ? '' : "\n      <input type=\"submit\" name=\"monte\" value=\"&uarr;\" title=\"Remonter l'information dans l'ordre d'apparition\">";
      $descend = ( $r['ordre'] == $GLOBALS['max'] ) ? '' : "\n      <input type=\"submit\" name=\"descend\" value=\"&darr;\" title=\"Descendre l'information dans l'ordre d'apparition\">";
      $suppr = "\n      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer l'information\">";
      $cache_nouveau = '';
      if ( $r['cache'] )  {
        $debut .= ' (information cachée, non présente sur le site public)';
        $cache_classe = ' cache';
        $cache = "\n      <input type=\"submit\" name=\"montre\" value=\"Montrer\" title=\"Montrer l'information, la rendre visible depuis le site public\">";
      }
      else  {
        $cache_classe = '';
        $cache = "\n      <input type=\"submit\" name=\"cache\" value=\"Cacher\" title=\"Cacher l'information, la rendre invisible depuis le site public (L'information sera encore visible ici, par exemple pour une modification ultérieure)\">";
      }
    }
    else  {
      $debut = 'Nouvelle information';
      $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications sur le titre ou le texte\">";
      $valide = $monte = $descend = $cache = $suppr = $cache_classe = '';
      $cache_nouveau = "\n    <p class=\"ligne\"><label for=\"cache\">Ne pas publier immédiatement (information cachée)&nbsp;: </label><input type=\"checkbox\" id=\"cache\" name=\"cache\" value=\"1\"></p>";
    }
    echo <<<FIN
  <div class="item admin$cache_classe">
  <form action="?${GLOBALS['p']}${GLOBALS['urladmin']}" method="post">$valide1
    <h3>$debut</h3>
    <p class="boutons">$valide$monte$descend$cache$suppr
    </p>
    <input class="ligne" type="text" name="titre" size=50 maxlength=65533 value="${r['titre']}">
    <textarea name="texte" rows="10" cols="100">${r['texte']}</textarea>$cache_nouveau
    <input type="hidden" name="id" value="${r['id']}">
  </form>
  </div>


FIN;
  
  }

  // Formulaire vide pour une nouvelle information
  affichage(array('id' => '', 'titre' => 'Titre de l\'information', 'texte' => '&lt;p&gt;Texte de l\'information à écrire ici&lt;/p&gt;'));

  // Affichage des informations
  $resultat = $mysqli->query("SELECT max(ordre) FROM infos WHERE page = $pid");
  $r = $resultat->fetch_row();
  $max = $r[0];
  $resultat = $mysqli->query("SELECT id,ordre,cache,titre,texte,auto FROM infos WHERE page = $pid");
  $mysqli->close();
  if ( $resultat->num_rows )  {
    while ( $r = $resultat->fetch_assoc() )
      affichage($r);
    $resultat->free();
  }
  else
    echo "  <h2>Il n'y actuellement aucune information enregistrée pour cette page.</h2>\n\n";

  echo "  <script type=\"text/javascript\" src=\"js/textarea.js\"></script>\n\n";
}

// Partie publique
else  {

  // Demander l'authentification si la page est protégée et l'utilisateur non connecté
  if ( $page['protection'] && !$lecteur )
    include('login_lecture.php');

  // Haut de page, menu et message
  include('haut.php');
  // Affichage des informations non cachées
  $resultat = $mysqli->query("SELECT titre,texte FROM infos WHERE page = $pid AND cache = 0");
  $mysqli->close();
  if ( $resultat->num_rows )  {
    echo "  <h2>${page['bandeau']}</h2>\n\n";
    while ( $r = $resultat->fetch_assoc() )
      echo <<<FIN
  <div class="item info">
    <h3>${r['titre']}</h3>
${r['texte']}
  </div>


FIN;
    $resultat->free();
  }
  else
    echo "  <h2>Cette page est actuellement vide.</h2>\n\n";
}

// Bas de page
include('bas.php');
?>
