<?php
// Script d'installation de Cahier de Prépa
// Vérifie la configuration et l'existence de la base de données
// Aide à l'installation et à la configuration

// Headers HTML
$header = <<<FIN
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
  <title>Cahier de Prépa : installation</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <link rel="stylesheet" href="css/style.css" type="text/css" media="screen">
  <link rel="stylesheet" href="css/couleurs.css" type="text/css" media="screen">
  <script type="text/javascript" src="js/jquery.js"></script>
</head>
<body style="padding: 0px 5%;">

<h1>Cahier de Prépa&nbsp;: installation</h1>

<div class="item">
  <h3>Bienvenue sur <a href="http://cahier-de-prepa.fr">Cahier de Prépa</a> et merci d'essayer ce gestionnaire de site&nbsp;!</h3>
  <p><a href="http://cahier-de-prepa.fr">Cahier de Prépa</a> est un gestionnaire de sites web pour la communication des professeurs vers leurs élèves de CPGE. Il permet de&nbsp;:</p>
  <ul>
    <li>Faire passer des informations de façon rapide sur des thèmes précis grâce à des pages dédiées</li>
    <li>Annoncer le programme de colle (pour les élèves et les colleurs)</li>
    <li>Tenir à jour le cahier de texte</li>
    <li>Mettre à disposition les documents distribués ou non</li>
  </ul>
</div>

FIN;
$footer = <<<FIN

</body>
</html>
FIN;

// Recharge de la page si elle est lancée par un autre script (donc config.php déjà appelé)
if ( defined('OK') )  {
  $proto = ( $GLOBALS['https'] ) ? 'https://' : 'http://';
  if ( strlen($GLOBALS['siteadmin']) )
    header("Location: $proto${GLOBALS['siteadmin']}/installation");
  else
    header("Location: $proto${GLOBALS['site']}/installation");
  exit();
}

///////////////////////////////
// Première vérifications, bloquantes : le fichier de configuration est ok
///////////////////////////////
if ( file_exists('config.php') && is_readable('config.php') )
  include('config.php');
else
  exit($header.'<h3 class="warning admin">Le fichier de configuration n\'existe pas ou n\'est pas lisible. Il doit s\'appeler config.php, se trouver au même endroit que l\'ensemble des fichiers constituant le site et être lisible par l\'utilisateur d\'Apache (<code>'.`whoami | tr -d '\n'`.'</code>).</h3>'.$footer);
// Vérification des données du fichier de configuration
if ( !isset($site) || !isset($siteadmin) || !isset($classe) || !isset($lycee) || !isset($https) || !isset($base) || !isset($mdp) )
  exit($header.'<h3 class="warning admin">Le fichier de configuration est incomplet, il manque des données nécessaire au fonctionnement du site. Il faut le modifier manuellement.</h3>'.$footer);
if ( strlen($base) > 12 )
  exit($header.'<h3 class="warning admin">Le nom de la base de données est trop long. Il ne doit pas être supérieur à 12 caractères. Il faut corriger cela dans le fichier de configuration manuellement.</h3>'.$footer);

///////////////////////////////
// Connexion obligatoire à partir d'ici, en entrant le mot de passe du fichier de configuration
///////////////////////////////
$s = ( strlen($siteadmin) ) ? $siteadmin : $site;
session_name(md5("$site-admin"));
session_set_cookie_params(0,strchr($s,'/').'/',str_replace(strchr($s,'/'),'',$s));
session_start();
if ( isset($_SESSION[md5($site)]) )  {
  if ( !isset($_REQUEST['deconnexion']) && ( $_SESSION['client'] == $_SERVER['HTTP_USER_AGENT'] ) && ( $_SESSION['ip'] == $_SERVER['REMOTE_ADDR'] ) )
    $admin = true;
  else  $admin = false;
}
elseif ( isset($_REQUEST['motdepasse']) && ( $_REQUEST['motdepasse'] == $mdp ) )  {
  $admin = true;
  // Interdiction de garder son identifiant de session
  session_regenerate_id(true);
  $_SESSION = array();
  // Pour vérification aux connexions ultérieures
  $_SESSION[md5($site)] = true;
  $_SESSION['client'] = $_SERVER['HTTP_USER_AGENT'];
  $_SESSION['ip'] = $_SERVER['REMOTE_ADDR'];
}
else  $admin = false;
if ( !$admin )  {
  $_SESSION = array();
  setcookie(session_name(),'',time()-3600);
  session_regenerate_id(true);
  echo <<<FIN
$header
<form class="warning admin" action="" method="post">
  <h3>Pour aller plus loin, vous devez entrer le mot de passe contenu dans le fichier de configuration.</h3>
  <p><input type="password" name="motdepasse"> <input type="submit" name="Ok" value="Envoyer"></p>
</form>
$footer
FIN;
  exit();
}
// Autoriser la connexion directe à l'interface d'administration uniquement si l'utilisateur et la matière sont définis (passage par l'étape 2)
$_SESSION['time'] = ( isset($_SESSION['ip']) ) ? time()+900 : time();

///////////////////////////////
// Codes MySQL des différentes étapes
///////////////////////////////
$code_etape1 = <<<FIN
DROP DATABASE IF EXISTS `$base`;
CREATE DATABASE `$base` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;
DELETE FROM mysql.user WHERE User = '$base' OR User = '$base-adm';
INSERT INTO mysql.user (Host, User, Password) 
  VALUES ('$serveur', '$base', PASSWORD('$mdp')),
         ('$serveur', '$base-adm', PASSWORD('$mdp'));
DELETE FROM mysql.db WHERE Db = '$base';
INSERT INTO mysql.db (Host, Db, User, Select_priv, Insert_priv, Update_priv, Delete_priv, Alter_priv, Drop_priv) 
  VALUES ('$serveur', '$base', '$base', 'Y', 'N', 'N', 'N', 'N', 'N'),
         ('$serveur', '$base','$base-adm', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
FLUSH PRIVILEGES;

USE `$base`;
CREATE TABLE `matieres` (
  `id` tinyint(2) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `ordre` tinyint(2) unsigned NOT NULL,
  `cle` varchar(50) NOT NULL,
  `nom` varchar(50) NOT NULL,
  `colles` tinyint(1) unsigned NOT NULL,
  `cdt` tinyint(1) unsigned NOT NULL,
  `docs` tinyint(1) unsigned NOT NULL,
  KEY `colles` (`colles`),
  KEY `cdt` (`cdt`),
  KEY `docs` (`docs`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `utilisateurs` (
  `id` tinyint(2) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `nom` varchar(50) NOT NULL,
  `mdp` char(40) NOT NULL,
  `matiere` tinyint(2) unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `pages` (
  `id` tinyint(2) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `ordre` tinyint(2) unsigned NOT NULL,
  `cle` varchar(50) NOT NULL,
  `nom` varchar(50) NOT NULL,
  `titre` text NOT NULL,
  `bandeau` text NOT NULL,
  `protection` tinyint(1) unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `infos` (
  `id` tinyint(3) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `ordre` tinyint(2) unsigned NOT NULL,
  `page` tinyint(2) unsigned NOT NULL,
  `cache` tinyint(1) unsigned NOT NULL,
  `titre` text NOT NULL,
  `texte` text NOT NULL,
  `auto` varchar(20) NOT NULL,
  KEY `ordre` (`ordre`,`page`),
  KEY `cache` (`cache`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `semaines` (
  `id` tinyint(2) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `debut` date NOT NULL,
  `colle` tinyint(1) unsigned NOT NULL,
  `vacances` tinyint(1) unsigned NOT NULL,
  KEY `debut` (`debut`),
  KEY `colle` (`colle`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `colles` (
  `id` tinyint(3) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `semaine` tinyint(2) unsigned NOT NULL,
  `matiere` tinyint(2) unsigned NOT NULL,
  `texte` text NOT NULL,
  `cache` tinyint(1) NOT NULL,
  KEY `semaine` (`semaine`),
  KEY `matiere` (`matiere`),
  KEY `cache` (`cache`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `cdt` (
  `id` smallint(5) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `matiere` tinyint(2) unsigned NOT NULL,
  `semaine` tinyint(2) unsigned NOT NULL,
  `jour` date NOT NULL,
  `h_debut` time NOT NULL,
  `h_fin` time NOT NULL,
  `pour` date NOT NULL,
  `type` tinyint(2) unsigned NOT NULL,
  `texte` text NOT NULL,
  `demigroupe` tinyint(1) unsigned NOT NULL,
  `cache` tinyint(1) unsigned NOT NULL,
  KEY `matiere` (`matiere`),
  KEY `semaine` (`semaine`),
  KEY `type` (`type`),
  KEY `cache` (`cache`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `cdt-types` (
  `id` tinyint(2) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `matiere` tinyint(2) unsigned NOT NULL,
  `ordre` tinyint(2) unsigned NOT NULL,
  `titre` varchar(50) NOT NULL,
  `cle` varchar(20) NOT NULL,
  `h_fin` tinyint(1) unsigned NOT NULL,
  KEY `matiere` (`matiere`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `cdt-seances` (
  `id` tinyint(2) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `matiere` tinyint(2) unsigned NOT NULL,
  `ordre` tinyint(2) unsigned NOT NULL,
  `nom` varchar(40) NOT NULL,
  `jour` tinyint(1) unsigned NOT NULL,
  `h_debut` time NOT NULL,
  `h_fin` time NOT NULL,
  `type` tinyint(3) unsigned NOT NULL,
  `demigroupe` tinyint(1) unsigned NOT NULL,
  KEY `matiere` (`matiere`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `reps` (
  `id` tinyint(3) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `parent` tinyint(3) unsigned NOT NULL,
  `parents` varchar(50) NOT NULL,
  `matiere` tinyint(2) unsigned NOT NULL,
  `nom` varchar(100) NOT NULL,
  `nbfic` tinyint(2) unsigned NOT NULL,
  `nbrep` tinyint(2) unsigned NOT NULL,
  `protection` tinyint(1) unsigned NOT NULL,
  KEY `parent` (`parent`),
  KEY `matiere` (`matiere`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `docs` (
  `id` smallint(4) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `parent` tinyint(3) unsigned NOT NULL,
  `parents` varchar(50) NOT NULL,
  `matiere` tinyint(2) unsigned NOT NULL,
  `nom` varchar(100) NOT NULL,
  `upload` date NOT NULL,
  `taille` varchar(12) NOT NULL,
  `lien` char(15) NOT NULL,
  `ext` varchar(5) NOT NULL,
  `protection` tinyint(1) unsigned NOT NULL,
  KEY `parent` (`parent`),
  KEY `matiere` (`matiere`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

FIN;

$code_etape2 = <<<FIN
TRUNCATE matieres;
INSERT INTO matieres (id,ordre,cle,nom,colles,cdt,docs) VALUES (1,1,'[cle_matiere]','[nom_matiere]',1,1,0);
TRUNCATE utilisateurs;
INSERT INTO utilisateurs (nom,mdp,matiere) VALUES ('[utilisateur]',SHA1('[mot_de_passe]'),1);
FIN;

$c = addslashes($classe);
$l = addslashes($lycee);
$code_etape3 = <<<FIN
TRUNCATE reps;
INSERT INTO reps (id,parent,parents,matiere,nom,nbfic,nbrep,protection)
 VALUES (1, 0, '0', 0, 'Général', 0, 0, 0),
        (2, 0, '0', 1, (SELECT nom FROM matieres WHERE id = 1), 0, 0, 0);
TRUNCATE pages;
INSERT INTO pages (ordre,cle,nom,titre,bandeau,protection)
  VALUES (1,'accueil','Accueil','La classe $c du lycée $l','Dernières informations importantes&nbsp;:',0);
UPDATE pages SET id = 0;
ALTER TABLE `pages` AUTO_INCREMENT =1;
TRUNCATE `cdt-types`;
INSERT INTO `cdt-types` (`matiere`, `ordre`, `cle`, `titre`, `h_fin`) VALUES
(1, 1, 'cours', 'Cours', 1),
(1, 2, 'TD', 'Séance de travaux dirigés', 1),
(1, 3, 'TP', 'Séance de travaux pratiques', 1),
(1, 4, 'DS', 'Devoir surveillé', 1),
(1, 5, 'interros', 'Interrogation de cours', 0),
(1, 6, 'distributions', 'Distribution de document', 0),
(1, 7, 'DM', 'Devoir maison', 0);

TRUNCATE semaines;

-- suivi des définitions des semaines de la zone choisie

FIN;
if ( isset($_REQUEST['zone']) )
  switch ( $_REQUEST['zone'] )  {
    case 'A':
    $code_etape3 .= <<<FIN
INSERT INTO semaines (debut, colle, vacances) VALUES
  ('2012-09-04',0,0),('2012-09-10',0,0),('2012-09-17',0,0),('2012-09-24',1,0),('2012-10-01',1,0),('2012-10-08',1,0),('2012-10-15',1,0),
  ('2012-10-22',1,0),('2012-10-29',0,1),('2012-11-12',1,0),('2012-11-19',1,0),('2012-11-26',1,0),('2012-12-03',1,0),('2012-12-10',1,0),
  ('2012-12-17',1,0),('2012-12-24',0,2),('2013-01-07',1,0),('2013-01-14',1,0),('2013-01-21',1,0),('2013-01-28',1,0),('2013-02-04',1,0),
  ('2013-02-11',1,0),('2013-02-18',1,0),('2013-02-25',0,3),('2013-03-11',1,0),('2013-03-18',1,0),('2013-03-25',1,0),('2013-04-02',1,0),
  ('2013-04-08',1,0),('2013-04-15',1,0),('2013-04-22',0,4),('2013-05-06',1,0),('2013-05-13',1,0),('2013-05-21',1,0),('2013-05-27',1,0),
  ('2013-06-03',1,0),('2013-06-10',1,0),('2013-06-17',1,0),('2013-06-24',1,0),('2013-07-01',1,0);

FIN;
    break;
    case 'B':
    $code_etape3 .= <<<FIN
INSERT INTO semaines (debut, colle, vacances) VALUES
  ('2012-09-04',0,0),('2012-09-10',0,0),('2012-09-17',0,0),('2012-09-24',1,0),('2012-10-01',1,0),('2012-10-08',1,0),('2012-10-15',1,0),
  ('2012-10-22',1,0),('2012-10-29',0,1),('2012-11-12',1,0),('2012-11-19',1,0),('2012-11-26',1,0),('2012-12-03',1,0),('2012-12-10',1,0),
  ('2012-12-17',1,0),('2012-12-24',0,2),('2013-01-07',1,0),('2013-01-14',1,0),('2013-01-21',1,0),('2013-01-28',1,0),('2013-02-04',1,0),
  ('2013-02-11',1,0),('2013-02-18',0,3),('2013-03-04',1,0),('2013-03-11',1,0),('2013-03-18',1,0),('2013-03-25',1,0),('2013-04-02',1,0),
  ('2013-04-08',1,0),('2013-04-15',0,4),('2013-04-29',1,0),('2013-05-06',1,0),('2013-05-13',1,0),('2013-05-21',1,0),('2013-05-27',1,0),
  ('2013-06-03',1,0),('2013-06-10',1,0),('2013-06-17',1,0),('2013-06-24',1,0),('2013-07-01',1,0);

FIN;
    break;
    case 'C':
    $code_etape3 .= <<<FIN
INSERT INTO semaines (debut, colle, vacances) VALUES
  ('2012-09-04',0,0),('2012-09-10',0,0),('2012-09-17',0,0),('2012-09-24',1,0),('2012-10-01',1,0),('2012-10-08',1,0),('2012-10-15',1,0),
  ('2012-10-22',1,0),('2012-10-29',0,1),('2012-11-12',1,0),('2012-11-19',1,0),('2012-11-26',1,0),('2012-12-03',1,0),('2012-12-10',1,0),
  ('2012-12-17',1,0),('2012-12-24',0,2),('2013-01-07',1,0),('2013-01-14',1,0),('2013-01-21',1,0),('2013-01-28',1,0),('2013-02-04',1,0),
  ('2013-02-11',1,0),('2013-02-18',1,0),('2013-02-25',1,0),('2013-03-04',0,3),('2013-03-18',1,0),('2013-03-25',1,0),('2013-04-02',1,0),
  ('2013-04-08',1,0),('2013-04-15',1,0),('2013-04-22',1,0),('2013-04-29',0,4),('2013-05-13',1,0),('2013-05-21',1,0),('2013-05-27',1,0),
  ('2013-06-03',1,0),('2013-06-10',1,0),('2013-06-17',1,0),('2013-06-24',1,0),('2013-07-01',1,0);

FIN;
    break;
  }

///////////////////////////////
// Installation
///////////////////////////////
if ( isset($_REQUEST['etape']) )  {
  switch ( $_REQUEST['etape'] )  {
    case 1:
      $mysqli = new mysqli($serveur,'root',$_REQUEST['mdp'],'mysql');
      if ( $mysqli->connect_errno )
        $message = 'La connexion à la base de données est impossible. Le mot de passe root est certainement faux. Erreur MySQL n°'.$mysqli->connect_errno.', «'.$mysqli->connect_error.'».';
      else  {
        $mysqli->set_charset('utf8');
        $mysqli->multi_query($code_etape1);
        $mysqli->close();
      }
    break;
    case 2:
      if ( strlen($_REQUEST['mdp1']) && ( $_REQUEST['mdp1'] == $_REQUEST['mdp2'] ) )  {
        $mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
        $mysqli->set_charset('utf8');
        $user = $mysqli->real_escape_string($_REQUEST['user']);
        $clemat = $mysqli->real_escape_string($_REQUEST['cle']);
        $code_etape2 = str_replace('[mot_de_passe]',$_REQUEST['mdp1'],$code_etape2);
        $code_etape2 = str_replace('[utilisateur]',$user,$code_etape2);
        $code_etape2 = str_replace('[cle_matiere]',$clemat,$code_etape2);
        $code_etape2 = str_replace('[nom_matiere]',$mysqli->real_escape_string($_REQUEST['matiere']),$code_etape2);
        $mysqli->multi_query($code_etape2);
        if ($mysqli->errno)
          $message = 'Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
        $mysqli->close();
      }
      else
        $message = 'Le mot de passe n\'a pas été correctement entré. Il ne peut pas être vide et vous devez l\'écrire de façon identique dans les deux cases.';
    break;
    case 3:
      $mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
      $mysqli->set_charset('utf8');
      $mysqli->multi_query($code_etape3);
      if ($mysqli->errno)
        $message = 'Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      $mysqli->close();
  }
  // Pour prendre en compte les modifications avant les tests qui suivent
  sleep(1);
}

///////////////////////////////
// Vérifications
///////////////////////////////
// Étape 1 : Vérification de la connexion pour l'utilisateur "public" (en lecture)
$mysqli = new mysqli($serveur,$base,$mdp);
if ( $mysqli->connect_errno || !($mysqli->select_db($base)) )  $etape = 1;
// Vérification de la connexion pour l'utilisateur "administration" (en écriture)
else  {
  $mysqli->close();
  $mysqli = new mysqli($serveur,"$base-adm",$mdp);
  if ( $mysqli->connect_errno || !($mysqli->select_db($base)) )  $etape = 1;
  
  // Étape 1bis : Vérification de la définition des tables
  else  {
    $resultat = $mysqli->query('SHOW TABLES');
    $tables = array('cdt','cdt-seances','cdt-types','colles','docs','infos','matieres','pages','reps','semaines','utilisateurs');
    if ( $resultat->num_rows )  {
      while ( $r = $resultat->fetch_row() )  $tables = array_diff($tables,$r);
      $resultat->free();
    }
    if ( !empty($tables) )  $etape = 1;
    
    // Étape 2 : Vérification de l'existence d'au moins un administrateur
    else  {
      $resultat = $mysqli->query('SELECT nom FROM utilisateurs LIMIT 1');
      if ( !($resultat->num_rows) )  $etape = 2;
      
      // Étape 2bis : Vérification de l'existence d'au moins une matière
      else  {
        $r = $resultat->fetch_assoc();
        $_SESSION['user'] = $r['nom'];
        $resultat->free();
        $resultat = $mysqli->query('SELECT cle FROM matieres LIMIT 1');
        if ( !($resultat->num_rows) )  $etape = 2;
        
        // Étape 3 : Vérification de la présence d'au moins un répertoire
        else  {
          $r = $resultat->fetch_assoc();
          $_SESSION['mat'] = $r['cle'];
          $resultat->free();
          $resultat = $mysqli->query('SELECT id FROM reps LIMIT 1');
          if ( !($resultat->num_rows) )  $etape = 3;
          
          // Étape 3bis : Vérification de la présence d'au moins une page
          else  {
            $resultat->free();
            $resultat = $mysqli->query('SELECT id FROM pages LIMIT 1');
            if ( !($resultat->num_rows) )  $etape = 3;
          
            // Étape 3ter : Vérification de la présence d'au moins un type de séances
            else  {
              $resultat->free();
              $resultat = $mysqli->query('SELECT id FROM `cdt-types` LIMIT 1');
              if ( !($resultat->num_rows) )  $etape = 3;
            
              // Étape 3quater : Vérification de la présence d'au moins une semaine
              else  {
                $resultat->free();
                $resultat = $mysqli->query('SELECT debut FROM semaines LIMIT 1');
                if ( !($resultat->num_rows) )  $etape = 3;
                else  $resultat->free();
              }
            }
          }
        }
      }
    }
  }
  $mysqli->close();
}
if ( !isset($etape) )  {
  // Vérification du répertoire "documents"
  if ( !is_dir('documents') )
    $erreur[] = 'Le répertoire «&nbsp;documents&nbsp;» n\'existe pas à la racine du site web.';
  elseif ( !is_readable('documents') || !is_executable('documents') || !is_writable('documents') )
    $erreur[] = 'Le répertoire «&nbsp;documents&nbsp;» n\'a pas les bons droits d\'accès. Il doit être accessible en lecture et en écriture. Vous pouvez taper en console&nbsp;:<br>
    <code>cd '.dirname(__FILE__).' && sudo chgrp '.`id -gn | tr -d '\n'`.' documents && sudo chmod g+w documents</code>';
  else 
    $reps[] = 'Le répertoire «&nbsp;documents&nbsp;» n\'a visiblement aucun problème.';
  // Vérification du répertoire "sauvegarde"
  if ( !is_dir('sauvegarde') )
    $erreur[] = 'Le répertoire «&nbsp;sauvegarde&nbsp;» n\'existe pas à la racine du site web.';
  elseif ( !is_readable('sauvegarde') || !is_executable('sauvegarde') || !is_writable('sauvegarde') )
    $erreur[] = 'Le répertoire «&nbsp;sauvegarde&nbsp;» n\'a pas les bons droits d\'accès. Il doit être accessible en lecture et en écriture. Vous pouvez taper en console&nbsp;:<br>
    <code>cd '.dirname(__FILE__).' && sudo chgrp '.`id -gn | tr -d '\n'`.' sauvegarde && sudo chmod g+w sauvegarde</code>';
  else 
    $reps[] = 'Le répertoire «&nbsp;sauvegarde&nbsp;» n\'a visiblement aucun problème.';
  // Vérification de la quantité de données téléchargeable
  if ( '100M' != ini_get('upload_max_filesize') )
    $erreur[] = 'Les directives d\'augmentation de la taille des documents envoyés sur le site, dans le fichier <code>.htaccess</code> ne sont visiblement pas prises en compte. Cela signifie qu\'elle est relativement faible (a priori 2 Mo), que les documents relativement lourds ne pourront pas être envoyés. Les documents classiques ne devraient cependant pas être affectés.<br> Pour modifier cela, vous devez obliger le serveur à prendre en compte les <code>.htaccess</code>. Il s\'agit en général de la directive <code>AllowOverride All</code> à mettre dans les fichiers de configuration d\'Apache.';
}

// HTML
echo "$header
<form style=\"position: absolute; top: 2.5em; left: 5%;\" action=\"\" method=\"post\"><input type=\"submit\" name=\"deconnexion\" value=\"Se déconnecter\"></form>

";
if ( isset($message) )
  echo "\n<p class=\"warning\">$message</p>\n";

// Si on est sur une des étapes d'installation : on exécute
if ( isset($etape) )  {
?>

<div class="item admin">
  <p>Vous êtes actuellement sur la page d'installation de votre <a href="http://cahier-de-prepa.fr">Cahier de Prépa</a>. Cette installation se déroule en 3 étapes&nbsp;:</p>
  <ul>
    <li<?php if ( $etape == 1 )  echo ' style="font-weight: 700;"'; ?>>Étape n°1&nbsp;: Création des tables de la base de données et des accès internes à la base</li>
    <li<?php if ( $etape == 2 )  echo ' style="font-weight: 700;"'; ?>>Étape n°2&nbsp;: Création d'un compte pour l'interface d'administration</li>
    <li<?php if ( $etape == 3 )  echo ' style="font-weight: 700;"'; ?>>Étape n°3&nbsp;: Ajout des données minimales (première page, planning annuel, types de séances)</li>
  </ul>
</div>

<?php
  switch ( $etape )  {
    // Étape 1
    case 1:
?>
<div class="item admin">
  <h3>Étape 1&nbsp;: Création des tables de la base de données et des accès internes à la base</h3>
  <p>La première étape de l'installation correspond à la création des tables de la base de données ainsi que des droits d'accès et de modification à la base de données.</p>
  <p>Cette étape correspond à entrer un certain code au serveur <code>MySQL</code>, avec des droits d'administrateur sur le serveur. Vous pouvez le faire vous-même si vous le souhaitez, grâce au code ci-dessous, ou la laisser ce site le faire automatiquement en entrant ci-dessous le mot de passe root du serveur <code>MySQL</code>. Ce mot de passe n'est noté nulle part et ne sert qu'à cette étape.</p>
</div>

<form class="warning admin" action="" method="post">
  <h4>Mot de passe root du serveur <code>MySQL</code>&nbsp;:</h4>
  <p><input type="password" name="mdp"> <input type="submit" name="Ok" value="Envoyer"><input type="hidden" name="etape" value="1"></p>
</form>

<div class="item" id="code">
  <h4>Code <code>MySQL</code> envoyé à cette étape</h4>
  <pre style="margin: 0.5em 2%; padding: 0 4%;">
<?php echo $code_etape1; ?>
  </pre>
  <p>Remarque&nbsp;: Si des données existent partiellement, elles seront automatiquement supprimées.</p>
</div>
<?php
    break;

    // Étape 2
    case 2:
?>
<div class="item admin">
  <h3>Étape 2&nbsp;: Création d'un compte pour l'interface d'administration</h3>
  <p>Il faut maintenant créer votre compte pour vous connecter à l'interface d'administration. Le nom n'est utilisé qu'à la connexion et n'est jamais affiché sur la partie publique du site, il est donc possible de mettre un prénom ou ce que l'on veut. Les accents ne posent pas de problème. Le mot de passe est à entrer deux fois pour éviter les erreurs de saisie.</p>
  <p>Les mots de passe sont chiffrés avant d'être stockés dans la base de données&nbsp;: il n'y a donc aucun souci sur leur confidentialité. Même l'administrateur du site, l'hébergeur ou d'éventuels pirates ne pourront jamais y avoir accès. Lors de la connexion, le mot de passe entré est chiffré à son tour et ce sont les deux chiffrements qui sont comparés. Un bon mot de passe est un mot de passe d'au moins 8 caractères contenant des lettres, des chiffres et au moins un symbole parmi «&nbsp;?&nbsp;;&nbsp;:&nbsp;!&nbsp;.&nbsp;,-&nbsp;_&nbsp;».</p>
  <p>Vous devez de plus spécifier une matière. Elle vous sera automatiquement associée. Ceci sera modifiable dans l'interface d'administration.</p>
  <p>Le <em>nom de la matière</em> est le nom qui sera affiché dans le menu et dans les titres des pages associées à la matière. Mettre un nom plutôt long et éventuellement en plusieurs mots est possible. Par exemple «&nbsp;Mathématiques&nbsp;», «&nbsp;Sciences Physiques&nbsp;».</p>
  <p>La <em>clé</em> est un mot-clé qui sera utilisé uniquement dans les adresses web vers les pages associées à la matière. Il vaut mieux que ce soit un mot unique, court et sans majuscule. Par exemple «&nbsp;maths&nbsp;», «&nbsp;physique&nbsp;».</p>
  <p>Toutes ces données seront entièrement modifiables par l'interface d'administration. D'autres utilisateurs et d'autres matières pourront aussi être créés et modifiés ultérieurement.</p>
</div>

<div class="item admin">
<form action="" method="post">
  <p class="ligne"><label for="user">Nom d'utilisateur&nbsp;: </label><input type="input" id="user" name="user" value="" size="50"></p>
  <p class="ligne"><label for="mdp1">Mot de passe&nbsp;: </label><input type="password" id="mdp1" name="mdp1" value="" size="50"></p>
  <p class="ligne"><label for="mdp2">Confirmation&nbsp;: </label><input type="password" id="mdp2" name="mdp2" value="" size="50"></p>
  <p class="ligne"><label for="matiere">Nom de la matière&nbsp;: </label><input type="input" id="matiere" name="matiere" value="" size="50"></p>
  <p class="ligne"><label for="cle">Clé dans les adresses&nbsp;: </label><input type="input" id="cle" name="cle" value="" size="50"></p>
  <p style="text-align: center;"><input type="submit" name="Ok" value="Envoyer"><input type="hidden" name="etape" value="2"></p>
</form>
</div>

<div class="item" id="code">
  <h4>Code <code>MySQL</code> envoyé à cette étape</h4>
  <pre style="margin: 0.5em 2%; padding: 0 4%;">
<?php echo $code_etape2; ?>
  </pre>
  <p>Remarque&nbsp;: Si des utilisateurs ou des matières existent, ils seront automatiquement supprimés.</p>
</div>
<?php
    break;

    // Étape 3
    case 3:
?>
<div class="item admin">
  <h3>Étape 3&nbsp;: Ajout des données minimales</h3>
  <p>Votre <a href="http://cahier-de-prépa.fr">Cahier de Prépa</a> a besoin pour fonctionner correctement d'un minimum de données&nbsp;:</p>
  <ul>
    <li>Un répertoire de base et un répertoire spécifique à votre matière. Leur nom sont automatiques, mais modifiables dans l'interface d'administration.</li>
    <li>Une page d'accueil&nbsp;: elle affichera automatiquement les informations que vous entrez sur le site (nouveaux programmes de colles, nouvelles informations, nouveaux documents...). Vous pourrez aussi y ajouter manuellement des informations, et créer d'autres pages spécifiques aux sujets que vous souhaitez.</li>
    <li>Des types de séances (cours, TD, TP...) qui servent à différentier les différentes entrées de votre cahier de texte. Chaque matière aura ses propres types de séances.</li>
    <li>Le planning annuel, sur lequel est basé l'affichage du cahier de texte et des programmes de colles. Il intègre les vacances, il faut donc renseigner ci-dessous la zone scolaire dans laquelle vous vous trouvez.</li>
  </ul>
  <p>Toutes ces données seront entièrement modifiables ultérieurement dans l'interface d'administration. Il s'agit simplement d'une base minimale pour le bon fonctionnement du site.</p>
  <form action="" method="post">
    <p class="ligne"><label for="zone">Académie ou zone&nbsp;: </label>
      <select name="zone">
        <option value="B">Aix-Marseille</option>
        <option value="B">Amiens</option>
        <option value="B">Besançon</option>
        <option value="C">Bordeaux</option>
        <option value="A">Caen</option>
        <option value="A">Clermont-Ferrand</option>
        <option value="C">Créteil</option>
        <option value="B">Dijon</option>
        <option value="A">Grenoble</option>
        <option value="B">Lille</option>
        <option value="B">Limoges</option>
        <option value="A">Lyon</option>
        <option value="A">Montpellier</option>
        <option value="A">Nancy-Metz</option>
        <option value="A">Nantes</option>
        <option value="B">Nice</option>
        <option value="B">Orléans-Tours</option>
        <option value="C">Paris</option>
        <option value="B">Poitiers</option>
        <option value="B">Reims</option>
        <option value="A">Rennes</option>
        <option value="B">Rouen</option>
        <option value="B">Strasbourg</option>
        <option value="A">Toulouse</option>
        <option value="C">Versailles</option>
        <option value="A">A</option>
        <option value="B">B</option>
        <option value="C">C</option>
      </select>

      
    </p>
    <p style="text-align: center;"><input type="submit" name="Ok" value="Envoyer"><input type="hidden" name="etape" value="3"></p>
  </form>
</div>

<div class="item" id="code">
  <h4>Code <code>MySQL</code> envoyé à cette étape</h4>
  <pre style="margin: 0.5em 2%; padding: 0 4%;">
<?php echo $code_etape3; ?>
  </pre>
  <p>Remarque&nbsp;: Si des répertoires, des pages, des types de séances ou des semaines existent, ils seront automatiquement supprimés.</p>
</div>

<?php  
  }
}
// Sinon, on affiche la configuration et on regarde l'état des répertoires documents et sauvegarde
else  {
  $proto = ( $https ) ? 'https://' : 'http://';
  $site = ( strlen($siteadmin) ) ? $siteadmin : "$site/?admin";
?>

<div class="item admin">
  <h3>Votre <a href="http://cahier-de-prepa.fr">Cahier de Prépa</a> est correctement installé.</h3>
  <p>Vous pouvez le modifier grâce à <a href="<?php echo $proto.$site; ?>">l'interface d'administration</a>.</p>
</div>

<div class="item">
  <h3>Vérification des répertoires où le site doit pouvoir écrire</h3>
  <p>Le répertoire «&nbsp;documents&nbsp;» est le répertoire où vous pourrez envoyer des documents pour qu'ils soient téléchargeables par les élèves. Lorsque vous envoyez un document via le site, le site copie le document dans le répertoire&nbsp;: il doit donc pouvoir écrire à l'intérieur de ce répertoire.</p>
  <p>Le répertoire «&nbsp;sauvegarde&nbsp;» permet au site de faire des sauvegarde de la base de données. Chaque jour, au moment de la première modification d'une table, le site la sauvegarde automatiquement dans un fichier à l'intérieur du répertoire «&nbsp;sauvegarde&nbsp;»&nbsp;: il doit donc pouvoir écrire à l'intérieur de ce répertoire.</p>

<?php
  if ( isset($reps) )  {
    $reps = implode("</li>\n  <li>",$reps);
    echo <<<FIN
  <ul>
    <li>$reps</li>
  </ul>


FIN;
  }

  if ( isset($erreur) )  {
    $erreur = implode("</p>\n<p>",$erreur);
    echo <<<FIN
</div>

<div class="warning admin">
  <p>$erreur</p>
</div>


FIN;
  }
}
?>

</div>

<script type="text/javascript">

$( function() {

  $('#code h4').append(' <span>[déplier]</span>');
  $("#code h4 span").css('cursor','pointer').click( function () {
    $(this).parent().parent().find('pre,p').toggle();
    $(this).text($(this).text() == '[déplier]' ? '[replier]' : '[déplier]');
  });
  $('#code').find('pre,p').hide();

});

</script>


</body>
</html>
<?php exit(); ?>
