
$( function() {

  // Boutons supplémentaires
  $('\
  <div id="js_controls">\
    <p class="boutons">\
      <input type="button" id="js_ligne" value="Paragraphe" title="Transformer la sélection en paragraphe">\
      <input type="button" id="js_note" value="Par. important" title="Transformer la sélection en paragraphe important, qui s\'affichera en rouge. Seul le texte entre les balises est affiché, soit &lt;div class=&rdquo;note&rdquo;&gt;TEXTE&lt;/div&gt;">\
      <input type="button" id="js_annonce" value="Par. très important" title="Transformer la sélection en paragraphe très important, qui s\'affichera en rouge et encadré. Seul le texte entre les balises est affiché, soit &lt;div class=&rdquo;annonce&rdquo;&gt;TEXTE&lt;/div&gt;">\
      <input type="button" id="js_lien" value="Lien" title="Créer un lien : le titre est entre les balises, l\'adresse entre les guillemets après « href », soit &lt;a href=&rdquo;ADRESSE&rdquo;>TITRE</a>">\
      <input type="button" id="js_gras" value="Gras" title="Mettre la sélection en gras">\
      <input type="button" id="js_it" value="Italique" title="Mettre la sélection en italique">\
      <input type="button" id="js_exp" value="Exposant" title="Mettre la sélection en exposant">\
      <input type="button" id="js_ind" value="Indice" title="Mettre la sélection en indice">\
    </p>\
    <p class="boutons">\
      <input type="button" id="js_h3" value="Titre de type chapitre (h3)" title="Insérer un titre « grand »">\
      <input type="button" id="js_h4" value="Titre de type «&nbsp;I.&nbsp;» (h4)" title="Insérer un titre « premier niveau »">\
      <input type="button" id="js_h5" value="Titre de type «&nbsp;1.&nbsp;» (h5)" title="Insérer un titre « deuxième niveau »">\
      <input type="button" id="js_h6" value="Titre de type «&nbsp;a.&nbsp;» (h6)" title="Insérer un titre « troisième niveau »">\
      <input type="button" id="js_colle" value="Titre de prog. de colles (h4)" title="Insérer le titre d\'une sous-partie d\'un programme de colles.">\
      <input type="button" id="js_ul" value="Liste à puces" title="Insérer une liste à puces (chaque &lt;li&gt; est une puce)">\
    </p>\
    <p id="s1" class="symboles"></p>\
    <p id="s2" class="symboles"></p>\
    <div class="aide_js">\
      <p>Si vous souhaitez mettre un lien vers un document envoyé, vous pouvez le copier depuis la page «&nbsp;Mes documents&nbsp;»</a>.</p>\
      <p>Le texte doit être écrit en HTML&nbsp;: toute mise en forme est indiquée par deux balises, de début comme &lt;h3&gt; pour un gros titre, de fin comme &lt;/h3&gt;. Les boutons ci-dessus aident à «&nbsp;encadrer&nbsp;» un texte sélectionné des balises correctes.</p>\
      <p>Les retours à la ligne et les espaces multiples ne comptent pas. Un retour à la ligne au dans un paragraphe (&lt;p&gt;Bla bla&lt;/p&gt;) ne crée pas un retour à la ligne au final. Pour ce faire, on peut utiliser la balise unique &lt;br&gt; en fin de ligne, mais il vaut mieux mettre chaque phrase entre &lt;p&gt; et &lt;/p&gt;. Les espaces en début de ligne ne servent qu\'à la lisibilité.</p>\
    </div>\
  </div>').appendTo('body').toggle();

  // Symboles
  var symboles = [ '&forall;', '&exist;', '&part;', '&nabla;', '&prod;', '&sum;', '&plusmn;', '&radic;', '&infin;', '&int;', '&prop;', '&sim;', '&cong;', '&asymp;', '&ne;', '&equiv;', '&le;', '&ge;', '&sub;', '&sup;', '&nsub;', '&sube;', '&supe;', '&isin;', '&notin;', '&ni;', '&oplus;', '&otimes;', '&sdot;', '&and;', '&or;', '&cap;', '&cup;', '&real;', '&image;', '&empty;', '&deg;', '&prime;', '&micro;', '&larr;', '&uarr;', '&rarr;', '&darr;', '&harr;', '&lArr;', '&uArr;', '&rArr;', '&dArr;', '&hArr;' ];
  for (var i=0, n=symboles.length, s=''; i<n; i++) {
     s = symboles[i];
     $('#s1').append('<input type="button" class="js_symbole" value="'+s+'" title="Insérer '+s+' : &amp;'+s.substring(1)+'">');
  }
  symboles = [ '&alpha;', '&beta;', '&gamma;', '&Delta;', '&delta;', '&epsilon;', '&eta;', '&Theta;', '&theta;', '&Lambda;', '&lambda;', '&mu;', '&nu;', '&xi;', '&Pi;', '&pi;', '&rho;', '&Sigma;', '&sigma;', '&tau;', '&upsilon;', '&Phi;', '&phi;', '&Psi;', '&psi;', '&Omega;', '&omega;' ];
  for (i=0, n=symboles.length; i<n; i++) {
     s = symboles[i];
     $('#s2').append('<input type="button" class="js_symbole" value="'+s+'" title="Insérer '+s+' : &amp;'+s.substring(1)+'">');
  }

  // Aide
  $('.aide_js').prepend("<h4>Aide et explications <span></span></h4>");
  $(".aide_js h4 span").css('cursor','pointer').click( function () {
    $(this).parent().parent().find('p').toggle();
    $(this).text($(this).text() == '[déplier]' ? '[replier]' : '[déplier]');
  });
  $('.aide_js').find('p').hide();

  // Le focus sur un textarea fait apparaître les boutons au bon endroit
  $('textarea:not(#bandeau)').focus( function() {
    $('#active').prop('id','');
    $(this).prop('id','active');
    $('#js_controls').detach().appendTo($(this).parent()).show();
    $('.aide_js').find('p').hide();
    $(".aide_js h4 span").text('[déplier]');
  });
  
  
  // Fonction d'insertion dans la textarea
  function insert(debut,fin) {
    var ta = $('#active')[0];
    if (document.selection) {
      ta.focus();
      sel = document.selection.createRange();
      sel.text = debut+sel.text+fin;
      ta.focus();
    }
    else if (ta.selectionStart || ta.selectionStart == '0') {
      var d = ta.selectionStart;
      var f = ta.selectionEnd;
      var scrollTop = ta.scrollTop;
      ta.value = ta.value.substring(0,d)+debut+ta.value.substring(d,f)+fin+ta.value.substring(f,ta.value.length);
      ta.focus();
      ta.selectionStart = d + debut.length;
      ta.selectionEnd = f + debut.length;
      ta.scrollTop = scrollTop;
    } else {
      ta.value += debut+fin;
      ta.focus();
    }
  }
  
  // Actions d'insertion de balises
  $('#js_ligne').click(function() { insert('<p>','</p>'); });
  $('#js_lien').click(function() { insert('<a href="">','</a>'); });
  $('#js_note').click(function() { insert('\u000A<div class="note">','</div>'); });
  $('#js_annonce').click(function() { insert('\u000A<div class="annonce">','</div>'); });
  $('#js_gras').click(function() { insert('<strong>','</strong>'); });
  $('#js_it').click(function() { insert('<em>','</em>'); });
  $('#js_exp').click(function() { insert('<sup>','</sup>'); });
  $('#js_ind').click(function() { insert('<sub>','</sub>'); });
  $('#js_h3').click(function() { insert('\u000A<h3>Chapitre ','</h3>'); });
  $('#js_h4').click(function() { insert('\u000A<h4>I. ','</h4>'); });
  $('#js_h5').click(function() { insert('\u000A<h5>1. ','</h5>'); });
  $('#js_h6').click(function() { insert('\u000A<h6>a. ','</h6>'); });
  $('#js_colle').click(function() { insert('\u000A<h4>','</h4>'); });
  $('#js_ul').click(function() { insert('\u000A<ul>\u000A  <li>','</li>\u000A  <li></li>\u000A</ul>'); });
  $('.js_symbole').click(function() { insert($(this).val(),''); });

});

