<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par un script autorisé
if ( !defined('OK') )  exit();

// Gestion de la connexion pour l'interface d'administration
// $admin est faux par défaut. Si l'utilisateur a bien rempli le formulaire
//  précédemment, $admin devient vrai et on retourne au script appelant (debut.php)
//  Sinon, on affiche un formulaire spécifique (sans menu, donc pas d'appel à
//  haut.php).
$admin = false;
if ( isset($_REQUEST['login']) && isset($_REQUEST['motdepasse']) )  {

  // Récupération des logins/mdp dans la base MySQL et comparaison
  // Seuls les logins/mdp correspondant à une matière sont acceptés (les autres
  // sont des utilisateurs en lecture seulement)
  $mysqli = premiere_connexion();
  $resultat = $mysqli->query('SELECT utilisateurs.nom, utilisateurs.mdp, matieres.cle
                              FROM utilisateurs LEFT JOIN matieres ON utilisateurs.matiere = matieres.id
                              WHERE matieres.id IS NOT NULL');
  $mysqli->close();
  if ( $resultat->num_rows )  {
    while ( $r = $resultat->fetch_assoc() )
      if ( ( $r['nom'] == $_REQUEST['login'] ) && ( $r['mdp'] == sha1($_REQUEST['motdepasse']) ) )  {
        $admin = true;
        break;
      }
    $resultat->free();
  }
  // Si pas d'utilisateur enregistré : retour au script d'installation
  else
    include('installation.php');

  // Si connexion, génération de $_SESSION pour reconnaissance ultérieure
  if ( $admin )  {
    // Interdiction de garder son identifiant de session
    session_regenerate_id(true);
    $_SESSION = array();
    // Interdiction de pouvoir se connecter aux autres site sur le même serveur
    $_SESSION[md5($site)] = true;
    // Pour vérification aux connexions ultérieures
    $_SESSION['client'] = $_SERVER['HTTP_USER_AGENT'];
    $_SESSION['ip'] = $_SERVER['REMOTE_ADDR'];
    $_SESSION['user'] = $_POST['login'];
    $_SESSION['mat'] = $r['cle'];
    $_SESSION['time'] = time()+900;
    session_write_close();
    
    // Vérification du répertoire de sauvegarde des données MySQL
    if ( !is_dir('sauvegarde') || !is_executable('sauvegarde') || !is_writable('sauvegarde') )
      $message = 'Attention, le répertoire de sauvegarde n\'est pas accessible&nbsp;: cela signifie que les données ne pourront pas être sauvegardées périodiquement comme prévu, et qu\'aucune protection n\'est en fonctionnement pour prévenir un accident.';
      
    // Retour au script appelant
    return;
  }
  else
    $message = 'Ce login/mot de passe n\'est pas correct&nbsp;!';
}

// Message par défaut
if ( !isset($message) )
  $message = "Vous devez vous identifier pour accéder à cette partie du site.";

////////////
/// HTML ///
////////////

$t = "La $classe du lycée $lycee - Interface d'administration";
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
  <title><?php echo $t; ?></title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <link rel="stylesheet" href="css/style.css" type="text/css" media="screen">
  <link rel="stylesheet" href="css/couleurs.css" type="text/css" media="screen">
  <link rel="stylesheet" href="css/mobile.css" type="text/css" media="handheld, only screen and (max-device-width:480px)">
</head>
<body>

<h1><?php echo $t; ?></h1>

<p class="warning"><?php echo $message; ?></p>

<form class="warning" action="" method="post">
  <p class="ligne"><label for="login">Nom d'utilisateur&nbsp;: </label><input type="text" name="login" id="login"></p>
  <p class="ligne"><label for="motdepasse">Mot de passe&nbsp;: </label><input type="password" name="motdepasse" id="motdepasse"></p>
  <p><input type="submit" name="Ok" value="Envoyer"></p>
</form>

<h3 class="warning"><a href="http://<?php echo $site; ?>">Revenir au site public</a></h3>

</body>
</html>
<?php exit(); ?>
