<?php
// Sécurité et récupération des données de configuration
// Mode admin obligatoire (OK=2)
define('OK',2);
include('debut.php');

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['id']) )  {

  // Connexion à la base de données
  $mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
  $mysqli->set_charset('utf8');

  // Traitement d'un ajout/modification
  if ( isset($_REQUEST['modifie']) )  {
    // Vérification des données envoyées
    if ( !strlen($_REQUEST['cle']) || !strlen($_REQUEST['nom']) )
      $message = 'Il n\'est pas possible de valider une matière sans clé ou sans nom. Pour supprimer une matière, il faut cliquer sur Supprimer.';
    else  {
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('matieres');
      // Validation des données envoyées
      $cle = $mysqli->real_escape_string($_REQUEST['cle']);
      $nom = $mysqli->real_escape_string($_REQUEST['nom']);
      $colles = ( is_numeric($_REQUEST['colles']) ) ? $_REQUEST['colles'] : 0;
      $cdt = ( is_numeric($_REQUEST['cdt']) ) ? $_REQUEST['cdt'] : 0;
      // Si identifiant numérique, modification d'une matière existante
      if ( is_numeric($id = $_REQUEST['id']) )  {
        // Sauvegarde de la table contenant les données
        sauvegarde_mysql('reps');
        $message = ( $mysqli->query("UPDATE matieres SET cle = '$cle', nom = '$nom', colles = $colles, cdt = $cdt WHERE id = $id")
                  && $mysqli->query("UPDATE reps SET nom = '$nom' WHERE matiere = $id AND parent = 0")
        ) ? 'La matière «&nbsp;'.stripslashes($nom).'&nbsp;» a bien été modifiée.' : 'La matière «&nbsp;'.stripslashes($nom).'&nbsp;» n\'a pas pu être modifiée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      }
      // Si id = '', ajout d'une nouvelle matière
      else
        $message = ( $mysqli->query("INSERT INTO matieres SET cle = '$cle', nom = '$nom', colles = $colles, cdt = $cdt, docs = 0, ordre = ((SELECT MAX(m.ordre) FROM matieres AS m)+1)")
                  && ( $id = $mysqli->insert_id )
                  && $mysqli->query("INSERT INTO reps SET parent = 0, parents = 0, nom = '$nom', matiere = $id, nbrep = 0, nbfic = 0, protection = 0")
                  && $mysqli->query("INSERT INTO `cdt-types` (`matiere`, `ordre`, `cle`, `titre`, `h_fin`) VALUES
                                                             ($id, 1, 'cours', 'Cours', 1),
                                                             ($id, 2, 'TD', 'Séance de travaux dirigés', 1),
                                                             ($id, 3, 'TP', 'Séance de travaux pratiques', 1),
                                                             ($id, 4, 'DS', 'Devoir surveillé', 1),
                                                             ($id, 5, 'interros', 'Interrogation de cours', 0),
                                                             ($id, 6, 'distributions', 'Distribution de document', 0),
                                                             ($id, 7, 'DM', 'Devoir maison', 0)")
        ) ? 'La matière «&nbsp;'.stripslashes($nom).'&nbsp;» a bien été ajoutée.' : 'La matière «&nbsp;'.stripslashes($nom).'&nbsp;» n\'a pas pu être ajoutée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }
  }

  // Traitement d'une transformation/suppression
  elseif ( is_numeric($id = $_REQUEST['id']) )  {
    
    // Vérification de l'existence et récupération de l'ordre d'affichage
    $resultat = $mysqli->query("SELECT ordre, nom, (SELECT MAX(ordre) FROM matieres) AS max FROM matieres WHERE id = $id");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $ordre = $r['ordre'];
      $nom = $r['nom'];
      $resultat->free();

      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('matieres');

      // Déplacement vers le haut
      if ( isset($_REQUEST['monte']) && ( $ordre > 1 ) )
        $message = ( $mysqli->query("UPDATE matieres SET ordre = (2*$ordre-1-ordre) WHERE ordre = $ordre OR ordre = ($ordre-1)")
                  && $mysqli->query('ALTER TABLE matieres ORDER BY ordre')
        ) ? "La matière «&nbsp;$nom&nbsp;» a bien été montée d'une place." : "La matière «&nbsp;$nom&nbsp;» n'a pas pu être déplacée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      // Déplacement vers le bas
      elseif ( isset($_REQUEST['descend']) && ( $ordre < $r['max'] ) )
        $message = ( $mysqli->query("UPDATE matieres SET ordre = (2*$ordre+1-ordre) WHERE ordre = $ordre OR ordre = ($ordre+1)")
                  && $mysqli->query('ALTER TABLE matieres ORDER BY ordre')
        ) ? "La matière «&nbsp;$nom&nbsp;» a bien été descendue d'une place." : "La matière «&nbsp;$nom&nbsp;» n'a pas pu être déplacée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      // Suppression (impossible s'il ne reste qu'une matière)
      elseif ( isset($_REQUEST['supprime']) && ( $r['max'] > 1 ) )  {
        // Demande de confirmation
        if ( !isset($_REQUEST['confirme']) )  {
          $message = "
        <form action=\"\" method=\"post\">
          <p>Souhaitez-vous réellement supprimer la matière «&nbsp;${r['nom']}&nbsp;»&nbsp;? Cela entraînera la suppression de toutes les entrées du cahier de texte, de tous les programmes de colles et de tous les documents qui s'y rapportent. Ces suppressions seront définitives.</p>
          <p>Si un utilisateur est associé à cette matière, il deviendra associé à la première matière de la liste. Ceci sera modifiable <a href=\"utilisateurs". str_replace('&amp;','?',$urladmin) ."\">sur la page de modification des utilisateurs</a>.</p>
          <input type=\"submit\" name=\"confirme\" value=\"Oui\">
          <input type=\"hidden\" name=\"supprime\" value=\"Supprimer\">
          <input type=\"hidden\" name=\"id\" value=\"$id\">
        </form>\n";
        }
        else  {
          // Sauvegarde des tables contenant les données
          sauvegarde_mysql('colles');
          sauvegarde_mysql('cdt');
          sauvegarde_mysql('reps');
          sauvegarde_mysql('docs');
          // Liste des fichiers à supprimer
          $resultat = $mysqli->query("SELECT GROUP_CONCAT(CONCAT('documents/',lien) SEPARATOR ' ') FROM docs WHERE matiere = $id");
          $r = $resultat->fetch_row();
          if ( $mysqli->query("DELETE FROM matieres WHERE id = $id")
            && $mysqli->query("UPDATE matieres SET ordre = (ordre-1) WHERE ordre > $ordre")
            && $mysqli->query("DELETE FROM colles WHERE matiere = $id")
            && $mysqli->query("DELETE FROM cdt WHERE matiere = $id")
            && $mysqli->query("DELETE FROM `cdt-types` WHERE matiere = $id")
            && $mysqli->query("DELETE FROM `cdt-seances` WHERE matiere = $id")
            && $mysqli->query("DELETE FROM reps WHERE matiere = $id")
            && $mysqli->query("DELETE FROM docs WHERE matiere = $id")
            && $mysqli->query("UPDATE utilisateurs SET matiere = (SELECT m.id FROM matieres AS m ORDER BY m.ordre LIMIT 1) WHERE matiere = $id") )  {
            $message = "La matière «&nbsp;$nom&nbsp;» a bien été supprimée, ainsi que l'ensemble des programmes de colles, du cahier de texte et des documents associés.";
            // Suppression physique
            if ( strlen($r[0]) )
              exec("rm -rf ${r[0]}");
          }
          else
            $message = "La matière «&nbsp;$nom&nbsp;» n'a pas pu être supprimée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
        }
      }
    }
  }
  $mysqli->close();
}

//////////
// HTML //
//////////
// Haut de page, menu et message
$p = 'matieres';
$t = 'Modifications des matieres';
$mysqli = new mysqli($serveur,$base,$mdp,$base);
$mysqli->set_charset('utf8');
include('haut.php');

// Fonction d'affichage
function affichage($r)  {
  $colles = str_replace("${r['colles']}\"","${r['colles']}\" selected",'<option value="0">Ne pas afficher</option><option value="1">Afficher sans mot de passe</option><option value="2">Afficher avec mot de passe</option>');
  $cdt = str_replace("${r['cdt']}\"","${r['cdt']}\" selected",'<option value="0">Ne pas afficher</option><option value="1">Afficher sans mot de passe</option><option value="2">Afficher avec mot de passe</option>');
  if ( $r['id'] )  {
    $debut = "Matière n°${r['ordre']}";
    $valide1 = '';
    $valide = "\n      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $monte = ( $r['ordre'] == 1 ) ? '' : "\n      <input type=\"submit\" name=\"monte\" value=\"&uarr;\" title=\"Remonter la matière dans l'ordre d'apparition\">";
    $descend = ( $r['ordre'] == $GLOBALS['max'] ) ? '' : "\n      <input type=\"submit\" name=\"descend\" value=\"&darr;\" title=\"Descendre la matière dans l'ordre d'apparition\">";
    $suppr = ( $GLOBALS['max'] == 1 ) ? '' : "\n      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer la matière\">";
  }
  else  {
    $debut = 'Créer une nouvelle matière';
    $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $valide = $monte = $descend = $suppr = '';
  }
  echo <<<FIN
  <div class="item admin">
  <form action="" method="post">$valide1
    <h3>$debut</h3>
    <p class="boutons">$valide$monte$descend$suppr
    </p>
    <p class="ligne"><label for="nom">Nom complet&nbsp;: </label><input type="text" id="nom" name="nom" value="${r['nom']}" size="50"></p>
    <p class="ligne"><label for="cle">Clé dans l'adresse&nbsp;: </label><input type="text" id="cle" name="cle" value="${r['cle']}" size="30"></p>
    <p class="ligne"><label for="colles">Programme de colles</label>
      <select id="colles" name="colles">$colles</select>
    </p>
    <p class="ligne"><label for="cdt">Cahier de texte</label>
      <select id="cdt" name="cdt">$cdt</select>
    </p>
    <input type="hidden" name="id" value="${r['id']}">
  </form>
  </div>


FIN;
}

// Formulaire vide pour une nouvelle matière et aide générale
affichage(array('id' => '', 'ordre' => 0, 'cle' => 'cle_de_la_matiere', 'nom' => 'Nom de la matière', 'colles' => 1, 'cdt' => 1, 'docs' => 0 ));
?>

  <div class="item aide">
    <p>Vous pouvez ci-dessus ajouter une matière, ci-dessous modifier les existantes ou leur ordre d'affichage dans le menu.</p>
    <p>Supprimer une matière supprime automatiquement toutes les entrées du cahier de texte, tous les programmes de colles, tous les répertoires et documents qui s'y rapportent. Une confirmation est demandée avant la suppression.</p>
    <p>Le <em>nom complet</em> de la matière est ce qui est affiché, à la fois dans les titres des pages et dans le menu.</p>
    <p>La <em>clé</em> est un mot-clé qui sera utilisé uniquement dans l'adresse des pages reliées à la matière. Il vaut mieux que ce soit un mot unique, court et sans majuscule. Par exemple, «&nbsp;maths&nbsp;», «&nbsp;phys&nbsp;»...</p>
    <p>Vous pouvez aussi définir si le cahier de texte et les programmes de colles sont visible ou non, ou accessible uniquement par les utilisateurs qui auront donné un mot de passe. Les utilisateurs et leur mot de passe sont modifiables <a href="utilisateurs<?php echo str_replace('&amp;','?',$urladmin); ?>">ici</a>. Les pages de documents sont disponibles automatiquement, uniquement si des documents sont à télécharger.</p>
  </div>

<?php

// Affichage des matières existantes
$resultat = $mysqli->query('SELECT max(ordre) FROM matieres');
$r = $resultat->fetch_row();
$max = $r[0];
$resultat = $mysqli->query('SELECT id, ordre, cle, nom, colles, cdt, docs FROM matieres');
$mysqli->close();
while ( $r = $resultat->fetch_assoc() )
  affichage($r);
$resultat->free();

// Bas de page
include('bas.php');
?>
