<?php
// Sécurité et récupération des données de configuration
// Mode admin obligatoire (OK=2)
define('OK',2);
include('debut.php');

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['id']) )  {
  // Connexion à la base de données
  $mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
  $mysqli->set_charset('utf8');

  // Traitement d'un ajout/modification
  if ( isset($_REQUEST['modifie']) )  {
    $id = $_REQUEST['id'];
    // Vérification des données envoyées (page d'accueil : cle et nom "disabled", donc n'existent pas)
    if ( !strlen($_REQUEST['titre']) || ( !( $id == 0 ) && ( !strlen($_REQUEST['cle']) || !strlen($_REQUEST['nom']) ) ) )
      $message = 'Il n\'est pas possible de valider une page avec une clé, un nom ou un titre vide. Pour supprimer une page, il faut cliquer sur Supprimer.';
    else  {
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('pages');
      // Validation des données envoyées
      $titre = $mysqli->real_escape_string($_REQUEST['titre']);
      $bandeau = $mysqli->real_escape_string($_REQUEST['bandeau']);
      $protection = ( isset($_REQUEST['protection']) ) ? 1 : 0;
      // Si page d'accueil (id=0), seuls titre, bandeau et protection sont modifiables
      if ( $id === '0' )
        $message = ( $mysqli->query("UPDATE pages SET titre = '$titre', bandeau = '$bandeau', protection = $protection WHERE id = 0")
        ) ? 'La page d\'accueil a bien été modifiée.' : 'La page d\'accueil n\'a pas pu être modifiée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      else  {
        $cle = $mysqli->real_escape_string($_REQUEST['cle']);
        $nom = $mysqli->real_escape_string($_REQUEST['nom']);
        // Si identifiant numérique non nul, modification d'une page existante
        if ( $id )
          $message = ( $mysqli->query("UPDATE pages SET cle = '$cle', nom = '$nom', titre = '$titre',
                                       bandeau = '$bandeau', protection = $protection WHERE id = $id")
          ) ? 'La page «&nbsp;'.stripslashes($nom).'&nbsp;» a bien été modifiée.' : 'La page «&nbsp;'.stripslashes($nom).'&nbsp;» n\'a pas pu être modifiée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
        // Si id = '', ajout d'une nouvelle page
        else
          $message = ( $mysqli->query("INSERT INTO pages SET cle = '$cle', nom = '$nom', titre = '$titre',
                                       bandeau = '$bandeau', protection = $protection, ordre = ((SELECT MAX(p.ordre) FROM pages AS p)+1)")
          ) ? 'La page «&nbsp'.stripslashes($nom).'&nbsp;» a bien été ajoutée.' : 'La page «&nbsp;'.stripslashes($nom).'&nbsp;» n\'a pas pu être ajoutée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      }
    }
  }

  // Traitement d'une transformation/suppression (impossible pour la page d'accueil, id=0)
  elseif ( is_numeric($id = $_REQUEST['id']) && $id )  {
    
    // Vérification de l'existence et récupération de l'ordre d'affichage
    $resultat = $mysqli->query("SELECT ordre, nom, (SELECT MAX(ordre) FROM pages) AS max FROM pages WHERE id = $id");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $ordre = $r['ordre'];
      $nom = $r['nom'];
      $resultat->free();

      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('pages');

      // Déplacement vers le haut
      if ( isset($_REQUEST['monte']) && ( $ordre > 2 ) )
        $message = ( $mysqli->query("UPDATE pages SET ordre = (2*$ordre-1-ordre) WHERE ordre = $ordre OR ordre = ($ordre-1)")
                  && $mysqli->query('ALTER TABLE pages ORDER BY ordre')
        ) ? "La page «&nbsp;$nom&nbsp;» a bien été montée d'une place." : "La page «&nbsp;$nom&nbsp;» n'a pas pu être déplacée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      // Déplacement vers le bas
      elseif ( isset($_REQUEST['descend']) && ( $ordre < $r['max'] ) )
        $message = ( $mysqli->query("UPDATE pages SET ordre = (2*$ordre+1-ordre) WHERE ordre = $ordre OR ordre = ($ordre+1)")
                  && $mysqli->query('ALTER TABLE pages ORDER BY ordre')
        ) ? "La page «&nbsp;$nom&nbsp;» a bien été descendue d'une place." : "La page «&nbsp;$nom&nbsp;» n'a pas pu être déplacée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      // Suppression
      elseif ( isset($_REQUEST['supprime']) && ( $r['max'] > 1 ) )  {
        // Sauvegarde de la table contenant les données
        sauvegarde_mysql('infos');
        $message = ( $mysqli->query("DELETE FROM pages WHERE id = $id")
                  && $mysqli->query("DELETE FROM infos WHERE page = $id")
                  && $mysqli->query("UPDATE pages SET ordre = (ordre-1) WHERE ordre > $ordre")
        ) ? "La page «&nbsp;$nom&nbsp;» a bien été supprimée, ainsi que les informations qu'elle comportait." : "La page «&nbsp;$nom&nbsp;» n'a pas pu être supprimée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      }
    }
  }
  $mysqli->close();
}

//////////
// HTML //
//////////
// Haut de page, menu et message
$p = 'pages';
$t = 'Modifications des pages d\'informations du site';
$mysqli = new mysqli($serveur,$base,$mdp,$base);
$mysqli->set_charset('utf8');
include('haut.php');

// Fonction d'affichage
function affichage($r)  {
  // Si l'identifiant est 0, c'est la page d'accueil (non déplaçable, non supprimable, clé non modifiable)
  // Si l'identifiant est '', c'est une nouvelle page 
  if ( $r['id'] == '' )  {
    $debut = 'Créer une nouvelle page d\'informations';
    $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $valide = $monte = $descend = $suppr = $disabled = '';
  }
  elseif ( $r['id'] == 0 )  {
    $debut = 'Page d\'accueil (page n°1)';
    $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $valide = $monte = $descend = $suppr = '';
    $disabled = ' disabled';
  }
  else  {
    $debut = "Page d'informations n°${r['ordre']}";
    $valide1 = '';
    $valide = "\n      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $monte = ( $r['ordre'] == 2 ) ? '' : "\n      <input type=\"submit\" name=\"monte\" value=\"&uarr;\" title=\"Remonter la page dans l'ordre d'apparition\">";
    $descend = ( $r['ordre'] == $GLOBALS['max'] ) ? '' : "\n      <input type=\"submit\" name=\"descend\" value=\"&darr;\" title=\"Descendre la page dans l'ordre d'apparition\">";
    $suppr = "\n      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer la page\">";
    $disabled = '';
  }
  echo <<<FIN
  <div class="item admin">
  <form action="" method="post">$valide1
    <h3>$debut</h3>
    <p class="boutons">$valide$monte$descend$suppr
    </p>
    <p class="ligne"><label for="titre">Titre&nbsp;: </label><input type="text" id="titre" name="titre" value="${r['titre']}" size="80"></p>
    <p class="ligne"><label for="nom">Nom dans le menu&nbsp;: </label><input type="text" id="nom" name="nom" value="${r['nom']}" size="50"$disabled></p>
    <p class="ligne"><label for="cle">Clé dans l'adresse&nbsp;: </label><input type="text" id="cle" name="cle" value="${r['cle']}" size="30"$disabled></p>
    <p class="ligne"><label for="bandeau">Texte de début&nbsp;:</label></p>
    <textarea id="bandeau" name="bandeau" rows="2" cols="100">${r['bandeau']}</textarea>
    <p class="ligne"><label for="protection">Accès avec mot de passe&nbsp;: </label><input type="checkbox" id="protection" name="protection" value="1"${r['protection']}></p>
    <input type="hidden" name="id" value="${r['id']}">
  </form>
  </div>


FIN;
}

// Formulaire vide pour une nouvelle page et aide générale
affichage(array('id' => '', 'cle' => 'cle_de_la_page', 'nom' => 'Nom de la page', 'titre' => 'Titre de la page', 'bandeau' => 'Texte (éventuel) marqué en haut de la page', 'protection' => ''));
?>

  <div class="item aide">
    <p>Vous pouvez ci-dessus ajouter une page d'information, ci-dessous modifier les existantes ou leur ordre. Supprimer une page supprime automatiquement les informations qui y sont.</p>
    <p>Le <em>titre</em> de la page est ce qui sera affiché en haut de page et dans la barre de titre du navigateur. Par exemple, «&nbsp;À propos de l'ADS et du TIPE&nbsp;».</p>
    <p>Le <em>nom</em> sera affiché dans le menu en tant que lien vers la page. Il est censé être un peu plus court que le titre. Par exemple, «&nbsp;Informations ADS/TIPE&nbsp;».</p>
    <p>La <em>clé</em> est un mot-clé qui sera utilisé uniquement dans l'adresse de la page («&nbsp;<code>http://<?php echo $site; ?>/?[clé]</code>&nbsp;»). Il vaut mieux que ce soit un mot unique, court et sans majuscule. Par exemple, «&nbsp;tipe&nbsp;».</p>
    <p>Le <em>texte de début</em> sera affiché systématiquement avant la liste des informations s'il y en a. Par exemple, «&nbsp;Dernières informations&nbsp;:&nbsp;». Si aucune informations n'est disponible sur la page, il ne sera pas utilisé.</p>
    <p>Si la case <em>Accès avec mot de passe</em> est cochée, un nom d'utilisateur et un mot de passe seront demandés. Les utilisateurs et leur mot de passe sont modifiables <a href="utilisateurs">ici</a>.</p>
  </div>

<?php

// Affichage des pages existantes
$resultat = $mysqli->query('SELECT max(ordre) FROM pages');
$r = $resultat->fetch_row();
$max = $r[0];
$resultat = $mysqli->query('SELECT id,ordre,cle,nom,titre,bandeau,IF(protection=1,\' checked\',\'\') AS protection FROM pages');
$mysqli->close();
while ( $r = $resultat->fetch_assoc() )
  affichage($r);
$resultat->free();

// Bas de page
include('bas.php');
?>
