<?php
// Sécurité et récupération des données de configuration
// Mode admin obligatoire (OK=2)
define('OK',2);
include('debut.php');

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['modifie']) && !empty($_REQUEST['debut']) )  {
  // Sauvegarde de la table contenant les données
  sauvegarde_mysql('semaines');

  // Récupération et validation de l'ensemble des paramètres
  $debuts = $_REQUEST['debut'];
  $colles = $_REQUEST['colle'];
  $vacances = $_REQUEST['vacances'];
  $n = count($debuts);
  $valeurs = '';
  for ( $i = 0; $i <$n; $i++ )  {
    // La date doit être non vide et du bon format
    if ( strlen($debuts[$i]) )  {
      $debut = preg_replace('/(\d{2})\/(\d{2})\/(\d{4})/','$3-$2-$1',$debuts[$i]);
      if ( strlen($debut) == 10 )  {
        if ( !is_numeric($v = $vacances[$i]) || ( $v < 0 ) || ( $v > 4 ) )
          $v = 0;
        $colle = ( isset($colles[$i]) && !$v ) ? 1 : 0;
        $valeurs .= " ('$debut',$colle,$v),";
      }
    }
  }

  // Remplacement de l'ensemble dans la base
  // Remarque : on réordonne les id pour qu'il soient dans le même ordre que celui
  //  du tableau. Cela est nécessaire pour que la requête "WHERE s.id BETWEEN $n
  //  AND ${sid[$m+$nb-1]}" de colles.php, l231, fonctionne correctement.
  //  Il serait aussi possible de changer cette requête par une beaucoup plus
  //  complexe, faisant intervenir le champ 'debut' uniquement. 
  if ( strlen($valeurs) )  {
    $mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
    $mysqli->set_charset('utf8');
    $message = ( $mysqli->query('DELETE FROM semaines')
              && $mysqli->query('ALTER TABLE semaines AUTO_INCREMENT = 50')
              && $mysqli->query('INSERT INTO semaines (debut, colle, vacances) VALUES'.substr($valeurs, 0, -1))
              && $mysqli->query('ALTER TABLE semaines ORDER BY debut')
              && $mysqli->query('SET @count = 0;')
              && $mysqli->query('UPDATE semaines SET id = @count:= @count + 1;')
              && $mysqli->query('ALTER TABLE semaines AUTO_INCREMENT = 1')
    ) ? 'Les semaines ont bien été toutes remises à jour.' : 'Les semaines n\'ont pas pu être modifiées. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    $mysqli->close();
  }
}

//////////
// HTML //
//////////
// Haut de page, menu et message
$p = 'semaines';
$t = 'Modifications des semaines du planning annuel';
$mysqli = new mysqli($serveur,$base,$mdp,$base);
$mysqli->set_charset('utf8');
include('haut.php');

// Fonction d'affichage du formulaire
function affiche_formulaire($n,$r)  {
  $select = str_replace("\"${r['vacances']}\"","\"${r['vacances']}\" selected",'<option value="0">Période scolaire</option><option value="1">Vacances de Toussaint</option><option value="2">Vacances de Noël</option><option value="3">Vacances d\'hiver</option><option value="4">Vacances de printemps</option>');
  if ( strlen($r['jour']) )  {
    $semaine = array('Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi');
    $r['jour'] = $semaine[$r['jour']];
  }
  echo <<<FIN
          <tr id="ligne$n">
            <td><label for="debut$n">${r['jour']}</label>&nbsp;&nbsp;<input type="text" class="date" id="debut$n" name="debut[$n]" value="${r['debut']}" size="8"></td>
            <td><input type="checkbox" name="colle[$n]" value="1"${r['colle']}></td>
            <td><select name="vacances[$n]">$select</select></td>
          </tr>

FIN;
}

// Affichage de l'aide générale et du haut du tableau
?>
  
  <div class="item aide">
    <p>Vous pouvez ci-dessous modifier le planning annuel, c'est-à-dire l'ensemble des semaines et vacances ainsi que s'il des colles sont prévues ou non cette semaine-là. Ce planning annuel est utilisé pour les programmes de colles et pour les cahiers de texte.</p>
    <p>La colonne <em>Colles</em> est à cocher si des colles sont prévues cette semaine-là.</p>
    <p>La validation des données se fait de façon globale, par les boutons de validation en haut ou en bas du formulaire&nbsp;: toutes les modifications sont prises en compte en une seule fois. De plus, les semaines sont automatiquement réorganisées par ordre chronologique&nbsp;: pas besoin de tout effacer et tout réécrire pour insérer une semaine oubliée, il suffit de l'ajouter en bas.</p>
    <p>Pour supprimer une semaine, il suffit de vider la date et de valider le tableau.</p>
  </div>

  <div class="item">
    <form action="" method="post">
      <p class="boutons">
        <input type="button" class="ajouter" value="Ajouter une ligne au tableau">
        <input type="button" class="retirer" value="Retirer la dernière ligne du tableau">
        <input type="submit" name="modifie" value="Valider">
      </p>
      <table id="semaines" class="admin">
        <thead>
          <tr>
            <th>Début de semaine</th>
            <th>Colle ou non</th>
            <th>Vacances</th>
          </tr>
        </thead>
        <tbody>
<?php
// Récupération et affichage des matières
$resultat = $mysqli->query('SELECT DATE_FORMAT(debut,\'%w\') AS jour, DATE_FORMAT(debut,\'%d/%m/%Y\') AS debut, IF(colle=1,\' checked\',\'\') AS colle, vacances FROM semaines');
$mysqli->close();
$n = 0;
if ( $resultat->num_rows )  {
  while ( $r = $resultat->fetch_assoc() )
    affiche_formulaire($n++,$r);
  $resultat->free();
}

// Affichage d'un formulaire vide pour ajout
affiche_formulaire($n++,array('jour'=>'','debut'=>'','colle'=>'','vacances'=>'0'));

// Fin du formulaire
?>
        </tbody>
      </table>

      <p class="boutons">
        <input type="button" class="ajouter" value="Ajouter une ligne au tableau">
        <input type="button" class="retirer" value="Retirer la dernière ligne du tableau">
        <input type="submit" name="modifie" value="Valider">
      </p>
    </form>
  </div>

  <script type="text/javascript">
$( function() {
  $('.date').datepick({
    dateFormat: 'dd/mm/yyyy',
    onSelect: function () {
      var s = $(this).val();
      var d = new Date(s.substring(6,10)+'/'+s.substring(3,5)+'/'+s.substring(0,2));
      var semaine = new Array('Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi');
      $(this).prev('label').text(semaine[d.getDay()]);
    }
  });
  $('select').change(function () {
    if ( $(this).val() == 0 )  {
      $(this).parent().prev().children('input').prop('checked',true);
    }
    else  {
      $(this).parent().prev().children('input').prop('checked',false);
    }
  });
  $('input:checkbox').change(function () {
    if ( $(this).is(':checked') )  {
      $(this).parent().next().children('select').val(0);
    }
  });

  var n = <?php echo $n; ?>;
  $('.ajouter').click(function () {
    $('#ligne'+(n-1)).clone(true).attr('id','ligne'+n).insertAfter($('#ligne'+(n-1)));
    $('#ligne'+n).find('input[name="debut['+(n-1)+']"]').attr('name','debut['+n+']');
    $('#ligne'+n).find('input[name="colle['+(n-1)+']"]').attr('name','colle['+n+']');
    $('#ligne'+n).find('select[name="vacances['+(n-1)+']"]').attr('name','vacances['+n+']');
    n++;
  });
  $('.retirer').click(function () {
    $('#ligne'+(n-1)).remove();
    n--;
  });
});
  </script>

<?php
// Bas de page
include('bas.php');
?>
