<?php
// Sécurité et récupération des données de configuration
// Mode admin obligatoire (OK=2)
define('OK',2);
include('debut.php');

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['id']) )  {
  // Connexion à la base de données
  $mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
  $mysqli->set_charset('utf8');

  // Récupération des utilisateurs
  $resultat = $mysqli->query('SELECT id, nom FROM utilisateurs');
  while ( $r = $resultat->fetch_assoc() )
    $utilisateurs[$r['id']] = $r['nom'];
  $resultat->free();

  // Traitement d'un ajout
  if ( isset($_REQUEST['ajoute']) && ( strlen($nom = $_REQUEST['nom']) ) && ( $_REQUEST['mdp1'] == $_REQUEST['mdp2'] ) )  {
    // Vérification des données envoyées
    if ( !strlen($mdp1 = $_REQUEST['mdp1']) )
      $message = "L'utilisateur «&nbsp;$nom&nbsp;» n'a pas pu être enregistré, car son mot de passe ne peut pas être vide.";
    elseif ( in_array($nom,$utilisateurs) )
      $message = "L'utilisateur «&nbsp;$nom&nbsp;» n'a pas pu être enregistré car un autre utilisateur porte déjà ce nom.";
    else  {
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('utilisateurs');
      // Validation des données envoyées
      $mdp1 = $mysqli->real_escape_string($mdp1);
      $nom = $mysqli->real_escape_string($nom);
      if ( !is_numeric($matiere = $_REQUEST['matiere']) )  $matiere = 0;
      // Envoi MySQL
      $message = ( $mysqli->query("INSERT INTO utilisateurs SET nom = '$nom', matiere = ( SELECT IF(id=$matiere,$matiere,0) FROM matieres ORDER BY ABS(id-$matiere) LIMIT 1 ), mdp = SHA1('$mdp1')")
      ) ? 'L\'utilisateur «&nbsp;'.stripslashes($nom).'&nbsp;» a bien été enregistré.' : 'L\'utilisateur «&nbsp;'.stripslashes($nom).'&nbsp;» n\'a pas pu être enregistré. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }
  }
  
  // Traitement d'une modification de mot de passe
  elseif ( isset($_REQUEST['modifie_mdp']) && isset($utilisateurs[$id = $_REQUEST['id']]) && ( $_REQUEST['mdp1'] == $_REQUEST['mdp2'] ) )  {
    // Vérification des données envoyées
    if ( !strlen($mdp1 = $_REQUEST['mdp1']) )
      $message = "Le mot de passe de l'utilisateur «&nbsp;${utilisateurs[$id]}&nbsp;» n'a pas pu être modifié, car il ne peut pas être vide.";
    else  {
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('utilisateurs');
      // Validation des données envoyées
      $mdp0 = $mysqli->real_escape_string($_REQUEST['mdp0']);
      $mdp1 = $mysqli->real_escape_string($mdp1);
      if ( $mysqli->query("UPDATE utilisateurs SET mdp = SHA1('$mdp1') WHERE id = $id AND mdp = SHA1('$mdp0')") )
        $message = ( $mysqli->affected_rows ) ? "Le mot de passe de l'utilisateur «&nbsp;${utilisateurs[$id]}&nbsp;» a bien été modifié." : "Le mot de passe de l'utilisateur «&nbsp;${utilisateurs[$id]}&nbsp;» n'a pas pu être modifié car sa valeur actuelle est incorrecte.";
      else
        $message = "Le mot de passe de l'utilisateur «&nbsp;${utilisateurs[$id]}&nbsp;» n'a pas pu être modifié. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }
  }

  // Traitement d'une modification de nom ou de matière
  elseif ( isset($_REQUEST['modifie']) && isset($utilisateurs[$id = $_REQUEST['id']]) )  {
    // Vérification des données envoyées
    if ( !strlen($nom = $_REQUEST['nom']) )
      $message = 'Il n\'est pas possible de valider un utilisateur sans nom. Pour supprimer un utilisateur, il faut cliquer sur Supprimer.';
    elseif ( ( $nom != $utilisateurs[$id] ) && in_array($nom,$utilisateurs) )
      $message = "Les données de l'utilisateur «&nbsp;${utilisateurs[$id]}&nbsp;» n'ont pas pu être modifiées car un autre utilisateur porte déjà ce nom.";
    else  {
      // Sauvegarde de la table contenant les données
      sauvegarde_mysql('utilisateurs');
      // Validation des données envoyées
      $nom = $mysqli->real_escape_string($nom);
      if ( !is_numeric($matiere = $_REQUEST['matiere']) )  $matiere = 0;
      // Envoi MySQL
      if ( $mysqli->query("UPDATE utilisateurs SET nom = '$nom', matiere = ( SELECT IF(id=$matiere,$matiere,0) FROM matieres ORDER BY ABS(id-$matiere) LIMIT 1 ) WHERE id = $id") )  {
        // Si on modifie son propre utilisateur, modification des données de session
        if ( $utilisateurs[$id] == $_SESSION['user'] )  {
          $SESSION['user'] = $nom;
          $resultat = $mysqli->query("SELECT cle FROM matieres WHERE id=$matiere");
          if ( $resultat->num_rows )  {
            $r = $resultat->fetch_row();
            $_SESSION['mat'] = $r[0];
          }
          else  $matiere = 0;
          $message = ( $matiere ) ? "Les données de l'utilisateur «&nbsp;${utilisateurs[$id]}&nbsp;» ont bien été modifiées." : 'Les données de votre compte utilisateur ont bien été modifiées. Attention, vous venez de le transformer en simple lecteur des pages protégées sur la partie publique&nbsp;: vous n\'aurez plus accès à cette interface d\'administration à votre prochaine connexion... Vous pouvez changer cela tant que vous ne vous déconnectez pas.';
        }
        else
          $message = 'Les données votre compte utilisateur ont bien été modifiées.';
      }
      else
        $message = "Les données de l'utilisateur «&nbsp;${utilisateurs[$id]}&nbsp;» n'ont pas pu être modifiées. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }
  }

  // Traitement d'une suppression
  elseif ( isset($_REQUEST['supprime']) && isset($utilisateurs[$id = $_REQUEST['id']]) ) {
    if ( count($utilisateurs) == 1 )
      $message = "L'utilisateur «&nbsp;${utilisateurs[$id]}&nbsp;» n'a pas pu être supprimé car il est le seul utilisateur actuellement.";
    else
      $message = ( $mysqli->query("DELETE FROM utilisateurs WHERE id = $id")
      ) ? "L'utilisateur «&nbsp;${utilisateurs[$id]}&nbsp;» a bien été supprimé." : "L'utilisateur «&nbsp;${utilisateurs[$id]}&nbsp;» n'a pas pu être supprimé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
  }

  $mysqli->close();
}

//////////
// HTML //
//////////
// Haut de page, menu et message
$p = 'utilisateurs';
$t = 'Modifications des utilisateurs';
$mysqli = new mysqli($serveur,$base,$mdp,$base);
$mysqli->set_charset('utf8');
include('haut.php');

// Récupération des matières
$resultat = $mysqli->query('SELECT id, nom FROM matieres');
$select_matieres = '<select id="matiere" name="matiere">';
while ( $r = $resultat->fetch_assoc() )
  $select_matieres .= "<option value=\"${r['id']}\">${r['nom']}</option>";
$resultat->free();
$select_matieres .= '<option value="0">Accès aux pages publiques protégées</option></select>';

// Récupération des utilisateurs (et fabrication du select pour l'affichage)
$resultat = $mysqli->query('SELECT id, nom, matiere FROM utilisateurs ORDER BY IF(matiere=0,100,matiere),nom');
$mysqli->close();
$select_utilisateurs = '<select id="id" name="id">';
unset($utilisateurs);
while ( $r = $resultat->fetch_assoc() ) {
  $select_utilisateurs .= "<option value=\"${r['id']}\">${r['nom']}</option>";
  $utilisateurs[$r['id']] = $r['nom'];
  $u_mat[$r['id']] = $r['matiere'];
}
$resultat->free();
$select_utilisateurs .= '</select>';

// Formulaire vide pour nouvel utilisateur et aide générale
?>

  <div class="item admin">
  <form action="" method="post">
    <input class="bouton" type="submit" name="ajoute" value="Valider" title="Valider les modifications">
    <h3>Créer un nouvel utilisateur</h3>
    <p class="ligne"><label for="nom">Nom&nbsp;: </label><input type="text" id="nom" name="nom" value="" size="50"></p>
    <p class="ligne"><label for="mdp1">Mot de passe&nbsp;: </label><input type="password" id="mdp1" name="mdp1" value=""></p>
    <p class="ligne"><label for="mdp2">Confirmation&nbsp;: </label><input type="password" id="mdp2" name="mdp2" value=""></p>
    <p class="ligne"><label for="matiere">Matière ou accès&nbsp;: </label>
      <?php echo $select_matieres; ?>

    </p>
    <input type="hidden" name="id" value="">
  </form>
  </div>

  <div class="item aide">
    <p>Vous pouvez ci-dessus ajouter un utilisateur, ci-dessous modifier les utilisateurs existants. Supprimer un utilisateur ne supprime pas la matière qui lui est associée.</p>
    <p>L'accès à l'interface d'administration n'est possible que pour les utilisateurs associés à une matière, assumés être des professeurs. Plusieurs utilisateurs (professeurs) peuvent être associés à une même matière.</p>
    <p>Le choix <em>Accès aux pages publiques protégées</em> est prévu pour donner la possibilité de voir des contenus protégés. Vous pouvez, au choix, créer un utilisateur par élève ou un pour toute la classe. Cet utilisateur n'a bien sûr pas accès à l'interface d'administration.</p>
    <p>La protection par mot de passe des répertoires/documents et des pages d'information est réglable pour chaque répertoire/document et chaque page. Pour les programmes de colles et les cahiers de texte, cela peut être modifié <a href="matieres">ici</a>.</p>
    <p>Les mots de passe sont chiffrés avant d'être stockés dans la base de données&nbsp;: il n'y a donc aucun souci sur leur confidentialité. Même l'administrateur du site, l'hébergeur ou d'éventuels pirates ne pourront jamais y avoir accès. Lors de la connexion, le mot de passe entré est chiffré à son tour et ce sont les deux chiffrements qui sont comparés. Attention&nbsp;: il est très dangereux que ce mot de passe soit évident. Un bon mot de passe est un mot de passe d'au moins 8 caractères contenant des lettres, des chiffres et au moins un symbole parmi «&nbsp;?&nbsp;;&nbsp;:&nbsp;!&nbsp;.&nbsp;,-&nbsp;_&nbsp;».</p>
    <p>Le nom n'est jamais affiché sur la partie publique du site, il est donc possible de mettre un prénom ou ce que l'on veut. Les accents ne posent pas de problème.</p>
  </div>

  <div class="item admin">
  <form action="" method="post">
    <input class="bouton" type="submit" name="modifie_mdp" value="Valider" title="Valider les modifications">
    <h3>Modification d'un mot de passe</h3>
    <p class="ligne"><label for="id">Utilisateur&nbsp;:</label>
      <?php echo $select_utilisateurs; ?>

    </p>
    <p class="ligne"><label for="mdp0">Mot de passe actuel&nbsp;: </label><input type="password" id="mdp0" name="mdp0" value=""></p>
    <p class="ligne"><label for="mdp1">Nouveau&nbsp;: </label><input type="password" id="mdp1" name="mdp1" value=""></p>
    <p class="ligne"><label for="mdp2">Confirmation&nbsp;: </label><input type="password" id="mdp2" name="mdp2" value=""></p>
  </form>
  </div>

  <div class='item'>
    <table id="utilisateurs" class="admin">
      <thead>
        <tr>
          <th>Utilisateurs</th>
          <th>Matière ou accès aux pages protégées</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
  
<?php
// Remplissage du tableau permettant de modifier les noms et matières
$suppr = ( count($utilisateurs) == 1 ) ? '' : ' <input type="submit" name="supprime" value="Supprimer">';
foreach ( $utilisateurs as $id => $nom )  {
  $m = str_replace("\"${u_mat[$id]}\"","\"${u_mat[$id]}\" selected",$select_matieres);
  echo <<<FIN
        <tr>
          <form action="" method="post">
          <td><input type="text" id="nom" name="nom" value="$nom" size="20"></td>
          <td>$m</td>
          <td><input type="submit" name="modifie" value="Valider">$suppr</td>
          <input type="hidden" name="id" value="$id">
          </form>
        </tr>

FIN;
}
?>
      </tbody>
    </table>
  </div>

<?php
// Bas de page
include('bas.php');
?>
