-- 
-- Voilà les modifications à effectuer sur chaque base pour passer de Cahier de
-- Prépa 2.2.0 à Cahier de Prépa 3.0.0.
-- 

DELETE FROM infos WHERE auto != '';
UPDATE infos SET page = page+1 ORDER BY page DESC;
UPDATE pages SET id = id+1 ORDER BY id DESC;
UPDATE matieres SET cdt = cdt - MOD(cdt,2) + IF((SELECT id FROM cdt WHERE matiere = matieres.id AND cache = 0 LIMIT 1),1,0);
UPDATE matieres SET colles = colles - MOD(colles,2) + IF((SELECT id FROM colles WHERE matiere = matieres.id AND cache = 0 LIMIT 1),1,0);
UPDATE matieres SET docs = (SELECT IF(nbfic+nbrep,1,0) FROM reps WHERE parent=0 AND matiere = matieres.id);
ALTER TABLE utilisateurs CHANGE matiere matieres VARCHAR( 15 ) NOT NULL;
ALTER TABLE utilisateurs ADD protection TINYINT( 1 ) UNSIGNED NOT NULL;
ALTER TABLE docs CHANGE id id SMALLINT( 4 ) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE infos CHANGE id id SMALLINT( 4 ) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE infos DROP auto;

CREATE TABLE recents (
  id smallint(5) unsigned NOT NULL PRIMARY KEY,
  heure datetime NOT NULL,
  titre varchar(50) NOT NULL,
  lien varchar(20) NOT NULL,
  texte text NOT NULL,
  KEY heure (heure)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- 
-- Voilà les modifications à effectuer sur chaque base pour passer de Cahier de
-- Prépa 3.0.0 à Cahier de Prépa 3.0.1.
-- 

ALTER TABLE recents CHANGE titre titre VARCHAR( 200 ) NOT NULL;

-- 
-- Voilà les modifications à effectuer sur chaque base pour passer de Cahier de
-- Prépa 3.0.1 à Cahier de Prépa 3.0.2.
-- 

ALTER TABLE reps CHANGE nbfic nbdoc_v TINYINT( 2 ) UNSIGNED NOT NULL;
ALTER TABLE reps ADD nbdoc_nv TINYINT( 2 ) UNSIGNED NOT NULL;
UPDATE reps SET nbdoc_nv = ( SELECT COUNT(docs.id) FROM docs WHERE docs.parent = reps.id AND docs.protection = 2 );

-- 
-- Voilà les modifications à effectuer sur chaque base pour passer de Cahier de
-- Prépa 3.0.3 à Cahier de Prépa 3.1.0.
-- 

ALTER TABLE `cdt-types` CHANGE h_fin deb_fin_pour TINYINT( 1 ) UNSIGNED NOT NULL;
UPDATE `cdt-types` SET deb_fin_pour = 2 WHERE MOD(id,7) = 0;
UPDATE cdt AS c,`cdt-types` AS ct SET c.h_debut = '0:00' WHERE c.type = ct.id AND ct.deb_fin_pour = 2;
UPDATE cdt AS c,`cdt-types` AS ct SET c.h_fin = '0:00' WHERE c.type = ct.id AND ct.deb_fin_pour != 1;
UPDATE cdt AS c,`cdt-types` AS ct SET c.pour = '0000-00-00' WHERE c.type = ct.id AND ct.deb_fin_pour != 2;
ALTER TABLE cdt ORDER BY jour,matiere,pour,h_debut,h_fin,type;
ALTER TABLE docs ADD nom_nat VARCHAR( 100 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL AFTER nom;
ALTER TABLE docs ADD INDEX ( nom_nat );
DROP FUNCTION IF EXISTS ZPAD;
DELIMITER $$
CREATE FUNCTION ZPAD(s VARCHAR(100))
  RETURNS VARCHAR(100)
BEGIN
  DECLARE i INT DEFAULT 1;
  DECLARE n INT DEFAULT 1;
  WHILE i <= LENGTH(s) DO
    IF FIND_IN_SET(SUBSTRING(s,i,1),"0,1,2,3,4,5,6,7,8,9") THEN
      SET n = i + 1;
      WHILE FIND_IN_SET(SUBSTRING(s,n,1),"0,1,2,3,4,5,6,7,8,9") DO
        SET n = n + 1;
      END WHILE;
      SET s = CONCAT(LEFT(s,i-1),REPEAT("0",10-n+i),RIGHT(s,CHAR_LENGTH(s)+1-i));
      SET i = i + 10;
    END IF;
    SET i = i + 1;
  END WHILE;
  RETURN s;
END
$$
DELIMITER ;
UPDATE docs SET nom_nat=ZPAD(nom);
DROP FUNCTION ZPAD;
ALTER TABLE docs ORDER BY parents, nom_nat;
UPDATE recents SET titre = CONCAT('<img class="icone" src="icones/info.png"> ',SUBSTRING(titre,8,CHAR_LENGTH(titre))) WHERE id < 2000;
UPDATE recents SET titre = CONCAT('<img class="icone" src="icones/colle.png"> ',titre) WHERE id > 2000 AND id < 3000;
UPDATE recents AS r, docs AS d SET 
  texte = CONCAT('<p>Nouveau document&nbsp;: <a href="download?id=',d.id,'">',r.titre,'</a></p>'),
  titre  = CONCAT('<img class="icone" src="icones/',
  CASE LOWER(d.ext)
    WHEN '.pdf' OR '.ps' THEN 'pdf' 
    WHEN '.doc' OR '.odt' OR '.docx' THEN 'doc'
    WHEN '.xls' OR '.ods' OR '.xlsx' THEN 'xls'
    WHEN '.ppt' OR '.odp' OR '.pptx' THEN 'ppt'
    WHEN '.jpg' OR '.jpeg' OR '.png' OR '.gif' OR '.svg' OR '.tif' OR '.tiff' OR '.bmp' OR '.ps' OR '.eps' THEN 'jpg'
    WHEN '.py' THEN 'python'
    WHEN '.avi' OR '.mpeg' OR '.mpg' OR '.wmv' OR '.mp4' OR '.ogv' OR '.qt' OR '.mov' OR '.mkv' OR 'flv' THEN 'avi'
    WHEN '.mp3' OR '.ogg' OR '.oga' OR '.wma' OR '.wav' OR '.ra' OR '.rm' THEN 'mp3'
    WHEN '.txt' OR '.rtf' THEN 'txt'
    WHEN '.zip' OR '.rar' OR '.7z' THEN 'zip'
    WHEN '.exe' OR '.sh' OR '.ml' OR '.mw' OR '' THEN 'exe'
    ELSE 'defaut' END
  ,'.png"> ',r.titre)
  WHERE r.id > 3000 AND d.id = r.id - 3000;
-- À effectuer avec les droits root
UPDATE mysql.db SET Create_routine_priv = 'Y' WHERE db.Db = '[base]' AND db.User = '[base]-adm';
FLUSH PRIVILEGES;

-- 
-- Voilà les modifications à effectuer sur chaque base pour passer de Cahier de
-- Prépa 3.1.0 à Cahier de Prépa 3.1.1.
-- 

ALTER TABLE recents CHANGE lien lien VARCHAR( 30 ) NOT NULL;

-- 
-- Voilà les modifications à effectuer sur chaque base pour passer de Cahier de
-- Prépa 3.1.1 à Cahier de Prépa 3.2.0.
-- 

ALTER TABLE pages ADD mat TINYINT( 2 ) UNSIGNED NOT NULL AFTER cle;
ALTER TABLE reps ADD menu TINYINT( 1 ) UNSIGNED NOT NULL;

-- 
-- Voilà les modifications à effectuer sur chaque base pour passer de Cahier de
-- Prépa 3.2.0 à Cahier de Prépa 4.0.0.
-- 

ALTER TABLE utilisateurs
  DROP protection,
  CHANGE nom login VARCHAR( 50 ) NOT NULL,
  ADD UNIQUE (login),
  ADD nom VARCHAR( 50 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL AFTER login,
  ADD prenom VARCHAR( 50 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL AFTER nom,
  ADD genre TINYINT( 1 ) UNSIGNED NOT NULL AFTER prenom,
  ADD mail VARCHAR( 50 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL AFTER genre,
  ADD autorisation TINYINT( 1 ) UNSIGNED NOT NULL AFTER mail,
  ADD timeout SMALLINT( 4 ) UNSIGNED NOT NULL,
  ADD mailexp TINYINT( 1 ) UNSIGNED NOT NULL,
  ADD mailcopy TINYINT( 1 ) UNSIGNED NOT NULL;
UPDATE utilisateurs SET autorisation = IF(matieres,3,1), matieres = IF(matieres,matieres,''), timeout = 900, mailexp = 1, mailcopy = 1;

ALTER TABLE matieres
  ADD notes TINYINT( 1 ) UNSIGNED NOT NULL,
  ADD colles_protection TINYINT( 1 ) UNSIGNED NOT NULL,
  ADD cdt_protection TINYINT( 1 ) UNSIGNED NOT NULL,
  ADD INDEX(notes);
UPDATE matieres SET colles_protection = colles DIV 2, cdt_protection = cdt DIV 2,
  colles = MOD( colles, 2 ), cdt = MOD( cdt, 2 ), notes = 0;

ALTER TABLE reps
  ADD nbrep_v TINYINT( 2 ) UNSIGNED NOT NULL AFTER nbrep,
  CHANGE nbdoc_nv nbdoc TINYINT( 2 ) UNSIGNED NOT NULL AFTER nbrep_v,
  CHANGE nbdoc_v nbdoc_v TINYINT( 2 ) UNSIGNED NOT NULL AFTER nbdoc;
UPDATE reps SET nbrep_v = nbrep, nbdoc = nbdoc + nbdoc_v;

UPDATE docs SET protection = 4 WHERE protection = 2; -- aucun répertoire ne pouvait avoir protection = 2

ALTER TABLE `cdt-types`
  ADD nb TINYINT( 3 ) UNSIGNED NOT NULL,
  ADD nb_v TINYINT( 3 ) UNSIGNED NOT NULL;

-- Semaines 2014-2015 -> Suppression des cahiers de texte et programmes de colles
TRUNCATE TABLE cdt;
TRUNCATE TABLE colles;
UPDATE matieres SET colles = 0, cdt = 0
TRUNCATE TABLE semaines;
INSERT INTO semaines (debut) VALUES ('2014-09-02'),('2014-09-08'),('2014-09-15'),('2014-09-22'),('2014-09-29'),
  ('2014-10-06'),('2014-10-13'),('2014-10-20'),('2014-10-27'),('2014-11-03'),('2014-11-10'),('2014-11-17'),('2014-11-24'),
  ('2014-12-01'),('2014-12-08'),('2014-12-15'),('2014-12-22'),('2014-12-29'),('2015-01-05'),('2015-01-12'),('2015-01-19'),('2015-01-26'),
  ('2015-02-02'),('2015-02-09'),('2015-02-16'),('2015-02-23'),('2015-03-02'),('2015-03-09'),('2015-03-16'),('2015-03-23'),('2015-03-30'),
  ('2015-04-07'),('2015-04-13'),('2015-04-20'),('2015-04-27'),('2015-05-04'),('2015-05-11'),('2015-05-18'),('2015-05-26'),
  ('2015-06-01'),('2015-06-08'),('2015-06-15'),('2015-06-22'),('2015-06-29');
UPDATE semaines SET colle = 1;

CREATE TABLE notes (
  id SMALLINT( 5 ) UNSIGNED NOT NULL PRIMARY KEY,
  semaine TINYINT( 2 ) UNSIGNED NOT NULL,
  eleve TINYINT( 2 ) UNSIGNED NOT NULL,
  colleur TINYINT( 2 ) UNSIGNED NOT NULL,
  matiere TINYINT( 2 ) UNSIGNED NOT NULL,
  note VARCHAR( 2 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

