<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

// Recherche de la matière concernée
if ( !empty($_REQUEST) )
  foreach ( $matieres as $r )
    if ( isset($_REQUEST[$r['cle']]) )  {
      $matiere = $r;
      break;
    }
// Si mauvaise demande
if ( !isset($matiere) )  {
  if ( strlen($_SESSION['matieres']) )
    exit('<p>Mauvais paramètre d\'accès à cette page. Vous n\'avez accès qu\'aux matières associées à votre compte et l\'adresse doit comporter la clé de la matière. Vous pouvez chager vos matières associées dans vos <a href="prefs">Préférences</a>.</p><p>Il est préférable de passer par les lien du menu&nbsp; <a href=".">retour à l\'accueil</a></p>');
  else
    exit('<p>Vous ne pourrez afficher cette page qu\'après avoir associé des matières à votre compte. Il faut aller dans vos <a href="prefs">Préférences</a> pour cela.</p>');
}

// Récupération des types de séances
$types = array();
$select_types = '';
$resultat = $mysqli->query("SELECT id, cle, deb_fin_pour FROM `cdt-types` WHERE matiere = ${matiere['id']}");
while ( $r = $resultat->fetch_assoc() )  {
  $types[$r['id']] = $r;
  $select_types .= "\n          <option value=\"${r['id']}\">".ucfirst($r['cle']).'</option>';
}
$resultat->free();

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = mysql_ecriture();

  // Vérification que l'identifiant est valide. Défaut : id=0 (nouveau raccourci)
  if ( $id )  {
    // Vérification de l'existence et récupération de l'ordre d'affichage
    $resultat = $mysqli->query("SELECT ordre, nom, (SELECT max(ordre) FROM `cdt-seances` WHERE matiere = ${matiere['id']}) AS max
                                FROM `cdt-seances` WHERE matiere = ${matiere['id']} AND id = $id");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $ordre = $r['ordre'];
      $resultat->free();
    }
    else
      $id = 0;
  }

  // Traitement d'un ajout/modification
  if ( isset($_REQUEST['modifie']) )  {
    // Vérification des données envoyées
    if ( !strlen($_REQUEST['nom']) )
      $message = 'Il n\'est pas possible de valider un nom vide. Pour supprimer un raccourci, il faut cliquer sur Supprimer.';
    else  {
      // Validation des données envoyées
      $nom = $mysqli->real_escape_string($_REQUEST['nom']);
      $jour = ( is_numeric($_REQUEST['jour']) ) ? $_REQUEST['jour'] : 1;
      $tid = ( array_key_exists($_REQUEST['tid'],$types) ) ? $_REQUEST['tid'] : key($types);
      $h_debut = $h_fin = '0:00';
      switch ( $types[$tid]['deb_fin_pour'] )  {
        case 1:
          $h_fin = preg_filter('/(\d{1,2})h(\d{2})/','$1:$2',$_REQUEST['h_fin']);
        case 0:
          $h_debut = preg_filter('/(\d{1,2})h(\d{2})/','$1:$2',$_REQUEST['h_debut']);
      }
      $demigroupe = ( isset($_REQUEST['demigroupe']) ) ? 1 : 0;
      // Si identifiant, modification d'un raccourci existant
      if ( $id )
        $message = ( requete('cdt-seances',"UPDATE `cdt-seances` SET nom = '$nom', jour = $jour, h_debut = '$h_debut',
                                            h_fin = '$h_fin', type = $tid, demigroupe = $demigroupe WHERE id = $id")
        ) ? 'Le raccourci <em>'.stripslashes($nom).'</em> a bien été modifié.' : 'Le raccourci <em>'.stripslashes($nom).'</em> n\'a pas pu être modifié. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      // Sinon, nouveau raccourci
      else  {
        $message = ( requete('cdt-seances',"INSERT INTO `cdt-seances` SET matiere = ${matiere['id']},
                                            ordre = (SELECT IFNULL(max(cs.ordre)+1,1) FROM `cdt-seances` AS cs WHERE cs.matiere = ${matiere['id']}),
                                            nom = '$nom', jour = $jour, h_debut = '$h_debut', h_fin = '$h_fin', type = $tid, demigroupe = $demigroupe")
        ) ? 'Le raccourci <em>'.stripslashes($nom).'</em> a bien été ajouté.' : 'Le raccourci <em>'.stripslashes($nom).'</em> n\'a pas pu être ajouté. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
        $mysqli->query('ALTER TABLE `cdt-seances` ORDER BY ordre,matiere');
      }
    }
  }

  // Traitement d'une transformation/suppression
  elseif ( $id )  {
    
    // Déplacement vers le haut
    if ( isset($_REQUEST['monte']) && ( $ordre > 1 ) )  {
      $message = ( requete('cdt-seances',"UPDATE `cdt-seances` SET ordre = (2*$ordre-1-ordre)
                                          WHERE ( ordre = $ordre OR ordre = ($ordre-1) ) AND matiere = ${matiere['id']}")
      ) ? "Le raccourci <em>${r['nom']}</em> a bien été monté d'une place." : "Le raccourci <em>${r['nom']}</em> n'a pas pu être déplacé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      $mysqli->query('ALTER TABLE `cdt-seances` ORDER BY ordre,matiere');
    }

    // Déplacement vers le bas
    elseif ( isset($_REQUEST['descend']) && ( $ordre < $r['max'] ) )  {
      $message = ( requete('cdt-seances',"UPDATE `cdt-seances` SET ordre = (2*$ordre+1-ordre)
                                          WHERE ( ordre = $ordre OR ordre = ($ordre+1) ) AND matiere = ${matiere['id']}")
      ) ? "Le raccourci <em>${r['nom']}</em> a bien été descendu d'une place." : "Le raccourci <em>${r['nom']}</em> n'a pas pu être déplacé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      $mysqli->query('ALTER TABLE `cdt-seances` ORDER BY ordre,matiere');
    }

    // Suppression
    elseif ( isset($_REQUEST['supprime']) )
      $message =  ( requete('cdt-seances',"DELETE FROM `cdt-seances` WHERE id = $id")
                 && requete('cdt-seances',"UPDATE `cdt-seances` SET ordre = (ordre-1) WHERE ordre > $ordre AND matiere = ${matiere['id']}")
      ) ? "Le raccourci <em>${r['nom']}</em> a bien été supprimé." : "Le raccourci <em>${r['nom']}</em> n'a pas pu être supprimé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
  }

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}

//////////////
//// HTML ////
//////////////
$p = "cdt?${matiere['cle']}";
$t = "Modification des raccourcis du cahier de texte - ${matiere['nom']}";
// Haut de page, menu et message
include('haut.php');

// Aide générale
?>

  <div>
    <a href="cdt?<?php echo $matiere['cle']; ?>">Revenir au cahier de texte de <?php echo $matiere['nom']; ?></a>
  </div>

  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez créer et modifier ci-dessous les boutons de raccourci qui apparaissent dans les formulaires d'entrée du cahier de texte. Ces boutons sont propres à la matière <?php echo $matiere['nom']; ?>.</p>
    <p>Le <em>nom</em> sera affiché sur le bouton. Il n'est visible que par vous, vous pouvez y mettre ce que vous souhaitez. Par exemple, &laquo;&nbsp;Cours du lundi&nbsp;&raquo;.</p>
    <p>Les autres champs réglables correspondent à l'action du bouton&nbsp;: une fois le bouton de raccourci créé, un clic rentre ces valeurs dans le formulaire d'entrée du cahier de texte.</p>
    <p>L'ordre d'apparition des boutons est modifiable grâce aux flèches.</p>
  </div>

<?php
// Select sur les jours de la semaine
$semaine = '
        <option value="1">Lundi</option>
        <option value="2">Mardi</option>
        <option value="3">Mercredi</option>
        <option value="4">Jeudi</option>
        <option value="5">Vendredi</option>
        <option value="6">Samedi</option>
        <option value="0">Dimanche</option>
';

// Fonction d'affichage
function affichage($r)  {
  if ( $id = $r['id'] )  {
    $titre = "Raccourci n°${r['ordre']}&nbsp;: ${r['nom']}";
    $valide1 = '';
    $valide = "\n        <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $monte = ( $r['ordre'] == 1 ) ? '' : "\n        <input type=\"submit\" name=\"monte\" value=\"&uarr;\" title=\"Remonter le raccourci dans l'ordre d'apparition\">";
    $descend = ( $r['ordre'] == $GLOBALS['max'] ) ? '' : "\n        <input type=\"submit\" name=\"descend\" value=\"&darr;\" title=\"Descendre le raccourci dans l'ordre d'apparition\">";
    $suppr = ( $GLOBALS['max'] == 1 ) ? '' : "\n        <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer le raccourci\">";
    $select_types = str_replace("\"${r['type']}\"","\"${r['type']}\" selected",$GLOBALS['select_types']);
    $semaine = str_replace("\"${r['jour']}\"","\"${r['jour']}\" selected",$GLOBALS['semaine']);
  }
  else  {
    $titre = 'Nouveau raccourci';
    $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $valide = $monte = $descend = $suppr = '';
    $select_types = $GLOBALS['select_types'];
    $semaine = $GLOBALS['semaine'];
  }
  echo <<<FIN
  <div class="item admin">
  <form action="?${GLOBALS['mat']}" method="post">$valide1
    <h3>$titre</h3>
    <div>
      <p class="boutons">$valide$monte$descend$suppr
      </p>
      <p class="ligne"><label for="nom$id">Nom&nbsp;: </label><input type="input" id="nom$id" name="nom" value="${r['nom']}" size="50"></p>
      <p class="ligne"><label for="tid$id">Type&nbsp;:</label>
        <select id="tid$id" name="tid">$select_types
        </select>
      </p>
      <p class="ligne"><label for="jour$id">Jour&nbsp;:</label>
        <select id="jour$id" name="jour">$semaine
        </select>
      </p>
      <p class="ligne"><label for="h_debut$id">Heure de début&nbsp;: </label><input type="text" class="heure" id="h_debut$id" name="h_debut" value="${r['h_debut']}" size="5"></p>
      <p class="ligne"><label for="h_fin$id">Heure de fin&nbsp;: </label><input type="text" class="heure" id="h_fin$id" name="h_fin" value="${r['h_fin']}" size="5"></p>
      <p class="ligne"><label for="demigroupe$id">Séance en demi-groupe&nbsp;: </label><input type="checkbox" id="demigroupe$id" name="demigroupe" value="1"${r['demigroupe']}></p>
      <input type="hidden" name="id" value="$id">
    </div>
  </form>
  </div>


FIN;
  
}

// Formulaire vide pour un nouveau type
$mat = $matiere['cle'];
affichage(array('id' => 0, 'nom' => '', 'jour' => 1, 'type' => 0, 'h_debut' => '08h00', 'h_fin' => '10h00', 'demigroupe' => ''));

// Affichage des types
$resultat = $mysqli->query("SELECT max(ordre) FROM `cdt-seances` WHERE matiere = ${matiere['id']}");
if ( $resultat->num_rows )  {
  $r = $resultat->fetch_row();
  $max = $r[0];
  $resultat->free();
  $resultat = $mysqli->query("SELECT id, ordre, nom, jour, type, IF(demigroupe=1,' checked','') AS demigroupe,
                              TIME_FORMAT(h_debut,'%Hh%i') AS h_debut, TIME_FORMAT(h_fin,'%Hh%i') AS h_fin
                              FROM `cdt-seances` WHERE matiere = ${matiere['id']}");
  $mysqli->close();
  while ( $r = $resultat->fetch_assoc() )
    affichage($r);
  $resultat->free();
}

echo <<<FIN

  <script type="text/javascript">
$( function() {
  
  // Modification du formulaire en fonction du type
  $('[name="tid"]').change(function() {
    var p1 = $(this).parent().parent().find('[id^="h_debut"]').parents('.ligne');
    var p2 = $(this).parent().parent().find('[id^="h_fin"]').parents('.ligne');
    switch ( $(this).val() )  {
FIN;
  foreach ( $types as $id => $type )
    switch ( $type['deb_fin_pour'] )  {
      case 0:
        echo "\n      case '$id': p1.show(); p2.hide(); break;";
        break;
      case 1:
        echo "\n      case '$id': p1.show(); p2.show(); break;";
        break;
      default:
        echo "\n      case '$id': p1.hide(); p2.hide(); break;";
    }
  echo <<<FIN

    }
  });
  // Modification au chargement
  $('[name="tid"]').change();

  $('.heure').timeEntry({timeSteps: [1, 15, 0], separator: 'h', spinnerImage: '../js/spinnerDefault.png'});
  
});
  </script>

FIN;
// Bas de page
include('bas.php');
?>
