<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

// Recherche de la matière concernée
if ( !empty($_REQUEST) )
  foreach ( $matieres as $r )
    if ( isset($_REQUEST[$r['cle']]) )  {
      $matiere = $r;
      break;
    }
// Si mauvaise demande
if ( !isset($matiere) )  {
  if ( strlen($_SESSION['matieres']) )
    exit('<p>Mauvais paramètre d\'accès à cette page. Vous n\'avez accès qu\'aux matières associées à votre compte et l\'adresse doit comporter la clé de la matière. Vous pouvez chager vos matières associées dans vos <a href="prefs">Préférences</a>.</p><p>Il est préférable de passer par les lien du menu&nbsp; <a href=".">retour à l\'accueil</a></p>');
  else
    exit('<p>Vous ne pourrez afficher cette page qu\'après avoir associé des matières à votre compte. Il faut aller dans vos <a href="prefs">Préférences</a> pour cela.</p>');
}

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = mysql_ecriture();
  
  // Traitement d'un ajout/modification
  if ( isset($_REQUEST['modifie']) )  {
    // Vérification des données envoyées
    if ( !strlen($_REQUEST['titre']) ||  !strlen($_REQUEST['cle']) )
      $message = 'Il n\'est pas possible de valider un titre ou une clé vide. Pour supprimer un type, il faut cliquer sur Supprimer (et il faut qu\'aucune entrée de ce type-là soit dans le cahier de texte pour voir ce bouton).';
    else  {
      // Validation des données envoyées
      $titre = $mysqli->real_escape_string($_REQUEST['titre']);
      $cle = $mysqli->real_escape_string($_REQUEST['cle']);
      $deb_fin_pour = ( is_numeric($_REQUEST['deb_fin_pour']) ) ? $_REQUEST['deb_fin_pour'] : 1;
      // Si identifiant, modification d'un type existant
      if ( $id )
        $message = ( requete('cdt-types',"UPDATE `cdt-types` SET titre = '$titre', cle = '$cle', deb_fin_pour = $deb_fin_pour WHERE id = $id")
        ) ? 'Le type <em>'.stripslashes($titre).'</em> a bien été modifié.' : 'Le type <em>'.stripslashes($titre).'</em> n\'a pas pu être modifié. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
      // Sinon, nouveau type
      else  {
        $message = ( requete('cdt-types',"INSERT INTO `cdt-types` SET matiere = ${matiere['id']},
                                          ordre = (SELECT max(ct.ordre)+1 FROM `cdt-types` AS ct WHERE ct.matiere = ${matiere['id']}),
                                          titre = '$titre', cle = '$cle', deb_fin_pour = $deb_fin_pour")
        ) ? 'Le type <em>'.stripslashes($titre).'</em> a bien été ajouté.' : 'Le type <em>'.stripslashes($titre).'</em> n\'a pas pu être ajouté. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
        $mysqli->query('ALTER TABLE `cdt-types` ORDER BY ordre,matiere');
      }
    }
  }

  // Traitement d'une transformation/suppression
  else  {
    
    // Vérification de l'existence et récupération de l'ordre d'affichage
    $resultat = $mysqli->query("SELECT ordre, titre, nb, (SELECT max(ordre) FROM `cdt-types` WHERE matiere = ${matiere['id']}) AS max
                                FROM `cdt-types` WHERE id = $id");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $ordre = $r['ordre'];
      $resultat->free();

      // Déplacement vers le haut
      if ( isset($_REQUEST['monte']) && ( $ordre > 1 ) )  {
        $message = ( requete('cdt-types',"UPDATE `cdt-types` SET ordre = (2*$ordre-1-ordre)
                                          WHERE ( ordre = $ordre OR ordre = ($ordre-1) ) AND matiere = ${matiere['id']}")
        ) ? "Le type <em>${r['titre']}</em> a bien été monté d'une place." : "Le type <em>${r['titre']}</em> n'a pas pu être déplacé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
        $mysqli->query('ALTER TABLE `cdt-types` ORDER BY ordre,matiere');
      }

      // Déplacement vers le bas
      elseif ( isset($_REQUEST['descend']) && ( $ordre < $r['max'] ) )  {
        $message = ( requete('cdt-types',"UPDATE `cdt-types` SET ordre = (2*$ordre+1-ordre)
                                          WHERE ( ordre = $ordre OR ordre = ($ordre+1) ) AND matiere = ${matiere['id']}")
        ) ? "Le type <em>${r['titre']}</em> a bien été descendu d'une place." : "Le type <em>${r['titre']}</em> n'a pas pu être déplacé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
        $mysqli->query('ALTER TABLE `cdt-types` ORDER BY ordre,matiere');
      }

      // Suppression (seulement si non vide)
      elseif ( isset($_REQUEST['supprime']) && ( $r['max'] > 1 ) && ( !$r['nb'] ) )
        $message =  ( requete('cdt-types',"DELETE FROM `cdt-types` WHERE id = $id")
                   && requete('cdt-types',"UPDATE `cdt-types` SET ordre = (ordre-1) WHERE ordre > $ordre AND matiere = ${matiere['id']}")
        ) ? "Le type <em>${r['titre']}</em> a bien été supprimé." : "Le type <em>${r['titre']}</em> n'a pas pu être supprimé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

    }
  }

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}

//////////////
//// HTML ////
//////////////
$p = "cdt?${matiere['cle']}";
$t = "Modification des types du cahier de texte - ${matiere['nom']}";
// Haut de page, menu et message
include('haut.php');

// Aide générale
?>

  <div>
    <a href="cdt?<?php echo $matiere['cle']; ?>">Revenir au cahier de texte de <?php echo $matiere['nom']; ?></a>
  </div>

  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez modifier ci-dessous les types d'entrée du cahier de texte. Ces modifications sont propres à la matière <?php echo $matiere['nom']; ?>.</p>
    <p>Le <em>titre</em> sera affiché au début de chaque entrée. Il doit s'agit d'un nom singulier et commençant par une majuscule. Il peut être relativement long. Par exemple&nbsp;: «&nbsp;Séance de travaux pratiques&nbsp;», «&nbsp;Interrogation de cours&nbsp;»</p>
    <p>La <em>clé</em> sera affichée dans le menu déroulant de recherche, précédé de «&nbsp;les&nbsp», ainsi que dans l'adresse des pages qui affichent ce type d'entrée&nbsp;: il faut donc que ce soit un pluriel, court, en un mot, sans majucule au début (sauf s'il le faut). Par exemple, «&nbsp;TP&nbsp;», «&nbsp;interros&nbsp;».</p>
    <p>Vous pouvez choisir les valeurs affichées pour chaque type d'entrée grâce à l'<em>affichage d'horaires</em>&nbsp;:</p>
    <ul>
      <li><em>Début seulement</em> conduit à ce qu'il n'y ait qu'une heure de début. Utile pour les interrogations par exemple.</li>
      <li><em>Début et fin</em> conduit à ce qu'il y ait une heure de début et une heure de fin. C'est le cas le plus général.</li>
      <li><em>Pas d'horaire mais date d'échéance</em> conduit à n'afficher qu'une date (&nbsp;pour le&nbsp;) et aucun horaire. Utile typiquement pour les devoirs maison.</li>
      <li><em>Pas d'horaire ni date d'échéance</em> vous convient si vous souhaitez arrêter de saisir les heures. Par exemple, pour les devoirs surveillés du samedi matin, il suffit d'avoir la date. Le titre affiché pour une entrée de ce type sur la partie publique contiendra la date et le <em>titre</em> du type (par exemple &laquo;&nbsp;Samedi XX/XX/XXXX : Devoir surveillé&nbsp;&raquo;).</li>
      <li><em>Entrée journalière</em> vous convient si vous souhaitez ne saisir qu'une entrée par jour. La différence avec la possibilité précédente et que l'on n'affichera pas le <em>titre</em> du type sur la partie publique. Cela est donc utile uniquement si vous souhaitez regrouper vos entrées par jour. Le titre affiché pour une entrée de ce type sur la partie publique ne contiendra que la date. Le meilleur <em>titre</em> sera alors certainement &laquo;&nbsp;Cours&nbsp;&raquo; (ne s'affichera que dans le formulaire de recherche en haut de page).</li>
      <li><em>Entrée hebdomadaire</em> vous convient si vous souhaitez ne saisir qu'une entrée par semaine. Cela est donc utile uniquement si vous souhaitez regrouper vos entrées par semaine. Il n'y aura pas de titre pour une entrée de ce type sur la partie publique, car la date de chaque semaine est déjà écrite systématiquement.</li>
    </ul>
    <p>Un type d'entrée peut être <em>supprimé</em> uniquement s'il ne correspond à aucune entrée.</p>
    <h4>Exemples de différentes possibilités</h4>
    <p>La première possibilité, celle de base, correspond à tout renseigner&nbsp; chaque séance (cours, TD, TP) a une heure de début et une heure de fin. On obtient&nbsp;</p>
    <ul>
      <li>[ Cours, cours, Début et fin ]</li>
      <li>[ Séance de travaux dirigés, TD, Début et fin ]</li>
      <li>[ Séance de travaux pratiques, TP, Début et fin ]</li>
      <li>[ Devoir surveillé, DS, Début et fin ]</li>
      <li>[ Interrogation de cours, interros, Début seulement ]</li>
      <li>[ Distribution de document, distributions, Début seulement ]</li>
      <li>[ Devoir maison, DM, Pas d'horaire mais date d'échéance ]</li>
    </ul>
    <p>Une deuxième possibilité est de simplifier les entrées qui ont un horaire à peu près fixe ou qui n'arrivent qu'une fois par semaine. Cela peut être le cas des TP, des devoirs... Si on imagine le cas d'un collègue qui ne voit pas l'intérêt du type &laquo;&nbsp;Distribution de document&nbsp;&raquo;, cela donne&nbsp;:</p>
    <ul>
      <li>[ Cours, cours, Début et fin ]</li>
      <li>[ Séance de travaux dirigés, TD, Début et fin ]</li>
      <li>[ Séance de travaux pratiques, TP, Pas d'horaire ni date d'échéance ]</li>
      <li>[ Devoir surveillé, DS, Pas d'horaire ni date d'échéance ]</li>
      <li>[ Interrogation de cours, interros, Début seulement ]</li>
      <li>[ Devoir maison, DM, Pas d'horaire mais date d'échéance ]</li>
    </ul>
    <p>Une troisième possibilité peut être de ne faire qu'une seule entrée pour les cours, TD. Mais de garder les TP, sans horaires (ou avec), de garder les DS... C'est-à-dire&nbsp;:</p>
    <ul>
      <li>[ Cours, cours, Entrée hebdomadaire ]</li>
      <li>[ Séance de travaux pratiques, TP, Pas d'horaire ni date d'échéance ]</li>
      <li>[ Devoir surveillé, DS, Pas d'horaire ni date d'échéance ]</li>
    </ul>
    <p>Quatrième idée, on peut choisir de regrouper les entrées par jour. Mais vouloir être capable de n'afficher que les DM, que les DS, ou tout le reste. Il faut donc avoir&nbsp;:</p>
    <ul>
      <li>[ Cours, cours, Entrée journalière ]</li>
      <li>[ Devoir surveillé, DS, Pas d'horaire ni date d'échéance ]</li>
      <li>[ Devoir maison, DM, Pas d'horaire mais date d'échéance ]</li>
    </ul>
    <p>Il est possible d'imaginer beaucoup plus de combinaisons. Il ne tient qu'à vous de trouver celle qui vous semble la meilleure.</p>
    <p>Seuls les types qui correspondent effectivement à des entrées apparaissent dans le formulaire de recherche de la partie publique. Ce n'est donc pas un problème d'avoir des types qui ne servent finalement à rien, il n'apparaîtront pas dans le formulaire.</p>
  </div>

<?php

// Fonction d'affichage
$deb_fin_pour = '
        <option value="0">Début seulement</option>
        <option value="1">Début et fin</option>
        <option value="2">Pas d\'horaire mais date d\'échéance</option>
        <option value="3">Pas d\'horaire ni date d\'échéance</option>
        <option value="4">Entrée journalière</option>
        <option value="5">Entrée hebdomadaire</option>
';
function affichage($r)  {
  if ( $id = $r['id'] )  {
    $titre = "Type n°${r['ordre']}&nbsp;: ${r['titre']}";
    if ( $r['nb'] )
      $titre .= ( $r['nb'] > 1 ) ? " (${r['nb']} entrées dans le cahier de texte)" : " (${r['nb']} entrée dans le cahier de texte)";
    $valide1 = '';
    $valide = "\n      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $monte = ( $r['ordre'] == 1 ) ? '' : "\n      <input type=\"submit\" name=\"monte\" value=\"&uarr;\" title=\"Remonter le type dans l'ordre d'apparition\">";
    $descend = ( $r['ordre'] == $GLOBALS['max'] ) ? '' : "\n      <input type=\"submit\" name=\"descend\" value=\"&darr;\" title=\"Descendre le type dans l'ordre d'apparition\">";
    $suppr = ( ( $GLOBALS['max'] == 1 ) || ( $r['nb'] ) ) ? '' : "\n      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer le type\">";
    $deb_fin_pour = str_replace("\"${r['deb_fin_pour']}\"","\"${r['deb_fin_pour']}\" selected",$GLOBALS['deb_fin_pour']);
  }
  else  {
    $titre = 'Nouveau type';
    $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $valide = $monte = $descend = $suppr = '';
    $deb_fin_pour = $GLOBALS['deb_fin_pour'];
  }
  echo <<<FIN
  <div class="item admin">
  <form action="?${GLOBALS['mat']}" method="post">$valide1
    <h3>$titre</h3>
    <p class="boutons">$valide$monte$descend$suppr
    </p>
    <p class="ligne"><label for="titre$id">Titre (singulier)&nbsp;: </label><input type="input" id="titre$id" name="titre" value="${r['titre']}" size="50"></p>
    <p class="ligne"><label for="cle$id">Clé (pluriel)&nbsp;: </label><input type="input" id="cle$id" name="cle" value="${r['cle']}" size="50"></p>
    <p class="ligne"><label for="deb_fin_pour$id">Affichage d'horaires&nbsp;:</label>
      <select id="deb_fin_pour$id" name="deb_fin_pour">$deb_fin_pour
      </select>
    </p>
    <input type="hidden" name="id" value="$id">
  </form>
  </div>


FIN;
  
}

// Formulaire vide pour un nouveau type
$mat = $matiere['cle'];
affichage(array('id' => 0, 'titre' => '', 'cle' => '', 'deb_fin_pour' => 1));

// Affichage des types
$resultat = $mysqli->query("SELECT MAX(ordre) FROM `cdt-types` WHERE matiere = ${matiere['id']}");
$r = $resultat->fetch_row();
$max = $r[0];
$resultat->free();
$resultat = $mysqli->query("SELECT id, ordre, titre, cle, deb_fin_pour, nb FROM `cdt-types` WHERE matiere = ${matiere['id']}");
$mysqli->close();
if ( $resultat->num_rows )  {
  while ( $r = $resultat->fetch_assoc() )
    affichage($r);
  $resultat->free();
}

// Bas de page
include('bas.php');
?>
