<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

///////////////////////////////////////////////
// Validation de la requête : matière, n, nb //
///////////////////////////////////////////////

// Recherche de la matière concernée
if ( !empty($_REQUEST) )
  foreach ( $matieres as $r )
    if ( isset($_REQUEST[$r['cle']]) )  {
      $matiere = $r;
      $mid = $matiere['id'];
      break;
    }
// Si mauvaise demande
if ( !isset($matiere) )  {
  if ( strlen($_SESSION['matieres']) )
    exit('<p>Mauvais paramètre d\'accès à cette page. Vous n\'avez accès qu\'aux matières associées à votre compte et l\'adresse doit comporter la clé de la matière. Vous pouvez chager vos matières associées dans vos <a href="prefs">Préférences</a>.</p><p>Il est préférable de passer par les lien du menu&nbsp; <a href=".">retour à l\'accueil</a></p>');
  else
    exit('<p>Vous ne pourrez afficher cette page qu\'après avoir associé des matières à votre compte. Il faut aller dans vos <a href="prefs">Préférences</a> pour cela.</p>');
}

// Récupération des semaines
$resultat = $mysqli->query("SELECT id, DATE_FORMAT(debut,'%w%Y%m%e') AS debut, vacances FROM semaines");
$select_semaines = '';
$semaines = array(0=>'');
while ( $r = $resultat->fetch_assoc() )  {
  switch ( $r['vacances'] )  {
    case 0:
      $select_semaines .= "\n        <option value=\"${r['id']}\">".format_date($r['debut']).'</option>';
      $semaines[$r['id']] = 'Semaine du '.format_date($r['debut']);
      $sid[] = $r['id'];
      break;
    case 1:
      $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances de Toussaint</option>";
      $semaines[$r['id']] = ucfirst(format_date($r['debut']))."&nbsp;: Vacances de Toussaint";
      break;
    case 2:
      $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances de Noël</option>";
      $semaines[$r['id']] = ucfirst(format_date($r['debut']))."&nbsp;: Vacances de Noël";
      break;
    case 3:
      $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances d'hiver</option>";
      $semaines[$r['id']] = ucfirst(format_date($r['debut']))."&nbsp;: Vacances d'hiver";
      break;
    case 4:
      $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances de Pâques</option>";
      $semaines[$r['id']] = ucfirst(format_date($r['debut']))."&nbsp;: Vacances de Pâques";
      break;
  }
}
$resultat->free();
$ntotal = count($sid);

// Gestion de la demande des semaines à afficher
if ( isset($_REQUEST['depuisledebut']) )  {
  $n = 1;
  $m = 0;
  $nb = $ntotal;
}
else  {
  // Validation de n (numéro de semaine à voir)
  if ( isset($_REQUEST['n']) && is_numeric($n = $_REQUEST['n']) )
    while ( !in_array($n,$sid) )
      $n = ( $n < $ntotal ) ? $n+1 : 1;
  // Sans argument, on souhaite afficher la semaine actuelle
  else {
    $date = ( isset($_REQUEST['date']) && preg_match('/\d{4}-\d{2}-\d{2}/',$_REQUEST['date']) ) ? '\''.trim($_REQUEST['date'],'\'').'\'' : 'NOW()';
    $resultat = $mysqli->query("SELECT IF(vacances,(SELECT id FROM semaines WHERE debut > $date AND vacances = 0 LIMIT 1),id) AS id
                                FROM semaines WHERE debut < $date ORDER BY debut DESC LIMIT 1");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $n = $r['id'];
      $resultat->free();
    }
    else
      $n = 1;
  }
  $m = array_search($n,$sid);

  // Validation de nb (nombre de semaines à voir)
  if ( isset($_REQUEST['nb']) && is_numeric($nb = $_REQUEST['nb']) )  {
    if ( $nb < 1 )
      $nb = 1;
    elseif ( $nb > $ntotal - $m )
      $nb = $ntotal - $m;
  }
  else
    // Par défaut : affichage d'une seule semaine
    $nb = 1;
}

// Récupération des types de séances
$resultat = $mysqli->query("SELECT id, cle, deb_fin_pour, nb FROM `cdt-types` WHERE matiere = $mid");
$select_types = $recherche_types = '';
if ( isset($_REQUEST['type']) )  {
  while ( $r = $resultat->fetch_assoc() )  {
    $types[$r['id']] = $r;  
    if ( $r['cle'] == $_REQUEST['type'] )  {
      // Select uniquement pour le formulaire
      if ( $r['nb'] )
        $select_types .= "\n        <option value=\"${r['cle']}\" selected>les ${r['cle']}</option>";
      $recherche_types = " AND t.cle = '${r['cle']}'";
    }
    else
      $select_types .= "\n        <option value=\"${r['cle']}\">les ${r['cle']}</option>"; 
  }
}
else
  while ( $r = $resultat->fetch_assoc() )  {
    // Select uniquement pour le formulaire
      if ( $r['nb'] )
      $select_types .= "\n        <option value=\"${r['cle']}\">les ${r['cle']}</option>"; 
    $types[$r['id']] = $r;  
  }
$resultat->free();

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = mysql_ecriture();

  // Vérification que l'identifiant est valide. Défaut : id=0 (nouvelle entrée)
  if ( $id )  {
    $resultat = $mysqli->query("SELECT id FROM cdt WHERE matiere = $mid AND id = $id");
    if ( $resultat->num_rows )
      $resultat->free();
    else
      $id = 0;
  }
  
  // Traitement d'un ajout/modification
  if ( isset($_REQUEST['modifie']) && strlen($_REQUEST['texte']) )  {
    
    // Validation du jour : à mettre dans la bonne semaine
    $jour = preg_filter('/(\d{2})\/(\d{2})\/(\d{4})/','$3-$2-$1',$_REQUEST['jour']);
    $resultat = $mysqli->query("SELECT id FROM semaines WHERE debut <= '$jour' ORDER BY debut DESC LIMIT 1");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $resultat->free();
      if ( ( $s = array_search($r['id'],$sid) ) !== false )  {
        // Correction éventuelle de n et nb pour que l'entrée soit visible après enregistrement
        if ( ( $s < $m ) || ( $m+$nb <= $s ) )  {
          $n = $r['id'];
          $m = array_search($n,$sid);
          $nb = 1;
        }
        
        // Validation des autres données envoyées
        $tid = ( array_key_exists($_REQUEST['tid'],$types) ) ? $_REQUEST['tid'] : key($types);
        $h_debut = $h_fin = '0:00';
        $pour = '0000/00/00';
        switch ( $types[$tid]['deb_fin_pour'] )  {
          case 1:
            $h_fin = preg_filter('/(\d{1,2})h(\d{2})/','$1:$2',$_REQUEST['h_fin']);
          case 0:
            $h_debut = preg_filter('/(\d{1,2})h(\d{2})/','$1:$2',$_REQUEST['h_debut']);
            break;
          case 2:
            $pour = preg_filter('/(\d{2})\/(\d{2})\/(\d{4})/','$3-$2-$1',$_REQUEST['pour']);
          // Cas 3, 4 et 5 : h_debut, h_fin et pour restent nuls (cf l'aide)
        }
        $texte = $mysqli->real_escape_string($_REQUEST['texte']);
        $demigroupe = ( isset($_REQUEST['demigroupe']) ) ? 1 : 0;

        // Si $id > 0 : modification d'une entrée existante. Si $id = 0, nouvelle entrée
        // Ordre : d'abord ce qui n'a pas de fin, ensuite les séances "normales", ensuite les "pour le"
        if ( $id )
          $message = ( requete('cdt',"UPDATE cdt SET semaine = ${r['id']},
                                      jour = '$jour', h_debut = '$h_debut', h_fin = '$h_fin', pour = '$pour',
                                      type = $tid, texte = '$texte', demigroupe = $demigroupe WHERE id = $id")
          ) ? 'L\'entrée du cahier de texte a bien été modifiée.' : 'L\'entrée du cahier de texte n\'a pas pu être modifiée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
        else  {
          $cache = ( isset($_REQUEST['cache']) ) ? 1 : 0;
          $message = ( requete('cdt',"INSERT INTO cdt SET semaine = ${r['id']}, matiere = $mid,
                                      jour = '$jour', h_debut = '$h_debut', h_fin = '$h_fin', pour = '$pour',
                                      type = $tid, texte = '$texte', demigroupe = $demigroupe, cache = $cache")
          ) ? 'L\'entrée du cahier de texte a bien été ajoutée.' : 'L\'entrée du cahier de texte n\'a pas pu être ajoutée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
        }
        $mysqli->query('ALTER TABLE cdt ORDER BY jour,matiere,pour,h_debut,h_fin,type');
      }
      else
        $message = 'La date saisie se situe pendant les vacances scolaires.';
    }
    else
      $message = 'La date saisie se situe avant le début de l\'année scolaire.';
  }

  elseif ( $id )  {

    // Positionnement "montré" (apparaît sur la partie publique)
    if ( isset($_REQUEST['montre']) )
      $message = ( requete('cdt',"UPDATE cdt SET cache = 0 WHERE id = $id") ) ? 'L\'entrée du cahier de texte a bien été diffusée, elle apparaît désormais sur la partie publique.' : 'L\'entrée du cahier de texte n\'a pas pu être diffusée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';

    // Positionnement "caché" (n'apparaît plus sur la partie publique)
    elseif ( isset($_REQUEST['cache']) )
      $message = ( requete('cdt',"UPDATE cdt SET cache = 1 WHERE id = $id") ) ? 'L\'entrée du cahier de texte n\'est plus diffusée&nbsp;: elle n\'apparaît plus dans la partie publique mais est toujours disponible ici pour modification ou diffusion.' : 'L\'entrée du cahier de texte n\'a pas pu être cachée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';

    // Suppression
    elseif ( isset($_REQUEST['supprime']) || !strlen($texte) )
      $message = ( requete('cdt',"DELETE FROM cdt WHERE id = $id") ) ? 'L\'entrée du cahier de texte a bien été supprimée.' : 'L\'entrée du cahier de texte n\'a pas pu être supprimée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
  }
    
  // Mise à jour des champs 'cdt' dans la table 'matieres' (pour le menu)
  $mysqli->query('UPDATE matieres SET cdt = IF((SELECT id FROM cdt WHERE matiere = matieres.id AND cache = 0 LIMIT 1),1,0)');

  // Mise à jour des champs 'nb' et nb_v dans la table 'cdt-types'
  $mysqli->query('UPDATE `cdt-types` SET
    nb = (SELECT COUNT(cdt.id) FROM cdt WHERE cdt.type = `cdt-types`.id),
    nb_v = (SELECT COUNT(cdt.id) FROM cdt WHERE cdt.type = `cdt-types`.id AND cdt.cache = 0)');

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}

////////////
/// HTML ///
////////////
$p = "cdt?${matiere['cle']}";
$t = "Cahier de texte - ${matiere['nom']}";

// Haut de page, menu et message
include('haut.php');

// Formulaire de la demande des semaines à afficher
$select_semaines = str_replace("\"$n\"","\"$n\" selected",$select_semaines);
echo <<<FIN

  <div class="item" id="recherche">
  <form action="" method="get">
    <input type="hidden" name="${matiere['cle']}" value="">
    <p>Afficher&nbsp;
      <select name="type">
        <option value="tout">tout</option>$select_types
      </select>
      <input type="submit" name="depuisledebut" id="depuisledebut" value="pour toute l'année">
      ou&nbsp;pendant&nbsp;<input type="text" name="nb" value="$nb" size="2">&nbsp;semaine(s) à partir du&nbsp;
      <select name="n">$select_semaines
      </select>
      <input type="submit" name="" value="OK">
    </p>
  </form>
  </div>


FIN;

// Aide générale
?>
  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ci-dessous modifier le cahier de texte de <?php echo $matiere['nom']; ?>.</p>
    <p>Il est possible d'afficher ci-dessous uniquement un type d'entrée ou certaines semaines. Cela ne conditionne pas la saisie d'une nouvelle entrée (vous pouvez afficher l'ensemble des cours et entrer un td, afficher tout sur septembre et saisir une entrée en octobre).</p>
    <p>Vous ne pouvez modifier que les cahiers de texte des matières qui vous sont associées. Elles sont modifiables dans vos <a href="prefs">Préférences</a>.</p>
    <p>Vous pouvez modifier l'accès de l'ensemble du cahier de texte dans les préférences de chaque matière, à la page <a href="prefs">Préférences</a>.</p>
    <h4>Nouvelle entrée</h4>
    <p>Le <em>type</em> d'entrée modifie l'affichage : par exemple, un cours a une heure de début et une heure de fin, tandis qu'un devoir maison n'en a pas.</p>
    <p>Les champs définissant le jour et l'heure apparaîtront si nécessaire lorsque vous modifiez le type d'entrée.</p>
    <p>La présence ou non des champs pour un type d'entrée donné est <a href="cdt-types?<?php echo $matiere['cle']; ?>">modifiable indépendamment pour chaque matière</a>.</p>
    <p>La case à cocher <em>Séance en demi-groupe</em> indique que la séance n'a pas eu lieu en classe entière.</p>
    <p>Le texte doit être formaté en HTML&nbsp;: par exemple, chaque bloc de texte doit être encadré par &lt;p&gt; et &lt;/p&gt;. Il peut donc contenir des liens vers les autres pages du site, vers des documents du site, vers le web... N'hésitez pas à consulter l'aide qui apparaîtra en-dessous de la case de texte après avoir cliqué dessus, ainsi qu'à utiliser les boutons fournis.</p>
    <p>La case à cocher <em>Ne pas diffuser sur la partie publique</em> permet de cacher temporairement ce programme de colle, par exemple pour le diffuser ultérieurement.</p>
    <h4>Entrée existante</h4>
    <p>Vous pouvez <em>cacher</em> une entrée existante et déjà diffusée, c'est-à-dire la rendre non visible sur la partie publique.</p>
    <p>Vous pouvez <em>montrer</em> une entrée existante et cachée, c'est-à-dire la rendre à nouveau visible sur la partie publique.</p>
    <p>Vous pouvez <em>supprimer</em> une entrée existante.</p>
  </div>

  <div class="item">
    <p>Vous pouvez <a href="cdt-types?<?php echo $matiere['cle']; ?>">modifier les différents types d'entrées</a> du cahier de texte et ainsi d'adapter complètement et exactement l'affichage de votre cahier de texte. Il est notamment possible de ne plus entrer d'horaires (ou seulement certains), de regrouper les entrées par jour ou par semaine. Si vous le faites sans avoir modifié les types d'entrée, vous n'utilisez pas toutes les capacités de Cahier de Prépa&nbsp;! Ces modifications sont indépendants d'une matière à l'autre.</p>
    <p>Vous pouvez <a href="cdt-seances?<?php echo $matiere['cle']; ?>">définir des boutons de raccourci</a>, propres à chaque matière, qui pré-rempliront les champs type, jour, heures et demi-groupe. Ils apparaîtront dans chaque formulaire d'entrée du cahier de texte.</p>
  </div>

<?php

// Select des types d'entrée différent de celui du formulaire précédent
$select_types = '';
foreach ( $types as $type )
  $select_types .= "\n          <option value=\"${type['id']}\">".ucfirst($type['cle']).'</option>';

// Fonction d'affichage
function affichage($r)  {
  if ( $id = $r['id'] )  {
    $semaine = array('','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi');
    $pour = ( strlen($r['pour']) ) ? " pour le ${r['pour']}" : '';
    switch ( $r['heure'] )  {
       case 3:
        $titre = "${semaine[$r['jour']]} ${r['date']}&nbsp;: ${r['titre']}";
        break;
      case 4:
        $titre = "${semaine[$r['jour']]} ${r['date']}";
        break;
      case 5:
        $titre = 'Cahier de texte de la semaine';
        break;
      default:
        $titre = "${semaine[$r['jour']]} ${r['date']}${r['heure']}&nbsp;: ${r['titre']}$pour${r['demigroupe']}";
    }
    $valide1 = '';
    $valide = "\n        <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $suppr = "\n        <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer l'entrée\">";
    $cache_nouveau = '';
    if ( $r['cache'] )  {
      $titre .= ' (entrée non diffusée sur la partie publique)';
      $cache_classe = ' cache';
      $cache = "\n        <input type=\"submit\" name=\"montre\" value=\"Montrer\" title=\"Diffuser l'entrée, la rendre visible sur la partie publique\">";
    }
    else  {
      $cache_classe = '';
      $cache = "\n        <input type=\"submit\" name=\"cache\" value=\"Cacher\" title=\"Ne plus diffuser l'entrée, la rendre invisible sur la partie publique\">";
    }
  }
  else  {
    $titre = 'Nouvelle entrée du cahier';
    $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $valide = $cache = $cache_classe = $suppr = '';
    $cache_nouveau = "\n      <p class=\"ligne\"><label for=\"cache\">Ne pas diffuser sur la partie publique&nbsp;: </label><input type=\"checkbox\" id=\"cache\" name=\"cache\" value=\"1\"></p>";
  }
  $demigroupe = ( strlen($r['demigroupe']) ) ? ' checked' : '';
  $select_types = str_replace("\"${r['tid']}\"","\"${r['tid']}\" selected",$GLOBALS['select_types']);
  $type = ( isset($_REQUEST['type']) ) ? "&amp;type=${_REQUEST['type']}" : '';
  echo <<<FIN
  <div class="item admin$cache_classe">
  <form action="${GLOBALS['p']}&amp;n=${GLOBALS['n']}&amp;nb=${GLOBALS['nb']}$type" method="post">$valide1
    <h3>$titre</h3>
    <div>
      <p class="boutons">$valide$cache$suppr
      </p>
      <p class="ligne"><label for="tid$id">Type&nbsp;:</label>
        <select id="tid$id" name="tid">$select_types
        </select>
      </p>
      <p class="ligne"><label for="jour$id">Jour&nbsp;: </label><input type="text" class="date" id="jour$id" name="jour" value="${r['date']}" size="8"></p>
      <p class="ligne"><label for="h_debut$id">Heure de début&nbsp;: </label><input type="text" class="heure" id="h_debut$id" name="h_debut" value="${r['h_debut']}" size="5"></p>
      <p class="ligne"><label for="h_fin$id">Heure de fin&nbsp;: </label><input type="text" class="heure" id="h_fin$id" name="h_fin" value="${r['h_fin']}" size="5"></p>
      <p class="ligne"><label for="pour$id">Pour le&nbsp;: </label><input type="text" class="date" id="pour$id" name="pour" value="${r['pour']}" size="8"></p>
      <p class="ligne"><label for="demigroupe$id">Séance en demi-groupe&nbsp;: </label><input type="checkbox" id="demigroupe$id" name="demigroupe" value="1"$demigroupe></p>
      <textarea name="texte" class="mat${GLOBALS['mid']}" rows="10" cols="100">${r['texte']}</textarea>$cache_nouveau
      <input type="hidden" name="id" value="$id">
    </div>
  </form>
  </div>


FIN;
}

// Formulaire vide
affichage(array('id' => 0, 'texte' => '', 'pour' => '', 'date' => date('d/m/Y'),
                'h_debut' => '08h00', 'h_fin' => '10h00', 'heure' => '', 'demigroupe' => '', 'cache' => 0, 'tid' => ''));

// Liens de navigation vers semaines précédentes/suivantes
$nav = '  <div class="item">';
if ( $m )
  $nav .= "\n    <a class=\"prec\" href=\"?${matiere['cle']}&amp;n=". $sid[max($m-$nb,0)] ."&amp;nb=$nb\">Semaines précédentes</a>";
if (  $m+$nb < $ntotal )
  $nav .= "\n    <a class=\"suiv\" href=\"?${matiere['cle']}&amp;n=". $sid[$m+$nb] ."&amp;nb=$nb\">Semaines suivantes</a>";
$nav .= "\n  </div>\n\n";
if ( strlen($nav) > 31 )
  echo $nav;

// Récupération des entrées
$resultat = $mysqli->query("SELECT cdt.id, cdt.texte, cdt.semaine,
                            DATE_FORMAT(cdt.jour,'%w') AS jour, DATE_FORMAT(cdt.jour,'%d/%m/%Y') AS date,
                            CASE t.deb_fin_pour
                              WHEN 0 THEN TIME_FORMAT(cdt.h_debut,' à %kh%i')
                              WHEN 1 THEN CONCAT(TIME_FORMAT(cdt.h_debut,' de %kh%i'),TIME_FORMAT(cdt.h_fin,' à %kh%i'))
                              WHEN 2 THEN ''
                              ELSE t.deb_fin_pour END AS heure,
                            TIME_FORMAT(cdt.h_debut,'%Hh%i') AS h_debut,
                            TIME_FORMAT(cdt.h_fin,'%Hh%i') AS h_fin,
                            IF(t.deb_fin_pour = 2,DATE_FORMAT(cdt.pour,'%d/%m/%Y'),'') AS pour,
                            IF(cdt.demigroupe,' (en demi-groupe)','') AS demigroupe, cdt.cache, t.id AS tid, t.titre
                            FROM cdt LEFT JOIN `cdt-types` AS t ON t.matiere = $mid AND t.id = cdt.type
                            WHERE cdt.semaine BETWEEN $n AND ${sid[$m+$nb-1]} AND cdt.matiere = $mid $recherche_types");

// Affichage des résultats
if ( $resultat->num_rows )  {
  // On ne garde que les semaines concernées. Il faut conserver la semaine précédente
  // pour que puisse fonctionner le premier next à l'affichage.
  $semaines = array_slice($semaines,$n-1,$sid[$m+$nb-1]-$n+2,true);
  $s = 0;
  $semaine = array('','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi');
  while ( $r = $resultat->fetch_assoc() )  {
    
    // Nouvelle semaine
    while ( ( $s != $r['semaine'] ) && next($semaines) )  {
      echo '  <h2 class="cdtsemaine">'.current($semaines)."</h2>\n\n";
      $s = key($semaines);
    }
    affichage($r);
  }
  $resultat->free();
  // Liens de navigation vers semaines précédentes/suivantes
  if ( strlen($nav) > 31 )
    echo $nav;
}
else  {
  if ( !isset($_REQUEST['type']) || ( $_REQUEST['type'] == 'tout' ) )
    echo "  <h2>Le cahier de texte est vide pour les semaines choisies.</h2>\n\n";
  else
    echo "  <h2>Le cahier de texte ne contient pas de «&nbsp;${_REQUEST['type']}&nbsp;» pour les semaines choisies.</h2>\n\n";
}

// Récupération des boutons
$resultat = $mysqli->query("SELECT id, nom, jour, TIME_FORMAT(h_debut,'%Hh%i') AS h_debut, TIME_FORMAT(h_fin,'%Hh%i') AS h_fin,
                            type, demigroupe FROM `cdt-seances` WHERE matiere = $mid");
$raccourcis = '';
$raccourcisjs = '';
if ( $resultat->num_rows )  {
  while ( $r = $resultat->fetch_assoc() )  {
    $raccourcis .= "<input type=\"button\" class=\"rac${r['id']}\" value=\"${r['nom']}\"> ";
    $r['demigroupe'] = ( $r['demigroupe'] ) ? 'true' : 'false';
    $raccourcisjs .= <<<FIN
  $('.rac${r['id']}').click(function() {
    $(this).parent().parent().find('[name="tid"]').val('${r['type']}').change();
    $(this).parent().parent().find('[id^="h_debut"]').val('${r['h_debut']}');
    $(this).parent().parent().find('[id^="h_fin"]').val('${r['h_fin']}');
    $(this).parent().parent().find('[id^="demigroupe"]').attr('checked', ${r['demigroupe']});
    var today=new Date();
    var t=today.getDay();
    t = ${r['jour']}-t;
    if ( t>0 ) { t-=7; }
    $(this).parent().parent().find('[id^="jour"]').datepick('setDate',t+'d');
  });

FIN;
  }
  $resultat->free();  
}

// Disparition automatique des heures et de la date d'échéance
echo <<<FIN
  <script type="text/javascript">
$( function() {

  // Modification du formulaire en fonction du type
  $('[name="tid"]').change(function() {
    var p1 = $(this).parent().parent().find('[id^="h_debut"]').parents('.ligne');
    var p2 = $(this).parent().parent().find('[id^="h_fin"]').parents('.ligne');
    var p3 = $(this).parent().parent().find('[id^="pour"]').parents('.ligne');
    switch ( $(this).val() )  {
FIN;
foreach ( $types as $id => $type )
  switch ( $type['deb_fin_pour'] )  {
    case 0:
      echo "\n      case '$id': p1.show(); p2.hide(); p3.hide(); break;";
      break;
    case 1:
      echo "\n      case '$id': p1.show(); p2.show(); p3.hide(); break;";
      break;
    case 2:
      echo "\n      case '$id': p1.hide(); p2.hide(); p3.show(); break;";
      break;
    default:
      echo "\n      case '$id': p1.hide(); p2.hide(); p3.hide(); break;";
  }
echo <<<FIN

    }
  });
  // Modification au chargement
  $('[name="tid"]').change();

  // Boutons de raccourcis
  $('<p class="boutons">$raccourcis</p>').clone().insertBefore($('.admin form').find('.ligne:first'));
$raccourcisjs
  $('.date').datepick({dateFormat: 'dd/mm/yyyy', showTrigger: '<img src="../js/calendar-blue.gif">'});
  $('.heure').timeEntry({timeSteps: [1, 15, 0], separator: 'h', spinnerImage: '../js/spinnerDefault.png'});

  // URL plus lisible après clic du bouton "Toute l'année"
  $('#depuisledebut').click(function() {
    window.location.search = '?${matiere['cle']}&type='+$(this).prev('[name="type"]').val()+'&depuisledebut';
    return false;
  });

});
  </script>


FIN;
$mysqli->close();

// Bas de page
include('bas.php');
?>
