<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

///////////////////////////////////////////////
// Validation de la requête : matière, n, nb //
///////////////////////////////////////////////

// Recherche de la matière concernée
if ( !empty($_REQUEST) )
  foreach ( $matieres as $r )
    if ( isset($_REQUEST[$r['cle']]) )  {
      $matiere = $r;
      $mid = $matiere['id'];
      break;
    }
// Si mauvaise demande
if ( !isset($matiere) )  {
  if ( strlen($_SESSION['matieres']) )
    exit('<p>Mauvais paramètre d\'accès à cette page. Vous n\'avez accès qu\'aux matières associées à votre compte et l\'adresse doit comporter la clé de la matière. Vous pouvez chager vos matières associées dans vos <a href="prefs">Préférences</a>.</p><p>Il est préférable de passer par les lien du menu&nbsp; <a href=".">retour à l\'accueil</a></p>');
  else
    exit('<p>Vous ne pourrez afficher cette page qu\'après avoir associé des matières à votre compte. Il faut aller dans vos <a href="prefs">Préférences</a> pour cela.</p>');
}

// Récupération des semaines
$resultat = $mysqli->query("SELECT s.id AS sid, DATE_FORMAT(s.debut,'%w%Y%m%e') AS d, s.colle, s.vacances, c.id AS cid, c.cache
                            FROM semaines AS s
                            LEFT JOIN (SELECT id, semaine, cache FROM colles WHERE matiere = $mid) AS c ON c.semaine=s.id");
$select_semaines = '';
while ( $r = $resultat->fetch_assoc() )  {
  switch ( $r['vacances'] )  {
    case 0:
      if ( $r['colle'] )  {
        if ( is_null($r['cid']) )
          $select_semaines .= "\n        <option value=\"${r['sid']}\">".format_date($r['d']).'</option>';
        elseif ( $r['cache'] )
          $select_semaines .= "\n        <option value=\"${r['sid']}\">".format_date($r['d']).' (non diffusé)</option>';
        else
          $select_semaines .= "\n        <option value=\"${r['sid']}\">".format_date($r['d']).' (déjà rempli)</option>';
      }
      else
        $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>".format_date($r['d']).' (pas de colle)</option>';
      $sid[] = $r['sid'];
      break;
    case 1:
      $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances de Toussaint</option>";
      break;
    case 2:
      $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances de Noël</option>";
      break;
    case 3:
      $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances d'hiver</option>";
      break;
    case 4:
      $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances de Pâques</option>";
  }
}
$resultat->free();

// Validation de n (numéro de semaine à voir)
if ( isset($_REQUEST['n']) && is_numeric($n = $_REQUEST['n']) )
  while ( !in_array($n,$sid) )
    $n = ( $n < count($sid) ) ? $n+1 : 1;
// Sans argument, on souhaite afficher le programme de colles de la semaine actuelle
else {
  $date = ( isset($_REQUEST['date']) && preg_match('/\d{4}-\d{2}-\d{2}/',$_REQUEST['date']) ) ? '\''.trim($_REQUEST['date'],'\'').'\'' : 'NOW()';
  $resultat = $mysqli->query("SELECT IF(vacances,(SELECT id FROM semaines WHERE debut > ADDDATE($date,3) AND vacances = 0 LIMIT 1),id) AS id
                              FROM semaines WHERE debut < ADDDATE($date,3) ORDER BY debut DESC LIMIT 1");
  if ( $resultat->num_rows )  {
    $r = $resultat->fetch_assoc();
    $n = $r['id'];
    $resultat->free();
    if ( $m = array_search($n,$sid) )
      $n = $sid[$m-1];
  }
  // Aucun résultat : l'année n'a pas encore commencé
  else
    $n = 0;
}
$m = array_search($n,$sid);

// Validation de nb (nombre de semaines à voir)
if ( isset($_REQUEST['nb']) && is_numeric($nb = $_REQUEST['nb']) ) {
  if ( $nb < 1 )
    $nb = 1;
}
else
  // Par défaut : affichage de la semaine courante et des semaines précédente et suivante
  $nb = 3;
if ( $nb > count($sid) - $m )
  $nb = count($sid) - $m;

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = mysql_ecriture();

  // Vérification que l'identifiant de la semaine est valide
  $resultat = $mysqli->query("SELECT DATE_FORMAT(s.debut,'%e/%m') AS debut, c.id, c.cache, c.texte FROM semaines AS s
                              LEFT JOIN (SELECT id, texte, semaine, cache FROM colles WHERE matiere = $mid) AS c ON c.semaine=s.id
                              WHERE s.id = $id AND s.colle = 1");
  if ( $resultat->num_rows ) {
    $r = $resultat->fetch_assoc();
    $cid = $r['id'];
    $resultat->free();
    $_REQUEST['n'] = $id;
    
    // Pour les informations récentes
    $titre_recent = "<img class=\"icone\" src=\"icones/colle.png\"> Colles du ${r['debut']} en ".addslashes($matiere['nom']);
    $lien_recent = 'colles?'.addslashes($matiere['cle'])."&amp;n=$id";

    // Ajout d'un nouveau programme de colles. Il ne faut pas pouvoir insérer un programme vide par erreur
    if ( isset($_REQUEST['modifie']) && strlen($_REQUEST['texte']) )  {
      
      // Validation des données envoyées
      $texte = $mysqli->real_escape_string($_REQUEST['texte']);
      
      // Si $cid n'est pas NULL : modification d'un programme existant. Sinon, nouveau programme
      if ( $cid )  {
        if ( requete('colles',"UPDATE colles SET texte = '$texte' WHERE id = $cid") )  {
          $message = "Le programme de colles de la semaine du ${r['debut']} a bien été modifié.";
          // Ajout d'une information récente si programme diffusé
          if ( !$r['cache'] )
            recent($mysqli,2,$cid,$titre_recent,$lien_recent,$texte);
        }
        else
          $message = "Le programme de colles de la semaine du ${r['debut']} n'a pas pu être modifié. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      }
      else  {
        $cache = ( isset($_REQUEST['cache']) ) ? 1 : 0;
        if ( requete('colles',"INSERT INTO colles SET texte = '$texte', semaine = $id, matiere = $mid, cache = $cache") )  {
          $message = "Le programme de colles de la semaine du ${r['debut']} a bien été ajouté.";
          // Ajout d'information récente si programme diffusé
          if ( !$cache )
            recent($mysqli,2,$mysqli->insert_id,$titre_recent,$lien_recent,$texte);
          $mysqli->query('ALTER TABLE colles ORDER BY matiere,semaine');
        }
        else
          $message = "Le programme de colles de la semaine du ${r['debut']} n'a pas pu être ajouté. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      }
    }

    elseif ( $cid )  {

      // Positionnement "montré" (apparaît sur la partie publique)
      if ( isset($_REQUEST['montre']) )  {
        if ( requete('colles',"UPDATE colles SET cache = 0 WHERE id = $cid") )  {
          $message = "Le programme de colles de la semaine du ${r['debut']} a bien été diffusé, il apparaît désormais sur la partie publique.";
          // Ajout d'information récente
          recent($mysqli,2,$cid,$titre_recent,$lien_recent,$mysqli->real_escape_string($r['texte']));
        }
        else
          $message = "Le programme de colles de la semaine du ${r['debut']} n'a pas pu être diffusé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      }

      // Positionnement "caché" (n'apparaît pas sur la partie publique)
      elseif ( isset($_REQUEST['cache']) )  {
        if ( requete('colles',"UPDATE colles SET cache = 1 WHERE id = $cid") )  {
          $message = "Le programme de colles du ${r['debut']} n'est plus diffusé&nbsp;: il n'apparaît plus sur la partie publique mais est toujours disponible ici pour modification ou diffusion.";
          // Suppression de l'éventuelle information récente
          recent($mysqli,2,$cid);
        }
        else
          $message = "Le programme de colles de la semaine du ${r['debut']} n'a pas pu être caché. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      }

      // Suppression
      elseif ( isset($_REQUEST['supprime']) || !strlen($_REQUEST['texte']) )  {
        if ( requete('colles',"DELETE FROM colles WHERE id = $cid") )  {
          $message = "Le programme de colles de la semaine du ${r['debut']} a bien été supprimé.";
          // Suppression de l'éventuelle information récente
          recent($mysqli,2,$cid);
        }
        else
          $message = "Le programme de colles de la semaine du ${r['debut']} n'a pas pu être modifié. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      }
    }
  }
  
  // Mise à jour des champs 'colles' dans la table 'matieres' (pour le menu)
  $mysqli->query('UPDATE matieres SET colles = IF((SELECT id FROM colles WHERE matiere = matieres.id AND cache = 0 LIMIT 1),1,0)');

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}

////////////
/// HTML ///
////////////
$p = "colles?${matiere['cle']}";
$t = "Programme de colles - ${matiere['nom']}";

// Haut de page, menu et message
include('haut.php');

// Formulaire de demande d'affichage
$select_semaines = str_replace("\"$n\"","\"$n\" selected",$select_semaines);
echo <<<FIN

  <div class="item" id="recherche">
  <form action="" method="get">
    <input type="hidden" name="${matiere['cle']}" value="">
    <p>Afficher&nbsp;<input type="text" name="nb" value="$nb" size="2">&nbsp;semaine(s) à partir du&nbsp;
      <select name="n">$select_semaines
      </select>
      <input type="submit" name="" value="OK">
    </p>
  </form>
  </div>


FIN;

// Aide générale
?>
  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ci-dessous modifier les programmes de colles de <?php echo $matiere['nom']; ?>. Vous pouvez choisir les semaines à afficher ci-dessus.</p>
    <p>Vous ne pouvez modifier que les programmes de colles des matières qui vous sont associées. Elles sont modifiables dans vos <a href="prefs">Préférences</a>.</p>
    <p>Vous pouvez modifier l'accès de l'ensemble du programme de colles dans les préférences de chaque matière, à la page <a href="prefs">Préférences</a>.</p>
    <h4>Nouveau programme de colles</h4>
    <p>Vous pouvez choisir la <em>semaine</em> du programme de colles parmi les semaines où le programme n'est pas déjà renseigné, et où il est prévu des colles. Vous pouvez modifier les semaines avec ou sans colle sur la page du <a href="planning">Planning annuel</a>.</p>
    <p>Le texte doit être formaté en HTML&nbsp;: par exemple, chaque bloc de texte doit être encadré par &lt;p&gt; et &lt;/p&gt;. Il peut donc contenir des liens vers les autres pages du site, vers des documents du site, vers le web... N'hésitez pas à consulter l'aide qui apparaîtra en-dessous de la case de texte après avoir cliqué dessus, ainsi qu'à utiliser les boutons fournis.</p>
    <p>La case à cocher <em>Ne pas diffuser sur la partie publique</em> permet de cacher temporairement ce programme de colle, par exemple pour le diffuser ultérieurement.</p>
    <h4>Programme de colles existant</h4>
    <p>Vous pouvez <em>cacher</em> un programme de colles existant et déjà diffusé, c'est-à-dire le rendre non visible sur la partie publique. Cela supprime aussi l'information récente correspondante.</p>
    <p>Vous pouvez <em>montrer</em> un programme de colles existant et caché, c'est-à-dire le rendre à nouveau visible sur la partie publique. Cela crée une nouvelle information récente.</p>
    <p>Vous pouvez <em>supprimer</em> un programme de colles existant.</p>
  </div>

<?php

// Affichage des semaines concernées
if ( $n )  {

  // Liens de navigation vers semaines précédentes/suivantes
  $nav = '  <div class="item">';
  if ( $m )
    $nav .= "\n    <a class=\"prec\" href=\"?${matiere['cle']}&amp;n=". $sid[max($m-$nb,0)] ."&amp;nb=$nb\">Semaines précédentes</a>";
  if (  $m+$nb < count($sid) )
    $nav .= "\n    <a class=\"suiv\" href=\"?${matiere['cle']}&amp;n=". $sid[$m+$nb] ."&amp;nb=$nb\">Semaines suivantes</a>";
  $nav .= "\n  </div>\n\n";
  if ( $nb > 1 )
    echo $nav;

  // Récupération des données à afficher
  $resultat = $mysqli->query("SELECT DATE_FORMAT(s.debut,'%w%Y%m%e') AS d, s.colle, s.vacances, c.texte, s.id, IF(c.cache,' checked','') AS cache 
                              FROM semaines AS s
                              LEFT JOIN (SELECT texte, semaine, cache FROM colles WHERE matiere = $mid) AS c ON c.semaine=s.id
                              WHERE s.id BETWEEN $n AND ${sid[$m+$nb-1]}" );
  // Gestion du titre
  while ( $r = $resultat->fetch_assoc() )  {
    switch ( $r['vacances'] )  {
      case 0:
        $titre = 'Semaine du '.format_date($r['d']);
        break;
      case 1:
        $titre = ucfirst(format_date($r['d']))."&nbsp;: Vacances de Toussaint";
        break;
      case 2:
        $titre = ucfirst(format_date($r['d']))."&nbsp;: Vacances de Noël";
        break;
      case 3:
        $titre = ucfirst(format_date($r['d']))."&nbsp;: Vacances d'hiver";
        break;
      case 4:
        $titre = ucfirst(format_date($r['d']))."&nbsp;: Vacances de Pâques";
        break;
    }
    // Affichage
    if ( $r['colle'] )  {
      if ( is_null($r['texte']) )  {
        $titre .= ' (à remplir)';
        $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
        $classe_cache = $boutons = '';
        $cache = "\n    <p class=\"ligne\"><label for=\"cache\">Ne pas diffuser sur la partie publique&nbsp;: </label><input type=\"checkbox\" id=\"cache\" name=\"cache\" value=\"1\"></p>";
      }
      else  {
        if ( $r['cache'] )  {
          $valide1 = $cache = '';
          $classe_cache = ' cache';
          $titre .= ' (programme non diffusé sur la partie publique)';
          $boutons = "
    <p class=\"boutons\">
      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications sur le texte\">
      <input type=\"submit\" name=\"montre\" value=\"Montrer\" title=\"Diffuser le programme, le rendre visible sur la partie publique\">
      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer le programme de colles\">
    </p>";
        }
        else  {
          $valide1 = $cache = $classe_cache = '';
          $boutons = "
    <p class=\"boutons\">
      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications sur le texte\">
      <input type=\"submit\" name=\"cache\" value=\"Cacher\" title=\"Ne plus diffuser le programme, le rendre invisible sur la partie public\">
      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer le programme de colles\">
    </p>";
        }
      }
      echo <<<FIN
  <div class="item admin$classe_cache">
  <form action="" method="post">$valide1
    <h3>$titre</h3>$boutons
    <textarea name="texte" class="mat$mid" rows="15" cols="100">${r['texte']}</textarea>$cache
    <input type="hidden" name="id" value="${r['id']}">
  </form>
  </div>


FIN;
    }
    else  {
      $texte = ( $r['vacances'] ) ? '' : "\n    <p>Il n'y a normalement pas de colles cette semaine-là. S'il s'agit d'une erreur, cela est modifiable <a href=\"semaines\">sur la page des semaines</a></p>";
      echo <<<FIN
  <div class="item admin">
    <h3>$titre</h3>$texte
  </div>


FIN;
    }
  }
  $resultat->free();
  // Liens de navigation vers semaines précédentes/suivantes
  echo $nav;
}
else
  echo "  <h2>L'année n'a pas encore commencé... Revenez à la rentrée&nbsp;!</h2>\n\n";
$mysqli->close();


// Bas de page
include('bas.php');
?>
