<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

//////////////////////////////////////////////////////
// Validation de la requête : répertoire ou matière //
//////////////////////////////////////////////////////

// Récupération de l'identifiant de répertoire demandé
if ( isset($_REQUEST['rep']) && is_numeric($rid = $_REQUEST['rep']) )  {
  $resultat = $mysqli->query("SELECT id FROM reps WHERE id = $rid AND FIND_IN_SET(matiere,'0,${_SESSION['matieres']}')");
  if ( $resultat->num_rows )
    $resultat->free();
  else
    unset($rid);
}
// Si une matière est demandée
elseif ( !empty($_REQUEST) )  {
  $resultat = $mysqli->query("SELECT r.id, m.cle FROM reps AS r LEFT JOIN matieres AS m ON r.matiere = m.id
                              WHERE FIND_IN_SET(m.id,'${_SESSION['matieres']}') AND r.parent = 0");
  if ( $resultat->num_rows )  {
    while ( $r = $resultat->fetch_assoc() )
      if ( isset($_REQUEST[$r['cle']]) )  {
        $rid = $r['id'];
        break;
      }
    $resultat->free();
  }
}
else
  $rid = 1;

// Si mauvaise demande
if ( !isset($rid) )  {
  $mysqli->close();
  exit('<p>Mauvais paramètre d\'accès à cette page. Vous n\'avez accès qu\'aux répertoires généraux ou correspondant aux matières associées à votre compte.</p><p><a href=".">Revenir à l\'interface d\'administration</a></p>');
}

/////////////////////////////////////
// Liste des icônes pour affichage //
/////////////////////////////////////
$icones = array(
  '.pdf' => 'pdf', '.ps' => 'pdf',
  '.doc' => 'doc', '.odt' => 'doc', '.docx' => 'doc',
  '.xls' => 'xls', '.ods' => 'xls', '.xlsx' => 'xls',
  '.ppt' => 'ppt', '.odp' => 'ppt', '.pptx' => 'ppt',
  '.jpg' => 'jpg', '.jpeg' => 'jpg', '.png' => 'jpg', '.gif' => 'jpg', '.svg' => 'jpg', '.tif' => 'jpg', '.tiff' => 'jpg', '.bmp' => 'jpg', '.ps' => 'jpg', '.eps' => 'jpg',
  '.py' => 'python',
  '.avi' => 'avi', '.mpeg' => 'avi', '.mpg' => 'avi', '.wmv' => 'avi', '.mp4' => 'avi', '.ogv' => 'avi', '.qt' => 'avi', '.mov' => 'avi', '.mkv' => 'avi', 'flv' => 'avi',
  '.mp3' => 'mp3', '.ogg' => 'mp3', '.oga' => 'mp3', '.wma' => 'mp3', '.wav' => 'mp3', '.ra' => 'mp3', '.rm' => 'mp3',
  '.txt' => 'txt', '.rtf' => 'txt',
  '.zip' => 'exe', '.rar' => 'exe', '.7z' => 'zip',
  '.exe' => 'exe', '.sh' => 'exe', '.ml' => 'exe', '.mw' => 'exe', '' => 'exe'
);

//////////////////////////////////
// Modifications de répertoires //
//////////////////////////////////
if ( isset($_REQUEST['modifie']) || isset($_REQUEST['supprime']) || isset($_REQUEST['cree']) )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = mysql_ecriture();

  // Récupération des données du répertoire
  $resultat = $mysqli->query("SELECT nom, parent, protection, nbrep+nbdoc AS nb, menu FROM reps WHERE id = $rid");
  $rep = $resultat->fetch_assoc();
  $resultat->free();

  // Récupération des liens de parenté entre répertoires
  $resultat = $mysqli->query("SELECT id, parents FROM reps WHERE FIND_IN_SET(matiere,'0,${_SESSION['matieres']}')");
  while ( $r = $resultat->fetch_assoc() )
    $parents[$r['id']] = $r['parents'];
  $resultat->free();

  // Traitement d'une modification du répertoire actuel
  // Une partie est impossible si $rep['parent'] est nul (répertoires racines de matières)
  if ( isset($_REQUEST['modifie']) )  {
    $message = '';

    // Modification du nom
    if ( isset($_REQUEST['nom']) && ( $rep['parent'] ) && ( strlen($nom = $mysqli->real_escape_string($_REQUEST['nom'])) ) && ( $rep['nom'] != $nom ) )
      $message = ( requete('reps',"UPDATE reps SET nom = '$nom' WHERE id = $rid") ) ? 'Le nom du répertoire <em>'.stripslashes($rep['nom'] = $nom).'</em> a bien été modifié.' : "Le nom du répertoire <em>${rep['nom']}</em> n'a pas pu être modifié. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

    // Déplacement du répertoire
    if ( isset($_REQUEST['parent']) && ( $rep['parent'] ) && isset($parents[$parent=$_REQUEST['parent']]) && ( $parent != $rep['parent'] ) && ( !in_array($rid,explode(',',$parents[$parent])) ) )  {
      // Récupération de l'éventuelle nouvelle matière
      $resultat = $mysqli->query("SELECT matiere FROM reps WHERE id = $parent");
      $r = $resultat->fetch_assoc();
      $resultat->free();
      $mat = $r['matiere'];
      $parents = "${parents[$parent]},$parent";
      // Modifications
      $message .= ( requete('reps',"UPDATE reps SET matiere = $mat, parent = $parent, parents = '$parents' WHERE id = $rid")
                 && requete('reps',"UPDATE reps SET matiere = $mat, parents = '$parents,$rid' WHERE parent = $rid")
                 && requete('docs',"UPDATE docs SET matiere = $mat, parents = '$parents,$rid' WHERE parent = $rid")
      ) ? " Le répertoire <em>${rep['nom']}</em> a bien été déplacé." : " Le répertoire <em>${rep['nom']}</em> n'a pas pu être déplacé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }

    // Modification de l'affichage dans le menu
    $menu = isset($_REQUEST['menu']) ? 1 : 0;
    if ( ( $rep['parent'] ) && ( $menu != $rep['menu'] ) )
      $message .= ( requete('reps',"UPDATE reps SET menu = $menu WHERE id = $rid") ) ? " L'affichage dans le menu du répertoire <em>${rep['nom']}</em> a bien été modifié." : " L'affichage dans le menu du répertoire <em>${rep['nom']}</em> n'a pas pu être modifié. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

    // Modification des droits d'accès au répertoire
    $protection = ( in_array($_REQUEST['protection'],array(0,1,2,3,4)) ) ? $_REQUEST['protection'] : 0;
    if ( $protection != $rep['protection'] )  {
      if ( requete('reps',"UPDATE reps SET protection = $protection WHERE id = $rid") )  {
        $message .=  " La visibilité du répertoire <em>${rep['nom']}</em> a bien été modifiée.";
        $rep['protection'] = $protection;
      }
      else
        $message .= " La visibilité du répertoire <em>${rep['nom']}</em> n'a pas pu être modifiée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }
    
    // Propagation des droits d'accès aux sous-répertoires et documents
    if ( isset($_REQUEST['propagation']) && ( $rep['nb'] ) )
      $message .=  ( requete('reps',"UPDATE reps SET protection = ${rep['protection']} WHERE FIND_IN_SET($rid,parents)")
                  && requete('docs',"UPDATE docs SET protection = ${rep['protection']} WHERE FIND_IN_SET($rid,parents)")
      ) ? " La visibilité du répertoire <em>${rep['nom']}</em> a bien été propagée à tout son contenu (sous-répertoires et documents)." : " La visibilité du répertoire <em>${rep['nom']}</em> a bien été propagée à tout son contenu (sous-répertoires et documents). Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

    if ( !strlen($message) )
      unset($message);
  }

  // Suppression du répertoire actuel
  elseif ( isset($_REQUEST['supprime']) && ( $rep['parent'] ) )  {
    if ( requete('reps',"DELETE FROM reps WHERE id = $rid OR FIND_IN_SET($rid,parents)") )  {
      $resultat = $mysqli->query("SELECT GROUP_CONCAT(CONCAT('../documents/',lien) SEPARATOR ' ') AS chemins
                                  FROM docs WHERE FIND_IN_SET($rid,parents)");
      $r = $resultat->fetch_assoc();
      $resultat->free();
      // Suppression physique ( $r['chemin'] est "null" si pas de document à supprimer)
      if ( $r['chemins'] )
        exec("rm -rf ${r['chemins']}");
      requete('docs',"DELETE FROM docs WHERE FIND_IN_SET($rid,parents)");
      $message = "La suppression du répertoire <em>${rep['nom']}</em> a bien été effectuée.";
      $rid = $rep['parent'];
    }
    else
      $message = "La suppression du répertoire <em>${rep['nom']}</em> n'a pas été effectuée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
  }

  // Création d'un sous-répertoire
  elseif ( isset($_REQUEST['cree']) && ( strlen($_REQUEST['nom']) ) )  {
    $nom = $mysqli->real_escape_string($_REQUEST['nom']);
    $protection = ( in_array($_REQUEST['protection'],array(0,1,2,3,4)) ) ? $_REQUEST['protection'] : 0;
    $menu = isset($_REQUEST['menu']) ? 1 : 0;
    $message = ( requete('reps',"INSERT INTO reps SET parent = $rid, parents = '${parents[$rid]},$rid',
                                 nom = '$nom', matiere = (SELECT r.matiere FROM reps AS r WHERE r.id = $rid),
                                 nbrep = 0, nbrep_v = 0, nbdoc = 0, nbdoc_v = 0, protection = $protection, menu = $menu")
    ) ? 'Le répertoire <em>'.stripslashes($nom).'</em> a bien été créé.' : 'Le répertoire <em>'.stripslashes($nom).'</em> n\'a pas pu être créé. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
  }

  // Mise à jour des champs nbrep/nbdoc dans la table 'reps'
  $mysqli->query('UPDATE reps AS r SET 
    nbrep = (SELECT COUNT(id) FROM (SELECT * FROM reps ) AS r1 WHERE r.id = r1.parent),
    nbrep_v = (SELECT COUNT(id) FROM (SELECT * FROM reps WHERE reps.protection<4) AS r2 WHERE r.id = r2.parent),
    nbdoc = (SELECT COUNT(id) FROM docs AS d WHERE r.id = d.parent),
    nbdoc_v = (SELECT COUNT(id) FROM docs AS d WHERE r.id = d.parent AND d.protection<4)');
  $mysqli->query('ALTER TABLE reps ORDER BY parents,nom');
  // Mise à jour des champs 'docs' dans la table 'matieres' (pour le menu)
  $mysqli->query('UPDATE matieres SET docs = (SELECT IF(SUM(nbdoc_v),1,0) FROM reps WHERE matiere = matieres.id)');

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}

////////////////////////////////
// Modifications de documents //
////////////////////////////////
elseif ( isset($_REQUEST['id']) && is_numeric($id = $_REQUEST['id']) )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = mysql_ecriture();

  // Récupération des données relatives au document
  if ( $id )  {
    $resultat = $mysqli->query("SELECT nom, protection, ext, lien, parent FROM docs WHERE id = $id AND FIND_IN_SET(matiere,'0,${_SESSION['matieres']}')");
    if ( $resultat->num_rows )  {
      $doc = $resultat->fetch_assoc();
      $resultat->free();
    }
    else
      $id = 0;
  }

  // Fonction PHP pour le stockage dans la base MySQL de l'ordre "naturel" (1,2,10,11 et non 1,10,11,2)
  // Remplace tout nombre par un nombre égal mais écrit sur 10 chiffres, complété par des zéros à gauche
  function zpad($s) {
    return preg_replace_callback('/(\d+)/', function($m){
      return(str_pad($m[1],10,'0',STR_PAD_LEFT)); }
    , $s);
  }

  // Traitement d'une modification d'un document
  if ( isset($_REQUEST['modifie_doc']) && ( $id ) )  {
    if ( !strlen($_REQUEST['nom']) )
      $message = 'Il n\'est pas possible de valider un nom de fichier vide. Pour supprimer un fichier, il faut cliquer sur Supprimer.';
    else  {
      $message = '';

      // Modification du nom
      setlocale(LC_CTYPE, "fr_FR.UTF-8");
      $nom = basename(str_replace($doc['ext'],'',str_replace('/','-',$_REQUEST['nom'])));
      if ( $nom != $doc['nom'] )  {
        // real_escape_string seulement pour la requête SQL
        if ( requete('docs','UPDATE docs SET nom = \''.$mysqli->real_escape_string($nom).'\', nom_nat = \''.zpad($mysqli->real_escape_string($nom))."' WHERE id = $id") )  {
          exec('mv ../documents/'.escapeshellarg("${doc['lien']}/${doc['nom']}${doc['ext']}").' ../documents/'.escapeshellarg("${doc['lien']}/$nom${doc['ext']}"));
          $message = " Le nom du document <em>$nom</em> a bien été modifié.";
          $doc['nom'] = $nom;
        }
        else
          $message ="Le nom du document <em>${doc['nom']}</em> n'a pas pu être modifié. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      }

      // Modification de l'accès
      $protection = ( in_array($_REQUEST['protection'],array(0,1,2,3,4)) ) ? $_REQUEST['protection'] : 0;
      if ( $protection != $doc['protection'] )
        $message .= ( requete('docs',"UPDATE docs SET protection = $protection WHERE id = $id")
        ) ? " L'accès au document <em>${doc['nom']}</em> a bien été modifié." : " L'accès au document <em>${doc['nom']}</em> n'a pas pu être modifié. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

      // Déplacement dans un autre répertoire
      if ( is_numeric($parent = $_REQUEST['parent']) && ( $parent != $doc['parent'] ) )  {
        $resultat = $mysqli->query("SELECT parents, matiere FROM reps WHERE id = $parent AND FIND_IN_SET(matiere,'0,${_SESSION['matieres']}')");
        if ( $resultat->num_rows )  {
          $r = $resultat->fetch_assoc();
          $resultat->free();
          $message .= ( requete('docs',"UPDATE docs SET parent = '$parent', parents = '${r['parents']},$parent',
                                        matiere = ${r['matiere']} WHERE id = $id")
          ) ? " Le document <em>${doc['nom']}</em> a bien été déplacé." : " Le document <em>${doc['nom']}</em> n'a pas pu être déplacé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
        }
      }
      
      // Si modification(s), on met à jour les informations récentes éventuelles
      if ( strlen($message) )  {
        if ( $protection < 4 )  {
          $resultat = $mysqli->query("SELECT GROUP_CONCAT( reps.nom ORDER BY FIND_IN_SET(reps.id,docs.parents) SEPARATOR '/' ) AS path
                                      FROM docs LEFT JOIN reps ON FIND_IN_SET(reps.id,docs.parents) WHERE docs.id = $id");
          $r = $resultat->fetch_assoc();
          $resultat->free();
          $path = $mysqli->real_escape_string("${r['path']}/${doc['nom']}");
          $icone = array_key_exists(strtolower($doc['ext']),$icones) ? $icones[strtolower($doc['ext'])] : 'defaut';
          // Document auparavant non visible
          if ( $doc['protection'] == 4 )
            recent($mysqli,3,$id,"<img class=\"icone\" src=\"icones/$icone.png\"> $path","download?id=$id","<p>Nouveau document&nbsp;: <a href=\"download?id=$id\">$path</a></p>");
          // Document auparavant visible : on met à jour les chemins, sans mettre en avant le document
          // Remarque : le RSS n'est pas modifié, le sera lors d'une nouvelle information récente
          // Le lien de téléchargement est de toutes façons inchangé
          else
            $mysqli->query("UPDATE recents SET texte = '<p>Nouveau document&nbsp;: <a href=\"download?id=$id\">$path</a></p>', titre = '<img class=\"icone\" src=\"icones/$icone.png\"> $path' WHERE id = 3000+$id");
        }
        // Si $protection = 4, on cherche à supprimer.
        else
          recent($mysqli,3,$id);
      }
      else
        unset($message);
    }
  }
  
  // Suppression d'un document
  elseif ( isset($_REQUEST['supprime_doc']) && ( $id ) )  {
    if ( requete('docs',"DELETE FROM docs WHERE id = $id") )  {
      $message = "Le document <em>${doc['nom']}</em> a bien été supprimé.";
      // Suppression physique
      exec("rm -rf ../documents/${doc['lien']}");
      // Mise à jour des informations récentes
      if ( $doc['protection'] < 4 )
        recent($mysqli,3,$id);
    }
    else
      $message = "Le document <em>${doc['nom']}</em> n'a pas pu être supprimé. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
  }

  // Mise à jour d'un document
  elseif ( isset($_REQUEST['envoie']) && ( $id ) )  {
    // Changement d'extension suspect donc interdit
    $ext = ( strpos($_FILES['fichier']['name'],'.') ) ? strrchr($_FILES['fichier']['name'],'.') : '';
    if ( $ext != $doc['ext'] )
      $message = "Le document <em>${doc['nom']}</em> n'a pas été mis à jour&nbsp;: l'extension n'est pas celle attendue.";
    else  {
      // Déplacement du document uploadé au bon endroit
      if ( move_uploaded_file($_FILES['fichier']['tmp_name'],"../documents/${doc['lien']}/${doc['nom']}${doc['ext']}") )  {
        // Gestion de la taille
        $taille = intval($_FILES['fichier']['size']/1024);
        $taille = ( $taille < 1024 ) ? "$taille&nbsp;ko" : intval($taille/1024).'&nbsp;Mo';
        // Modifications dans la base de données
        requete('docs',"UPDATE docs SET upload = DATE(NOW()), taille = '$taille' WHERE id = $id");
        // Information récente si document visible
        if ( $doc['protection'] < 4 )  {
          $resultat = $mysqli->query("SELECT GROUP_CONCAT( reps.nom ORDER BY FIND_IN_SET(reps.id,docs.parents) SEPARATOR '/' ) AS path
                                      FROM docs LEFT JOIN reps ON FIND_IN_SET(reps.id,docs.parents) WHERE docs.id = $id");
          $r = $resultat->fetch_assoc();
          $resultat->free();
          $path = $mysqli->real_escape_string("${r['path']}/${doc['nom']}");
          $icone = array_key_exists(strtolower($doc['ext']),$icones) ? $icones[strtolower($doc['ext'])] : 'defaut';
          recent($mysqli,3,$id,"<img class=\"icone\" src=\"icones/$icone.png\"> $path","download?id=$id","<p>Nouvelle version du document&nbsp;: <a href=\"download?id=$id\">$path</a></p>");
        }
        $message = "Le document <em>${doc['nom']}</em> a bien été mis à jour.";
      }
      else
        $message = "Le document <em>${doc['nom']}</em> n'a pas été mis à jour car le fichier envoyé n'est pas valide.";
    }
  }

  // Envoi d'un nouveau document
  elseif ( isset($_REQUEST['envoie']) )  {
    // Vérifications des données envoyées (on fait confiance aux utilisateurs connectés pour ne pas envoyer de scripts malsains)
    $nom = $_FILES['fichier']['name'];
    // $est ne doit pas faire plus de 4 caractères sinon fichier plus accessible
    $ext = ( strpos($nom,'.') ) ? substr(strrchr($nom,'.'),0,4) : '';
    setlocale(LC_CTYPE, "fr_FR.UTF-8");
    $nom = basename(str_replace('/','-',str_replace($ext,'', ( strlen($_REQUEST['nom']) ) ? $_REQUEST['nom'] : $nom )));
    $protection = ( in_array($_REQUEST['protection'],array(0,1,2,3,4)) ) ? $_REQUEST['protection'] : 0;
    // Création du répertoire particulier
    $lien = substr(sha1(mt_rand()),0,15);
    while ( is_dir("../documents/$lien") )
      $lien = substr(sha1(mt_rand()),0,15);
    mkdir("../documents/$lien");
    // Gestion de la taille
    $taille = intval($_FILES['fichier']['size']/1024);
    $taille = ( $taille < 1024 ) ? "$taille&nbsp;ko" : intval($taille/1024).'&nbsp;Mo';
    // Récupération des données du répertoire parent
    $resultat = $mysqli->query("SELECT parents, matiere FROM reps WHERE id = $rid");
    $r = $resultat->fetch_assoc();
    $resultat->free();
    // Déplacement du document uploadé au bon endroit
    if ( move_uploaded_file($_FILES['fichier']['tmp_name'],"../documents/$lien/$nom$ext") )  {
      // Écriture MySQL
      if ( requete('docs',"INSERT INTO docs SET parent = $rid, parents = '${r['parents']},$rid',
                           matiere = ${r['matiere']}, nom = '".$mysqli->real_escape_string($nom).'\',
                           nom_nat = \''.zpad($mysqli->real_escape_string($nom))."', upload = DATE(NOW()),
                           taille = '$taille', lien = '$lien',
                           ext='".$mysqli->real_escape_string($ext)."', protection = $protection") )  {
        $id = $mysqli->insert_id;
        $message = "Le document <em>$nom</em> a bien été mis en ligne.";
        // Mise à jour du répertoire et des informations récentes
        if ( $protection < 4 )  {
          $resultat = $mysqli->query("SELECT GROUP_CONCAT( reps.nom ORDER BY FIND_IN_SET(reps.id,docs.parents) SEPARATOR '/' ) AS path
                                      FROM docs LEFT JOIN reps ON FIND_IN_SET(reps.id,docs.parents) WHERE docs.id = $id");
          $r = $resultat->fetch_assoc();
          $resultat->free();
          $path = $mysqli->real_escape_string("${r['path']}/$nom");
          $icone = array_key_exists(strtolower($ext),$icones) ? $icones[strtolower($ext)] : 'defaut';
          recent($mysqli,3,$id,"<img class=\"icone\" src=\"icones/$icone.png\"> $path","download?id=$id","<p>Nouveau document&nbsp;: <a href=\"download?id=$id\">$path</a></p>");
        }
      }
      else  {
        // Retour en arrière
        exec("rm -rf ../documents/$lien");
        $message = "Le document <em>$nom</em> n'a pas été mis en ligne à cause d'une erreur lors des modifications dans la base de données MySQL. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
      }
    }
    else
      $message = "Le document <em>$nom</em> n'a pas été mis en ligne car le fichier envoyé n'est pas valide.";
  }
  
  // Mise à jour des champs nbrep/nbdoc dans la table 'reps'
  $mysqli->query('UPDATE reps AS r SET
    nbrep = IFNULL((SELECT n FROM (SELECT COUNT(id) AS n, parent FROM reps GROUP BY parent) AS r1 WHERE r.id = r1.parent),0),
    nbrep_v =IFNULL((SELECT n FROM (SELECT COUNT(id) AS n, parent FROM reps WHERE reps.protection<4 GROUP BY parent) AS r1 WHERE r.id =r1.parent),0),
    nbdoc = (SELECT COUNT(id) FROM docs AS d WHERE r.id = d.parent),
    nbdoc_v = (SELECT COUNT(id) FROM docs AS d WHERE r.id = d.parent AND d.protection<4)');
  $mysqli->query('ALTER TABLE docs ORDER BY parents,nom_nat');
  // Mise à jour des champs 'docs' dans la table 'matieres' (pour le menu)
  $mysqli->query('UPDATE matieres SET docs = (SELECT IF(SUM(nbdoc_v),1,0) FROM reps WHERE matiere = matieres.id)');
    
  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}

//////////
// HTML //
//////////

// Récupération des répertoires, dans le bon ordre pour un select
function liste($rid,$n)  {
  $resultat = $GLOBALS['mysqli']->query("SELECT id, nom FROM reps
                                          WHERE parent = $rid AND FIND_IN_SET(matiere,'0,${_SESSION['matieres']}')");
  while ( $r = $resultat->fetch_assoc() )  {
    $GLOBALS['select_reps'] .= "        <option value=\"${r['id']}\">".str_repeat('&rarr;',$n)."${r['nom']}</option>\n";
    liste($r['id'],$n+1);
  }
  $resultat->free();
}
$select_reps = '';
liste(0,0);

// Récupération des données, vérification de la protection, répertoires parents
$resultat = $mysqli->query("SELECT r.nom, r.parent, r.parents, r.nbrep + r.nbdoc AS nb,
                            r.protection, r.menu, m.cle, m.nom AS mat
                            FROM reps AS r LEFT JOIN matieres AS m ON r.matiere = m.id
                            WHERE r.id = $rid");
$rep = $resultat->fetch_assoc();
$resultat->free();

$t = "Gestion des documents - ${rep['nom']}";
$p = ( is_null($rep['cle']) ) ? "docs" : "docs?${rep['cle']}";
// Haut de page, menu et message
include('haut.php');

// Répertoires parents
$resultat = $mysqli->query("SELECT id, nom, IF(parent,'next','home') AS icone,
                            IF(protection,'-lock','') AS protection
                            FROM reps WHERE FIND_IN_SET(id,'${rep['parents']},$rid')");
$parents = '';
while ( $r = $resultat->fetch_assoc() )
  $parents .= "\n    <a href=\"?rep=${r['id']}\"><img class=\"icone\" src=\"../icones/${r['icone']}${r['protection']}.png\">${r['nom']}</a>";
$resultat->free();
echo <<<FIN
  
  <div class="item" id="parents">$parents
  </div>
  
  <div id="ordre">
    <span>Ordre alphabétique&nbsp;<a href="?rep=$rid&amp;ordre=alpha"><img src="../icones/down.png" alt="croissant"></a>&nbsp;<a href="?rep=$rid&amp;ordre=alpha-r"><img src="../icones/up.png" alt="décroissant"></a></span>
    <span>Ordre chronologique&nbsp;<a href="?rep=$rid&amp;ordre=chrono"><img src="../icones/down.png" alt="croissant"></a>&nbsp;<a href="?rep=$rid&amp;ordre=chrono-r"><img src="../icones/up.png" alt="décroissant"></a></span>
  </div>

FIN;

// Affichage du répertoire et de son contenu
if ( $rep['nb'] )  {
  
  function affichage($mysqli, $rid, $n)  {
    $indent = str_pad('',2*$n);

    // Sous-répertoires et récursivité
    $resultat = $mysqli->query("SELECT id, nom, nbrep, nbdoc, protection FROM reps WHERE parent = $rid");
    if ( $resultat->num_rows )  {
      while ( $r = $resultat->fetch_assoc() )  {
        if ( $r['nbrep']+$r['nbdoc'] )
          $contenu = str_replace(array('0 répertoire, ',', 0 document'),'',"(${r['nbrep']} répertoire".( ( $r['nbrep'] > 1 ) ? 's' : '' ).", ${r['nbdoc']} document".( ( $r['nbdoc'] > 1 ) ? 's' : '' ));
        else
          $contenu = '(vide';
        $contenu .= ( $r['protection'] == 4 ) ? '&nbsp;-&nbsp;non visible)' : ')';
        $s = ( $r['protection'] ) ? '<p class="rep open lock"><img class="icone" src="../icones/rep-open-lock.png">' : '<p class="rep open"><img class="icone" src="../icones/rep-open.png">';
        echo <<<FIN

$indent<div class="rep">
$indent  $s<a href="?rep=${r['id']}">${r['nom']}</a> $contenu</p>
FIN;
        affichage($mysqli,$r['id'],$n+1);
        echo "\n$indent</div>";
      }
    }
    $resultat->free();

    // Documents
    $ordre = '';
    if ( isset($_REQUEST['ordre']) )
      switch ( $_REQUEST['ordre'] )  {
        case 'alpha':
          $ordre = ' ORDER BY nom_nat ASC';
          break;
        case 'alpha-r':
          $ordre = ' ORDER BY nom_nat DESC';
          break;
        case 'chrono':
          $ordre = ' ORDER BY docs.upload ASC';
          break;
        case 'chrono-r':
          $ordre = ' ORDER BY docs.upload DESC';
      }
    $resultat = $mysqli->query("SELECT id, nom, taille, DATE_FORMAT(upload,'%d/%m/%Y') AS upload,
                                LOWER(ext) AS ext, protection FROM docs WHERE parent = $rid$ordre");
    if ( $resultat->num_rows )  {
      $icones = $GLOBALS['icones'];
      while ( $r = $resultat->fetch_assoc() )  {
        $icone = array_key_exists($r['ext'],$icones) ? $icones[$r['ext']] : 'defaut';
        $id = $r['id'];
        if ( $r['protection'] && ( $r['protection'] < 4 ) )
          $icone .= '-lock';
        $cache = ( $r['protection'] == 4 ) ? ' (non visible)' : '';
        $select_reps = str_replace(array("\"$rid\"",'        '),array("\"$rid\" selected","$indent      "),$GLOBALS['select_reps']);
        $select_protection = str_replace("\"${r['protection']}\"","\"${r['protection']}\" selected","
$indent        <option value=\"0\">Visible de tous</option>
$indent        <option value=\"1\">Visible pour les élèves, colleurs, profs</option>
$indent        <option value=\"2\">Visible pour les colleurs et les profs</option>
$indent        <option value=\"3\">Visible pour les profs uniquement</option>
$indent        <option value=\"4\">Non visible</option>");
        echo <<<FIN

$indent<div class="fic admin">
$indent  <span><img class="icone" src="../icones/$icone.png">${r['nom']}</span>$cache
$indent  <form action="?rep=${GLOBALS['rid']}" method="post" enctype="multipart/form-data">
$indent    <input class="bouton" type="submit" name="envoie" value="Envoyer">
$indent    <p class="ligne"><label for="fichier$id">Mettre à jour&nbsp;: </label><input type="file" id="fichier$id" name="fichier"></p>
$indent    <input type="hidden" name="id" value="$id">
$indent  </form>
$indent  <hr>
$indent  <form action="?rep=${GLOBALS['rid']}" method="post">
$indent    <p class="boutons"><input type="submit" name="modifie_doc" value="Valider" title="Valider les modifications"><input type="submit" name="supprime_doc" value="Supprimer" title="Supprimer ce document"></p>
$indent    <p class="ligne"><label for="nomdoc$id">Nom à afficher&nbsp;: </label><input type="text" id="nom$id" name="nom" value="${r['nom']}" size="50"></p>
$indent    <p class="ligne"><label for="parent$id">Répertoire&nbsp;: </label><select id="parent$id" name="parent">
$select_reps$indent    </select></p>
$indent    <p class="ligne"><label for="protecdoc$id">Accès&nbsp;: </label>
$indent      <select id="protecdoc$id" name="protection">$select_protection
$indent      </select>
$indent    </p>
$indent    <input type="hidden" name="id" value="$id">
$indent    <p class="ligne"><label>Lien&nbsp;: </label><code>&lt;a href="download?id=$id"&gt;${r['nom']}&lt;/a&gt;</code></p>
$indent    <p class="ligne"><a href="download?id=$id">Télécharger</a>|&nbsp;Taille&nbsp;: ${r['taille']}&nbsp;|&nbsp;Diffusé le ${r['upload']}</p>
$indent  </form>
$indent</div>
FIN;
      }
      $resultat->free();
    }
  }

  affichage($mysqli,$rid,1);
  
}
else
  echo "\n  <h3 class=\"warning\">Ce répertoire est vide.</h3>\n\n";

/////////////////////////////////
// Formulaires de modification //
/////////////////////////////////

// Taille maximale de fichier (pour l'aide)
$taille = min(ini_get('upload_max_filesize'),ini_get('post_max_size'));
if ( stristr($taille,'m') )
  $taille = substr($taille,0,-1)*1048576;
elseif ( stristr($taille,'k') )
  $taille = substr($taille,0,-1)*1024;
$taille = ( $taille < 1048576 ) ? intval($taille/1024).'&nbsp;ko' : intval($taille/1048576).'&nbsp;Mo';

// Restrictions pour les modifications sur le répertoire
$indication = $pas_suppr = $disabled = '';
if ( $rep['nb'] )  {
  $indication = "\n    <p>Attention, la suppression de ce répertoire entraînera de façon définitive la suppression de tous les sous-répertoires et de tous les documents qui s'y trouvent. Aucune confirmation ne sera demandée.</p>";
}
if ( !$rep['parent'] )  {
  $disabled = $pas_suppr = ' disabled';
  $indication = "\n    <p>Ce répertoire est un répertoire racine, il ne peut être ni supprimé, ni renommé, ni déplacé.</p>";
  $select_reps = '        <option></option>';
}  

// Choix par défaut de la protection du nouveau document et du sous-répertoire
$select_protection = str_replace("\"${rep['protection']}\"","\"${rep['protection']}\" selected",'
        <option value="0">Visible de tous</option>
        <option value="1">Visible pour les élèves, colleurs, profs</option>
        <option value="2">Visible pour les colleurs et les profs</option>
        <option value="3">Visible pour les profs uniquement</option>
        <option value="4">Non visible</option>');

  // HTML
?>

  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ci-dessous modifier le répertoire <?php echo $rep['nom']; ?> ainsi que l'ensemble des documents contenus dans les sous-répertoires.</p>
    <p>Les liens vers les répertoires et les documents sont garantis&nbsp;: aucune modification (déplacement, changement de nom...) réalisée sur les répertoires ou les documents ne peut modifier ces liens.</p>
    <p>Le lien dans le menu vers le répertoire de premier niveau de chaque matière est généré automatiquement, seulement si des documents sont disponibles.</p>
    <p>Seul le répertoire général, les répertoires correspondant aux matières qui vous sont associées et tous leurs sous-répertoires sont accessibles. Les matières qui vous sont associées sont modifiables dans vos <a href="prefs">Préférences</a>.</p>
    <h4>Liste de sous-répertoires et documents</h4>
    <p>Dans cette arborescence, les sous-répertoires se déplient en cliquant sur leur icône. Cliquer sur leur nom envoie vers la page correspondant au répertoire en question.</p>
    <p>Cliquer sur l'icône ou le nom d'un document ouvre le formulaire de modification correspondant.</p>
    <h4>Modification des documents déjà envoyés</h4>
    <p>Les documents déjà envoyés sont modifiables en cliquant sur leur nom ou leur icône dans l'arborescence.</p>
    <p>Vous pouvez <em>mettre à jour</em> un document déjà envoyé&nbsp;: cela évite de supprimer/recréer le document, et permet aux liens vers le document d'être toujours valables (l'adresse ne change pas). Une nouvelle information récente apparaîtra pour indiquer cette mise à jour.</p>
    <p>Vous pouvez aussi renommer tout document. Le <em>nom à afficher</em> sera le nom réellement affiché sur le site web (sans extension&nbsp;: elle est détectée automatiquement). Cette case ne peut être vide.</p>
    <p>Vous pouvez aussi déplacer tout document. Seul le répertoire général, les répertoires correspondant aux matières qui vous sont associées et tous leurs sous-répertoires peuvent accueillir vos documents. Les matières qui vous sont associées sont modifiables dans vos <a href="prefs">Préférences</a>.</p>
    <p>Vous pouvez modifier l'<em>accès</em> du document parmi cinq possibilités&nbsp;:</p>
    <ul>
      <li><em>Visible de tous</em>&nbsp;: document accessible de tout visiteur, sans identification.</li>
      <li><em>Visible pour les élèves, colleurs, professeurs</em>&nbsp;: document accessible uniquement par tout utilisateur après identification. Il faut donc avoir un compte validé (voir l'aide de la page <a href="utilisateurs">Utilisateurs</a>) pour y accéder.</li>
      <li><em>Visible pour les colleurs, professeurs</em>&nbsp;: document accessible uniquement par les utilisateurs de type colleur ou professeur. Attention, si l'accès au répertoire est différent, le titre du document peut être visible par les élèves ou un visiteur non identifié.</li>
      <li><em>Visible pour les professeurs</em>&nbsp;: document accessible uniquement par les utilisateurs de type professeur (vous et vos collègues).</li>
      <li><em>Non visible</em>&nbsp;: document n'est pas encore visible en ligne. Cela peut être utile si vous souhaitez le mettre à disposition ultérieurement. C'est complètement sûr&nbsp;: vous pouvez mettre comme cela le prochain sujet de devoir ou même le corrigé.</li>
    </ul>
    <p>Les documents visibles après identification ont un cadenas dans leur icône. Les documents non visibles sont marqués comme tels.</p>
    <p>Chaque formulaire déplié présente par ailleurs le lien vers le document (en HTML) ainsi qu'un lien de téléchargement si vous souhaitez vérifier immédiatement de quel document il s'agit.</p>
    <h4>Préférences du répertoire</h4>
    <p>Seul le répertoire <?php echo $rep['nom']; ?> est modifiable ici. Pour modifier le nom ou déplacer un autre répertoire, il faut afficher sa propre page en cliquant sur son nom dans l'arborescence.</p>    
    <p>Modifier le <em>répertoire parent</em> revient à déplacer le répertoire et l'ensemble de son contenu. Le déplacement n'est possible qu'au sein du répertoire général ou des répertoires correspondant aux matières qui vous sont associées. Les matières qui vous sont associées sont modifiables dans vos <a href="prefs">Préférences</a>.</p>
    <p>La case à cocher <em>Affichage du répertoire dans le menu</em> permet d'afficher un lien direct dans le menu (partie publique et interface d'administration) vers la page correspondant au répertoire.</p>
    <p>Vous pouvez modifier l'<em>accès</em> du répertoire parmi cinq possibilités&nbsp;:</p>
    <ul>
      <li><em>Visible de tous</em>&nbsp;: répertoire accessible de tout visiteur, sans identification. Les titres des documents sont visibles, mais chaque document peut avoir son propre accès.</li>
      <li><em>Visible pour les élèves, colleurs, professeurs</em>&nbsp;: répertoire accessible uniquement par tout utilisateur après identification. Il faut donc avoir un compte validé (voir l'aide de la page <a href="utilisateurs">Utilisateurs</a>) pour y accéder.</li>
      <li><em>Visible pour les colleurs, professeurs</em>&nbsp;: répertoire accessible uniquement par les utilisateurs de type colleur ou professeur. Attention, si l'accès au répertoire est différent, le titre du document peut être visible par les élèves ou un visiteur non identifié.</li>
      <li><em>Visible pour les professeurs</em>&nbsp;: répertoire accessible uniquement par les utilisateurs de type professeur (vous et vos collègues).</li>
      <li><em>Non visible</em>&nbsp;: répertoire non visible en ligne. Il n'apparaît pas sur la partie publique. Cela peut être utile si vous souhaitez le mettre à disposition ultérieurement.</li>
    </ul>
    <p>La case à cocher <em>Propager le choix ci-dessus à chaque document/sous-répertoire</em> permet de faire suivre le choix précédent à l'ensemble du contenu du répertoire. Si elle est décochée, aucune modification supplémentaire n'a lieu. Si elle est cochée, une action sera effectuée même si la précédente case n'a pas changé d'état.</p>
    <h4>Suppression d'un répertoire</h4>
    <p>Les répertoires racines (<em>Général</em> ou ayant le nom d'une matière) ne peuvent être supprimés. Tous les autres peuvent être supprimés. La suppression d'un répertoire entraîne automatiquement la suppression de tous les sous-répertoires et de tous les documents qu'il contient.</p>
    <h4>Nouveau document</h4>
    <p>Il est possible d'envoyer un nouveau document grâce au formulaire. Le document sera automatiquement dans le répertoire <?php echo $rep['nom']; ?>. Si vous souhaitez envoyer votre document dans un autre répertoire, il faut aller sur la page de ce répertoire en cliquant sur son nom dans l'arborescence.</p>
    <p>Le <em>nom à afficher</em> sera le nom réellement affiché sur le site web (sans extension&nbsp;: elle est détectée automatiquement lors de l'envoi). Si vous laissez cette case vide, le nom du fichier envoyé sera récupéré.</p>
    <p>Vous pouvez choisir l'<em>accès</em> du document parmi cinq possibilités&nbsp;:</p>
    <ul>
      <li><em>Visible de tous</em>&nbsp;: document accessible de tout visiteur, sans identification.</li>
      <li><em>Visible pour les élèves, colleurs, professeurs</em>&nbsp;: document accessible uniquement par tout utilisateur après identification. Il faut donc avoir un compte validé (voir l'aide de la page <a href="utilisateurs">Utilisateurs</a>) pour y accéder.</li>
      <li><em>Visible pour les colleurs, professeurs</em>&nbsp;: document accessible uniquement par les utilisateurs de type colleur ou professeur. Attention, si l'accès au répertoire est différent, le titre du document peut être visible par les élèves ou un visiteur non identifié.</li>
      <li><em>Visible pour les professeurs</em>&nbsp;: document accessible uniquement par les utilisateurs de type professeur (vous et vos collègues).</li>
      <li><em>Non visible</em>&nbsp;: document n'est pas encore visible en ligne. Cela peut être utile si vous souhaitez le mettre à disposition ultérieurement. C'est complètement sûr&nbsp;: vous pouvez mettre comme cela le prochain sujet de devoir ou même le corrigé.</li>
    </ul>
    <p>La taille du fichier envoyé est limitée à <?php echo $taille; ?>. Tout document est modifiable et déplaçable après envoi, sans que cela ne modifie le lien vers le document.</p>
    <h4>Nouveau sous-répertoire</h4>
    <p>Il est possible de créer autant de sous-répertoires que vous le souhaitez. Le <em>nom</em> sera le nom du sous-répertoire.</p>
    <p>La case à cocher <em>Affichage du répertoire dans le menu</em> permet d'afficher un lien direct dans le menu (partie publique et interface d'administration) vers la page correspondant au répertoire.</p>
    <p>Vous pouvez définir l'<em>accès</em> du sous-répertoire parmi cinq possibilités&nbsp;:</p>
    <ul>
      <li><em>Visible de tous</em>&nbsp;: répertoire accessible de tout visiteur, sans identification. Les titres des documents sont visibles, mais chaque document peut avoir son propre accès.</li>
      <li><em>Visible pour les élèves, colleurs, professeurs</em>&nbsp;: répertoire accessible uniquement par tout utilisateur après identification. Il faut donc avoir un compte validé (voir l'aide de la page <a href="utilisateurs">Utilisateurs</a>) pour y accéder.</li>
      <li><em>Visible pour les colleurs, professeurs</em>&nbsp;: répertoire accessible uniquement par les utilisateurs de type colleur ou professeur. Attention, si l'accès au répertoire est différent, le titre du document peut être visible par les élèves ou un visiteur non identifié.</li>
      <li><em>Visible pour les professeurs</em>&nbsp;: répertoire accessible uniquement par les utilisateurs de type professeur (vous et vos collègues).</li>
      <li><em>Non visible</em>&nbsp;: répertoire non visible en ligne. Il n'apparaît pas sur la partie publique. Cela peut être utile si vous souhaitez le mettre à disposition ultérieurement.</li>
    </ul>
  </div>

  <div class="item admin">
  <form action="<?php echo "?rep=$rid"; ?>" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications">
    <input class="bouton" type="submit" name="supprime" value="Supprimer" title="Supprimer ce répertoire"<?php echo $pas_suppr;?>>
    <h3>Modifier le répertoire <em><?php echo $rep['nom']; ?></em></h3>
    <p class="ligne"><label for="nomrep">Nom&nbsp;: </label><input type="text" id="nomrep" name="nom" value="<?php echo $rep['nom']; ?>" size="50"<?php echo $disabled;?>></p>
    <p class="ligne"><label for="parent">Répertoire parent&nbsp;: </label>
      <select id="parent" name="parent"<?php echo $disabled;?>>
<?php echo str_replace("\"${rep['parent']}\"","\"${rep['parent']}\" selected",$select_reps); ?>
      </select>
    </p>
    <p class="ligne"><label for="menurep">Affichage du répertoire dans le menu&nbsp;: </label><input type="checkbox" id="menurep" name="menu" value="1"<?php echo ( $rep['menu'] ) ? ' checked' : ''; echo $disabled; ?>></p>
    <p class="ligne"><label for="protecrep">Accès&nbsp;: </label>
      <select id="protecrep" name="protection"><?php echo $select_protection; ?></select>
    </p>
    <p class="ligne"><label for="propagation">Propager le choix ci-dessus à chaque document/sous-répertoire&nbsp;: </label><input type="checkbox" id="propagation" name="propagation" value="1"></p><?php echo $indication;?>
  </form>
  </div>

  <div class="item admin">
  <form action="<?php echo "?rep=$rid"; ?>" method="post" enctype="multipart/form-data">
    <input class="bouton" type="submit" name="envoie" value="Envoyer">
    <h3>Déposer un document dans le répertoire <em><?php echo $rep['nom']; ?></em></h3>
    <p class="ligne"><label for="nomdoc">Nom à afficher&nbsp;: </label><input type="text" id="nomdoc" name="nom" value="" size="50"></p>
    <p class="ligne"><label for="fichier">Fichier&nbsp;: </label><input type="file" id="fichier" name="fichier"></p>
    <p class="ligne"><label for="protecdoc">Accès&nbsp;: </label>
      <select id="protecdoc" name="protection"><?php echo $select_protection; ?></select>
    </p>
    <input type="hidden" name="id" value="0">
  </form>
  </div>

  <div class="item admin">
  <form action="<?php echo "?rep=$rid"; ?>" method="post" enctype="multipart/form-data">
    <input class="bouton" type="submit" name="cree" value="Créer">
    <h3>Créer un sous-répertoire</h3>
    <p class="ligne"><label for="nomssrep">Nom&nbsp;: </label><input type="text" id="nomssrep" name="nom" value="" size="50"></p>
    <p class="ligne"><label for="menussrep">Affichage du répertoire dans le menu&nbsp;: </label><input type="checkbox" id="menussrep" name="menu" value="1"></p>
    <p class="ligne"><label for="protecssrep">Accès&nbsp;: </label>
      <select id="protecssrep" name="protection"><?php echo $select_protection; ?></select>
    </p>
  </form>
  </div>

  <script type="text/javascript">
$( function() {
  $('.fic span').replaceWith(function() { return '<a href="">'+$(this).html()+'</a>'; });
  $('.fic > a').click( function () {
    $(this).parent().find('form,hr').toggle();
    $(this).parent().toggleClass('admin');
    return false;
  }).click();
  $('p.rep img').css('cursor','pointer').click( function () {
    var p = $(this).parent();
    p.toggleClass('open');
    p.parent().children('.fic,div.rep').toggle();
    $(this).attr('src',function(i,val){ return val.replace(p.is('.open')?'rep':'rep-open',p.is('.open')?'rep-open':'rep'); });
  });
  $('p.rep img').attr('src',function(i,val){return val.replace('rep-open','rep');}).parent().removeClass('open');
  $('div.rep .fic,div.rep div.rep').hide();
});
  </script>
  
<?php
$mysqli->close();

// Bas de page
include('bas.php');
?>
