<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par un script autorisé
if ( !defined('OK') )  exit();

/////////////////////////////////////////////
// Fonction de connexion à la base MySQL
function mysql_lecture()  {
  $mysqli = new mysqli($GLOBALS['serveur'],$GLOBALS['base'],$GLOBALS['mdp'],$GLOBALS['base']);
  $mysqli->set_charset('utf8');
  return $mysqli;
}
function mysql_ecriture()  {
  $mysqli = new mysqli($GLOBALS['serveur'],$GLOBALS['base'].'-adm',$GLOBALS['mdp'],$GLOBALS['base']);
  $mysqli->set_charset('utf8');
  return $mysqli;
}

/////////////////////////////////////////////
// Fonction d'affichage des semaines
function format_date($date)  {
  $semaine = array('dimanche','lundi','mardi','mercredi','jeudi','vendredi','samedi');
  $mois = array('','janvier','février','mars','avril','mai','juin','juillet','août','septembre','octobre','novembre','décembre');
  return $semaine[substr($date,0,1)].' '.substr($date,7).' '.$mois[intval(substr($date,5,2))].' '.substr($date,1,4);
}

/////////////////////////////////////////////
// Fonction d'envoi de requêtes MySQL et d'enregistrement
// A besoin d'une connexion MySQL en écriture déjà existante
//  * sauvegarde une fois par mois la table complète
//  * enregistre la requête
//  * exécute la requête
//  * renvoie le résultat de l'exécution
function requete($table,$requete)  {
  $mysqli = $GLOBALS['mysqli'];
  if ( is_dir('../sauvegarde') && is_executable('../sauvegarde') && is_writable('../sauvegarde') )
    $rep = '../sauvegarde';
  elseif ( is_dir('sauvegarde') && is_executable('sauvegarde') && is_writable('sauvegarde') )
    $rep = 'sauvegarde';
  if ( isset($rep) )  {
    // Sauvegarde de la table complète une seule fois par mois
    $mois = date('Y-m');
    $heure = date('d/m/Y à H:i:s');
    if ( !file_exists("$rep/$table.$mois.php") )  {
      $s = <<<FIN
  <?php exit(); ?>
-- Sauvegarde complète de la table $table le $heure
TRUNCATE `$table`; 
FIN;
      $resultat = $mysqli->query("SHOW COLUMNS FROM `$table`");
      $s1 = "INSERT INTO $table (";
      while ( $r = $resultat->fetch_row() )
        $s1 .= "`${r[0]}`,";
      $s1 = substr($s1,0,-1).') VALUES';
      $resultat->free();
      // Récupération des données
      $resultat = $mysqli->query("SELECT * FROM `$table`");
      if ( $resultat->num_rows )  {
        while ( $r = $resultat->fetch_row() )
          $s1 .= "\n  ('".  str_replace('SEPARATEUR','\',\'',addslashes(implode('SEPARATEUR',$r)))  .'\'),';
        $s1 = substr($s1,0,-1).';';
        $resultat->free();
      }
      else
        $s1 = '-- Table vide !';
      $fichier = fopen("$rep/$table.$mois.php",'wb');
      fwrite($fichier, "$s\n$s1\n");
    }
    else
      $fichier = fopen("$rep/$table.$mois.php",'ab');
    // Sauvegarde systématique de la requête
    if ( isset($_SESSION['login'])  )
      fwrite($fichier, "\n-- Requête de ${_SESSION['login']} (${_SESSION['ip']}) le $heure\n$requete;\n");
    else  {
      $login = ( isset($GLOBALS['utilisateur']) ) ? $GLOBALS['utilisateur']['login'] : $GLOBALS['login'];
      fwrite($fichier, "\n-- Requête de $login (${_SERVER['REMOTE_ADDR']}) le $heure\n$requete;\n");
    }
    fclose($fichier);
  }
  return $mysqli->query($requete);
}

///////////////////////////////////////////
// Fonction de mise à jour des nouveautés
function recent($mysqli,$type,$id,$titre='',$lien='',$texte='')  {
  // type : 1->informations, 2->programmes de colles, 3->documents
  // id : celui de l'information/le programme de colles/le document

  // Ajout dans la base de données, suppression si $titre est vide
  if ( strlen($titre) )
    $mysqli->query('REPLACE INTO recents SET id = '.($type*1000+$id).", heure = NOW(), titre = '$titre', lien = '$lien', texte = '$texte'");
  else
    $mysqli->query('DELETE FROM recents WHERE id = '.($type*1000+$id));
  
  // Pas la peine d'aller plus loin si la table n'a pas été modifiée.
  if ( !($mysqli->affected_rows) )
    return;

  // Nettoyage des anciennes entrées
  $mysqli->query('DELETE FROM recents WHERE DATEDIFF(NOW(),heure) > 30');
  // Mise dans l'ordre, les plus récents en premier
  $mysqli->query('ALTER TABLE recents ORDER BY heure DESC');

  // Titre : on récupère celui de la première page
  $resultat = $mysqli->query('SELECT titre FROM pages WHERE id = 1');
  $r = $resultat->fetch_assoc();
  $resultat->free();
  $t = "${r['titre']}";
  
  // Regénération du flux RSS
  $rep = '../documents/'.sha1($GLOBALS['base']);
  $d = date(DATE_RSS);
  $rss = <<<FIN
<?xml version="1.0" encoding="UTF-8"?>
<rss version="2.0" xmlns:atom="http://www.w3.org/2005/Atom">
  <channel>
    <title>$t</title>
    <atom:link href="http://${GLOBALS['site']}/$rep/rss.xml" rel="self" type="application/rss+xml" />
    <link>http://${GLOBALS['site']}</link>
    <description>$t</description>
    <lastBuildDate>$d</lastBuildDate>
    <language>fr-FR</language>


FIN;
  // Récupération des items
  $resultat = $mysqli->query('SELECT UNIX_TIMESTAMP(heure) AS heure, titre, lien, texte FROM recents');
  while ( $r = $resultat->fetch_assoc() )  {
    $d = date(DATE_RSS,$r['heure']);
    $titre = preg_replace('/^<[^>]*> /','',$r['titre']);
    $texte = preg_replace('/href="([^h])/',"href=\"http://${GLOBALS['site']}/\\1",$r['texte']);
    $rss .= <<<FIN
    <item>
      <title><![CDATA[$titre]]></title>
      <link>http://${GLOBALS['site']}/${r['lien']}</link>
      <guid isPermaLink="false">${r['heure']}</guid>
      <description><![CDATA[$texte]]></description>
      <pubDate>$d</pubDate>
    </item>


FIN;
  }
  $rss .= <<<FIN
  </channel>
</rss>

FIN;

  // Mise à jour du flux RSS
  if ( !is_dir($rep) )  mkdir($rep);
  $fichier = fopen($rep.'/rss.xml','wb');
  fwrite($fichier, $rss);
  fclose($fichier);
}
?>
