<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par un script autorisé
if ( !defined('OK') )  exit();

/////////*/
// HTML //
//////////

// La connexion MySQL (lien $mysqli) doit être obligatoirement établie par le script appelant.
// $t et $p doivent être réglés par le script appelant
// $t = titre de la page, $p = cle de la page
?><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
  <title><?php echo $t; ?></title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <link rel="stylesheet" href="../css/style.css" type="text/css" media="screen">
  <link rel="stylesheet" href="../css/print.css" type="text/css" media="print">
  <link rel="stylesheet" href="../css/couleurs.css" type="text/css" media="screen">
  <script type="text/javascript" src="../js/jquery.js"></script>
  <script type="text/javascript" src="/MathJax/MathJax.js?config=TeX-AMS-MML_HTMLorMML"></script>
  <link rel="stylesheet" href="../js/jquery.datepick.css" type="text/css">
  <link rel="stylesheet" href="../js/jquery.timeentry.css" type="text/css">
  <script type="text/javascript" src="../js/jquery.plugin.js"></script>
  <script type="text/javascript" src="../js/jquery.datepick.js"></script>
  <script type="text/javascript" src="../js/jquery.datepick-fr.js"></script>
  <script type="text/javascript" src="../js/jquery.timeentry.js"></script>
  <script type="text/javascript" src="../js/jquery.timeentry-fr.js"></script>
  <script type="text/javascript" src="js.php"></script>
  <script type="text/x-mathjax-config">
    MathJax.Hub.Config({tex2jax: {inlineMath: [["$","$"],["\\(","\\)"]]}});
  </script>
</head>
<body>
<div id="global">

<h1><?php echo $t; ?></h1>

<div id="colonne">

  <div id="menu">
    <div>
<?php
  // Gestion du compte
  $menu = <<<FIN
      <h3>Mon compte</h3>
      <a href=".">Accueil</a>
      <a href="prefs">Préférences</a>
      <a href="mail">Envoyer un mail</a>
      <a href=".?deconnexion">Se déconnecter</a>
    </div>
    <div>
      <h3>Pages d'informations</h3>
FIN;

  // Pages d'informations
  $resultat = $mysqli->query("SELECT CONCAT_WS('/',m.cle,p.cle) AS cle, CONCAT_WS('/',m.nom,p.nom) AS nom
                              FROM pages AS p LEFT JOIN matieres AS m ON p.mat = m.id
                              WHERE FIND_IN_SET(p.mat,'0,${_SESSION['matieres']}')
                              ORDER BY FIND_IN_SET(p.mat,'0,${_SESSION['matieres']}'), p.ordre");
  while ( $r = $resultat->fetch_assoc() )
    $menu .= "\n      <a href=\"pages?page=${r['cle']}\">${r['nom']}</a>";
  $resultat->free();

  // Documents
  $menu .= <<<FIN

      <a href="pages">Gestion des pages</a>
    </div>
    <div>
      <h3>Documents</h3>
      <a href="docs">Docs toutes matières</a>
FIN;
  $resultat = $mysqli->query('SELECT id, nom FROM reps WHERE matiere = 0 AND menu = 1');
  if ( $resultat->num_rows )  {
    while ( $r = $resultat->fetch_assoc() )
      $menu .= "\n        <a class=\"menurep\" href=\"docs?rep=${r['id']}\">${r['nom']}</a>";        
    $resultat->free();
  }
  foreach ( $matieres as $mat )  {
      $menu .= "\n      <a href=\"docs?${mat['cle']}\">Docs ${mat['nom']}</a>";
    $resultat = $mysqli->query("SELECT id, nom FROM reps WHERE matiere = ${mat['id']} AND menu = 1");
    if ( $resultat->num_rows )  {
      while ( $r = $resultat->fetch_assoc() )
        $menu .= "\n        <a class=\"menurep\" href=\"docs?rep=${r['id']}\">${r['nom']}</a>";        
      $resultat->free();
    }
  }

  // Matières
  foreach ( $matieres as $mat )
    $menu .= <<<FIN

    </div>
    <div>
      <h3>Matière <em>${mat['nom']}</em></h3>
      <a href="colles?${mat['cle']}">Programme de colles</a>
      <a href="cdt?${mat['cle']}">Cahier de texte</a>
      <a href="notes?${mat['cle']}">Notes</a>
FIN;

// Affichage du menu
echo str_replace("a href=\"$p\"","a id=\"actuel\" href=\"$p\"",$menu);
?>

    </div>
    <div>
      <h3>Gestion du site</h3>
      <a href="site">Le titre du site</a>
      <a href="utilisateurs">Les utilisateurs</a>
      <!--<a href="trinomes">Les groupes de colles</a>-->
      <a href="matieres">Les matières</a>
      <a href="planning">Le planning annuel</a>
    </div>
    <div>
      <a href="http://<?php echo $site; ?>">Retour au site public</a>
      <a href=".?deconnexion">Se déconnecter</a>
    </div>
  </div>
</div>

<div id="contenu">
<?php
// Conditionnement du message éventuel
if ( isset($message) )
  echo "\n  <div class=\"warning\">$message</div>\n";
?>
