<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

if ( !isset($message) )  {
  // Recherche des demandes de création compte en attente
  $resultat = $mysqli->query('SELECT id FROM utilisateurs WHERE login RLIKE \'^tmp[0-9]{5}\'');
  if ( $n = $resultat->num_rows )  {
    $message = 'Il y a actuellement '. ( ( $n > 1 ) ? $n.' utilisateurs' : '1 utilisateur' ) . ' en attente de validation de sa demande de compte sur ce Cahier de Prépa. Vous devez aller sur la page &laquo;&nbsp;<a href="utilisateurs">Utilisateurs</a>&nbsp;&raquo; pour réaliser cela.';
    $resultat->free();
  }
  else  {
    // Vérification du planning : si colles partout, ce n'est pas normal...
    $resultat = $mysqli->query('SELECT COUNT(id) AS n FROM semaines WHERE colle = 0');
    $r = $resultat->fetch_assoc();
    if ( !$r['n'] )
      $message = 'Le planning annuel n\'a pas été modifié. Vous avez la possibilité de spécifier quelles semaines sont des semaines de colles ou non, quelles semaines sont les semaines de vacances. Vous pouvez faire cela sur la page <a href="planning">Planning</a>.';
    $resultat->free();
  }
}

//////////////
//// HTML ////
//////////////
// Haut de page, menu et message
$p = ".";
// Titre : on récupère celui de la première page
$resultat = $mysqli->query('SELECT titre FROM pages WHERE id = 1');
$r = $resultat->fetch_assoc();
$resultat->free();
$t = "${r['titre']} - Administration";
include('haut.php');

// Taille maximale de fichier
$taille = min(ini_get('upload_max_filesize'),ini_get('post_max_size'));
if ( stristr($taille,'m') )
  $taille = substr($taille,0,-1)*1048576;
elseif ( stristr($taille,'k') )
  $taille = substr($taille,0,-1)*1024;
$taille = ( $taille < 1048576 ) ? intval($taille/1024).'&nbsp;ko.' : intval($taille/1048576).'&nbsp;Mo';
?>

  <div>
    <p>Bienvenue sur l'interface d'administration de votre Cahier de Prépa.</p>
    <p>Cette page propose des possibilités de modifications rapide, mais vous pouvez gérer beaucoup plus de choses grâce aux liens du menu&nbsp;!</p>
  </div>

  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ci-dessous effectuer les tâches quotidiennes les plus fréquentes&nbsp;: ajouter un programme de colle dans les matières qui vous sont associées, déposer un document dans le répertoire général ou dans celui d'une de vos matières, ou enregistrer une nouvelle information. Tous ces formulaires sont des raccourcis vers les différentes section de cette interface d'administration.</p>
    <p>Les matières qui vous sont associées sont modifiables dans vos <a href="prefs">Préférences</a>.</p>
    <h4>Programmes de colles</h4>
    <p>Vous pouvez choisir la <em>semaine</em> du programme de colles parmi les semaines où le programme n'est pas déjà renseigné, et où il est prévu des colles. Vous pouvez modifier/supprimer les programmes de colles existants sur les pages <a href='colles'>Programme de colles</a> de chaque matière. Vous pouvez modifier les semaines avec ou sans colle sur la page du <a href="planning">Planning annuel</a>.</p>
    <p>Le texte doit être formaté en HTML&nbsp;: par exemple, chaque bloc de texte doit être encadré par &lt;p&gt; et &lt;/p&gt;. Il peut donc contenir des liens vers les autres pages du site, vers des documents du site, vers le web... N'hésitez pas à consulter l'aide qui apparaîtra en-dessous de la case de texte après avoir cliqué dessus, ainsi qu'à utiliser les boutons fournis.</p>
    <p>La case à cocher <em>Ne pas diffuser sur la partie publique</em> permet de cacher temporairement ce programme de colle, par exemple pour le diffuser ultérieurement.</p>
    <h4>Document</h4>
    <p>Le <em>nom à afficher</em> sera le nom réellement affiché sur le site web (sans extension&nbsp;: elle est détectée automatiquement lors de l'envoi). Si vous laissez cette case vide, le nom du fichier envoyé sera récupéré.</p>
    <p>Seul le répertoire général, les répertoires correspondant aux matières qui vous sont associées et tous leurs sous-répertoires peuvent accueillir vos documents.</p>
    <p>Vous pouvez choisir l'<em>accès</em> du document parmi cinq possibilités&nbsp;:</p>
    <ul>
      <li><em>Visible de tous</em>&nbsp;: document accessible de tout visiteur, sans identification.</li>
      <li><em>Visible pour les élèves, colleurs, professeurs</em>&nbsp;: document accessible uniquement par tout utilisateur après identification. Il faut donc avoir un compte validé (voir l'aide de la page <a href="utilisateurs">Utilisateurs</a>) pour y accéder.</li>
      <li><em>Visible pour les colleurs, professeurs</em>&nbsp;: document accessible uniquement par les utilisateurs de type colleur ou professeur. Attention, si l'accès au répertoire est différent, le titre du document peut être visible par les élèves ou un visiteur non identifié.</li>
      <li><em>Visible pour les professeurs</em>&nbsp;: document accessible uniquement par les utilisateurs de type professeur (vous et vos collègues).</li>
      <li><em>Non visible</em>&nbsp;: document n'est pas encore visible en ligne. Cela peut être utile si vous souhaitez le mettre à disposition ultérieurement. C'est complètement sûr&nbsp;: vous pouvez mettre comme cela le prochain sujet de devoir ou même le corrigé.</li>
    </ul>
    <p>Dans la page <a href="docs">Documents</a>, les répertoires et documents visibles après identification ont un cadenas dans leur icône. Les répertoires et documents non visibles sont marqués comme tels.</p>
    <p>La taille du fichier envoyé est limitée à <?php echo $taille; ?>. Tout document est modifiable et déplaçable après envoi, sans que cela ne modifie le lien vers le document.</p>
    <h4>Information</h4>
    <p>Vous pouvez choisir la <em>page</em> sur laquelle se trouvera l'information. Pour créer d'autres pages, vous pouvez aller sur la page <a href="pages">Gestion des pages</a>.</p>
    <p>Le <em>titre</em> sera affiché, un peu plus gros, au-dessus de l'information. Il peut rester vide (il n'y aura alors pas de titre affiché).</p>
    <p>Le texte doit être formaté en HTML&nbsp;: par exemple, chaque bloc de texte doit être encadré par &lt;p&gt; et &lt;/p&gt;. Il peut donc contenir des liens vers les autres pages du site, vers des documents du site, vers le web... N'hésitez pas à consulter l'aide qui apparaîtra en-dessous de la case de texte après avoir cliqué dessus, ainsi qu'à utiliser les boutons fournis.</p>
    <p>La case à cocher <em>Ne pas diffuser sur la partie publique</em> permet de cacher temporairement cette information, par exemple pour la diffuser ultérieurement.</p>
  </div>
<?php

///////////////////////////////////
// Nouveaux programmes de colles //
///////////////////////////////////

// Pour chaque matière
foreach ( $matieres as $m )  {
  // Récupération des semaines
  $resultat = $mysqli->query("SELECT s.id AS sid, DATE_FORMAT(s.debut,'%w%Y%m%e') AS d, s.colle, s.vacances, c.id AS cid, c.cache
                              FROM semaines AS s
                              LEFT JOIN (SELECT id, semaine, cache FROM colles WHERE matiere = ${m['id']}) AS c ON c.semaine=s.id");
  $select_semaines = '';
  if ( $resultat->num_rows )  {
    while ( $r = $resultat->fetch_assoc() )  {
      switch ( $r['vacances'] )  {
        case 0:
          if ( $r['colle'] )  {
            if ( is_null($r['cid']) )
              $select_semaines .= "\n        <option value=\"${r['sid']}\">".format_date($r['d']).'</option>';
            elseif ( $r['cache'] )
              $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>".format_date($r['d']).' (non diffusé)</option>';
            else
              $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>".format_date($r['d']).' (déjà rempli)</option>';
          }
          else
            $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>".format_date($r['d']).' (pas de colle)</option>';
          break;
        case 1:
          $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances de Toussaint</option>";
          break;
        case 2:
          $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances de Noël</option>";
          break;
        case 3:
          $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances d'hiver</option>";
          break;
        case 4:
          $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances de Pâques</option>";
      }
    }
    $resultat->free();
?>

  <div class="item admin">
  <form action="colles?<?php echo $m['cle']; ?>" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications">
    <h3>Enregistrer un programme de colles de <?php echo $m['nom']; ?></h3>
    <p class="ligne"><label for="id<?php echo $m['id']; ?>">Semaine&nbsp;: </label>
      <select id="id<?php echo $m['id']; ?>" name="id"><?php echo $select_semaines; ?>

      </select>
    </p>
    <textarea name="texte" class="mat<?php echo $m['id']; ?>" rows="10" cols="100"></textarea>
    <p class="ligne"><label for="cache<?php echo $m['id']; ?>">Ne pas diffuser sur la partie publique&nbsp;: </label><input type="checkbox" id="cache<?php echo $m['id']; ?>" name="cache" value="1"></p>
  </form>
  </div>
<?php
  }
}

///////////////////////
// Envoi de document //
///////////////////////
// Récupération des répertoires, dans le bon ordre pour un select
function liste($rid,$n)  {
  $resultat = $GLOBALS['mysqli']->query("SELECT id, nom FROM reps
                                         WHERE parent = $rid AND FIND_IN_SET(matiere,'0,${_SESSION['matieres']}')
                                         ORDER BY FIND_IN_SET(matiere,'0,${_SESSION['matieres']}')");
  while ( $r = $resultat->fetch_assoc() )  {
    $GLOBALS['select_reps'] .= "        <option value=\"${r['id']}\">".str_repeat('&rarr;',$n)."${r['nom']}</option>\n";
    liste($r['id'],$n+1);
  }
  $resultat->free();
}
$select_reps = '';
liste(0,0);
?>

  <div class="item admin">
  <form action="docs" method="post" enctype="multipart/form-data">
    <input class="bouton" type="submit" name="envoie" value="Envoyer">
    <h3>Déposer un document</h3>
    <p class="ligne"><label for="nom">Nom à afficher&nbsp;: </label><input type="text" id="nom" name="nom" value="" size="50"></p>
    <p class="ligne"><label for="fichier">Fichier&nbsp;: </label><input type="file" id="fichier" name="fichier"></p>
    <p class="ligne"><label for="rep">Répertoire&nbsp;: </label>
      <select id="rep" name="rep">
<?php echo $select_reps; ?>
      </select>
    </p>
    <p class="ligne"><label for="protection">Accès&nbsp;: </label>
      <select id="protection" name="protection">
        <option value="0">Visible de tous</option>
        <option value="1">Visible pour les élèves, colleurs, profs</option>
        <option value="2">Visible pour les colleurs et les profs</option>
        <option value="3">Visible pour les profs uniquement</option>
        <option value="4">Non visible</option>
      </select>
    </p>
    <input type="hidden" name="id" value="0">
  </form>
  </div>
<?php

//////////////////////////
// Nouvelle information //
//////////////////////////
$resultat = $mysqli->query("SELECT CONCAT_WS('/',m.cle,p.cle) AS cle, CONCAT_WS('/',m.nom,p.nom) AS nom
                            FROM pages AS p LEFT JOIN matieres AS m ON p.mat = m.id
                            WHERE FIND_IN_SET(p.mat,'0,${_SESSION['matieres']}')
                            ORDER BY FIND_IN_SET(p.mat,'0,${_SESSION['matieres']}'), p.ordre");
$select_pages = '';
while ( $r = $resultat->fetch_assoc() )
  $select_pages .= "        <option value=\"${r['cle']}\">${r['nom']}</option>\n";
$resultat->free();
?>

  <div class="item admin">
  <form action="pages" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications sur le titre ou le texte">
    <h3>Enregistrer une nouvelle information</h3>
    <p class="ligne"><label for="page">Page&nbsp;: </label>
      <select id="page" name="page">
<?php echo $select_pages; ?>
      </select>
    </p>
    <p class="transparent"><input class="ligne" type="text" name="titre" size=50 maxlength=65533 value="Titre"></p>
    <textarea name="texte" class="mat0" rows="6" cols="100"></textarea>
    <p class="ligne"><label for="cache">Ne pas diffuser sur la partie publique&nbsp;: </label><input type="checkbox" id="cache" name="cache" value="1"></p>
    <input type="hidden" name="id" value="0">
    <input type="hidden" name="action" value="info">
  </form>
  </div>

<?php
$mysqli->close();
// Bas de page
include('bas.php');
exit();
?>
