<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

header('Content-Type: application/javascript; charset=utf-8');

// Récupération des répertoires, avec le chemin complet
$resultat = $mysqli->query("SELECT id, nom, matiere,
                            CONCAT( ( SELECT GROUP_CONCAT(nom SEPARATOR '/') FROM reps AS r WHERE FIND_IN_SET(r.id,reps.parents) ) ,'/') AS parents
                            FROM reps WHERE nbdoc_v AND FIND_IN_SET(matiere,'0,${_SESSION['matieres']}')");
if ( $resultat->num_rows )  {
  $reps = array(0=>'');
  $docs = array();
  while ( $r = $resultat->fetch_assoc() )  {
    if ( !isset($reps[$r['matiere']]) )
      $reps[$r['matiere']] = '';
    $reps[$r['matiere']] .= "<option value=\"${r['id']}\">".addslashes($r['parents'].$r['nom']).'</option>';
    if ( $r['matiere'] )
      $reps[0] .= "<option value=\"${r['id']}\">".addslashes($r['parents'].$r['nom']).'</option>';
    // Récupération des documents
    $docs[$r['id']] = '';
    $res = $mysqli->query("SELECT id, nom FROM docs WHERE parent = ${r['id']} AND protection < 4");
    while ( $d = $res->fetch_assoc() )  {
      $docs[$r['id']] .= "<option value=\"${d['id']}\">".addslashes($d['nom']).'</option>';
    }
    $res->free();
  }
  $resultat->free();
  $boutons_reps = '
    <p class="boutons" id="boutons_reps">Insérer un document&nbsp;:\\
      <select id="reps"></select>\\
      <select id="doc"></select>\\
      <input type="button" id="js_doc" value="Insérer">\\
    </p>\\
';
}
else
  $boutons_reps = '';

$mysqli->close();
?>

$( function() {

  ///////////////////////
  // Pliage des boîtes //
  ///////////////////////

  // Pliage des items et aides de l'interface d'administration
  // .fic => fichiers dans docs.php ; .user => nouvel utilisateur dans utilisateurs.php
  $('.aide h3,.admin:not(.fic, .nojs) h3').append(' <span>déplier</span>');
  $('.aide h3 span,.admin:not(.fic, .user, .nojs) h3 span').click( function () {
    $(this).parent().parent().children(':not(h3,.nonvisible)').toggle();
    $(this).text($(this).text() == 'déplier' ? 'replier' : 'déplier');
  });
  // Premier pliage
  $('.aide,.admin:not(.fic, .nojs) form').children(':not(h3)').hide();
  // Recopie des boutons de modification d'ordre
  $( "[name='monte'],[name='descend']" ).each(function(){
    // Un bouton de validation doit se trouver en premier dans le formulaire pour
    // valider par appui sur la touche entrée. 
    // On place derrière le bouton de descente, puis le bouton de montée
    $(this).prev("[name='modifie']").clone().addClass('nonvisible').hide().prependTo($(this).parents('form'));
    $(this).clone().addClass('bouton').insertAfter($(this).parents('form').find('.nonvisible'));
  });

  ///////////////////////////
  // Contrôle des textarea //
  ///////////////////////////

  // Texte si vide
  $('textarea:not(.nojs):empty').addClass('texte_aide').html("\
&lt;p&gt;Ce texte doit être formaté en HTML. C'est un langage simple de balisage, où chaque paragraphe doit être entouré par deux balises &laquo;&nbsp;p&nbsp;&raquo;, comme ici. L'ensemble de ce texte disparaîtra automatiquement dès que vous y écrirez quelque chose.&lt;/p&gt;\n\n\
---------------------------------------------------------------------------------------------------\n\n\
Pour ajouter un lien au sein de votre texte, la syntaxe est\n\
            &lt;a href=\"l'adresse du lien\"&gt;le texte qui apparaît souligné&lt;/a&gt;\n\n\
Pour ajouter un lien seul sur une ligne, mettez-le dans un paragraphe&nbsp;: &lt;p&gt;&lt;a href=\"l'adresse du lien\"&gt;le texte qui apparaît souligné&lt;/a&gt;&lt;/p&gt; (c'est ce que fait par défaut le bouton &laquo;&nbsp;Insérer&nbsp;&raquo;).\n\n\
Différents formatages classiques sont disponibles dans les boutons qui s'affichent ci-dessous (cliquez ici si vous ne les voyez pas). N'hésitez pas à essayer, à regarder l'aide disponible et à utiliser le bouton &laquo;&nbsp;Prévisualiser le texte&nbsp;&raquo;.\n");

  $('.texte_aide').on('keydown paste',function() { $(this).val('').off('keydown paste').removeClass('texte_aide'); });

  // Boutons supplémentaires
  $('\
  <div id="js_controls">\
    <div id="aide_js">\
      <h4>Aide et explications <span></span> <input type="button" id="js_preview" value="Prévisualiser le texte"> <input type="button" id="js_suppr" value="Supprimer le texte"></h4>\
      <p>Le texte doit être écrit en HTML&nbsp;: toute mise en forme est indiquée par deux balises, de début comme &lt;h3&gt; pour un gros titre, de fin comme &lt;/h3&gt;. Les boutons ci-dessus aident à «&nbsp;encadrer&nbsp;» un texte sélectionné des balises correctes.</p>\
      <p>Comme en HTML, les retours à la ligne et les espaces multiples ne comptent pas. Un retour à la ligne dans un paragraphe (&lt;p&gt;Bla bla&lt;/p&gt;) ne crée pas un retour à la ligne visible au final. Pour ce faire, on peut utiliser la balise unique &lt;br&gt;, mais il vaut mieux mettre chaque paragraphe entre balises &lt;p&gt; et &lt;/p&gt;. Les espaces en début de ligne, de même, n\'apparaissent pas sur le site public et ne servent qu\'à la lisibilité ici.</p>\
      <p class="tex2jax_ignore">Il est possible d\'insérer du code en LaTeX, sur une ligne séparée (balises \\[...\\] ou balises $$...$$) ou au sein d\'une phrase (balises $...$). Il faut ensuite taper du code en LaTeX à l\'intérieur. La prévisualisation est impossible&nbsp;: il faut valider le texte et aller voir le site public pour vérifier ce que l\'on a tapé.</p>\
    </div>\<?php echo $boutons_reps; ?>
    <p class="boutons">\
      <input type="button" id="js_ligne" value="Paragraphe" title="Transformer la sélection en paragraphe">\
      <input type="button" id="js_note" value="Par. important" title="Transformer la sélection en paragraphe important, qui s\'affichera en rouge. Seul le texte entre les balises est affiché, soit &lt;div class=&rdquo;note&rdquo;&gt;TEXTE&lt;/div&gt;">\
      <input type="button" id="js_annonce" value="Par. très important" title="Transformer la sélection en paragraphe très important, qui s\'affichera en rouge et encadré. Seul le texte entre les balises est affiché, soit &lt;div class=&rdquo;annonce&rdquo;&gt;TEXTE&lt;/div&gt;">\
      <input type="button" id="js_lien" value="Lien" title="Créer un lien : le titre est entre les balises, l\'adresse entre les guillemets après « href », soit &lt;a href=&rdquo;ADRESSE&rdquo;>TITRE</a>">\
      <input type="button" id="js_gras" value="Gras" title="Mettre la sélection en gras">\
      <input type="button" id="js_it" value="Italique" title="Mettre la sélection en italique">\
      <input type="button" id="js_exp" value="Exposant" title="Mettre la sélection en exposant">\
      <input type="button" id="js_ind" value="Indice" title="Mettre la sélection en indice">\
    </p>\
    <p class="boutons">\
      <input type="button" id="js_h3" value="Titre de type chapitre (h3)" title="Insérer un titre « grand »">\
      <input type="button" id="js_h4" value="Titre de type «&nbsp;I.&nbsp;» (h4)" title="Insérer un titre « premier niveau »">\
      <input type="button" id="js_h5" value="Titre de type «&nbsp;1.&nbsp;» (h5)" title="Insérer un titre « deuxième niveau »">\
      <input type="button" id="js_h6" value="Titre de type «&nbsp;a.&nbsp;» (h6)" title="Insérer un titre « troisième niveau »">\
    </p>\
    <p class="boutons">\
      <input type="button" id="js_colle" value="Titre de prog. de colles (h4)" title="Insérer le titre d\'une sous-partie d\'un programme de colles.">\
      <input type="button" id="js_ul" value="Liste à puces" title="Insérer une liste à puces (chaque &lt;li&gt; est une puce)">\
      <input type="button" id="js_latex" value="Phrase en LaTeX" title="Insérer une ligne d\'équation en LaTeX - voir l\'aide pour les détails">\
    </p>\
    <p class="boutons">\
      <input type="button" id="js_s1" value="(HTML) Insérer le caractère">&nbsp;<select id="select1"></select>\
      <input type="button" id="js_s2" value="(HTML) Insérer la lettre">&nbsp;<select id="select2"></select></p>\
  </div>').appendTo('body').toggle();

  // Symboles
  var symboles = [ '&forall;', '&exist;', '&part;', '&nabla;', '&prod;', '&sum;', '&plusmn;', '&radic;', '&infin;', '&int;', '&prop;', '&sim;', '&cong;', '&asymp;', '&ne;', '&equiv;', '&le;', '&ge;', '&sub;', '&sup;', '&nsub;', '&sube;', '&supe;', '&isin;', '&notin;', '&ni;', '&oplus;', '&otimes;', '&sdot;', '&and;', '&or;', '&cap;', '&cup;', '&real;', '&image;', '&empty;', '&deg;', '&prime;', '&micro;', '&larr;', '&uarr;', '&rarr;', '&darr;', '&harr;', '&lArr;', '&uArr;', '&rArr;', '&dArr;', '&hArr;' ];
  for (var i=0, n=symboles.length, s=''; i<n; i++) {
     s = symboles[i];
     $('#select1').append('<option value="'+s+'">'+s+'</option>');
  }
  symboles = [ '&alpha;', '&beta;', '&gamma;', '&Delta;', '&delta;', '&epsilon;', '&eta;', '&Theta;', '&theta;', '&Lambda;', '&lambda;', '&mu;', '&nu;', '&xi;', '&Pi;', '&pi;', '&rho;', '&Sigma;', '&sigma;', '&tau;', '&upsilon;', '&Phi;', '&phi;', '&Psi;', '&psi;', '&Omega;', '&omega;' ];
  for (i=0, n=symboles.length; i<n; i++) {
     s = symboles[i];
     $('#select2').append('<option value="'+s+'">'+s+'</option>');
  }

  // Aide
  $('#aide_js h4 span').css('cursor','pointer').click( function () {
    $(this).parent().parent().find('p').toggle();
    $(this).text($(this).text() == '[déplier]' ? '[replier]' : '[déplier]');
  });
  $('#aide_js').find('p').hide();

  // Le focus sur un textarea fait apparaître les boutons au bon endroit
  $('textarea:not(.nojs)').focus( function() {
    // Modification des répertoires en fonction de la matière correspondante
<?php
  if ( !empty($docs) )  {
    $matieres = explode(',',"0,${_SESSION['matieres']}");
    foreach ( $matieres as $m )  {
      if ( isset($reps[$m]) )
        echo <<<FIN
    if ( $(this).hasClass('mat$m') )  {
      $('#reps').html('${reps[$m]}').change();
      $('#boutons_reps').show();
    }

FIN;
      else
        echo <<<FIN
    if ( $(this).hasClass('mat$m') )
      $('#boutons_reps').hide();

FIN;
    }
  }
?>
    $('#active').prop('id','');
    $(this).prop('id','active');
    $('#js_controls').detach().appendTo($(this).parent()).show();
    $('#aide_js').find('p').hide();
    $('#aide_js h4 span').text('[déplier]');
  });

<?php
  if ( !empty($docs) )  {
    echo '
  // Modification des documents en fonction du répertoire choisi
  $(\'#reps\').change( function() {
    switch ( $(this).val() )  {';
    foreach ( $docs as $rep => $select )
      echo "\n      case '$rep': $('#doc').html('$select'); break;";
    echo '
    }
  });';
  }
?>

  // Suppression
  $('#js_suppr').click(function() { $('#active').val('').off('keydown paste').removeClass('texte_aide'); });
  
  // Prévisualisation
  $('<div id="preview_fond"></div>').appendTo('body');
  $('<div class="item admin" id="preview"><h2>Prévisualisation</h2><div></div><p>Cliquer n\'importe où pour revenir à l\'édition</p></div>').appendTo('body');
  $('#preview_fond,#preview').hide().click(function() { $('#preview_fond,#preview').hide(); });
  $('#js_preview').click(function() {
    $('#preview>div').html($('#active').val());
    $('#preview_fond,#preview').show();
    MathJax.Hub.Queue(["Typeset",MathJax.Hub,"preview"]);
    
  });
  
  // Fonction d'insertion dans la textarea
  function insert(debut,fin) {
    if ( $('#active').hasClass('texte_aide') )
      $('#active').val('').off('keydown paste').removeClass('texte_aide');
    var ta = $('#active')[0];
    if (document.selection) {
      ta.focus();
      sel = document.selection.createRange();
      sel.text = debut+sel.text+fin;
      ta.focus();
    }
    else if (ta.selectionStart || ta.selectionStart == '0') {
      var d = ta.selectionStart;
      var f = ta.selectionEnd;
      var scrollTop = ta.scrollTop;
      ta.value = ta.value.substring(0,d)+debut+ta.value.substring(d,f)+fin+ta.value.substring(f,ta.value.length);
      ta.focus();
      ta.selectionStart = d + debut.length;
      ta.selectionEnd = f + debut.length;
      ta.scrollTop = scrollTop;
    } else {
      ta.value += debut+fin;
      ta.focus();
    }
  }
  
  // Actions d'insertion de balises
  $('#js_doc').click(function() { insert('\u000A<p><a href="download?id='+$('#doc').val()+'">'+$('#doc option:selected').text()+'</a></p>',''); });
  $('#js_ligne').click(function() { insert('<p>','</p>'); });
  $('#js_lien').click(function() { insert('<a href="">','</a>'); });
  $('#js_note').click(function() { insert('\u000A<div class="note">','</div>'); });
  $('#js_annonce').click(function() { insert('\u000A<div class="annonce">','</div>'); });
  $('#js_gras').click(function() { insert('<strong>','</strong>'); });
  $('#js_it').click(function() { insert('<em>','</em>'); });
  $('#js_exp').click(function() { insert('<sup>','</sup>'); });
  $('#js_ind').click(function() { insert('<sub>','</sub>'); });
  $('#js_h3').click(function() { insert('\u000A<h3>Chapitre ','</h3>'); });
  $('#js_h4').click(function() { insert('\u000A<h4>I. ','</h4>'); });
  $('#js_h5').click(function() { insert('\u000A<h5>1. ','</h5>'); });
  $('#js_h6').click(function() { insert('\u000A<h6>a. ','</h6>'); });
  $('#js_colle').click(function() { insert('\u000A<h4>','</h4>'); });
  $('#js_ul').click(function() { insert('\u000A<ul>\u000A  <li>','</li>\u000A  <li></li>\u000A</ul>'); });
  $('#js_latex').click(function() { insert('\u000A\\[','\\]'); });
  $('#js_s1').click(function() { insert($('#select1').val(),''); });
  $('#js_s2').click(function() { insert($('#select2').val(),''); });

  ////////////////////////////////////////////
  // Gestion du timeout et des reconnexions //
  ////////////////////////////////////////////
<?php
$t = $_SESSION['timeout'];
if ( $t <= 120 )  {
  $t2 = 30;
  $temps = '30 secondes';
}
else  {
  $t2 = ( $t < 600 ) ? 120 : 300;
  $temps = ($t2/60).' minutes';
}
$t1 = $t-$t2;
?>

  // Messages d'annonce de la future déconnexion
  var html1 = 'Vous allez être déconnecté dans moins de <?php echo $temps; ?>. Toute modification non validée dans  <?php echo $temps; ?> sera perdue...<br><a href="#" id="connect">Cliquez ici</a> pour rester connecté.';
  var html2 = 'Vous avez été déconnecté automatiquement. Si vous validez cette page, vos modifications seront perdues. Il suffit avant cela de taper à nouveau votre nom et votre mot de passe&nbsp;;\
<form id="formlogin">\
  <p class="ligne"><label for="login">Nom d\'utilisateur&nbsp;: </label><input type="text" name="login" id="logintmp"></p>\
  <p class="ligne"><label for="motdepasse">Mot de passe&nbsp;: </label><input type="password" name="motdepasse" id="motdepassetmp"></p>\
  <p><input type="submit" value="Envoyer"></p>\
</form>';

  // Affichage des messages
  function afficher_timeout() {
    $('#message').hide(200);
    // Suppression de l'éventuelle attente
    try{ window.clearTimeout(timeout); } catch(e){}
    timeout = window.setTimeout( function() {
      $('#message').html(html1).show(200);
      $("#connect").click( function() { connect(); return false; });
      timeout = window.setTimeout( function() {
        $('#message').html(html2);
        $('#formlogin').submit( function() { connect(); return false; });
      } ,  <?php echo $t2; ?>000);
    } ,  <?php echo $t1; ?>000);
  }

  // Vérification de la connexion et reconnexion
  function connect() {
    var login = '';
    var motdepasse = '';
    if ( $('#formlogin').length > 0 )  {
      login = $('#logintmp').val();
      motdepasse = $('#motdepassetmp').val();
    }
    $.post('connect',
          { login : login , motdepasse : motdepasse },
          function(data) {
            if ( data.etat == 1 )  { afficher_timeout(); }
            else  {
              $('#message').html(html2);
              $('#formlogin').submit( function() { connect(); return false; });
            }
          },
          "json");
  }

  // Initialisation
  var timeout;
  $( function() {
    $('<div id="message" class="warning"></div>').prependTo('body').css('display', 'none');
    afficher_timeout();
  });

});
