<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

// Récupération des préférences d'envoi (mailexp, mailsign, mailcopy) de l'utilisateur
$resultat = $mysqli->query("SELECT nom, prenom, genre, mail, mailexp, IF(mailcopy,' checked','') AS mailcopybox, mailcopy
                            FROM utilisateurs WHERE id = ${_SESSION['id']}");
$u = $resultat->fetch_assoc();
$resultat->free();

// Impossible d'aller plus loin si le mail n'est pas renseigné
if ( !strlen($u['mail']) )  {
$p = "mail";
$t = 'Envoi de mail';
include('haut.php');
?>
  <div class="warning">Il est impossible d'envoyer des mails sans avoir renseigné une adresse mail qui sera écrite en tant qu'expéditeur. Il faut aller voir vos <a href="prefs">Préférences</a> pour mettre à jour votre identité.</div>

<?php
include('bas.php');
exit();
}

// Champ expéditeur
switch ( $u['genre'] )  {
  case 1 : $g = 'M. '; break;
  case 2 : $g = 'Mme '; break;
  case 3 : $g = 'Melle '; break;
  default : $g = '';
}
switch ( $u['mailexp'] )  {
  case 1 : $exp = "$g${u['nom']}"; break;
  case 2 : $exp = "$g${u['prenom']} ${u['nom']}"; break;
  case 3 : $exp = "${u['prenom']} ${u['nom']}"; break;
  case 4 : $exp = "${u['nom']}"; break;
}

///////////////////
// Envoi du mail //
///////////////////
if ( isset($_REQUEST['valide']) && isset($_REQUEST['dest']) )  {
  // Récupération des destinataires
  $resultat = $mysqli->query("SELECT id, mail, CASE autorisation WHEN autorisation = 1 THEN CONCAT( prenom, ' ', nom )
                                               ELSE CONCAT( CASE MOD(genre,5) WHEN 1 THEN 'M. ' WHEN 2 THEN 'Mme ' WHEN 3 THEN 'Melle ' END, nom ) END AS nom_complet
                              FROM utilisateurs WHERE login NOT RLIKE '^tmp[0-9]{5}' AND LENGTH(mail) > 0 AND id != ${_SESSION['id']} ORDER BY autorisation DESC, nom");
  while ( $r = $resultat->fetch_assoc() )
    $utilisateurs[$r['id']] = $r;
  $dests = '';
  foreach ( $_REQUEST['dest'] as $i )
    if ( isset($utilisateurs[$i]) )  {
      $dests .= $utilisateurs[$i]['nom_complet'].' <'.$utilisateurs[$i]['mail'].'>, ';
      unset($utilisateurs[$i]);
    }
  if ( strlen($dests) )  {
    $dests = substr($dests,0,-2);
    $bcc = ( $u['mailcopy'] ) ? "Bcc: $exp <${u['mail']}>, " : 'Bcc: ';
  }
  else  {
    $dests = "$exp <${u['mail']}>";
    $bcc = 'Bcc: ';
  }
  if ( isset($_REQUEST['dest_bcc']) )
    foreach ( $_REQUEST['dest_bcc'] as $i )
      if ( isset($utilisateurs[$i]) )  {
        $bcc .= $utilisateurs[$i]['nom_complet'].' <'.$utilisateurs[$i]['mail'].'>, ';
        unset($utilisateurs[$i]);
      }
  $bcc = ( strlen($bcc) == 4 ) ? '' : substr($bcc,0,-2);
  mail($dests,$_REQUEST['sujet'],$_REQUEST['texte'],"From: $exp <${u['mail']}>\r\nContent-type: text/plain; charset=UTF-8\r\n$bcc");
  $message = 'Le mail a bien été envoyé.';
}


//////////
// HTML //
//////////
// Haut de page, menu et message
$p = "mail";
$t = 'Envoi de mail';
include('haut.php');

// Aide générale et formulaires
?>

  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ci-dessous envoyer un mail aux utilisateurs ayant renseigné leur adresse mail.</p>
    <p>Les cases à cocher <em>Copie</em> permettre d'ajouter les utilisateurs cochés dans la liste des destinataires. Il est obligatoire qu'au moins un utilisateur soit en copie.</p>
    <p>Les cases à cocher <em>Copie cachée</em> permettre d'ajouter les utilisateurs cochés dans la liste des destinataires en copie cachée&nbsp;: les autres destinataires ne verront pas que ce mail a aussi été envoyé à ceux en copie cachée.</p>
    <p>Les case à cocher sont grisées si l'utilisateur n'a pas renseigné son adresse mail.</p>
    <p>Le <em>sujet</em> est le sujet du mail.</p>
    <p>Le <em>contenu</em> est le corps du mail, en texte brut. Le mail envoyé ne sera pas formaté en HTML&nbsp;: il n'est pas possible de réaliser un formattage particulier (changer une taille d'écriture, une police, mettre de la couleur...). Par convrntion classique,</p>
    <ul>
      <li>écrire un mot entre astérisques (*) signifie le mettre en gras et appuyer sur ce mot.</li>
      <li>écrire un mot entre slashes (/) signifie le mettre en italique pour indiquer qu'il faut y faire attention.</li>
      <li>écrire en majuscules signifie que l'on en train d'hurler. :-)</li>
    </ul>
    <p>Vous pouvez aussi modifier légèrement ce qui apparaîtra comme expéditeur de tous vos mails (actuellement <code><?php echo "$exp &lt;${u['mail']}&gt;"; ?></code>). C'est une des préférences techniques de vos <a href="prefs">Préférences</a>.</p>
    <p>Vous pouvez être de façon automatique en copie de tous vos mails. C'est une des préférences techniques de vos <a href="prefs">Préférences</a>.</p>
  </div>

<?php
// Récupération des utilisateurs
$resultat = $mysqli->query("SELECT id, login, IF(LENGTH(mail),'',' disabled') AS mail, autorisation,
                            CONCAT( CASE MOD(genre,5) WHEN 1 THEN 'M. ' WHEN 2 THEN 'Mme ' WHEN 3 THEN 'Melle ' END, prenom, ' ', nom ) AS nom_complet
                            FROM utilisateurs WHERE login NOT RLIKE '^tmp[0-9]{5}' AND id != ${_SESSION['id']} ORDER BY autorisation DESC, nom");
?>
  <div class="item admin nojs">
  <form action="" method="post">
    <input class="bouton" type="submit" name="valide" value="Envoyer le mail">
    <h3>Destinataires</h3>
    <table class="admin" id="dests">
      <tbody>
        <tr><td></td><td class="checks">Copie</td><td class="checks">Copie cachée</td></tr>
<?php
$a = 0;
while ( $r = $resultat->fetch_assoc() )  {
  if ( $a != $r['autorisation'] )  {
    $a = $r['autorisation'];
    switch ( $a )  {
      case 1 : $t = 'Élèves'; break;
      case 2 : $t = 'Colleurs'; break;
      case 3 : $t = 'Professeurs'; break;
    }
    echo <<<FIN
        <tr><th>$t</th><td></td><td></td></tr>

FIN;
    }
  $nom = ( strlen($r['nom_complet']) ) ? $r['nom_complet'] : "<em>${r['login']}</em>";
  echo "        <tr><td>$nom</td><td><input type=\"checkbox\" class=\"dest_c$a\" name=\"dest[]\" value=\"${r['id']}\"${r['mail']}></td><td><input type=\"checkbox\" class=\"dest_bcc$a\" name=\"dest_bcc[]\" value=\"${r['id']}\"${r['mail']}></td></tr>\n";
}
$resultat->free();
$mysqli->close();
?>
      </tbody>
    </table>

  <script type="text/javascript">
$( function() {
  // Pliage du tableau des destinataires
  $('#dests').hide().prev('h3').append(' <span id="deplie">déplier</span>');
  $('#deplie').click( function () {
    $('#dests').toggle();
    $(this).text($(this).text() == 'déplier' ? 'replier' : 'déplier');
  });

  // Bouton de sélection multiple
  $('#dests th').next().append('<input type="button" class="button_c" value="Tout cocher">');
  $('#dests th').next().next().append('<input type="button" class="button_bcc" value="Tout cocher">');
  $('.button_c,.button_bcc').click( function () {
    var a = $(this).closest('tr').next().find('input[name=dest\\[\\]]').attr('class').substr(6);
    var t1 = $(this).attr('class').substr(7);
    var t2 = ( t1 == 'c' ? 'bcc' : 'c' );
    if ( $(this).val() == 'Tout cocher' )  {
      $(this).val('Tout décocher');
      $('.dest_'+t1+a).prop("checked",true);
      $('.dest_'+t2+a).prop("checked",false);
      $(this).closest('tr').find('.button_'+t2).val('Tout cocher');
    }
    else  {
      $(this).val('Tout cocher');
      $('.dest_'+t1+a).prop("checked",false);
    }
  });
  $('input[name*=dest]').click( function () {
    if ( $(this).is(':checked') )
      $(this).closest('tr').find( $(this).attr('class').length > 8 ? '.dest_c'+$(this).attr('class').substr(8) : '.dest_bcc'+$(this).attr('class').substr(6) ).prop("checked",false);
  });
});
  </script>

    <h3>Sujet</h3>
    <textarea class="nojs" name="sujet" rows="1" cols="100"></textarea>
    <input class="bouton" type="submit" name="valide" value="Envoyer le mail">
    <h3>Contenu</h3>
    <textarea class="nojs" name="texte" rows="30" cols="100"><?php echo "Bonjour à tous\n\n\n\n\n-- \n$exp"; ?></textarea>

<?php
// Pour info, l'expéditeur
$u['mailcopy'] = ( $u['mailcopy'] ) ? 'Vous recevrez' : 'Vous ne recevrez pas';
echo "
  <p>L'expéditeur du mail apparaîtra comme &laquo;&nbsp;<code>$exp &lt;${u['mail']}&gt;</code>&nbsp;&raquo;. Ceci est modifiable dans vos <a href=\"prefs\">Préférences</a>.</p>
  <p>${u['mailcopy']} une copie de ce mail dans votre boîte mail. Ceci est modifiable dans vos <a href=\"prefs\">Préférences</a>.</p>
  </form>
  </div>\n";


// Bas de page
include('bas.php');
?>
