<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

///////////////////
// Modifications //
///////////////////

// Ajout ou modification d'une matière
if ( isset($_REQUEST['id']) && in_array($id = $_REQUEST['id'],explode(',',"0,${_SESSION['matieres']}")) && isset($_REQUEST['modifie']) )  {

  // Récupération des données de la matière à modifier
  if ( $id )  {
    $resultat = $mysqli->query("SELECT cle, nom, colles_protection, cdt_protection FROM matieres WHERE id = $id");
    $r = $resultat->fetch_assoc();
  }
  // Si $id = 0, nouvelle matière
  else
    $r = array('cle' => '', 'nom' => '', 'colles_protection' => 5, 'cdt_protection' => 5);

  $requete = array();
  $modif = array();
  // Connexion à la base de données avec les droits d'écriture
  $mysqli->close();
  $mysqli = mysql_ecriture();

  // Validation des données envoyées
  $cle = $mysqli->real_escape_string($_REQUEST['cle']);
  $nom = $mysqli->real_escape_string($_REQUEST['nom']);
  if ( strlen($nom) && ( $nom != $r['nom'] ) )  {
    $requete[] = "nom = '$nom'";
    $modif[] = 'nom';
    if ( $id )
      requete('reps',"UPDATE reps SET nom = '$nom' WHERE matiere = $id AND parent = 0");
  }
  if ( strlen($cle) && ( $cle != $r['cle'] ) )  {
    // Vérification que la clé souhaitée n'existe pas déjà
    $resultat = $mysqli->query("SELECT id FROM matieres WHERE cle = '$cle'");
    if ( $resultat->num_rows )
      $resultat->free();
    else  {
      $requete[] = "cle = '$cle'";
      $modif[] = 'clé';
    }
  }
  if ( in_array($colles_protection = $_REQUEST['colles_protection'],array(0,1,2,3)) && ( $colles_protection != $r['colles_protection'] ) )  {
    $requete[] = "colles_protection = $colles_protection";
    $modif[] = 'accès aux programmes de colles';
  }
  if ( in_array($cdt_protection = $_REQUEST['cdt_protection'],array(0,1,2,3)) && ( $cdt_protection != $r['cdt_protection'] ) )  {
    $requete[] = "cdt_protection = $cdt_protection";
    $modif[] = 'accès au cahier de texte';
  }

  if ( empty($requete) )
    $message = 'Aucune modification à effectuer.';

  // Modification d'une matière existante
  elseif ( $id )  {
    $requete = implode(', ',$requete);
    $modif = implode(', ',$modif);
    if ( requete('matieres',"UPDATE matieres SET $requete WHERE id = $id") )
      $message = "Les modifications ($modif) sur la matière &laquo;&nbsp;${r['nom']}&nbsp;&raquo; ont bien été réalisées.";
    // Modification de $matieres, définie par debut.php et utilisée notamment pour le menu (haut.php)
    $resultat = $mysqli->query("SELECT id, cle, nom FROM matieres
                                WHERE FIND_IN_SET(id,'${_SESSION['matieres']}') ORDER BY FIND_IN_SET(id,'${_SESSION['matieres']}')");
    $matieres = array();
    while ( $r = $resultat->fetch_assoc() )
      $matieres[] = $r;
    $resultat->free();
  }
  
  // Création d'une nouvelle matière
  elseif ( count($modif) == 4 )  {
    $requete = implode(', ',$requete);
    if ( requete('matieres',"INSERT INTO matieres SET $requete, ordre = (SELECT MAX(m.ordre)+1 FROM matieres AS m)") )  {
      $id = $mysqli->insert_id;
      requete('reps',"INSERT INTO reps SET parent = 0, parents = '0', nom = '$nom', matiere = $id,
                      nbrep = 0, nbrep_v = 0, nbdoc = 0, nbdoc_v = 0, protection = 0, menu = 0");
      requete('cdt-types',"INSERT INTO `cdt-types` (matiere, ordre, cle, titre, deb_fin_pour) VALUES
                           ($id, 1, 'cours', 'Cours', 1),
                           ($id, 2, 'TD', 'Séance de travaux dirigés', 1),
                           ($id, 3, 'TP', 'Séance de travaux pratiques', 1),
                           ($id, 4, 'DS', 'Devoir surveillé', 1),
                           ($id, 5, 'interros', 'Interrogation de cours', 0),
                           ($id, 6, 'distributions', 'Distribution de document', 0),
                           ($id, 7, 'DM', 'Devoir maison', 2)");
      $message = 'La matière <em>'.stripslashes($nom).'</em> a bien été ajoutée.';
    }
  }
  else
    $message = 'La matière souhaitée n\'a pas pu être créée, car les données envoyées sont incorrectes. La clé ne peut pas être déjà utilisée par une autre matière, le nom et la clé doivent être non vides.';
  
  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}

// Montée, descente, suppression : possible sur toutes les matières
elseif ( isset($id) && is_numeric($id) )  {
  
  // Récupération des données de la matière à modifier
  $resultat = $mysqli->query("SELECT nom, ordre, (SELECT MAX(m.ordre) FROM matieres AS m) AS max,
                              colles+cdt+docs+notes AS nonvide FROM matieres WHERE id = $id");
  if ( $resultat->num_rows )  {
    $r = $resultat->fetch_assoc();
    $ordre = $r['ordre'];

    // Connexion à la base de données avec les droits d'écriture
    $mysqli->close();
    $mysqli = mysql_ecriture();

    // Déplacement vers le haut
    if ( isset($_REQUEST['monte']) && ( $ordre > 1 ) )
      $message = ( requete('matieres',"UPDATE matieres SET ordre = (2*$ordre-1-ordre) WHERE ordre = $ordre OR ordre = ($ordre-1)")
      ) ? "La matière <em>${r['nom']}</em> a bien été montée d'une place." : "La matière <em>${r['nom']}</em> n'a pas pu être déplacée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

    // Déplacement vers le bas
    elseif ( isset($_REQUEST['descend']) && ( $ordre < $r['max'] ) )
      $message = ( requete('matieres',"UPDATE matieres SET ordre = (2*$ordre+1-ordre) WHERE ordre = $ordre OR ordre = ($ordre+1)")
      ) ? "La matière <em>${r['nom']}</em> a bien été descendue d'une place." : "La matière <em>${r['nom']}</em> n'a pas pu être déplacée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

    // Suppression
    elseif ( isset($_REQUEST['supprime']) && ( $r['max'] > 1 ) && !$r['nonvide'] )  {
      if ( requete('matieres',"DELETE FROM matieres WHERE id = $id") )  {
        requete('matieres',"UPDATE matieres SET ordre = (ordre-1) WHERE ordre > $ordre");
        requete('cdt-types',"DELETE FROM `cdt-types` WHERE matiere = $id");
        requete('cdt-seances',"DELETE FROM `cdt-seances` WHERE matiere = $id");
        requete('reps',"DELETE FROM reps WHERE matiere = $id");
        requete('pages',"UPDATE pages SET mat = 0 WHERE mat = $id");
        $message = "La matière <em>${r['nom']}</em> a bien été supprimée.";
        requete('utilisateurs',"UPDATE utilisateurs SET matieres = TRIM(BOTH ',' FROM REPLACE(CONCAT(',',matieres,','),',$id,',',')) ");
        if ( $mysqli->affected_rows )  {
          $message .= '<br> Elle a été détachée de '.$mysqli->affected_rows.' utilisateur(s).';
          // Modification de $matieres, définie par debut.php et utilisée notamment pour le menu (haut.php)
          $m = explode(',',$_SESSION['matieres']);
          if ( in_array($id,$m) )  {
            unset($matieres[array_search($id,$m)]);
            unset($m[array_search($id,$m)]);
            $_SESSION['matieres'] = implode(',',$m);
          }
        }
      }
      else
        $message = "La matière <em>${r['nom']}</em> n'a pas pu être supprimée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
    }

    // Passage en connexion MySQL en lecture seulement
    $mysqli->close();
    $mysqli = mysql_lecture();
  }
}

//////////
// HTML //
//////////
// Haut de page, menu et message
$p = "matieres";
$t = 'Modifications des matieres';
include('haut.php');
?>

  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ci-dessous ajouter une matière ou modifier les matières existantes.</p>
    <p>L'ordre d'apparition des matières dans le menu de la partie publique est modifiable grâce aux flèches. Si vous avez plusieurs matières associée à votre compte dans cette interface d'administration, leur ordre n'est pas modifiable ici&nbsp;: il faut aller voir vos <a href="prefs">Préférences</a>.</p>
    <h4>Préférences de chaque matière</h4>
    <p>Pour chaque matière associée à votre compte, vous pouvez modifier&nbsp;:</p>
    <ul>
      <li>le <em>nom complet</em> qui s'affiche dans le menu et dans les titres des pages. Mettez une majuscule au début.</li>
      <li>la <em>clé dans l'adresse</em> qui est un mot-clé utilisé uniquement dans l'adresse des pages associées à la matière. Il vaut mieux que ce soit un mot unique, court et sans majuscule. Par exemple, «&nbsp;maths&nbsp;», «&nbsp;phys&nbsp;»...</li>
    </ul>
    <p>L'<em>accès au programmes de colles</em> et l'<em>accès au cahier de texte</em> peuvent être choisis parmi quatre possibilités&nbsp;:</p>
    <ul>
      <li><em>Visible de tous</em>&nbsp;: accessible de tout visiteur, sans identification.</li>
      <li><em>Visible pour les élèves, colleurs, professeurs</em>&nbsp;: accessible uniquement par tout utilisateur après identification. Il faut donc avoir un compte validé (voir l'aide de la page <a href="utilisateurs">Utilisateurs</a>) pour y accéder.</li>
      <li><em>Visible pour les colleurs, professeurs</em>&nbsp;: accessible uniquement par les utilisateurs de type colleur ou professeur.</li>
      <li><em>Visible pour les professeurs</em>&nbsp;: accessible uniquement par les utilisateurs de type professeur (vous et vos collègues).</li>
    </ul>
    <p>Quel que soit ce choix, les liens dans le menu de la partie publique apparaîtront pour tout visiteur (si le cahier de texte/programme de colles est non vide uniquement), tout comme le lien vers les documents.</p>
    <h4>Suppression d'une matière</h4>
    <p>La suppression d'une matière est une modification importante et lourde de conséquence. Aussi, il n'est possible ici que de supprimer les matières&nbsp;:
    <ul>
      <li>qui vous sont associées</li>
      <li>dont le cahier de texte, les programmes de colles, les documents et les notes sont complètement vides. Tous ces contenus peuvent être rapidement supprimés dans vos <a href="prefs">Préférences</a> (il faut aller dans les préférences de la matière).</li>
    </ul>
    <p>La matière à supprimer peut l'être même si elle est encore associée à un autre collègue. Elle en sera automatiquement détachée.</p>
  </div>

<?php
// Formulaire pour chaque matière
$select_protection = '
        <option value="0">Visible de tous</option>
        <option value="1">Visible pour les élèves, colleurs, profs</option>
        <option value="2">Visible pour les colleurs et les profs</option>
        <option value="3">Visible pour les profs uniquement</option>';
function affichage($r)  {
  $select_colles = str_replace("\"${r['colles_protection']}\"","\"${r['colles_protection']}\" selected",$GLOBALS['select_protection']);
  $select_cdt = str_replace("\"${r['cdt_protection']}\"","\"${r['cdt_protection']}\" selected",$GLOBALS['select_protection']);
  if ( $id = $r['id'] )  {
    $titre = "Matière n°${r['ordre']}&nbsp;: ${r['nom']}";
    $valide1 = '';
    $valide = "\n      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\"${r['disabled']}>";
    $monte = ( $r['ordre'] > 1 ) ? "\n      <input type=\"submit\" name=\"monte\" value=\"&uarr;\" title=\"Remonter la matière dans l'ordre d'apparition\">" : '';
    $descend = ( $r['ordre'] < $GLOBALS['max'] ) ? "\n      <input type=\"submit\" name=\"descend\" value=\"&darr;\" title=\"Descendre la matière dans l'ordre d'apparition\">" : '';
    if ( $r['ok'] )  {
      $indication = ( $r['nonvide'] ) ? "\n    <p>Cette matière ne peut pas être supprimée car elle contient des données. Vous pouvez les supprimer en allant dans vos <a href=\"prefs\">préférences</a>.</p>" : '';
    }
    else  {
      $indication = "\n    <p>Cette matière ne peut pas être modifiée tant qu'elle ne vous est pas associée. Ceci est modifiable dans vos <a href=\"prefs\">préférences</a>. Elle sera supprimable si tous les contenus sont supprimés avant.</p>";
    }
    $suppr = ( ( $GLOBALS['max'] > 1 ) ) ? "\n      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer la matière\"".( ( $r['nonvide'] ) ? ' disabled' : '' ).'>' : '';
  }
  else  {
    $titre = 'Nouvelle matière';
    $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $valide = $monte = $descend = $suppr = $indication = '';
  }
  echo <<<FIN
  <div class="item admin">
  <form action="" method="post">$valide1
    <h3>$titre</h3>
    <p class="boutons">$valide$monte$descend$suppr
    </p>
    <p class="ligne"><label for="nom$id">Nom complet&nbsp;: </label><input type="text" id="nom$id" name="nom" value="${r['nom']}" size="50"${r['disabled']}></p>
    <p class="ligne"><label for="cle$id">Clé dans l'adresse&nbsp;: </label><input type="text" id="cle$id" name="cle" value="${r['cle']}" size="30"${r['disabled']}></p>
    <p class="ligne"><label for="colles_protection$id">Accès aux programmes de colles&nbsp;: </label>
      <select id="colles_protection$id" name="colles_protection"${r['disabled']}>$select_colles
      </select>
    </p>
    <p class="ligne"><label for="cdt_protection$id">Accès au cahier de texte&nbsp;: </label>
      <select id="cdt_protection$id" name="cdt_protection"${r['disabled']}>$select_cdt
      </select>
    </p>
    <input type="hidden" name="id" value="$id">$indication
  </form>
  </div>


FIN;
}

// Formulaire vide pour une nouvelle matière et aide générale
affichage(array('id' => 0, 'cle' => 'cle_de_la_matiere', 'nom' => 'Nom de la matière', 'colles_protection' => 0, 'cdt_protection' => 0, 'disabled' => ''));

$resultat = $mysqli->query("SELECT id, ordre, cle, nom, colles+cdt+docs+notes AS nonvide, colles_protection, cdt_protection,
                            FIND_IN_SET(id,'${_SESSION['matieres']}') AS ok,
                            IF (FIND_IN_SET(id,'${_SESSION['matieres']}'),'',' disabled') AS disabled
                            FROM matieres ORDER BY ordre");
$max = $resultat->num_rows;
$mysqli->close();
while ( $r = $resultat->fetch_assoc() )
  affichage($r);
$resultat->free();

// Bas de page
include('bas.php');
?>
