<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par un script autorisé
if ( !defined('OK') )  exit();

// Lancé uniquement depuis notes.php (colleurs et profs) ou admin/notes.php (profs uniquement)
// * authentification déjà faite
// * debut.php déjà parcouru (et fonctions.php aussi)
// * $mysqli déjà définie
// * $matiere et $mid déjà définies

// Récupération des élèves
$resultat = $mysqli->query('SELECT id, CONCAT(nom,\' \',prenom) AS nom FROM utilisateurs WHERE autorisation = 1 ORDER BY nom');
$eleves = array();
while ( $r = $resultat->fetch_assoc() )  {
  $eid[] = $r['id'];
  $eleves[] = $r;
}
$resultat->free();

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['id']) )  {
  $id = $_REQUEST['id'];
  
  // Récupération des semaines contenant des notes
  $resultat = $mysqli->query("SELECT s.id, COUNT(n.id) AS nb, DATE_FORMAT(s.debut,'%w%Y%m%e') AS d
                              FROM semaines AS s LEFT JOIN (SELECT id, semaine FROM notes WHERE colleur = ${_SESSION['id']} AND matiere = $mid) AS n ON n.semaine = s.id
                              WHERE s.colle GROUP BY s.id ORDER BY s.id");
  while ( $r = $resultat->fetch_assoc() )
    $sid[$r['id']] = $r;
  $resultat->free();

  // Connexion à la base de données avec les droits d'écriture
  $mysqli->close();
  $mysqli = mysql_ecriture();

  // Ajout ou modification de notes 
  if ( isset($_REQUEST['modifie']) && isset($sid[$s = $_REQUEST['semaine']]) && ( ( $id == $s ) || !$sid[$s]['nb'] ) )  {
    // Suppression des notes existantes
    if ( isset($sid[$id]) )  {
      requete('notes',"DELETE FROM notes WHERE semaine = $id AND colleur = ${_SESSION['id']} AND matiere = $mid");
      $action = ( $id == $s ) ? 'modification' : 'déplacement';
    }
    else
      $action = 'ajout';

    // Écriture des nouvelles notes
    $requete = array();
    $modif = array();
    if ( isset($_REQUEST['notes']) )
      foreach ( $_REQUEST['notes'] as $eleve => $note )
        if ( in_array($eleve,$eid) && ( is_numeric($note) || ( $note == 'a' ) ) )  {
          $requete[] = "($s,$eleve,${_SESSION['id']},$mid,'$note')";
          $modif[] = $eleves[array_search($eleve,$eid)]['nom'];
        }

    // Exécution et message
    if ( empty($requete) )  {
      if ( $action == 'ajout' )
        $message = 'Aucune modification à effectuer.';
      else
        $message = ($mysqli->affected_rows).' notes ont bien été supprimées à la semaine du '.format_date($sid[$id]['d']).'.';
    }
    else  {
      $n = count($requete);
      $requete = implode(', ',$requete);
      $modif = implode(', ',$modif);
      if ( requete('notes',"INSERT INTO notes (semaine,eleve,colleur,matiere,note) VALUES $requete") ) {
        switch ( $action )  {
          case 'ajout':
            $message = "$n notes ($modif) ont bien été ajoutées à la semaine du ".format_date($sid[$s]['d']).'.';
            break;
          case 'modification':
            $message = "$n notes ($modif) ont bien été modifiées à la semaine du ".format_date($sid[$s]['d']).'.';
            break;
          case 'déplacement':
            $message = "$n notes ($modif) ont bien été modifiées et déplacées de la semaine du ".format_date($sid[$id]['d']).' à la semaine du '.format_date($sid[$s]['d']).'.';
        }
        // Vérification qu'il n'y a pas deux notes de colles pour le même élève, la même semaine, dans la même matière
        $resultat = $mysqli->query("SELECT n1.id AS id FROM (SELECT * FROM notes WHERE colleur = ${_SESSION['id']} AND matiere = $mid) AS n1
                                    JOIN notes AS n2 USING (semaine,eleve,matiere) WHERE n1.id != n2.id");
        if ( $resultat->num_rows )  {
          while( $r = $resultat->fetch_assoc() )
            requete('notes',"DELETE FROM notes WHERE id = ${r['id']}");
          $resultat->free();
          $message .= '<br>Attention, certaines de vos notes ont été automatiquement supprimées&nbsp;: il est impossible pour un élève d\'avoir la même semaine deux notes dans la même matière.';
        }
      }
      else
        $message = 'Les notes de la semaine du '.format_date($sid[$s]['d']).' n\'ont pas pu être ajoutées. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }
  }

  // Suppression des notes d'une semaine
  elseif ( isset($_REQUEST['supprime']) && isset($sid[$id]) && $sid[$id]['nb'] )
    $message = ( requete('notes',"DELETE FROM notes WHERE semaine = $id AND colleur = ${_SESSION['id']} AND matiere = $mid") ) ? 'Les '.$sid[$id]['nb'].' notes de la semaine du '.format_date($sid[$id]['d']).' ont bien été supprimées.' : 'Les '.$sid[$id]['nb'].' notes de la semaine du '.format_date($sid[$id]['d']).' n\'ont pas pu être supprimées. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';

  // Mise à jour des champs 'notes' dans la table 'matieres' (pour le menu)
  $mysqli->query('UPDATE matieres SET notes = IF((SELECT id FROM notes WHERE matiere = matieres.id LIMIT 1),1,0)');

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}

////////////
/// HTML ///
////////////
$p = "notes?${matiere['cle']}";
$t = "Notes de colles en ${matiere['nom']}";

// Haut de page, menu et message
include('haut.php');

// Besoin de stocker l'affichage à émettre pour insérer ici du contenu dans admin/notes.php
ob_start();

// Récupération des semaines
$resultat = $mysqli->query("SELECT s.id, DATE_FORMAT(s.debut,'%w%Y%m%e') AS d, s.colle, s.vacances, COUNT(n.id) AS nb
                            FROM semaines AS s
                            LEFT JOIN (SELECT id, semaine FROM notes WHERE colleur = ${_SESSION['id']} AND matiere = $mid) AS n ON n.semaine = s.id
                            GROUP BY s.id ORDER BY s.id");
$select_semaines = '';
while ( $r = $resultat->fetch_assoc() )  {
  switch ( $r['vacances'] )  {
    case 0:
      if ( $r['colle'] == 0 )
        $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>".format_date($r['d']).' (pas de colle)</option>';
      else  {
        $select_semaines .= ( $r['nb'] ) ? "\n        <option value=\"${r['id']}\" disabled>".format_date($r['d'])." (${r['nb']} notes déjà entrées)</option>" : "\n        <option value=\"${r['id']}\">".format_date($r['d']).'</option>';
        $semaines[$r['id']] = $r['d'];
      }
      break;
    case 1:
      $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances de Toussaint</option>";
      break;
    case 2:
      $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances de Noël</option>";
      break;
    case 3:
      $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances d'hiver</option>";
      break;
    case 4:
      $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances de Pâques</option>";
  }
}
$resultat->free();

// Fonction d'affichage
function affichage($r,$d)  {
  $s = $r['semaine'];
  if ( strlen($d) )  {
    $titre = 'Semaine du '.format_date($d)."&nbsp;: ${r['nb']} notes";
    $valide = '';
    $suppr = "\n      <input class=\"bouton\" type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer ces notes\">";
    $semaine = 'Changer la semaine';
    $select_semaines = str_replace("\"$s\" disabled","\"$s\" selected",$GLOBALS['select_semaines']);
  }
  else  {
    $titre = 'Nouvelles notes';
    $suppr = '';
    $semaine = 'Semaine';
    $select_semaines = str_replace("\"$s\"","\"$s\" selected",$GLOBALS['select_semaines']);
    $s = 0;
  }
  echo <<<FIN

  <div class="item admin">
  <form action="" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider ces notes">$suppr
    <h3>$titre</h3>
    <p class="ligne"><label for="sem$s">$semaine&nbsp;:</label>
      <select id="sem$s" name="semaine">$select_semaines
      </select>
    </p>
FIN;
  // Affichage des élèves
  $select_notes = '<option value="a">Absent</option><option value="0">0</option><option value="1">1</option><option value="2">2</option><option value="3">3</option><option value="4">4</option><option value="5">5</option><option value="6">6</option><option value="7">7</option><option value="8">8</option><option value="9">9</option><option value="10">10</option><option value="11">11</option><option value="12">12</option><option value="13">13</option><option value="14">14</option><option value="15">15</option><option value="16">16</option><option value="17">17</option><option value="18">18</option><option value="19">19</option><option value="20">20</option>';
  $eleves = $GLOBALS['eleves'];
  $notes = array_combine(explode(',',$r['eleves']),explode(',',$r['notes']));
  foreach ( $eleves as $eleve )  {
    $id = $eleve['id'];
    echo "
    <p class=\"ligne\"><label for=\"eleve${id}_$s\">${eleve['nom']}</label>
      <select id=\"eleve${id}_$s\" name=\"notes[$id]\">
        <option value=\"x\">${eleve['nom']}</option>";
    echo ( isset($notes[$id]) ) ? str_replace("\"${notes[$id]}\"","\"${notes[$id]}\" selected",$select_notes) : $select_notes;
    echo "\n      </select>\n    </p>";
  }
  echo "
    <input type=\"hidden\" name=\"id\" value=\"$s\">
  </form>
  </div>\n";
}

// Formulaire pour de nouvelles notes
$resultat = $mysqli->query("SELECT id FROM semaines WHERE colle AND id > IFNULL( ( SELECT MAX( semaine ) FROM notes WHERE colleur = ${_SESSION['id']} AND matiere = $mid) , 0 ) LIMIT 1");
$r = $resultat->fetch_assoc();
$resultat->free();
affichage(array('semaine'=>$r['id'],'nb'=>0,'eleves'=>'0','notes'=>'0'),'');
                              
// Récupération de l'ensemble des notes mises, regroupées par semaine
$resultat = $mysqli->query("SELECT semaine, COUNT(id) AS nb,
                            GROUP_CONCAT(eleve ORDER BY id SEPARATOR ',') AS eleves, GROUP_CONCAT(note ORDER BY id SEPARATOR ',') AS notes
                            FROM notes WHERE colleur = ${_SESSION['id']} AND matiere = $mid GROUP BY semaine ORDER BY semaine DESC");
// Affichage de l'ensmeble des notes de l'année
if ( $resultat->num_rows )  {
  while ( $r = $resultat->fetch_assoc() )
    affichage($r,$semaines[$r['semaine']]);
  $resultat->free();
}
else
  echo "  <h2>Vous n'avez encore donné aucune note cette année.</h2>\n\n";

// Le buffer est stocké dans $aff, à afficher dans le script appelant
$aff = ob_get_clean();
?>
