<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

////////////////////////////////////////
// Validation de la requête : matière //
////////////////////////////////////////

// Recherche de la matière concernée
if ( !empty($_REQUEST) )
  foreach ( $matieres as $r )
    if ( isset($_REQUEST[$r['cle']]) )  {
      $matiere = $r;
      $mid = $matiere['id'];
      break;
    }
// Si mauvaise demande
if ( !isset($matiere) )  {
  if ( strlen($_SESSION['matieres']) )
    exit('<p>Mauvais paramètre d\'accès à cette page. Vous n\'avez accès qu\'aux matières associées à votre compte et l\'adresse doit comporter la clé de la matière. Vous pouvez chager vos matières associées dans vos <a href="prefs">Préférences</a>.</p><p>Il est préférable de passer par les lien du menu&nbsp; <a href=".">retour à l\'accueil</a></p>');
  else
    exit('<p>Vous ne pourrez afficher cette page qu\'après avoir associé des matières à votre compte. Il faut aller dans vos <a href="prefs">Préférences</a> pour cela.</p>');
}

//////////////////////////////
// Appel à notes-saisie.php //
//////////////////////////////
// * appelle haut.php
// * réalise les modifications de la base
// * fournit $eid, $eleves et $semaines
// * fournit le contenu à afficher dans $aff
include('notes-saisie.php');

////////////////////////////////////
// Consultation globale des notes //
////////////////////////////////////

// Select sur les colleurs
$resultat = $mysqli->query("SELECT id, CONCAT(prenom,' ',nom) AS nom FROM utilisateurs WHERE autorisation > 1 AND FIND_IN_SET($mid,matieres) ORDER BY nom");
$select_colleurs = '';
while ( $r = $resultat->fetch_assoc() )  {
  $select_colleurs .= "\n        <option value=\"${r['id']}\">${r['nom']}</option>";
  $cid[] = $r['id'];
}
$resultat->free();

// Select sur les semaines
$select_semaines = preg_replace('/ disabled>(.*) \(\d+ notes déjà entrées\)/','>\1',$select_semaines);

// Validation de la requête
if ( isset($_REQUEST['colleur']) )  {
  $sid = array_keys($semaines);

  if ( !isset($_REQUEST['depuisledebut']) && is_numeric($n1 = $_REQUEST['n']) && is_numeric($nb = $_REQUEST['nb']) )  {
    // Validation de n
    while ( !isset($semaines[$n1]) )
      $n1 = ( $n1 < 50 ) ? $n1+1 : key($semaines);
    // Validation de nb
    $m = array_search($n1,$sid);
    if ( isset($sid[$m+$nb]) )  {
      $n2 = $sid[$m+$nb-1];
      $sid = array_slice($sid,$m,$nb);
    }
    else  {
      $n2 = end($sid);
      $sid = array_slice($sid,$m);
      $nb = count($sid);
    }
  }
  // Si toute l'année
  else  {
    $n1 = current($sid);
    $n2 = end($sid);
    $nb = count($sid);
  }
  $select_semaines = str_replace("\"$n1\"","\"$n1\" selected",$select_semaines);

  // Validation du colleur
  if ( in_array($colleur = $_REQUEST['colleur'],$cid) )  {
    $select_colleurs = str_replace("\"$colleur\"","\"$colleur\" selected",$select_colleurs);
    $colleur = "OR colleur != ${_REQUEST['colleur']}";
  }
  else
    $colleur = '';
}
// Valeur par défaut
else
  $nb = 1;

// Aide et formulaire de recherche
?>

  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ci-dessous consulter les notes en <?php echo $matiere['nom']; ?> et en ajouter.</p>
    <p>Vous ne pouvez consulter que les notes de colles des matières qui vous sont associées. Elles sont modifiables dans vos <a href="prefs">Préférences</a>.</p>
    <h4>Consultation des notes de colles</h4>
    <p>Pour consulter les notes, vous devez valider le premier formulaire ci-dessous, vous permettant de choisir éventuellement le colleur dont vous voulez voir les notes et la période sur laquelle vous souhaitez voir les notes. De façon générale, un clic sur le bouton <em>pour toute l'année</em> sera ce que vous souhaitez.</p>
    <p>Le tableau qui s'affichera est récupérable dans un tableur (Excel, Calc...) par simple copié-collé. Répondez &laquo;&nbsp;automatique&nbsp;&raquo; lorsque votre tableur vous demandera comment vous souhaitez réaliser l'importation.</p>
    <p>Le caractère &laquo;&nbsp;a&nbsp;&raquo; signifie que l'élève a été marqué absent par le colleur.</p>
    <h4>Ajout de notes de colles</h4>
    <p>Vous pouvez ajouter ou modifier des notes. Attention, un élève ne peut avoir plus d'une note dans la même matière une même semaine&nbsp;: si vous ajoutez une telle note, elle ne sera pas validée.</p>
    <p>Pour ajouter des notes sur une nouvelle semaine, vous devez obligatoirement sélectionner une semaine où vous n'avez pas encore mis de note dans cette matière. Il n'y a pas de limite de nombre d'élèves collés par semaine (toutes les notes d'une semaine sont à entrer en une seule fois).</p>
    <p>Les notes déjà mises peuvent être modifiées&nbsp;: soit déplacées à une autre semaine, soit modifiées sur place, soit les deux simultanément.</p>
    <p>Il est aussi possible de <em>supprimer</em> l'ensemble des notes d'une semaine.</p>
  </div>

  <h2>Consulter les notes de la classe</h2>

  <div class="item" id="recherche">
  <form action="" method="post">
    <p>Afficher les notes de&nbsp;
      <select name="colleur">
        <option value="0">tous les colleurs</option><?php echo $select_colleurs; ?>
      </select>
      <input type="submit" name="depuisledebut" id="depuisledebut" value="pour toute l'année">
      ou&nbsp;pendant&nbsp;<input type="text" name="nb" value="<?php echo $nb; ?>" size="2">&nbsp;semaine(s) à partir du&nbsp;
      <select name="n"><?php echo $select_semaines; ?>
      </select>
      <input type="submit" name="" value="OK">
    </p>
  </form>
  </div>

<?php
// Affichage du tableau de notes
if ( isset($_REQUEST['colleur']) )  {
  // Recherche des notes concernées
  $resultat = $mysqli->query("SELECT nom, CONCAT('<td>',GROUP_CONCAT( IF(ISNULL(note) OR note = 'x' $colleur,'',note) ORDER BY sid SEPARATOR '</td><td>'),'</td>') AS notes
                              FROM ( SELECT s.id AS sid, u.id AS eid, CONCAT('<td>',nom,' ',prenom,'</td>') AS nom
                                     FROM semaines AS s LEFT JOIN utilisateurs AS u ON 1 WHERE colle AND s.id>=$n1 AND s.id<=$n2 AND u.autorisation=1 ORDER BY nom) AS t
                              LEFT JOIN notes ON sid = semaine AND eid = eleve AND matiere = $mid GROUP BY eid ORDER BY nom,sid");
  if ( $resultat->num_rows )  {
    echo "  <table class=\"admin\">\n    <thead>\n      <tr><th class=\"semaines\">Nom</th>";
    foreach ( $sid as $i)
      echo '<td class="semaines"><span>'.str_pad(preg_replace('/.{5}(.{2})(.*)/','\2/\1',$semaines[$i]),5,'0',STR_PAD_LEFT).'</span></td>';
    echo "</tr>\n    </thead>\n      <tbody>\n";
    while ( $r = $resultat->fetch_assoc() )
      if ( strlen(str_replace('<td></td>','',$r['notes'])) )
        echo "        <tr>${r['nom']}${r['notes']}</tr>\n";
      else
        echo "        <tr>${r['nom']}<td class=\"pasnote\" colspan=\"$nb\">Pas encore de note pour cet élève</td></tr>\n";
    $resultat->free();
    echo "      </tbody>\n  </table>\n\n";
  }
  else
    echo "\n  <div class=\"warning\">Il n'y a encore aucune note de colle en ${matiere['nom']} cette année.</div>\n\n";
}

// Affichage du résultat de notes.saisie.php
echo "  <h2>Ajouter des notes</h2>\n$aff";

$mysqli->close();

// Bas de page
include('bas.php');
?>
