<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

// Recherche de la page concernée, variable "page"
if ( isset($_REQUEST['page']) )  {
  $resultat = $mysqli->query("SELECT p.id, CONCAT_WS('/',m.cle,p.cle) AS cle, p.nom, p.mat
                              FROM pages AS p LEFT JOIN matieres AS m ON p.mat = m.id
                              WHERE FIND_IN_SET(p.mat,'0,${_SESSION['matieres']}')");
  if ( $resultat->num_rows )  {
    while ( $r = $resultat->fetch_assoc() )
      if ( $_REQUEST['page'] == $r['cle'] )  {
        $pid = $r['id'];
        $page = $r;
        break;
      }
    $resultat->free();
  }
  // Pas de page par défaut : si pas de page demandée, gestion des pages
}

/////////////////////////////
// Modifications des pages //
/////////////////////////////
if ( isset($_REQUEST['action']) && $_REQUEST['action'] == 'page' )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = mysql_ecriture();
  
  // Vérification que l'identifiant est valide. Défaut : id=0 (nouvelle page)
  if ( isset($pid) )
    $id = $pid;
  elseif ( is_numeric($_REQUEST['id']) )
    $id = $_REQUEST['id'];
  $resultat = $mysqli->query("SELECT id, nom, ordre, mat, (SELECT MAX(p.ordre) FROM pages AS p WHERE p.mat = pages.mat) AS max FROM pages WHERE id = $id");
  if ( $resultat->num_rows )  {
    $r = $resultat->fetch_assoc();
    $resultat->free();
  }
  else
    $id = 0;

  // Ajout ou modification d'une page
  if ( isset($_REQUEST['modifie']) )  {
    // Vérification des données envoyées
    if ( !strlen($_REQUEST['titre']) || !strlen($_REQUEST['cle']) || !strlen($_REQUEST['nom']) )
      $message = 'Il n\'est pas possible de valider une page avec une clé, un nom ou un titre vide. Pour supprimer une page, il faut cliquer sur Supprimer.';
    else  {
      // Validation des données envoyées
      $titre = $mysqli->real_escape_string($_REQUEST['titre']);
      $bandeau = $mysqli->real_escape_string($_REQUEST['bandeau']);
      $cle = $mysqli->real_escape_string($_REQUEST['cle']);
      $nom = $mysqli->real_escape_string($_REQUEST['nom']);
      $protection = ( in_array($_REQUEST['protection'],array(0,1,2,3)) ) ? $_REQUEST['protection'] : 0;
      if ( !isset($_REQUEST['mat']) || !is_numeric($mat = $_REQUEST['mat']) || !in_array($mat,explode(',',$_SESSION['matieres'])) )
        $mat = 0;
      // Si identifiant numérique non nul, modification d'une page existante
      if ( $id )  {
        // Si matière identique
        if ( $mat == $r['mat'] )
          $message = ( requete('pages',"UPDATE pages SET cle = '$cle', nom = '$nom', titre = '$titre',
                                        bandeau = '$bandeau', protection = $protection WHERE id = $id")
          ) ? 'La page <em>'.stripslashes($nom).'</em> a bien été modifiée.' : "La page <em>${r['nom']}</em> n'a pas pu être modifiée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
        else  {
          $resultat = $mysqli->query("SELECT IFNULL(MAX(ordre)+1,1) AS max FROM pages WHERE mat = $mat");
          $m = $resultat->fetch_assoc();
          $resultat->free();
          $message = ( requete('pages',"UPDATE pages SET cle = '$cle', nom = '$nom', mat = $mat, titre = '$titre',
                                        ordre = ${m['max']}, bandeau = '$bandeau', protection = $protection WHERE id = $id")
                    && requete('pages',"UPDATE pages SET ordre = (ordre-1) WHERE mat = ${r['mat']} AND ordre > ${r['ordre']}")
          ) ? 'La page <em>'.stripslashes($nom).'</em> a bien été modifiée.' : "La page <em>${r['nom']}</em> n'a pas pu être modifiée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';
        }
        // Correction des données de la page si $pid réglé
        if ( isset($pid) )  {
          $resultat = $mysqli->query("SELECT p.id, CONCAT_WS('/',m.cle,p.cle) AS cle, p.nom
                                      FROM pages AS p LEFT JOIN matieres AS m ON p.mat = m.id
                                      WHERE p.id = $pid");
          $page = $resultat->fetch_assoc();
          $resultat->free();
        }
      }
      // Si id = 0, ajout d'une nouvelle page
      else
        $message = ( requete('pages',"INSERT INTO pages SET cle = '$cle', nom = '$nom', mat = $mat, titre = '$titre',
                                      bandeau = '$bandeau', protection = $protection, ordre = (SELECT IFNULL(MAX(ordre)+1,1)
                                      FROM pages AS p WHERE p.mat = $mat)")
        ) ? 'La page «&nbsp'.stripslashes($nom).'</em> a bien été ajoutée.' : 'La page <em>'.stripslashes($nom).'</em> n\'a pas pu être ajoutée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }
  }

  elseif ( $id )  {
    $ordre = $r['ordre'];

    // Déplacement vers le haut
    if ( isset($_REQUEST['monte']) && ( $ordre > 1 ) )
      $message = ( requete('pages',"UPDATE pages SET ordre = (2*$ordre-1-ordre) WHERE mat = ${r['mat']} AND ( ordre = $ordre OR ordre = ($ordre-1) )")
      ) ? "La page <em>${r['nom']}</em> a bien été montée d'une place." : "La page <em>${r['nom']}</em> n'a pas pu être déplacée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

    // Déplacement vers le bas
    elseif ( isset($_REQUEST['descend']) && ( $ordre < $r['max'] ) )
      $message = ( requete('pages',"UPDATE pages SET ordre = (2*$ordre+1-ordre) WHERE mat = ${r['mat']} AND ( ordre = $ordre OR ordre = ($ordre+1) )")
      ) ? "La page <em>${r['nom']}</em> a bien été descendue d'une place." : "La page <em>${r['nom']}</em> n'a pas pu être déplacée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

    // Suppression : possible uniquement hors page d'accueil, page n°1 sans matière associée (mat=0)
    elseif ( isset($_REQUEST['supprime']) && ( $r['max']+$r['mat'] > 1 ) )
      $message = ( requete('pages',"DELETE FROM pages WHERE id = $id")
                && requete('infos',"DELETE FROM infos WHERE page = $id")
                && requete('pages',"UPDATE pages SET ordre = (ordre-1) WHERE mat = ${r['mat']} AND ordre > $ordre")
      ) ? "La page <em>${r['nom']}</em> a bien été supprimée, ainsi que les informations qu'elle comportait." : "La page <em>${r['nom']}</em> n'a pas pu être supprimée. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

    // Suppression des informations
    elseif ( isset($_REQUEST['vide']) )
      $message = ( requete('infos',"DELETE FROM infos WHERE page = $id") ) ? "Toutes les informations de la page <em>${r['nom']}</em> ont bien été supprimées." : "Les informations de la page <em>${r['nom']}</em> n'ont pas pu être supprimées. Erreur MySQL n°".$mysqli->errno.', «'.$mysqli->error.'».';

  }
  $mysqli->query('ALTER TABLE pages ORDER BY mat,ordre');

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}

////////////////////////////////////
// Modifications des informations //
////////////////////////////////////
elseif ( isset($pid) && isset($_REQUEST['action']) && $_REQUEST['action'] == 'info' )  {
  // Connexion à la base de données
  $mysqli->close();
  $mysqli = mysql_ecriture();
  
  // Vérification que l'identifiant est valide. Défaut : id=0 (nouvelle information)
  if ( is_numeric($id = $_REQUEST['id']) && $id )  {
    $resultat = $mysqli->query("SELECT id, ordre, cache, titre, texte, ( SELECT MAX(ordre) FROM infos WHERE page = $pid ) AS max
                                FROM infos WHERE page = $pid AND id = $id");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $resultat->free();
    }
    else
      $id = 0;
  }
  else
    $id = 0;

  // Pour les informations récentes
  $lien_recent = '?'.addslashes($page['cle']);

  // Traitement d'un ajout/modification
  if ( isset($_REQUEST['modifie']) && strlen($_REQUEST['texte']) )  {

    // Validation des données envoyées
    $texte = $mysqli->real_escape_string($_REQUEST['texte']);
    $titre = $mysqli->real_escape_string($_REQUEST['titre']);
    $titre_recent = ( strlen($titre) ) ? $titre : 'Nouvelle information';

    // Si $id > 0 : modification d'une information existante. Si $id = 0, nouvelle information
    if ( $id )  {
      if ( requete('infos',"UPDATE infos SET texte = '$texte', titre = '$titre' WHERE id = $id") )  {
        $message = 'L\'information a bien été modifiée.';
        // Ajout d'une information récente si information diffusée
        if ( !$r['cache'] )
          recent($mysqli,1,$id,"<img class=\"icone\" src=\"icones/info.png\"> $titre_recent",$lien_recent,$texte);
      }
      else
        $message = 'L\'information n\'a pas pu être modifiée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }
    else  {
      $cache = ( isset($_REQUEST['cache']) ) ? 1 : 0;
      if ( requete('infos',"UPDATE infos SET ordre = (ordre+1) WHERE page = $pid")
        && requete('infos',"INSERT INTO infos SET ordre = 1, page = $pid, texte = '$texte', titre = '$titre', cache = $cache") )  {
          $message = 'L\'information a bien été ajoutée.';
          // Ajout d'une information récente si information diffusée
          if ( !$cache )
            recent($mysqli,1,$mysqli->insert_id,"<img class=\"icone\" src=\"icones/info.png\"> $titre_recent",$lien_recent,$texte);
          $mysqli->query('ALTER TABLE infos ORDER BY page,ordre');
      }
      else
        $message = 'L\'information n\'a pas pu être ajoutée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }
  }

  elseif ( $id )  {

    // Déplacement vers le haut
    if ( isset($_REQUEST['monte']) && ( $r['ordre'] > 1 ) )
      $message = ( requete('infos',"UPDATE infos SET ordre = (2*${r['ordre']}-1-ordre) WHERE ( ordre = ${r['ordre']} OR ordre = (${r['ordre']}-1) ) AND page = $pid")
                && $mysqli->query('ALTER TABLE infos ORDER BY page,ordre')
      ) ? 'L\'information a bien été montée d\'une place.' : 'L\'information n\'a pas pu être déplacée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';

    // Déplacement vers le bas
    elseif ( isset($_REQUEST['descend']) && ( $r['ordre'] < $r['max'] ) )
      $message = ( requete('infos',"UPDATE infos SET ordre = (2*${r['ordre']}+1-ordre) WHERE ( ordre = ${r['ordre']} OR ordre = (${r['ordre']}+1) ) AND page = $pid")
                && $mysqli->query('ALTER TABLE infos ORDER BY page,ordre')
      ) ? 'L\'information a bien été descendue d\'une place.' : 'L\'information n\'a pas pu être déplacée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';

    // Positionnement "montré" (apparaît sur la partie publique)
    elseif ( isset($_REQUEST['montre']) )  {
      if ( requete('infos',"UPDATE infos SET cache = 0 WHERE id = $id") )  {
        $message = 'L\'information a bien été diffusée, elle apparaît désormais sur la partie publique.';
        // Ajout d'information récente
        $titre_recent = ( strlen($r['titre']) ) ? $mysqli->real_escape_string($r['titre']) : 'Nouvelle information';
        recent($mysqli,1,$id,"<img class=\"icone\" src=\"icones/info.png\"> $titre_recent",$lien_recent,$mysqli->real_escape_string($r['texte']));
      }
      else
        $message = 'L\'information n\'a pas pu être diffusée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }

    // Positionnement "caché" (n'apparaît pas sur la partie publique)
    elseif ( isset($_REQUEST['cache']) )  {
      if ( requete('infos',"UPDATE infos SET cache = 1 WHERE id = $id") )  {
        $message = 'L\'information n\'est plus diffusée&nbsp;: elle n\'apparaît plus sur la partie publique mais est toujours disponible ici pour modification ou diffusion.';
        // Suppression de l'éventuelle information récente
        recent($mysqli,1,$id);
      }
      else
        $message = 'L\'information n\'a pas pu être cachée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }

    // Suppression
    elseif ( isset($_REQUEST['supprime']) || !strlen($_REQUEST['texte']) )  {
      if ( requete('infos',"DELETE FROM infos WHERE id = $id") 
        && requete('infos',"UPDATE infos SET ordre = (ordre-1) WHERE ordre > ${r['ordre']} AND page = $pid") )  {
        $message = 'L\'information a bien été supprimée.';
        // Suppression de l'éventuelle information récente
        recent($mysqli,1,$id);
      }
      else
        $message = 'L\'information n\'a pas pu être supprimée. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
    }
  }

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}

//////////
// HTML //
//////////
// Haut de page, menu et message
if ( isset( $pid ) )  {
  $p = "pages?page=${page['cle']}";
  $t = "Modification de la page «&nbsp;${page['nom']}&nbsp;»";
  include('haut.php');
?>

  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ci-dessous modifier la page &laquo;&nbsp;<?php echo $page['nom']; ?>&nbsp;&raquo;, ajouter une information ou modifier les informations existantes.</p>
    <p>Pour supprimer cette page (et automatiquement toutes les informations qu'elle contient), il faut aller sur la page <a href="pages">Gestion des pages</a>.</p>
    <p>L'ordre d'affichage des informations dans la page peut être modifié en cliquant sur les flèches.</p>
    <h4>Préférences associées à cette page</h4>
    <p>Concernant cette page, vous pouvez modifier&nbsp;:</p>
    <ul>
      <li>le <em>titre</em> qui sera affiché en haut de page et dans la barre de titre du navigateur. Par exemple, «&nbsp;À propos de l'ADS et du TIPE&nbsp;».</li>
      <li>le <em>nom dans le menu</em> qui est affiché dans le menu en tant que lien vers la page. Il est préférable qu'il rentre sur une ligne, il faut donc le choisir assez court. Par exemple, «&nbsp;Informations ADS/TIPE&nbsp;».</li>
      <li>la <em>clé dans l'adresse</em> qui est un mot-clé qui est utilisé uniquement dans l'adresse de la page. Par convention, il vaut mieux que ce soit un mot unique, court et sans majuscule. Par exemple, «&nbsp;ads-tipe&nbsp;».</li>
      <li>la <em>matière associée</em> qui conditionne la place du lien dans le menu de la partie publique. Vous ne pouvez associer à cette page qu'une matière déjà associée à votre compte. Pour modifier les matières qui vous sont associées, il faut aller dans vos <a href="prefs">Préférences</a>.</li>
      <li>le <em>texte de début</em>, qui sera affiché au-dessus des informations de la page. Il s'agit d'une ou deux phrases maximum. Il n'est affiché que si la page contient des informations. Cette case peut être laissée vide.</li>
    </ul>
    <p>L'<em>accès</em> à cette page peut être choisi parmi quatre possibilités&nbsp;:</p>
    <ul>
      <li><em>Visible de tous</em>&nbsp;: accessible de tout visiteur, sans identification.</li>
      <li><em>Visible pour les élèves, colleurs, professeurs</em>&nbsp;: accessible uniquement par tout utilisateur après identification. Il faut donc avoir un compte validé (voir l'aide de la page <a href="utilisateurs">Utilisateurs</a>) pour y accéder.</li>
      <li><em>Visible pour les colleurs, professeurs</em>&nbsp;: accessible uniquement par les utilisateurs de type colleur ou professeur.</li>
      <li><em>Visible pour les professeurs</em>&nbsp;: accessible uniquement par les utilisateurs de type professeur (vous et vos collègues).</li>
    </ul>
    <p>Quel que soit ce choix, le lien dans le menu de la partie publique apparaîtra pour tout visiteur (identifié ou non).</p>
    <h4>Suppression des informations d'une page</h4>
    <p>Si la page contient une ou plusieurs informations, il est possible de toutes les supprimer (vider la page, sans la supprimer). Ce bouton apparaît dans les préférences de la page.</p>
    <h4>Informations</h4>
    <p>Le <em>titre</em> sera affiché, un peu plus gros, au-dessus de l'information. Il peut rester vide (il n'y aura alors pas de titre affiché).</p>
    <p>Le texte doit être formaté en HTML&nbsp;: par exemple, chaque bloc de texte doit être encadré par &lt;p&gt; et &lt;/p&gt;. Il peut donc contenir des liens vers les autres pages du site, vers des documents du site, vers le web... N'hésitez pas à consulter l'aide qui apparaîtra en-dessous de la case de texte après avoir cliqué dessus, ainsi qu'à utiliser les boutons fournis.</p>
    <p>La case à cocher <em>Ne pas diffuser sur la partie publique</em> permet de cacher temporairement cette information, par exemple pour la diffuser ultérieurement.</p>
  </div>

<?php
}
else  {
  $p = "pages";
  $t = 'Modifications des pages d\'informations';
  include('haut.php');
?>

  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ci-dessous ajouter une page d'information ou modifier les pages existantes. Les pages du <em>Menu général</em> sont affichées, sur la partie publique, en haut du menu. Les pages associées à une matière donnée y apparaissent au niveau de la matière.</p>
    <p>La première page ne peut pas être déplacée dans une matière ni supprimée, car c'est la page d'accueil de la partie publique. Il est cependant tout à fait possible de modifier son <em>titre</em>, son <em>nom dans le menu</em> ou sa <em>clé dans l'adresse</em>. Pour information, le <em>titre</em> de la page d'accueil est repris à plusieurs endroits (page de connexion, page du flux RSS...) et est aussi modifiable sur la page <a href="site">Titre du site</a>.</p>
    <p>L'ordre d'affichage des pages dans le menu de la partie publique peut être modifié en cliquant sur les flèches.</p>
    <h4>Préférences associées à chaque page</h4>
    <p>Pour chaque page, vous pouvez modifier&nbsp;:</p>
    <ul>
      <li>le <em>titre</em> qui sera affiché en haut de page et dans la barre de titre du navigateur. Par exemple, «&nbsp;À propos de l'ADS et du TIPE&nbsp;».</li>
      <li>le <em>nom dans le menu</em> qui est affiché dans le menu en tant que lien vers la page. Il est préférable qu'il rentre sur une ligne, il faut donc le choisir assez court. Par exemple, «&nbsp;Informations ADS/TIPE&nbsp;».</li>
      <li>la <em>clé dans l'adresse</em> qui est un mot-clé qui est utilisé uniquement dans l'adresse de la page. Par convention, il vaut mieux que ce soit un mot unique, court et sans majuscule. Par exemple, «&nbsp;ads-tipe&nbsp;».</li>
      <li>la <em>matière associée</em> qui conditionne la place du lien dans le menu de la partie publique. Vous ne pouvez associer à une nouvelle page qu'une matière déjà associée à votre compte. Pour modifier les matières qui vous sont associées, il faut aller dans vos <a href="prefs">Préférences</a>.</li>
      <li>le <em>texte de début</em>, qui sera affiché au-dessus des informations de la page. Il s'agit d'une ou deux phrases maximum. Il n'est affiché que si la page contient des informations. Cette case peut être laissée vide.</li>
    </ul>
    <p>L'<em>accès</em> à chaque page peut être choisi parmi quatre possibilités&nbsp;:</p>
    <ul>
      <li><em>Visible de tous</em>&nbsp;: accessible de tout visiteur, sans identification.</li>
      <li><em>Visible pour les élèves, colleurs, professeurs</em>&nbsp;: accessible uniquement par tout utilisateur après identification. Il faut donc avoir un compte validé (voir l'aide de la page <a href="utilisateurs">Utilisateurs</a>) pour y accéder.</li>
      <li><em>Visible pour les colleurs, professeurs</em>&nbsp;: accessible uniquement par les utilisateurs de type colleur ou professeur.</li>
      <li><em>Visible pour les professeurs</em>&nbsp;: accessible uniquement par les utilisateurs de type professeur (vous et vos collègues).</li>
    </ul>
    <p>Quel que soit ce choix, le lien de chaque page dans le menu de la partie publique apparaîtra pour tout visiteur (identifié ou non).</p>
    <h4>Suppression d'une page</h4>
    <p>La suppression d'une page entraîne automatiquement la suppression de toutes les informations qui y étaient inscrites. La suppression n'est pas possible pour la première page du <em>Menu général</em>.</p>
    <h4>Suppression des informations d'une page</h4>
    <p>Si la page contient une ou plusieurs informations, il est possible de toutes les supprimer (vider la page, sans la supprimer).</p>
  </div>

<?php
}

// Select sur les matières
$select_matieres = '<option value="O">Pas de matière associée</option>';
foreach ( $matieres as $m )
  $select_matieres .= "\n        <option value=\"${m['id']}\">${m['nom']}</option>";
// Select sur la protection
$select_protection = '
        <option value="0">Visible de tous</option>
        <option value="1">Visible pour les élèves, colleurs, profs</option>
        <option value="2">Visible pour les colleurs et les profs</option>
        <option value="3">Visible pour les profs uniquement</option>';

// Fonction d'affichage des pages
function affichage_page($r)  {
  $id = $r['id'];
  // Identifiant unique pour les champs du formulaire
  $fid = "${r['mat']}$id";
  // Si l'identifiant est nul, formulaire de nouvelle page
  // Si l'identifiant est positif, on est sur la gestion des pages
  // Si l'identifiant est négatif, on est sur la gestion de la page d'identifiant $pid
  if ( $id == 0 )  {
    $titre = 'Nouvelle page';
    $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $valide = $monte = $descend = $suppr = $vide = $disabled = '';
    // Présélections sur les select
    $select_matieres = $GLOBALS['select_matieres'];  
    $select_protection = $GLOBALS['select_protection'];
  }
  else  {
    if ( $id > 0 )  {
      $titre = "Page n°${r['ordre']}&nbsp;: ${r['nom']}";
      $valide1 = '';
      $valide = "\n      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
      $monte = ( $r['ordre'] > 1 ) ? "\n      <input type=\"submit\" name=\"monte\" value=\"&uarr;\" title=\"Remonter la page dans l'ordre d'apparition\">" : '';
      $descend = ( $r['ordre'] < $GLOBALS['max'] ) ? "\n      <input type=\"submit\" name=\"descend\" value=\"&darr;\" title=\"Descendre la page dans l'ordre d'apparition\">" : '';
      $suppr = ( $GLOBALS['max']+$r['mat'] > 1 ) ? "\n      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer la page\">" : '';
      $disabled = ( $r['ordre']+$r['mat'] == 1 ) ? ' disabled' : '';
    }
    else  {
      $titre = 'Modifier les préférences de la page';
      $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
      $valide = $monte = $descend = $suppr = '';
      $id = -$r['id'];
      $disabled = ( $r['ordre']+$r['mat'] == 1 ) ? ' disabled' : '';
    }
    // Bouton de suppression des informations
    $vide = ( $r['n'] ) ? "\n    <p class=\"ligne\">Cette page contient ${r['n']} information".( ( $r['n'] > 1 ) ? 's' : '' ).".<input type=\"submit\" name=\"vide\" value=\"Supprimer toutes les informations de cette page\"></p>" : '';
    // Présélections sur les select
    $select_matieres = str_replace("\"${r['mat']}\"","\"${r['mat']}\" selected",$GLOBALS['select_matieres']);  
    $select_protection = str_replace("\"${r['protection']}\"","\"${r['protection']}\" selected",$GLOBALS['select_protection']);  
  }
  // Affichage du formulaire
  echo <<<FIN
  <div class="item admin">
  <form action="${GLOBALS['p']}" method="post">$valide1
    <h3>$titre</h3>
    <p class="boutons">$valide$monte$descend$suppr
    </p>
    <p class="ligne"><label for="titre$fid">Titre&nbsp;: </label><input type="text" id="titre$fid" name="titre" value="${r['titre']}" size="80"></p>
    <p class="ligne"><label for="nom$fid">Nom dans le menu&nbsp;: </label><input type="text" id="nom$fid" name="nom" value="${r['nom']}" size="50"></p>
    <p class="ligne"><label for="cle$fid">Clé dans l'adresse&nbsp;: </label><input type="text" id="cle$fid" name="cle" value="${r['cle']}" size="30"></p>
    <p class="ligne"><label for="mat$fid">Matière associée&nbsp;: </label>
      <select id="mat$fid" name="mat"$disabled>
        $select_matieres
      </select>
    </p>
    <p class="ligne"><label for="bandeau$fid">Texte de début&nbsp;:</label></p>
    <textarea class="nojs" id="bandeau$fid" name="bandeau" rows="2" cols="100">${r['bandeau']}</textarea>
    <p class="ligne"><label for="protection">Accès&nbsp;: </label>
      <select id="protection" name="protection">$select_protection
      </select>
    </p>$vide
    <input type="hidden" name="id" value="$id">
    <input type="hidden" name="action" value="page">
  </form>
  </div>


FIN;
}

// Fonction d'affichage des infos
function affichage_info($r)  {
  if ( $id = $r['id'] )  {
    if ( $r['cache'] )  {
      $diff = ' (information non diffusée sur la partie publique)';
      $cache_classe = ' cache';
      $cache = "\n      <input type=\"submit\" name=\"montre\" value=\"Montrer\" title=\"Diffuser l'information, la rendre visible sur la partie publique\">";
    }
    else  {
      $cache_classe = $diff = '';
      $cache = "\n      <input type=\"submit\" name=\"cache\" value=\"Cacher\" title=\"Ne plus diffuser l'information, la rendre invisible sur la partie publique\">";
    }
    
    $titre = "Information n°${r['ordre']}&nbsp;: ".( ( strlen($r['titre']) ) ? $r['titre'] : '[Information sans titre]' ).$diff;
    $valide1 = $cachecheck = '';
    $valide = "\n      <input type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications sur le titre ou le texte\">";
    $monte = ( $r['ordre'] > 1 ) ? "\n      <input type=\"submit\" name=\"monte\" value=\"&uarr;\" title=\"Remonter l'information dans l'ordre d'apparition\">" : '';
    $descend = ( $r['ordre'] < $GLOBALS['max'] ) ? "\n      <input type=\"submit\" name=\"descend\" value=\"&darr;\" title=\"Descendre l'information dans l'ordre d'apparition\">" : '';
    $suppr = "\n      <input type=\"submit\" name=\"supprime\" value=\"Supprimer\" title=\"Supprimer l'information\">";
  }
  else  {
    $titre = 'Ajouter une nouvelle information';
    $valide1 = "\n    <input class=\"bouton\" type=\"submit\" name=\"modifie\" value=\"Valider\" title=\"Valider les modifications\">";
    $valide = $monte = $descend = $suppr = $cache_classe = $diff = $cache = '';
    $cachecheck = "\n    <p class=\"ligne\"><label for=\"cache\">Ne pas diffuser sur la partie publique&nbsp;: </label><input type=\"checkbox\" id=\"cache\" name=\"cache\" value=\"1\"></p>";
  }
  echo <<<FIN
  <div class="item admin$cache_classe">
  <form action="${GLOBALS['p']}" method="post">$valide1
    <h3>$titre</h3>
    <p class="boutons">$valide$monte$descend$cache$suppr
    </p>
    <p class="transparent"><input class="ligne" type="text" name="titre" size=50 maxlength=65533 value="${r['titre']}"></p>
    <textarea name="texte" class="mat${GLOBALS['mid']}" rows="10" cols="100">${r['texte']}</textarea>$cachecheck
    <input type="hidden" name="id" value="${r['id']}">
    <input type="hidden" name="action" value="info">
  </form>
  </div>


FIN;
}

// Gestion des pages
if ( !isset($pid) )  {
  // Pour chaque matière
  $matieres = array(-1=>array('id'=>0,'nom'=>'Menu général'))+$matieres;
  foreach ( $matieres as $m )  {
    echo "  <h2>${m['nom']}</h2>\n\n";
    // Formulaire vide pour une nouvelle page et aide générale
    affichage_page(array('id' => 0, 'cle' => 'cle_de_la_page', 'nom' => 'Nom de la page', 'titre' => 'Titre de la page', 'bandeau' => 'Texte (éventuel) marqué en haut de la page', 'mat' => $m['id']));
    // Affichage des pages existantes
    $resultat = $mysqli->query("SELECT p.id, p.ordre, p.cle, p.nom, p.mat, p.titre, p.bandeau, p.protection, COUNT(i.id) AS n
                                FROM pages AS p LEFT JOIN infos AS i ON i.page = p.id WHERE p.mat = ${m['id']} GROUP BY p.id");
    if ( $max = $resultat->num_rows )  {
      while ( $r = $resultat->fetch_assoc() )
        affichage_page($r);
      $resultat->free();
    }
  }
}

// Gestion des informations
else  {
  // Formulaire de modification de la page
  $resultat = $mysqli->query("SELECT (-p.id) AS id, p.ordre, p.cle, p.nom, p.mat, p.titre, p.bandeau, p.protection, COUNT(i.id) AS n
                              FROM pages AS p LEFT JOIN infos AS i ON i.page = p.id WHERE p.id = $pid GROUP BY p.id");
  $r = $resultat->fetch_assoc();
  affichage_page($r);
  $mid = $r['mat'];
  $resultat->free();
  
  // Formulaire de nouvelle information
  affichage_info(array('id' => 0, 'cache' => 0, 'titre' => 'Titre de l\'information', 'texte' => ''));
  
  // Formulaire de modification des informations
  $resultat = $mysqli->query("SELECT id, ordre, cache, titre, texte FROM infos WHERE page = $pid");
  if ( $max = $resultat->num_rows )  {
    while ( $r = $resultat->fetch_assoc() )
      affichage_info($r);
    $resultat->free();
  }
  else
    echo "  <h2>Il n'y a actuellement aucune information enregistrée pour cette page.</h2>\n\n";
}

$mysqli->close();

// Bas de page
include('bas.php');
?>
