<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['modifie']) )  {

  // Connexion à la base de données avec les droits d'écriture
  $mysqli->close();
  $mysqli = mysql_ecriture();
  
  // Récupérations des semaines
  $resultat = $mysqli->query('SELECT id, colle, vacances, DATE_FORMAT(debut,\'%d/%m/%Y\') AS debut FROM semaines');
  $modif = array();
  $colles = ( isset($_REQUEST['colles']) ) ? $_REQUEST['colles'] : array();
  $vacances = $_REQUEST['vacances'];

  // Validation des données envoyées et modifications
  while ( $r = $resultat->fetch_assoc() )  {
    if ( !is_numeric($v = $vacances[$r['id']]) )
      $v = 0;
    $c = ( isset($colles[$r['id']]) && !$v ) ? 1 : 0;
    if ( ( $c != $r['colle'] ) || ( $v != $r['vacances'] ) )  {
      requete('semaines',"UPDATE semaines SET colle = $c, vacances = $v WHERE id = ${r['id']}");
      $modif[] = "semaine du ${r['debut']}";
    }
  }
  
  // Message à afficher
  if ( empty($modif) )
    $message = 'Aucune modification à effectuer.';
  else
    $message = ( empty($modif) ) ? 'Aucune modification à effectuer.' : 'Les modifications ('.implode(',',$modif).') ont bien été réalisées.';

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}

//////////
// HTML //
//////////
// Haut de page, menu et message
$p = "semaines";
$t = 'Modifications des semaines du planning annuel';
include('haut.php');

// Affichage de l'aide générale et du haut du tableau
?>
  
  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ci-dessous modifier le planning annuel, c'est-à-dire pour chaque semaine de l'année, préciser s'il s'agit&nbsp;:
    <ul>
      <li>d'une semaine de colle (case <em>Colle ou non</em> cochée), qui pourra recevoir des programmes de colles et des notes de colles.</li>
      <li>d'une semaine sans colle (case <em>Colle ou non</em> décochée), qui ne pourra recevoir ni programmes de colles, ni notes de colles.</li>
      <li>d'une semaine de vacances (colonne <em>Vacances</em>) qui ne pourra recevoir ni cahier de texte, ni programmes de colles, ni notes de colles.</li>
    </ul>
    <p>Les vacances de deux semaines (toutes en fait :-) ) sont donc à marquer deux fois.</p>
    <p>Il est préférable de décocher la case <em>Colle ou non</em> lorsque l'on sait qu'il n'y aura pas de colle, comme souvent en début ou en fin d'année&nbsp;: cela modifie l'affichage des programmes de colles (&laquo;&nbsp;Il n'y a pas de colle cette semaine&nbsp;&raquo; au lieu de &laquo;&nbsp;Le programme de colles de cette semaine n'est pas défini.&nbsp;&raquo;), et évite les erreurs d'écriture des programmes.</p>
  </div>

  <div class="item admin nojs">
    <form action="" method="post">
      <input type="submit" class="bouton" name="modifie" value="Valider" title="Valider les modifications">
      <h3>Modifier le planning annuel</h3>
      <table class="admin">
        <thead>
          <tr>
            <th>Début de semaine</th>
            <th>Colle ou non</th>
            <th>Vacances</th>
          </tr>
        </thead>
        <tbody>
<?php
// Récupération et affichage des matières
$semaine = array('Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi');
$resultat = $mysqli->query('SELECT id, DATE_FORMAT(debut,\'%w\') AS jour, DATE_FORMAT(debut,\'%d/%m/%Y\') AS debut, IF(colle=1,\' checked\',\'\') AS colle, vacances FROM semaines');
$mysqli->close();
while ( $r = $resultat->fetch_assoc() )  {
  $select = str_replace("\"${r['vacances']}\"","\"${r['vacances']}\" selected",'<option value="0">Période scolaire</option><option value="1">Vacances de Toussaint</option><option value="2">Vacances de Noël</option><option value="3">Vacances d\'hiver</option><option value="4">Vacances de printemps</option>');
  $r['jour'] = $semaine[$r['jour']];
  echo <<<FIN
          <tr>
            <td>${r['jour']} ${r['debut']}</td>
            <td><input type="checkbox" name="colles[${r['id']}]" value="1"${r['colle']}></td>
            <td><select name="vacances[${r['id']}]">$select</select></td>
          </tr>

FIN;
}
$resultat->free();

// Fin du formulaire
?>
        </tbody>
      </table>

    </form>
  </div>

  <script type="text/javascript">
$( function() {
  $('select').change(function () {
    if ( $(this).val() == 0 )  {
      $(this).parent().prev().children('input').prop('checked',true);
    }
    else  {
      $(this).parent().prev().children('input').prop('checked',false);
    }
  });
  $('input:checkbox').change(function () {
    if ( $(this).is(':checked') )  {
      $(this).parent().next().children('select').val(0);
    }
  });
});
  </script>

<?php
// Bas de page
include('bas.php');
?>
