<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

// Récupération des données de l'utilisateur
$resultat = $mysqli->query("SELECT id, login, nom, prenom, genre, mail, mdp, matieres, timeout, mailexp, mailcopy
                            FROM utilisateurs WHERE id = ${_SESSION['id']}");
$u = $resultat->fetch_assoc();
$resultat->free();

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['modifie']) )  {
  
  // Vérification du mot de passe
  if ( ( sha1($_REQUEST['mdp0']) != $u['mdp'] ) && ( ( $u['mdp'] != 'pas de mot de passe' ) || ( $_REQUEST['action'] != 'mdp' ) ) )
    $message = 'Le mot de passe fourni est incorrect. Les modifications n\'ont pas été effectuées.';
  else  {

    $requete = array();
    $modif = array();
    
    // Validation des données envoyées
    switch ( $_REQUEST['action'] )  {
      case 'identite':
        $login = $mysqli->real_escape_string($_REQUEST['login']);
        $prenom = mb_convert_case($mysqli->real_escape_string($_REQUEST['prenom']),MB_CASE_TITLE,'UTF-8');
        $nom = mb_convert_case($mysqli->real_escape_string($_REQUEST['nom']),MB_CASE_TITLE,'UTF-8');
        $mail = strtolower($mysqli->real_escape_string($_REQUEST['mail']));
        if ( in_array($genre = $_REQUEST['genre'],array(1,2,3)) && ( $genre != $u['genre'] ) )  {
          $u['genre'] = $genre;
          $requete[] = "genre = $genre";
          $modif[] = 'genre';
        }
        if ( strlen($login) && ( $login != $u['login'] ) )  {
          // Vérification que le login n'existe pas déjà
          $resultat = $mysqli->query("SELECT id FROM utilisateurs WHERE login = '$login'");
          if ( $resultat->num_rows )
            $resultat->free();
          else  {
            $u['login'] = $login;
            $requete[] = "login = '$login'";
            $modif[] = 'identifiant';
            $_SESSION['login'] = $login;
          }
        }
        if ( strlen($nom) && ( $nom != $u['nom'] ) )  {
          $u['nom'] = $nom;
          $requete[] = "nom = '$nom'";
          $modif[] = 'nom';
        }
        if ( strlen($prenom) && ( $prenom != $u['prenom'] ) )  {
          $u['prenom'] = $prenom;
          $requete[] = "prenom = '$prenom'";
          $modif[] = 'prénom';
        }
        if ( ( $mail != $u['mail'] ) && ( filter_var($mail,FILTER_VALIDATE_EMAIL) || !strlen($mail) ) )  {
          $u['mail'] = $mail;
          $requete[] = "mail = '$mail'";
          $modif[] = 'mail';
        }
        break;
      
      case 'mdp':
        if ( strlen($mdp1 = $_REQUEST['mdp1']) && ( $mdp1 == $_REQUEST['mdp2'] ) && ( ( $mdp1 = sha1($mdp1) ) != $u['mdp'] ) )  {
          $u['mdp'] = $mdp1;
          $requete[] = "mdp = '$mdp1'";
          $modif[] = 'mot de passe';
        }
        break;

      case 'params':
        $mailcopy = ( isset($_REQUEST['mailcopy']) ) ? 1 : 0;
        if ( is_numeric( $timeout = $_REQUEST['timeout'] ) && ( $timeout != $u['timeout'] ) )  {
          if ( $timeout < 60 )
            $timeout = 60;
          $u['timeout'] = $timeout;
          $requete[] = "timeout = $timeout";
          $modif[] = 'temps de connexion';
          $_SESSION['timeout'] = $timeout;
        }
        if ( in_array($mailexp = $_REQUEST['mailexp'],array(1,2,3,4)) && ( $mailexp != $u['mailexp'] ) )  {
          $u['mailexp'] = $mailexp;
          $requete[] = "mailexp = $mailexp";
          $modif[] = 'champ expéditeur des mails';
        }
        if ( $mailcopy != $u['mailcopy'] )  {
          $u['mailcopy'] = $mailcopy;
          $requete[] = "mailcopy = '$mailcopy'";
          $modif[] = 'mise en copie des mails';
        }
        break;
    
      case 'matieres':
        $m = ( isset($_REQUEST['matieres']) ) ? array_filter(array_unique($_REQUEST['matieres'],SORT_NUMERIC),'is_numeric') : array();
        if ( ( $m = implode(',',$m) ) != $u['matieres'] )  {
          $requete[] = "matieres = '$m'";
          $modif[] = 'matières';
          $_SESSION['matieres'] = $m;
          // Modification de $matieres, définie par debut.php et utilisée notamment pour le menu (haut.php)
          $resultat = $mysqli->query("SELECT id, cle, nom FROM matieres WHERE FIND_IN_SET(id,'$m') ORDER BY FIND_IN_SET(id,'$m')");
          $matieres = array();
          if ( $resultat->num_rows )  {
            while ( $r = $resultat->fetch_assoc() )
              $matieres[] = $r;
            $resultat->free();
          }
        }
        break;
    }

    if ( empty($requete) )
      $message = 'Aucune modification à effectuer.';
    else  {
      $requete = implode(', ',$requete);
      $modif = implode(', ',$modif);
      // Connexion à la base de données avec les droits d'écriture
      $mysqli->close();
      $mysqli = mysql_ecriture();
      if ( requete('utilisateurs',"UPDATE utilisateurs SET $requete WHERE id = ${u['id']}") )
        $message = "Les modifications ($modif) ont bien été réalisées.";
    }
  }

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}  

//////////////////////////////////////////////////////////////////
// Modifications d'une matière : données, suppressions massives //
//////////////////////////////////////////////////////////////////
elseif ( isset($_REQUEST['id']) && in_array($id = $_REQUEST['id'],explode(',',$_SESSION['matieres'])) )  {

  // Vérification du mot de passe
  if ( sha1($_REQUEST['mdp0']) != $u['mdp'] )
    $message = 'Le mot de passe fourni est incorrect. Les modifications n\'ont pas été effectuées.';
  else  {
    // Récupération des données de la matière à modifier
    $resultat = $mysqli->query("SELECT cle, nom, colles_protection, cdt_protection FROM matieres WHERE id = $id");
    $r = $resultat->fetch_assoc();
    // Connexion à la base de données avec les droits d'écriture
    $mysqli->close();
    $mysqli = mysql_ecriture();

    /////////////////////////////////////////////
    // Modifications des données d'une matière //
    /////////////////////////////////////////////
    if ( isset($_REQUEST['modifie_matiere']) )  {
      $requete = array();
      $modif = array();

      // Validation des données envoyées
      $cle = $mysqli->real_escape_string($_REQUEST['cle']);
      $nom = $mysqli->real_escape_string($_REQUEST['nom']);
      if ( strlen($nom) && ( $nom != $r['nom'] ) )  {
        $requete[] = "nom = '$nom'";
        $modif[] = 'nom';
        requete('reps',"UPDATE reps SET nom = '$nom' WHERE matiere = $id AND parent = 0");
      }
      if ( strlen($cle) && ( $cle != $r['cle'] ) )  {
        $requete[] = "cle = '$cle'";
        $modif[] = 'clé';
      }
      if ( in_array($colles_protection = $_REQUEST['colles_protection'],array(0,1,2,3)) && ( $colles_protection != $r['colles_protection'] ) )  {
        $requete[] = "colles_protection = $colles_protection";
        $modif[] = 'accès aux programmes de colles';
      }
      if ( in_array($cdt_protection = $_REQUEST['cdt_protection'],array(0,1,2,3)) && ( $cdt_protection != $r['cdt_protection'] ) )  {
        $requete[] = "cdt_protection = $cdt_protection";
        $modif[] = 'accès au cahier de texte';
      }
     
      if ( empty($requete) )
        $message = 'Aucune modification à effectuer.';
      else  {
        $requete = implode(', ',$requete);
        $modif = implode(', ',$modif);
        if ( requete('matieres',"UPDATE matieres SET $requete WHERE id = $id") )
          $message = "Les modifications ($modif) sur la matière &laquo;&nbsp;${r['nom']}&nbsp;&raquo; ont bien été réalisées.";
        // Modification de $matieres, définie par debut.php et utilisée notamment pour le menu (haut.php)
        $resultat = $mysqli->query("SELECT id, cle, nom FROM matieres
                                    WHERE FIND_IN_SET(id,'${_SESSION['matieres']}') ORDER BY FIND_IN_SET(id,'${_SESSION['matieres']}')");
        $matieres = array();
        if ( $resultat->num_rows )  {
          while ( $r = $resultat->fetch_assoc() )
            $matieres[] = $r;
          $resultat->free();
        }
      }
    }

    ////////////////////////////////////////////////////////
    // Suppression des programmes de colles d'une matière //
    ////////////////////////////////////////////////////////
    elseif ( isset($_REQUEST['supprime_colles']) )  {
      if ( requete('colles',"DELETE FROM colles WHERE matiere = $id") )  {
        requete('matieres',"UPDATE matieres SET colles = 0 WHERE id = $id");
        $message = "Tous les programmes de colles de la matière &laquo;&nbsp;${r['nom']}&nbsp;&raquo; ont bien été supprimés.";
      }
    }
    
    //////////////////////////////////////////////////
    // Suppression du cahier de texte d'une matière //
    //////////////////////////////////////////////////
    elseif ( isset($_REQUEST['supprime_cdt']) )  {
      if ( requete('cdt',"DELETE FROM cdt WHERE matiere = $id") )  {
        requete('matieres',"UPDATE matieres SET cdt = 0 WHERE id = $id");
        $message = "L'ensemble du contenu du cahier de texte de la matière &laquo;&nbsp;${r['nom']}&nbsp;&raquo; a bien été supprimé.";
      }
    }

    /////////////////////////////////////////////
    // Suppression des documents d'une matière //
    /////////////////////////////////////////////
    elseif ( isset($_REQUEST['supprime_docs']) )  {
      if ( requete('reps',"DELETE FROM reps WHERE matiere = $id AND parent > 0") )  {
        $resultat = $mysqli->query("SELECT GROUP_CONCAT(CONCAT('../documents/',lien) SEPARATOR ' ') AS chemins FROM docs WHERE matiere = $id");
        $p = $resultat->fetch_assoc();
        $resultat->free();
        // Suppression physique ( $r['chemin'] est "null" si pas de document à supprimer)
        if ( $p['chemins'] )
          exec("rm -rf ${p['chemins']}");
        requete('docs',"DELETE FROM docs WHERE matiere = $id");
        requete('matieres',"UPDATE matieres SET docs = 0 WHERE id = $id");
        $message = "Tous les documents de la matière &laquo;&nbsp;${r['nom']}&nbsp;&raquo; ont bien été supprimés.";
      }
    }
    
    /////////////////////////////////////////
    // Suppression des notes d'une matière //
    /////////////////////////////////////////
    elseif ( isset($_REQUEST['supprime_notes']) )  {
      if ( requete('notes',"DELETE FROM notes WHERE matiere = $id") )  {
        requete('matieres',"UPDATE matieres SET notes = 0 WHERE id = $id");
      $message = "Toutes les notes de la matière &laquo;&nbsp;${r['nom']}&nbsp;&raquo; ont bien été supprimées.";
      }
    }
  }

  // Passage en connexion MySQL en lecture seulement
  $mysqli->close();
  $mysqli = mysql_lecture();
}


//////////////
//// HTML ////
//////////////
// Haut de page, menu et message
$p = "prefs";
$t = 'Préférences';
if ( $u['mdp'] == 'pas de mot de passe' )  {
  if ( !isset($message) )
    $message = 'IMPORTANT : votre mot de passe a été réinitialisé. Vous devez absolument le redéfinir ci-dessous.';
  $mdp0 = '    <input type="hidden" name="mdp0" value="réinitialisé">';
}
else
  $mdp0 = '    <p class="ligne"><label for="mdp02">Mot de passe actuel&nbsp;: </label><input type="password" id="mdp02" name="mdp0" value=""></p>';
include('haut.php');

?>

  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ci-dessous modifier les réglages qui vous concernent personnellement (identité, votre mot de passe, matières associées), ainsi que les réglages de chaque matière qui vous est associée. Pour valider chaque modification sur cette page, vous devrez renseigner votre mot de passe.</p>
    <h4>Identité</h4>
    <p>Vous pouvez modifier votre identité. L'<em>identifiant</em> ne sert qu'à la connexion, seuls les autres professeurs (via la page <a href="utilisateurs">Utilisateurs</a>) peuvent le voir. Les accents et les majuscules n'y posent pas problème. Le <em>prénom</em> et le <em>nom</em> sont obligatoires, l'<em>adresse mail</em> ne l'est pas. Cette dernière est cependant nécessaire pour activer la fonction <a href="mail">Envoi de mail</a> ou pour que des collègues puissent vous mettre en copie de mails envoyés via Cahier de Prépa et elle apparaîtra bien sûr comme expéditeur des mails que vous enverrez.</p>
    <h4>Mot de passe</h4>
    <p>Vous pouvez modifier votre <em>mot de passe</em>. Il faut bien entendu renseigner le <em>mot de passe actuel</em> et taper deux fois le <em>nouveau mot de passe</em> pour éviter les erreurs de frappe.</p>
    <p>Les mots de passe sont chiffrés avant d'être stockés dans la base de données. Cela signifie que, sauf s'il est trop simple, votre mot de passe sera en complète sécurité : même l'administrateur du site, l'hébergeur ou d'éventuels pirates ne pourront jamais y avoir accès. Lors de la connexion, le mot de passe entré est chiffré à son tour et ce sont les deux chiffrements qui sont comparés. Attention&nbsp;: il est très dangereux que ce mot de passe soit évident, parce qu'un élève pourrait le deviner en vous voyant de loin le taper par exemple. Un bon mot de passe est un mot de passe d'au moins 8 caractères contenant des lettres, des chiffres et au moins un symbole parmi «&nbsp;?&nbsp;;&nbsp;:&nbsp;!&nbsp;.&nbsp;,-&nbsp;_&nbsp;». Mais vous faîtes ce que vous voulez...</p>
    <h4>Les préferences techniques</h4>
    <p>Quelques paramètres techniques sont modifiables&nbsp;:</p>
    <ul>
      <li>le <em>temps de déconnexion</em> est en secondes le temps au bout duquel, sans aucune action, votre session sera supprimée. À chaque chargement de page, le décompte repart de zéro. Par défaut, il est réglé à 15 minutes. Le but est d'éviter qu'un utilisateur passant derrière vous sur un ordinateur public puisse usurper votre identifiant. Si vous avez la bonne habitude de vous déconnecter systématiquement et de ne pas laisser seul un ordinateur public où vous êtes connecté, cela ne pose aucun problème de le régler à une durée plus longue, 1&nbsp;h par exemple.</li>
      <li>le <em>champ expéditeur pour les mails</em> est le réglage de ce qui apparaîtra comme expéditeur de vos mails. Vous avez le choix entre des valeurs plus ou moins formelles, selon votre relation avec vos élèves.</li>
      <li>la case à cocher <em>Étre en copie des mails envoyés</em> permet de recevoir en copie cachée (les destinataires ne le voient pas) les mails que vous envoyez via la page <a href="mail">Envoi de mail</a>.</li>
    </ul>
    <h4>Les matières qui vous sont associées</h4>
    <p>Vous pouvez choisir quelles matières apparaissent dans le menu de gauche, dans votre interface d'administration, et dans quel ordre elles apparaissent. Ce choix ne modifie pas le menu de la partie publique (ni quelles matières y sont affichées, ni leur ordre d'apparition). Une matière peut être associée à plusieurs professeurs.</p>
    <p>Vous ne pourrez modifier/consulter que les données (cahiers de texte, programmes de colles, documents, notes) des matières listées ici.</p>
    <h4>Préférences de matière</h4>
    <p>Pour chaque matière associée à votre compte, vous pouvez modifier&nbsp;:</p>
    <ul>
      <li>le <em>nom complet</em> qui s'affiche dans le menu et dans les titres des pages. Mettez une majuscule au début.</li>
      <li>la <em>clé dans l'adresse</em> qui est un mot-clé utilisé uniquement dans l'adresse des pages associées à la matière. Il vaut mieux que ce soit un mot unique, court et sans majuscule. Par exemple, «&nbsp;maths&nbsp;», «&nbsp;phys&nbsp;»...</li>
    </ul>
    <p>L'<em>accès au programmes de colles</em> et l'<em>accès au cahier de texte</em> peuvent être choisis parmi quatre possibilités&nbsp;:</p>
    <ul>
      <li><em>Visible de tous</em>&nbsp;: accessible de tout visiteur, sans identification.</li>
      <li><em>Visible pour les élèves, colleurs, professeurs</em>&nbsp;: accessible uniquement par tout utilisateur après identification. Il faut donc avoir un compte validé (voir l'aide de la page <a href="utilisateurs">Utilisateurs</a>) pour y accéder.</li>
      <li><em>Visible pour les colleurs, professeurs</em>&nbsp;: accessible uniquement par les utilisateurs de type colleur ou professeur.</li>
      <li><em>Visible pour les professeurs</em>&nbsp;: accessible uniquement par les utilisateurs de type professeur (vous et vos collègues).</li>
    </ul>
    <p>Quel que soit ce choix, les liens dans le menu de la partie publique apparaîtront pour tout visiteur (si le cahier de texte/programme de colles est non vide uniquement), tout comme le lien vers les documents.</p>
  </div>
<?php

// Formulaire de modification de l'identité
$select_genre = str_replace("\"${u['genre']}\"","\"${u['genre']}\" selected",'
        <option value="1">M.</option>
        <option value="2">Mme</option>
        <option value="3">Melle</option>');

echo <<<FIN
  <div class="item admin">
  <form action="" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications">
    <h3>Modifier mon identité</h3>
    <p class="ligne"><label for="genre">M-Mme-Melle&nbsp;:</label>
      <select name="genre" id="genre">$select_genre
      </select>
    </p>
    <p class="ligne"><label for="login">Identifiant&nbsp;: </label><input type="text" id="login" name="login" value="${u['login']}" size="50"></p>
    <p class="ligne"><label for="prenom">Prénom&nbsp;: </label><input type="text" id="prenom" name="prenom" value="${u['prenom']}" size="50"></p>
    <p class="ligne"><label for="nom">Nom&nbsp;: </label><input type="text" id="nom" name="nom" value="${u['nom']}" size="50"></p>
    <p class="ligne"><label for="mail">Adresse mail&nbsp;: </label><input type="text" id="mail" name="mail" value="${u['mail']}" size="50"></p>
    <p class="ligne"><label for="mdp01">Mot de passe&nbsp;: </label><input type="password" id="mdp01" name="mdp0" value=""></p>
    <input type="hidden" name="action" value="identite">
  </form>
  </div>

FIN;

// Formulaire de modification du mot de passe
?>

  <div class="item admin">
  <form action="" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications">
    <h3>Modifier mon mot de passe</h3>
<?php echo $mdp0; ?>

    <p class="ligne"><label for="mdp1">Nouveau mot de passe&nbsp;: </label><input type="password" id="mdp1" name="mdp1" value=""></p>
    <p class="ligne"><label for="mdp2">Confirmation&nbsp;: </label><input type="password" id="mdp2" name="mdp2" value=""></p>
    <input type="hidden" name="action" value="mdp">
  </form>
  </div>

<?php
// Formulaire de modification des préférences techniques
if ( strlen($u['mail']) )  {
  switch ( $u['genre'] )  {
    case 1 : $g = 'M. '; break;
    case 2 : $g = 'Mme '; break;
    case 3 : $g = 'Melle '; break;
    default : $g = '';
  }
  $select_mailexp = str_replace("\"${u['mailexp']}\"","\"${u['mailexp']}\" selected","
        <option value=\"1\">$g${u['nom']}</option>
        <option value=\"2\">$g${u['prenom']} ${u['nom']}</option>
        <option value=\"3\">${u['prenom']} ${u['nom']}</option>
        <option value=\"3\">${u['nom']}</option>");
}
else
  $select_mailexp = '
        <option value="1">Il faut définir votre adresse mail pour pouvoir en envoyer.</option>';
$u['mailcopy'] = ( $u['mailcopy']) ? ' checked' : '';
echo <<<FIN

  <div class="item admin">
  <form action="" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications">
    <h3>Modifier mes préférences techniques</h3>
    <p class="ligne"><label for="timeout">Temps de déconnexion&nbsp;: </label><input type="text" id="timeout" name="timeout" value="${u['timeout']}" size="3"></p>
    <p class="ligne"><label for="mailexp">Champ expéditeur pour les mails&nbsp;:</label>
      <select name="mailexp" id="mailexp">$select_mailexp
      </select>
    </p>
    <p class="ligne"><label for="mailcopy">Étre en copie des mails envoyés&nbsp;: </label><input type="checkbox" id="mailcopy" name="mailcopy" value="1"${u['mailcopy']}></p>
    <p class="ligne"><label for="mdp04">Mot de passe&nbsp;: </label><input type="password" id="mdp04" name="mdp0" value=""></p>
    <input type="hidden" name="action" value="params">
  </form>
  </div>

FIN;

// Formulaire de modification des matières
$resultat = $mysqli->query("SELECT id, nom, ordre FROM matieres ORDER BY ordre");
$select = "    <p id=\"ligneXX\" class=\"ligne\"><label for=\"matiereXX\">Matière n°XX&nbsp;:</label>\n      <select name=matieres[XX]>\n";
$max = $resultat->num_rows;
while ( $r = $resultat->fetch_assoc() )
  $select .= "        <option value=\"${r['id']}\">${r['nom']}</option>\n";
$resultat->free();
$select .= "      </select>\n    </p>\n";
?>

  <div class="item admin">
  <form action="" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications">
    <h3>Modifier mes matières</h3>
<?php
$n = 0;
foreach ( $matieres as $m )
  echo str_replace("\"${m['id']}\"","\"${m['id']}\" selected",str_replace('XX',++$n,$select));
?>
    <p class="ligne"><label for="mdp03">Mot de passe&nbsp;: </label><input type="password" id="mdp03" name="mdp0" value=""></p>
    <p class="boutons">
      <input type="button" id="ajouter" value="Ajouter une matière">
      <input type="button" id="retirer" value="Retirer la dernière matière">
    </p>
    <input type="hidden" name="action" value="matieres">
  </form>
  </div>
<?php

// Formulaire sur chaque matière enregistrée
$select_protection = '
        <option value="0">Visible de tous</option>
        <option value="1">Visible pour les élèves, colleurs, profs</option>
        <option value="2">Visible pour les colleurs et les profs</option>
        <option value="3">Visible pour les profs uniquement</option>';
$resultat = $mysqli->query("SELECT id, cle, nom, colles, cdt, docs, notes, colles_protection, cdt_protection
                            FROM matieres WHERE FIND_IN_SET(id,'${_SESSION['matieres']}') ORDER BY FIND_IN_SET(id,'${_SESSION['matieres']}')");
while ( $r = $resultat->fetch_assoc() )  {
  $id = $r['id'];
  if ( $r['colles'] + $r['cdt'] + $r['docs'] + $r['notes'] )  {
    $boutons = '';//"\n    <p class=\"boutons\">";
    if ( $r['colles'] )
      $boutons .= "\n    <p class=\"ligne\"><label>Supprimer tous les programmes de colles&nbsp;</label><input type=\"submit\" name=\"supprime_colles\" value=\"Supprimer\"></p>";
    if ( $r['cdt'] )
      $boutons .= "\n    <p class=\"ligne\"><label>Supprimer tout le cahier de texte&nbsp;</label><input type=\"submit\" name=\"supprime_cdt\" value=\"Supprimer\"></p>";
    if ( $r['docs'] )
      $boutons .= "\n    <p class=\"ligne\"><label>Supprimer tous les documents&nbsp;</label><input type=\"submit\" name=\"supprime_docs\" value=\"Supprimer\"></p>";
    if ( $r['notes'] )
      $boutons .= "\n    <p class=\"ligne\"><label>Supprimer toutes les notes&nbsp;</label><input type=\"submit\" name=\"supprime_notes\" value=\"Supprimer\"></p>";
  }
  else
    $boutons = '';
  $select_colles = str_replace("\"${r['colles_protection']}\"","\"${r['colles_protection']}\" selected",$select_protection);
  $select_cdt = str_replace("\"${r['cdt_protection']}\"","\"${r['cdt_protection']}\" selected",$select_protection);
  echo <<<FIN

  <div class="item admin">
  <form action="" method="post">
    <input class="bouton" type="submit" name="modifie_matiere" value="Valider" title="Valider les modifications">
    <h3>Modifier la matière <em>${r['nom']}</em></h3>
    <p class="ligne"><label for="nom$id">Nom complet&nbsp;: </label><input type="text" id="nom$id" name="nom" value="${r['nom']}" size="50"></p>
    <p class="ligne"><label for="cle$id">Clé dans l'adresse&nbsp;: </label><input type="text" id="cle$id" name="cle" value="${r['cle']}" size="30"></p>
    <p class="ligne"><label for="colles_protection$id">Accès aux programmes de colles&nbsp;: </label>
      <select id="colles_protection$id" name="colles_protection">$select_colles
      </select>
    </p>
    <p class="ligne"><label for="cdt_protection$id">Accès au cahier de texte&nbsp;: </label>
      <select id="cdt_protection$id" name="cdt_protection">$select_cdt
      </select>
    </p>$boutons
    <p class="ligne"><label for="mdp01$id">Mot de passe&nbsp;: </label><input type="password" id="mdp01$id" name="mdp0" value=""></p>
    <input type="hidden" name="id" value="$id">
    <input type="hidden" name="action" value="matiere">
  </form>
  </div>

FIN;
}
?>

  <script type="text/javascript">
$( function() {
  var n = <?php echo $n; ?>;
  var select = '<?php echo str_replace(array("'","\n",'  '),array("\'",'',''),$select); ?>';
  $('#ajouter').click(function () {
    if ( n < <?php echo $max; ?> )  {
      n++;
      $( select.replace(/XX/g,n) ).insertBefore($('#mdp03').parent());
    }
  });
  $('#retirer').click(function () {
    if ( n )  {
      $('#ligne'+n).remove();
      n--;
    }
  });

});
  </script>

<?php
$mysqli->close();
// Bas de page
include('bas.php');
exit();
?>
