<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php'); // fournit $mysqli et $matieres

// Fonction d'envoi du mail de création/validation du compte
function envoi_mail($type_action,$type_compte,$mail,$prenom,$nom,$login,$mdp)  {
  switch ($type_action)  {
    case 1:
      $action = 'vous créer un compte'; 
      $mdp = "\nVotre mot de passe est \"$mdp\". Ce mot de passe est temporaire : vous devrez obligatoirement le modifier dès votre prochaine connexion. Le mot de passe est entièrement chiffré avant son stockage dans la base de données, vous pouvez donc utiliser un mot de passe qui vous est familier. Il est conseillé, de façon générale, de mettre un mot de passe d'au moins 8 caractères, n'étant pas un mot du dictionnaire, comportant de lettres minuscules et majuscules, des chiffres et au moins un signe parmi «?,.;/:§!».\n"; 
      break;
    case 2:
      $action = 'valider votre compte';
      break;
  }
  switch ($type_compte)  {
    case 1:
      $texte = 'La connexion s\'effectue par le lien «Se connecter» situé en bas du menu. Vous aurez alors accès aux contenus que vos professeurs mettent en ligne de façon privée, ainsi qu\'aux éventuelles notes de colles que les colleurs entreront dans la base de données.';
      break;
    case 2:
      $texte = 'La connexion s\'effectue par le lien «Se connecter» situé en bas du menu. Vous aurez alors accès aux contenus que les professeurs pourraient en ligne de façon privée, réservés aux élèves ou uniquement aux colleurs. Vous pourrez aussi mettre des notes de colles.';
      break;
    case 3:
      $texte = 'Vous pouvez vous connecter à l\'interface d\'administration par le lien situé en bas du menu. Vous aurez alors la possibilité de :
* écrire des informations sur le site pour les élèves
* proposer les programmes de colles
* remplir votre cahier de texte
* mettre en ligne des documents
* envoyer des mails à tous vos élèves, à vos colleurs, à vos collègues
* consulter les notes de colles de vos colleurs
* modifier le site : ajouter/modifier des pages d\'informations, des matières, ajouter/supprimer des utilisateurs...

Vous pouvez vous associer à une ou plusieurs matières. Chaque contenu (chaque document, chaque page d\'information, le programme de colles, le cahier de texte) peut être rendu privé individuellement, et accessible soit pour les élèves et les colleurs, soit pour les colleurs uniquement, soit pour vous-même (et vos collègues) uniquement. 

Une page «Préférences» vous permettra de modifier votre mot de passe et l\'association des matières à votre compte.

N\'hésitez pas à faire part de toute remarque visant à améliorer Cahier de Prépa à l\'auteur du logiciel via <admin@cahier-de-prepa.fr>.';
      break;
  }
  mail($mail,'[Cahier de Prépa] Création de votre compte',
"Bonjour $prenom $nom

L'équipe pédagogique en charge du Cahier de Prépa se trouvant à l'adresse <http://${GLOBALS['site']}> vient de $action.

Votre identifiant est \"$login\" (sans les guillemets, attention à respecter les majuscules).
$mdp
$texte

Cordialement,
-- 
Cahier de Prépa
","From: ne-pas-repondre@cahier-de-prepa.fr\r\nContent-type: text/plain; charset=UTF-8");
  
}

///////////////////
// Modifications //
///////////////////
// Ajout d'un nouvel utilisateur
if ( isset($_REQUEST['ajoute']) )  {

  // Validation des données envoyées
  $genre = ( in_array($_REQUEST['genre'],array(1,2,3)) ) ? $_REQUEST['genre']+5 : 5;
  $prenom = mb_convert_case($mysqli->real_escape_string($_REQUEST['prenom']),MB_CASE_TITLE,'UTF-8');
  $nom = mb_convert_case($mysqli->real_escape_string($_REQUEST['nom']),MB_CASE_TITLE,'UTF-8');
  $mail = strtolower($mysqli->real_escape_string($_REQUEST['mail']));
  $mdp1 = sha1($_REQUEST['mdp1']);
  $autor = ( in_array($_REQUEST['autorisation'],array(1,2,3)) ) ? $_REQUEST['autorisation'] : 1;
  $matiere = ( ( $autor > 1 ) && isset($_REQUEST['matiere']) && is_numeric($_REQUEST['matiere']) ) ? $_REQUEST['matiere'] : '';
  // Login automatiquement généré
  $login = mb_strtolower(mb_substr($prenom,0,1,'UTF-8').str_replace(' ','_',$nom),'UTF-8');
  // Vérification que le login n'existe pas
  $resultat = $mysqli->query("SELECT id FROM utilisateurs WHERE login RLIKE '^${login}[0-9]*'");  
  if ( $resultat->num_rows )  {
    $login = $login.$resultat->num_rows;
    $resultat->free();
  }
  // Écriture dans la base de données'
  if ( $mdp1 != sha1($_REQUEST['mdp2']) )
    $message = 'Les mots de passe donnés ne sont pas identiques.';
  elseif ( strlen($mail) && !filter_var($mail,FILTER_VALIDATE_EMAIL) )
    $message = 'L\'adresse mail est incorrecte.';
  elseif ( strlen($prenom) && strlen($nom) && strlen($mdp1) )  {
    // Connexion à la base de données avec les droits d'écriture
    $mysqli->close();
    $mysqli = mysql_ecriture();
    if ( requete('utilisateurs',"INSERT INTO utilisateurs SET login = '$login', genre = $genre, prenom = '$prenom', nom = '$nom', mail = '$mail',
                                 mdp = '$mdp1', autorisation = $autor, matieres = '$matiere', timeout = 900, mailexp = 1, mailcopy = 1") )  {
      $message = 'Le compte de '.stripslashes("$prenom $nom").' a bien été enregistré.';
      if ( isset($_REQUEST['envoimail']) )  {
        envoi_mail(1,$autor,$mail,stripslashes($prenom),stripslashes($nom),stripslashes($login),$_REQUEST['mdp1']);
        $message .= " Un mail lui a été envoyé.";
      }
    }
    // Passage en connexion MySQL en lecture seulement
    $mysqli->close();
    $mysqli = mysql_lecture();
  }
}

// Validations de comptes en attente, suppressions
elseif ( isset($_REQUEST['modifie']) )  {

  // Vérification du mot de passe
  $resultat = $mysqli->query("SELECT mdp FROM utilisateurs WHERE id = ${_SESSION['id']}");
  $u = $resultat->fetch_assoc();
  $resultat->free();
  if ( sha1($_REQUEST['mdp']) != $u['mdp'] )
    $message = 'Le mot de passe fourni est incorrect. Les modifications n\'ont pas été effectuées.';
  else  {
    $message = array();
    // Connexion à la base de données avec les droits d'écriture
    $mysqli->close();
    $mysqli = mysql_ecriture();
  
    // Validation de comptes temporaires
    if ( isset($_REQUEST['valide']) && is_array($ids = $_REQUEST['valide']) )  {
      $ids = array_filter(array_unique($ids,SORT_NUMERIC),'is_numeric');
      $liste = array();
      foreach ( $ids as $u )  {
        $resultat = $mysqli->query("SELECT SUBSTRING(login,9) AS l, (SELECT COUNT(u2.id) FROM utilisateurs AS u2 WHERE u2.login=l) AS n,
                                    autorisation, mail, prenom, nom
                                    FROM utilisateurs AS u1 WHERE id = $u AND login RLIKE '^tmp[0-9]{5}'");
        if ( $resultat->num_rows )  {
          $r = $resultat->fetch_assoc();
          $login = ( $r['n'] ) ? $mysqli->real_escape_string($r['l'].$r['n']) : $mysqli->real_escape_string($r['l']);
          if ( requete('utilisateurs',"UPDATE utilisateurs SET login = '$login' WHERE id = $u") )  {
            $liste[] = $r['prenom'].' '.$r['nom'];
            if ( strlen($r['mail']) )
              envoi_mail(2,$r['autorisation'],$r['mail'],$r['prenom'],$r['nom'],$login,'');
          }
          $resultat->free();
        }
      }
      if ( !empty($liste) )
        $message[] = 'Les comptes suivants ont été validés&nbsp;: '.implode(', ',$liste);
    }

    // Suppression de comptes
    if ( isset($_REQUEST['supprime']) && is_array($ids = $_REQUEST['supprime']) )  {
      $ids = array_filter(array_unique($ids,SORT_NUMERIC),'is_numeric');
      $liste = array();
      foreach ( $ids as $u )  {
        $resultat = $mysqli->query("SELECT prenom, nom FROM utilisateurs WHERE id = $u");
        if ( $resultat->num_rows )  {
          $r = $resultat->fetch_assoc();
          if ( requete('utilisateurs',"DELETE FROM utilisateurs WHERE id = $u") )
            $liste[] = $r['prenom'].' '.$r['nom'];
          $resultat->free();
        }
      }
      if ( !empty($liste) )
        $message[] = ' Les comptes suivants ont été supprimés&nbsp;: '.implode(', ',$liste);
    }
    
    // Message
    $message = empty($message) ? 'Aucune action à effectuer.' : implode('<br>',$message);

    // Passage en connexion MySQL en lecture seulement
    $mysqli->close();
    $mysqli = mysql_lecture();
  }
}

//////////
// HTML //
//////////
// Haut de page, menu et message
$p = "utilisateurs";
$t = 'Modifications des utilisateurs';
include('haut.php');

// Récupération des matières
$resultat = $mysqli->query('SELECT id, nom FROM matieres');
$select_matieres = '';
while ( $r = $resultat->fetch_assoc() )
  $select_matieres .= "        <option value=\"${r['id']}\">${r['nom']}</option>\n";
$resultat->free();

// Aide générale et formulaires
?>

  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ci-dessous ajouter un utilisateur, consulter et supprimer les utilisateurs existants. Les utilisateurs sont séparés en trois types&nbsp;:</p>
    <ul>
      <li>Les <em>professeurs</em> peuvent accéder automatiquement à cette interface d'administration. Ils peuvent être associés ou non à une ou plusieurs matières (chaque professeur peut modifier les matières qui lui sont associées sur sa page de <a href="prefs">Préférences</a>).</li>
      <li>Les <em>colleurs</em> peuvent mettre des notes en se connectant sur la partie publique. Ils n'ont pas accès à l'interface d'administration. Ils sont associés à une matière.</li>
      <li>Les élèves peuvent voir leurs notes s'il y en a.</li>
    </ul>
    <p>Mis à part les notes, les utilisateurs ayant un compte ce Cahier de Prépa peuvent se connecter sur la partie publique pour accéder aux contenus dont l'accès a été protégé. Il y a quatre niveaux de protection&nbsp;:</p>
    <ul>
      <li>visible de tout visiteur, sans identification</li>
      <li>visible uniquement pour les utilisateurs ayant un compte, qu'ils soient élèves, colleurs ou professeurs</li>
      <li>visible uniquement pour les utilisateurs de type colleur ou professeur</li>
      <li>visible uniquement pour les professeurs</li>
    </ul>
    <p>L'accès à chaque contenu est à paramétrer de façon individuelle, pour chaque contenu.</p>
    <h4>Nouvel utilisateur</h4>
    <p>Vous pouvez créer un nouvel utilisateur. Il faut renseigner son identité complète (<em>prénom</em> et <em>nom</em> sont obligatoires).</p>
    <p>L'<em>identifiant</em> ne sert qu'à la connexion, seuls la personnes concernée et les professeurs peuvent le voir (dans la liste d'utilisateurs ci-dessous). Les accents et les majuscules n'y posent pas problème.</p>
    <p>L'<em>adresse mail</em> n'est pas obligatoire. Elle est cependant nécessaire pour recevoir les mails des professeurs envoyés via Cahier de Prépa ou, pour les professeurs, pour activer la fonction <a href="mail">Envoi de mail</a>. Qu'il s'agisse d'un élève, d'un colleur ou d'un professeur, l'utilisateur pourra modifier son identité et son adresse mail ultérieurement, dans ses Préférences.</p>
    <p>Vous pouvez taper un <em>mot de passe</em> ou utiliser le <em>générateur automatique</em>. Dans les deux cas, <strong>ce mot de passe est obligatoirement temporaire</strong>&nbsp;: il sera automatiquement effacé à la première connexion de l'utilisateur, qui devra alors en entrer un nouveau. Ce n'est donc pas un problème que vous l'ayez vu ou qu'il soit écrit à côté du générateur, il sera très vite réinitialisé.</p>
    <p>La case à cocher <em>Envoyer un mail de confirmation à l'intéressé</em> vous permet de le prévenir automatiquement. Il recevra ainsi par mail l'adresse du site, son identifiant et son mot de passe.</p>
    <p>Pour les colleurs, vous devez obligatoirement associer une matière, qui ne sera plus modifiable. Pour les professeurs, vous pouvez ou non associer une matière. Votre collègue pourra ensuite modifier ce choix dans ses Préférences.</p>
    <h4>Création d'utilisateurs via la partie publique</h4>
    <p>Depuis le lien <code>Se connecter</code> de la partie publique, un visiteur peut envoyer une demande de création de compte, uniquement de type élève ou colleur. Cette création n'est effective que si vous ou vos collègues la validez ici. L'ensemble des demandes apparait dans une nouvelle case <em>Utilisateurs en attente</em>. L'existance de demandes de création en attente, s'il y en a, est mentionnée sur la page d'<a href=".">accueil</a> de cette interface d'administration.</p>
    <p>Tout compte non encore validé n'a bien sûr pas accès aux documents dont l'accès est protégé.</p>
    <p>La validation/suppression des demandes de création de compte requiert votre mot de passe.</p>
    <p>Remarque&nbsp;: les comptes de type professeur doivent obligatoirement être créés sur cette page. Il ne peuvent pas faire l'objet de demande de création depuis la partie publique.</p>
    <h4>Liste des utilisateurs</h4>
    <p>Chaque utilisateur est supprimable. Ces modifications requièrent votre mot de passe.</p>
  </div>

  <div class="item admin user">
  <form action="" method="post" id="ajoute">
    <input class="bouton" type="submit" name="ajoute" value="Valider" title="Valider les modifications">
    <h3>Créer un nouvel utilisateur</h3>
    <p class="ligne"><label for="genre">M&nbsp;/&nbsp;Mme&nbsp;/&nbsp;Melle&nbsp;:</label>
      <select name="genre" id="genre">
        <option value="1">M.</option>
        <option value="2">Mme</option>
        <option value="3">Melle</option>
      </select>
    </p>
    <p class="ligne"><label for="prenom">Prénom&nbsp;: </label><input type="text" id="prenom" name="prenom" value="" size="50"></p>
    <p class="ligne"><label for="nom">Nom&nbsp;: </label><input type="text" id="nom" name="nom" value="" size="50"></p>
    <p class="ligne"><label for="mail">Adresse mail&nbsp;: </label><input type="text" id="mail" name="mail" value="" size="50"></p>
    <p class="ligne"><label for="mdp1">Mot de passe temporaire&nbsp;: </label><input type="password" id="mdp1" name="mdp1" value=""></p>
    <p class="ligne"><label for="mdp2">Confirmation&nbsp;: </label><input type="password" id="mdp2" name="mdp2" value=""></p>
    <p class="ligne"><label for="autorisation">Type d'utilisateur&nbsp;:</label>
      <select name="autorisation" id="autorisation">
        <option value="1">Élève</option>
        <option value="2">Colleur</option>
        <option value="3">Professeur</option>
      </select>
    </p>
    <p class="ligne"><label for="matiere">Matière&nbsp;: </label>
      <select  id="matiere" name="matiere">
<?php echo $select_matieres; ?>
        <option value="0">Pas de matière associée</option>
      </select>
    </p>
    <p class="ligne"><label for="envoimail">Envoyer un mail de confirmation à l'intéressé</label><input type="checkbox" id="envoimail" name="envoimail" value="1" checked></p>
    <p>Pour tout professeur, la(les) matière(s) associée(s) est(sont) modifiable(s) par lui-même, dans ses <em>Préférences</em>, mais il est souvent plus simple de lui associer directement la bonne matière. Il est possible de créer une matière <a href="matieres">ici</a> (votre collègue pourra le faire après sa connexion si vous ne le faites pas maintenant).</p>
  </form>
  </div>

  <script type="text/javascript">
$( function() {
  // Ajout d'un générateur de mot de passe
  $("#ajoute p:last-child").before('<p><input type="button" value="Générer un mot de passe" id="generer_mdp">&nbsp;<span></span></p>');
  $('#generer_mdp').click( function () {
    var c = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789,;:!?.';
    var p = '';
    for ( var i = 0 ; i < 8 ; i++ )
      p += c.charAt(1 + Math.floor(Math.random()*68));
    $(this).next('span').html("Valeur recopiée&nbsp;:&nbsp;<code>"+p+"</code>");
    $('#mdp1,#mdp2').val(p);
  });
  $('#generer_mdp').parent().toggle();

  // Affichage du choix de matière uniquement si colleur ou professeur
  $('#autorisation').change( function() { 
    switch ( $(this).val() )  {
      case '1' : $('#matiere').parent().hide(); break;
      case '2' : $('#matiere').parent().show().find('option:last').prop('disabled',true); break;
      case '3' : $('#matiere').parent().show().find('option:last').prop('disabled',false); break;
    }
  });
  $('#matiere').parent().hide();
  
  // Remplace le pliage 
  $('.user h3 span').click( function () {
    $(this).parent().parent().children(':not(h3)').toggle();
    if ( $(this).text() == 'déplier' )  {
      $(this).text('replier');
      switch ( $('#autorisation').val() )  {
        case '1' : $('#matiere').parent().hide(); break;
        case '2' :
        case '3' : $('#matiere').parent().show(); break;
      }
    }
    else  {
      $(this).text('déplier');
      $('#matiere').parent().hide();
    }
  });
    
});
  </script>

<?php
// Utilisateurs "temporaires" -- demandes de création de compte en attente
$resultat = $mysqli->query('SELECT id, mail, CASE autorisation WHEN 1 THEN \'Élève\' WHEN 2 THEN \'Colleur\' END AS autorisation,
                            CONCAT( CASE MOD(genre,5) WHEN 1 THEN \'M. \' WHEN 2 THEN \'Mme \' WHEN 3 THEN \'Melle \' END, prenom, \' \', nom ) AS nom_complet
                            FROM utilisateurs WHERE login RLIKE \'^tmp[0-9]{5}\' ORDER BY nom');
if ( $n = $resultat->num_rows )  {
  $u = ( $n > 1 ) ? $n.' utilisateurs' : '1 utilisateur';
?>

  <div class="item admin">
  <form action="" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications">
    <h3><?php echo $u; ?> en attente</h3>
    <p>C'est assez urgent&nbsp;: il y a actuellement <?php echo $u; ?> en attente de votre aval pour pouvoir se connecter réellement.</p>
    <p>N'acceptez pas une demande qui vous paraît étrange. Un mail de confirmation sera envoyé automatiquement aux personnes concernées après votre acceptation.</p>
    <table class="admin">
      <thead>
        <tr><th>Nom</th><th>Mail</th><th>Type</th><th class="checks">Valider</th><th class="checks">Supprimer</th></tr>
      </thead>
      <tbody>

<?php
  while ( $r = $resultat->fetch_assoc() )
    echo "<tr><td>${r['nom_complet']}</td><td>${r['mail']}</td><td>${r['autorisation']}</td><td><input type=\"checkbox\" name=\"valide[]\" value=\"${r['id']}\"></td><td><input type=\"checkbox\" name=\"supprime[]\" value=\"${r['id']}\"></td></tr>\n";
?>
      </tbody>
    </table>
    <p class="ligne"><label for="mdp01">Mot de passe&nbsp;: </label><input type="password" id="mdp01" name="mdp" value=""></p>
    <p>Votre mot de passe est nécessaire pour valider la modification.</p>
  </form>
  </div>
  
<?php
  $resultat->free();
}

// Utilisateurs "réels"
$resultat = $mysqli->query('SELECT id, login, mail, autorisation,
                            CONCAT( CASE MOD(genre,5) WHEN 1 THEN \'M. \' WHEN 2 THEN \'Mme \' WHEN 3 THEN \'Melle \' END, prenom, \' \', nom ) AS nom_complet
                            FROM utilisateurs WHERE login NOT RLIKE \'^tmp[0-9]{5}\' ORDER BY autorisation DESC, nom');
?>

  <div class="item admin nojs">
  <form action="" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications">
    <h3>Liste des utilisateurs</h3>
    <table class="admin">
      <tbody>

<?php
$a = 0;
while ( $r = $resultat->fetch_assoc() )  {
  if ( $a != $r['autorisation'] )  {
    $a = $r['autorisation'];
    switch ( $a )  {
      case 1 : $t = 'Élèves'; break;
      case 2 : $t = 'Colleurs'; break;
      case 3 : $t = 'Professeurs'; break;
    }
    echo <<<FIN
        <tr><th colspan="4">$t</th></tr>
        <tr><th>Nom</th><th>Identifiant</th><th>Mail</th><th class="checks">Supprimer</th></tr>
      
FIN;
    }
  echo "<tr><td>${r['nom_complet']}</td><td>${r['login']}</td><td>${r['mail']}</td><td><input type=\"checkbox\" name=\"supprime[]\" value=\"${r['id']}\"></td></tr>\n";
}
?>
      </tbody>
    </table>
    <p class="ligne"><label for="mdp02">Mot de passe&nbsp;: </label><input type="password" id="mdp02" name="mdp" value=""></p>
    <p>Votre mot de passe est nécessaire pour valider la modification.</p>
  </form>
  </div>

<?php
$resultat->free();
$mysqli->close();

// Bas de page
include('bas.php');
?>
