<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php');

///////////////////////////////////////////////
// Validation de la requête : matière, n, nb //
///////////////////////////////////////////////

// Recherche de la matière concernée (affichage seulement si le cdt existe)
$mysqli = premiere_connexion();
$resultat = $mysqli->query('SELECT id, cle, nom, cdt_protection FROM matieres WHERE cdt');
if ( $resultat->num_rows )  {
  if ( !empty($_REQUEST) )
    while ( $r = $resultat->fetch_assoc() )
      if ( isset($_REQUEST[$r['cle']]) )  {
        $matiere = $r;
        break;
      }
  // Matière par défaut : la première
  if ( !isset($matiere) )  {
    $resultat->data_seek(0);
    $matiere = $resultat->fetch_assoc();
  }
  $resultat->free();
  
  // Si la page est protégée et l'utilisateur non autorisé
  while ( $matiere['cdt_protection'] > $autorisation )  {
    $p = "cdt?${matiere['cle']}";
    $t = "Cahier de texte - ${matiere['nom']}";
    include('login.php');
  }

  // $message ne peut être généré ici que par login.php si l'utilisateur s'est
  // connecté avec un mot de passe temporaire (admin/fonctions.php déjà inclus)
  if ( !isset($message) )  {
    // Fonction d'affichage des dates
    function format_date($date)  {
      $semaine = array('dimanche','lundi','mardi','mercredi','jeudi','vendredi','samedi');
      $mois = array('','janvier','février','mars','avril','mai','juin','juillet','août','septembre','octobre','novembre','décembre');
      return $semaine[substr($date,0,1)].' '.substr($date,7).' '.$mois[intval(substr($date,5,2))].' '.substr($date,1,4);
    }
  }
}
// Si aucune matière présentant son cahier de texte n'est enregistrée
else  {
  $mysqli->close();
  exit('Cette page ne contient aucune information.');
}

// Récupération de l'ensemble des semaines
$resultat = $mysqli->query("SELECT id, DATE_FORMAT(debut,'%w%Y%m%e') AS debut, vacances FROM semaines");
$select_semaines = '';
$semaines = array(0=>'');
while ( $r = $resultat->fetch_assoc() )  {
  switch ( $r['vacances'] )  {
    case 0:
      $select_semaines .= "\n        <option value=\"${r['id']}\">".format_date($r['debut']).'</option>';
      $semaines[$r['id']] = 'Semaine du '.format_date($r['debut']);
      $sid[] = $r['id'];
      break;
    case 1:
      $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances de Toussaint</option>";
      $semaines[$r['id']] = ucfirst(format_date($r['debut']))."&nbsp;: Vacances de Toussaint";
      break;
    case 2:
      $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances de Noël</option>";
      $semaines[$r['id']] = ucfirst(format_date($r['debut']))."&nbsp;: Vacances de Noël";
      break;
    case 3:
      $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances d'hiver</option>";
      $semaines[$r['id']] = ucfirst(format_date($r['debut']))."&nbsp;: Vacances d'hiver";
      break;
    case 4:
      $select_semaines .= "\n        <option value=\"${r['id']}\" disabled>Vacances de Pâques</option>";
      $semaines[$r['id']] = ucfirst(format_date($r['debut']))."&nbsp;: Vacances de Pâques";
      break;
  }
}
$resultat->free();
$ntotal = count($sid);

// Gestion de la demande des semaines à afficher

if ( isset($_REQUEST['depuisledebut']) )  {
  $n = 1;
  $m = 0;
  $nb = $ntotal;
}
else  {
  // Validation de n (numéro de semaine à voir)
  if ( isset($_REQUEST['n']) && is_numeric($n = $_REQUEST['n']) )
    while ( !in_array($n,$sid) )
      $n = ( $n < $ntotal ) ? $n+1 : 1;
  // Sans argument, on souhaite afficher la semaine actuelle
  else {
    $date = ( isset($_REQUEST['date']) && preg_match('/\d{4}-\d{2}-\d{2}/',$_REQUEST['date']) ) ? '\''.trim($_REQUEST['date'],'\'').'\'' : 'NOW()';
    $resultat = $mysqli->query("SELECT IF(vacances,(SELECT id FROM semaines WHERE debut > $date AND vacances = 0 LIMIT 1),id) AS id
                                FROM semaines WHERE debut < $date ORDER BY debut DESC LIMIT 1");
    if ( $resultat->num_rows )  {
      $r = $resultat->fetch_assoc();
      $n = $r['id'];
      $resultat->free();
    }
    else
      $n = 1;
  }
  $m = array_search($n,$sid);

  // Validation de nb (nombre de semaines à voir)
  if ( isset($_REQUEST['nb']) && is_numeric($nb = $_REQUEST['nb']) )  {
    if ( $nb < 1 )
      $nb = 1;
    elseif ( $nb > $ntotal - $m )
      $nb = $ntotal - $m;
  }
  else
    // Par défaut : affichage d'une seule semaine
    $nb = 1;
}

// Récupération des types de séances, pour le formulaire de recherche
$resultat = $mysqli->query("SELECT cle FROM `cdt-types` WHERE matiere = ${matiere['id']} AND nb_v");
$select_types = $recherche_types = '';
if ( isset($_REQUEST['type']) )  {
  while ( $r = $resultat->fetch_assoc() )
    if ( $r['cle'] == $_REQUEST['type'] )  {
      $select_types .= "\n        <option value=\"${r['cle']}\" selected>les ${r['cle']}</option>";
      $recherche_types = " AND t.cle = '${r['cle']}'";
    }
    else
      $select_types .= "\n        <option value=\"${r['cle']}\">les ${r['cle']}</option>"; 
}
else
  while ( $r = $resultat->fetch_assoc() )
    $select_types .= "\n        <option value=\"${r['cle']}\">les ${r['cle']}</option>"; 
$resultat->free();

////////////
/// HTML ///
////////////
$p = "cdt?${matiere['cle']}";
$t = "Cahier de texte - ${matiere['nom']}";

// Haut de page, menu et message
include('haut.php');

// Formulaire de la demande des semaines à afficher
$select_semaines = str_replace("\"$n\"","\"$n\" selected",$select_semaines);
echo <<<FIN

  <div class="item" id="recherche">
  <form action="" method="get">
    <input type="hidden" name="${matiere['cle']}" value="">
    <p>Afficher&nbsp;
      <select name="type">
        <option value="tout">tout</option>$select_types
      </select>
      <input type="submit" name="depuisledebut" id="depuisledebut" value="pour toute l'année">
      ou&nbsp;pendant&nbsp;<input type="text" name="nb" value="$nb" size="2">&nbsp;semaine(s) à partir du&nbsp;
      <select name="n">$select_semaines
      </select>
      <input type="submit" name="" value="OK">
    </p>
  </form>
  </div>


FIN;

// Liens de navigation vers semaines précédentes/suivantes
$nav = '  <div class="item">';
if ( $m )
  $nav .= "\n    <a class=\"prec\" href=\"?${matiere['cle']}&amp;n=". $sid[max($m-$nb,0)] ."&amp;nb=$nb\">Semaines précédentes</a>";
if (  $m+$nb < $ntotal )
  $nav .= "\n    <a class=\"suiv\" href=\"?${matiere['cle']}&amp;n=". $sid[$m+$nb] ."&amp;nb=$nb\">Semaines suivantes</a>";
$nav .= "\n  </div>\n\n";
if ( strlen($nav) > 31 )
  echo $nav;

// Récupération des entrées
$resultat = $mysqli->query("SELECT cdt.texte, cdt.semaine,
                            DATE_FORMAT(cdt.jour,'%w') AS jour, DATE_FORMAT(cdt.jour,'%d/%m/%Y') AS date,
                            CASE t.deb_fin_pour
                              WHEN 0 THEN TIME_FORMAT(cdt.h_debut,' à %kh%i')
                              WHEN 1 THEN CONCAT(TIME_FORMAT(cdt.h_debut,' de %kh%i'),TIME_FORMAT(cdt.h_fin,' à %kh%i'))
                              WHEN 2 THEN ''
                              ELSE t.deb_fin_pour END AS heure,
                            IF(t.deb_fin_pour = 2,CONCAT(' pour le ',DATE_FORMAT(cdt.pour,'%d/%m/%Y')),'') AS pour,
                            IF(cdt.demigroupe,' (en demi-groupe)','') AS demigroupe, t.titre
                            FROM cdt LEFT JOIN `cdt-types` AS t ON t.matiere = ${matiere['id']} AND t.id = cdt.type
                            WHERE cdt.cache = 0 AND cdt.semaine BETWEEN $n AND ${sid[$m+$nb-1]} AND cdt.matiere = ${matiere['id']} $recherche_types");

// Affichage des résultats
if ( $resultat->num_rows )  {
  // On ne garde que les semaines concernées. Il faut conserver la semaine précédente
  // pour que puisse fonctionner le premier next à l'affichage.
  $semaines = array_slice($semaines,$n-1,$sid[$m+$nb-1]-$n+2,true);
  $s = 0;
  $semaine = array('','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi');
  while ( $r = $resultat->fetch_assoc() )  {
    
    // Nouvelle semaine
    while ( ( $s != $r['semaine'] ) && next($semaines) )  {
      echo '  <h2 class="cdtsemaine">'.current($semaines)."</h2>\n\n";
      $s = key($semaines);
    }
    switch ( $r['heure'] )  {
      case 3:
        $titre = "\n      <p class=\"titre\">${semaine[$r['jour']]} ${r['date']}&nbsp;: ${r['titre']}</p>";
        break;
      case 4:
        $titre = "\n      <p class=\"titre\">${semaine[$r['jour']]} ${r['date']}</p>";
        break;
      case 5:
        $titre = '';
        break;
      default:
        $titre = "\n      <p class=\"titre\">${semaine[$r['jour']]} ${r['date']}${r['heure']}&nbsp;: ${r['titre']}${r['pour']}${r['demigroupe']}</p>";
    }
    echo <<<FIN
  <div class="item cdt">$titre
${r['texte']}
  </div>


FIN;

  }
  $resultat->free();
  // Liens de navigation vers semaines précédentes/suivantes
  if ( strlen($nav) > 31 )
    echo $nav;
}
else  {
  if ( !isset($_REQUEST['type']) || ( $_REQUEST['type'] == 'tout' ) )
    echo "  <h2>Le cahier de texte est vide pour les semaines choisies.</h2>\n\n";
  else
    echo "  <h2>Le cahier de texte ne contient pas de «&nbsp;${_REQUEST['type']}&nbsp;» pour les semaines choisies.</h2>\n\n";
}

$mysqli->close();

// Bas de page
include('bas.php');
?>
