<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php');

///////////////////////////////////////////////
// Validation de la requête : matière, n, nb //
///////////////////////////////////////////////

// Recherche de la matière concernée (affichage seulement si le programme existe)
$mysqli = premiere_connexion();
$resultat = $mysqli->query('SELECT id, cle, nom, colles_protection FROM matieres WHERE colles');
if ( $resultat->num_rows )  {
  if ( !empty($_REQUEST) )
    while ( $r = $resultat->fetch_assoc() )
      if ( isset($_REQUEST[$r['cle']]) )  {
        $matiere = $r;
        break;
      }
  // Matière par défaut : la première
  if ( !isset($matiere) )  {
    $resultat->data_seek(0);
    $matiere = $resultat->fetch_assoc();
  }
  $resultat->free();
  
  // Si la page est protégée et l'utilisateur non autorisé
  while ( $matiere['colles_protection'] > $autorisation )  {
    $p = "colles?${matiere['cle']}";
    $t = "Programme de colles - ${matiere['nom']}";
    include('login.php');
  }

  // $message ne peut être généré ici que par login.php si l'utilisateur s'est
  // connecté avec un mot de passe temporaire (admin/fonctions.php déjà inclus)
  if ( !isset($message) )  {
    // Fonction d'affichage des dates
    function format_date($date)  {
      $semaine = array('dimanche','lundi','mardi','mercredi','jeudi','vendredi','samedi');
      $mois = array('','janvier','février','mars','avril','mai','juin','juillet','août','septembre','octobre','novembre','décembre');
      return $semaine[substr($date,0,1)].' '.substr($date,7).' '.$mois[intval(substr($date,5,2))].' '.substr($date,1,4);
    }
  }
}
// Si aucune matière présentant son programme de colles n'est enregistrée
else  {
  $mysqli->close();
  exit('Cette page ne contient aucune information.');
}

// Récupération de l'ensemble des semaines
$resultat = $mysqli->query("SELECT s.id AS sid, DATE_FORMAT(s.debut,'%w%Y%m%e') AS d, s.colle, s.vacances,
                            IF(c.id IS NULL OR c.cache, ' disabled','') AS disabled
                            FROM semaines AS s
                            LEFT JOIN (SELECT id, semaine, cache FROM colles WHERE matiere = ${matiere['id']}) AS c ON c.semaine=s.id");
$select_semaines = '';
while ( $r = $resultat->fetch_assoc() )  {
  switch ( $r['vacances'] )  {
    case 0:
      $select_semaines .= "\n        <option value=\"${r['sid']}\"${r['disabled']}>".format_date($r['d']).'</option>';
      $sid[] = $r['sid'];
      break;
    case 1:
      $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances de Toussaint</option>";
      break;
    case 2:
      $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances de Noël</option>";
      break;
    case 3:
      $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances d'hiver</option>";
      break;
    case 4:
      $select_semaines .= "\n        <option value=\"${r['sid']}\" disabled>Vacances de Pâques</option>";
  }
}
$resultat->free();

// Validation de n (numéro de semaine à voir)
if ( isset($_REQUEST['n']) && is_numeric($n = $_REQUEST['n']) )
  while ( !in_array($n,$sid) )
    $n = ( $n < count($sid) ) ? $n+1 : 1;
// Sans argument, on souhaite afficher le programme de colles de la semaine actuelle
else {
  $date = ( isset($_REQUEST['date']) && preg_match('/\d{4}-\d{2}-\d{2}/',$_REQUEST['date']) ) ? '\''.trim($_REQUEST['date'],'\'').'\'' : 'NOW()';
  $resultat = $mysqli->query("SELECT IF(vacances,(SELECT id FROM semaines WHERE debut > ADDDATE($date,3) AND vacances = 0 LIMIT 1),id) AS id
                              FROM semaines WHERE debut < ADDDATE($date,3) ORDER BY debut DESC LIMIT 1");
  if ( $resultat->num_rows )  {
    $r = $resultat->fetch_assoc();
    $n = $r['id'];
    $resultat->free();
  }
  // Aucun résultat : l'année n'a pas encore commencé
  else
    $n = 0;
}
$m = array_search($n,$sid);

// Validation de nb (nombre de semaines à voir)
if ( isset($_REQUEST['nb']) && is_numeric($nb = $_REQUEST['nb']) ) {
  if ( $nb < 1 )
    $nb = 1;
  elseif ( $nb > count($sid) - $m )
    $nb = count($sid) - $m;
}
else
  // Par défaut : affichage d'une seule semaine
  $nb = 1;

////////////
/// HTML ///
////////////
$p = "colles?${matiere['cle']}";
$t = "Programme de colles - ${matiere['nom']}";

// Haut de page, menu et message
include('haut.php');

// Formulaire de la demande des semaines à afficher
$select_semaines = str_replace("\"$n\"","\"$n\" selected",$select_semaines);
echo <<<FIN

  <div class="item" id="recherche">
  <form action="" method="get">
    <input type="hidden" name="${matiere['cle']}" value="">
    <p>Afficher&nbsp;<input type="text" name="nb" value="$nb" size="2">&nbsp;semaine(s) à partir du&nbsp;
      <select name="n">$select_semaines
      </select>
      <input type="submit" name="" value="OK">
    </p>
  </form>
  </div>


FIN;

// Affichage des semaines concernées
if ( $n )  {

  // Liens de navigation vers semaines précédentes/suivantes
  $nav = '  <div class="item">';
  if ( $m )
    $nav .= "\n    <a class=\"prec\" href=\"?${matiere['cle']}&amp;n=". $sid[max($m-$nb,0)] ."&amp;nb=$nb\">Semaines précédentes</a>";
  if (  $m+$nb < count($sid) )
    $nav .= "\n    <a class=\"suiv\" href=\"?${matiere['cle']}&amp;n=". $sid[$m+$nb] ."&amp;nb=$nb\">Semaines suivantes</a>";
  $nav .= "\n  </div>\n\n";
  if ( $nb > 1 )
    echo $nav;

  // Récupération des données à afficher
  $resultat = $mysqli->query("SELECT DATE_FORMAT(s.debut,'%w%Y%m%e') AS d, s.colle, s.vacances, c.texte 
                              FROM semaines AS s
                              LEFT JOIN (SELECT texte, semaine FROM colles WHERE matiere = ${matiere['id']} AND cache = 0) AS c ON c.semaine=s.id
                              WHERE s.id BETWEEN $n AND ${sid[$m+$nb-1]}" );
  // Gestion du titre
  while ( $r = $resultat->fetch_assoc() )  {
    switch ( $r['vacances'] )  {
      case 0:
        $titre = 'Semaine du '.format_date($r['d']);
        break;
      case 1:
        $titre = ucfirst(format_date($r['d']))."&nbsp;: Vacances de Toussaint";
        break;
      case 2:
        $titre = ucfirst(format_date($r['d']))."&nbsp;: Vacances de Noël";
        break;
      case 3:
        $titre = ucfirst(format_date($r['d']))."&nbsp;: Vacances d'hiver";
        break;
      case 4:
        $titre = ucfirst(format_date($r['d']))."&nbsp;: Vacances de Pâques";
        break;
    }
    
    // Affichage
    if ( $r['colle'] )
      $texte = ( is_null($r['texte']) ) ? '    <p>Le programme de colles de cette semaine n\'est pas défini.</p>' : $r['texte'];
    else
      $texte = ( $r['vacances'] ) ? '' : '    <p>Il n\'y a pas de colles cette semaine.</p>';
      echo <<<FIN
  <div class="item colle">
    <h3>$titre</h3>
$texte
  </div>


FIN;
  }
  $resultat->free();
  
  // Liens de navigation vers semaines précédentes/suivantes
  echo $nav;
}
else
  echo "  <h2>L'année n'a pas encore commencé... Revenez à la rentrée&nbsp;!</h2>\n\n";
$mysqli->close();

// Bas de page
include('bas.php');
?>
