<?php
// Définition de la base de données
// À utiliser en tant qu'utilisateur root
// Champs à remplacer : $base, $mdp, $serveur, $cle_matiere, $nom_matiere,
// $login, $nom, $prenom, $genre, $mot_de_passe, $mail, $titre
//
// Ces définitions sont utilisables en php directement ou en shell linux par
// sed '1,/FIN/d ; N;$!P;$!D;$d' def_sql.php | sed "s/\\\$base/$BASE/g;s/\\\$serveur/$SERVEUR/g;..."

$requete = <<< FIN

DROP DATABASE IF EXISTS `$base`;
CREATE DATABASE `$base` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;
DELETE FROM mysql.user WHERE User = '$base' OR User = '$base-adm';
INSERT INTO mysql.user (Host, User, Password) 
  VALUES ('$serveur', '$base', PASSWORD('$mdp')),
         ('$serveur', '$base-adm', PASSWORD('$mdp'));
DELETE FROM mysql.db WHERE Db = '$base';
INSERT INTO mysql.db (Host, Db, User, Select_priv, Insert_priv, Update_priv, Delete_priv, Alter_priv, Drop_priv) 
  VALUES ('$serveur', '$base', '$base', 'Y', 'N', 'N', 'N', 'N', 'N'),
         ('$serveur', '$base','$base-adm', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
FLUSH PRIVILEGES;
USE `$base`;

CREATE TABLE `matieres` (
  `id` tinyint(2) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `ordre` tinyint(2) unsigned NOT NULL,
  `cle` varchar(50) NOT NULL,
  `nom` varchar(50) NOT NULL,
  `colles` tinyint(1) unsigned NOT NULL,
  `cdt` tinyint(1) unsigned NOT NULL,
  `docs` tinyint(1) unsigned NOT NULL,
  `notes` tinyint(1) unsigned NOT NULL,
  `colles_protection` tinyint(1) unsigned NOT NULL,
  `cdt_protection` tinyint(1) unsigned NOT NULL,
  KEY `colles` (`colles`),
  KEY `cdt` (`cdt`),
  KEY `docs` (`docs`),
  KEY `notes` (`notes`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `utilisateurs` (
  `id` tinyint(2) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `login` varchar(50) NOT NULL UNIQUE,
  `nom` varchar(50) NOT NULL,
  `prenom` varchar(50) NOT NULL,
  `genre` tinyint(1) UNSIGNED NOT NULL,
  `mail` varchar(50) NOT NULL,
  `autorisation` tinyint(1) UNSIGNED NOT NULL,
  `mdp` char(40) NOT NULL,
  `matieres` varchar(15) NOT NULL,
  `timeout` smallint(4) UNSIGNED NOT NULL,
  `mailexp` tinyint(1) UNSIGNED NOT NULL,
  `mailcopy` tinyint(1) UNSIGNED NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `pages` (
  `id` tinyint(2) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `ordre` tinyint(2) unsigned NOT NULL,
  `cle` varchar(50) NOT NULL,
  `mat` tinyint(2) NOT NULL,
  `nom` varchar(50) NOT NULL,
  `titre` text NOT NULL,
  `bandeau` text NOT NULL,
  `protection` tinyint(1) unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `infos` (
  `id` smallint(4) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `ordre` tinyint(2) unsigned NOT NULL,
  `page` tinyint(2) unsigned NOT NULL,
  `cache` tinyint(1) unsigned NOT NULL,
  `titre` text NOT NULL,
  `texte` text NOT NULL,
  KEY `ordre` (`ordre`,`page`),
  KEY `cache` (`cache`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `semaines` (
  `id` tinyint(2) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `debut` date NOT NULL,
  `colle` tinyint(1) unsigned NOT NULL,
  `vacances` tinyint(1) unsigned NOT NULL,
  KEY `debut` (`debut`),
  KEY `colle` (`colle`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `colles` (
  `id` tinyint(3) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `semaine` tinyint(2) unsigned NOT NULL,
  `matiere` tinyint(2) unsigned NOT NULL,
  `texte` text NOT NULL,
  `cache` tinyint(1) NOT NULL,
  KEY `semaine` (`semaine`),
  KEY `matiere` (`matiere`),
  KEY `cache` (`cache`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `cdt` (
  `id` smallint(3) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `matiere` tinyint(2) unsigned NOT NULL,
  `semaine` tinyint(2) unsigned NOT NULL,
  `jour` date NOT NULL,
  `h_debut` time NOT NULL,
  `h_fin` time NOT NULL,
  `pour` date NOT NULL,
  `type` tinyint(2) unsigned NOT NULL,
  `texte` text NOT NULL,
  `demigroupe` tinyint(1) unsigned NOT NULL,
  `cache` tinyint(1) unsigned NOT NULL,
  KEY `matiere` (`matiere`),
  KEY `semaine` (`semaine`),
  KEY `type` (`type`),
  KEY `cache` (`cache`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `cdt-types` (
  `id` tinyint(2) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `matiere` tinyint(2) unsigned NOT NULL,
  `ordre` tinyint(2) unsigned NOT NULL,
  `titre` varchar(50) NOT NULL,
  `cle` varchar(20) NOT NULL,
  `deb_fin_pour` tinyint(1) unsigned NOT NULL,
  `nb` tinyint(2) unsigned NOT NULL,
  `nb_v` tinyint(2) unsigned NOT NULL,
  KEY `matiere` (`matiere`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `cdt-seances` (
  `id` tinyint(2) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `matiere` tinyint(2) unsigned NOT NULL,
  `ordre` tinyint(2) unsigned NOT NULL,
  `nom` varchar(40) NOT NULL,
  `jour` tinyint(1) unsigned NOT NULL,
  `h_debut` time NOT NULL,
  `h_fin` time NOT NULL,
  `type` tinyint(3) unsigned NOT NULL,
  `demigroupe` tinyint(1) unsigned NOT NULL,
  KEY `matiere` (`matiere`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `reps` (
  `id` tinyint(3) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `parent` tinyint(3) unsigned NOT NULL,
  `parents` varchar(50) NOT NULL,
  `matiere` tinyint(2) unsigned NOT NULL,
  `nom` varchar(100) NOT NULL,
  `nbrep` tinyint(2) unsigned NOT NULL,
  `nbrep_v` tinyint(2) unsigned NOT NULL,
  `nbdoc` tinyint(2) unsigned NOT NULL,
  `nbdoc_v` tinyint(2) unsigned NOT NULL,
  `protection` tinyint(1) unsigned NOT NULL,
  `menu` tinyint(1) unsigned NOT NULL,
  KEY `parent` (`parent`),
  KEY `matiere` (`matiere`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `docs` (
  `id` smallint(3) unsigned NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `parent` tinyint(3) unsigned NOT NULL,
  `parents` varchar(50) NOT NULL,
  `matiere` tinyint(2) unsigned NOT NULL,
  `nom` varchar(100) NOT NULL,
  `nom_nat` VARCHAR(100) NOT NULL,
  `upload` date NOT NULL,
  `taille` varchar(12) NOT NULL,
  `lien` char(15) NOT NULL,
  `ext` varchar(5) NOT NULL,
  `protection` tinyint(1) unsigned NOT NULL,
  KEY `parent` (`parent`),
  KEY `matiere` (`matiere`),
  KEY `nom_nat` (`nom_nat`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `recents` (
  `id` smallint(5) unsigned NOT NULL PRIMARY KEY,
  `heure` datetime NOT NULL,
  `titre` varchar(200) NOT NULL,
  `lien` varchar(30) NOT NULL,
  `texte` text NOT NULL,
  KEY `heure` (`heure`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE notes (
  `id` smallint(5) UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `semaine` tinyint(2) unsigned NOT NULL,
  `eleve` tinyint(2) unsigned NOT NULL,
  `colleur` tinyint(2) unsigned NOT NULL,
  `matiere` tinyint(2) unsigned NOT NULL,
  `note` varchar(2) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO utilisateurs (id,login,genre,prenom,nom,mail,mdp,autorisation,matieres,timeout,mailexp,mailcopy)
  VALUES (1, '$login', $genre, '$prenom', '$nom', '$mail', '$mot_de_passe', 3, '1', 900, 1, 1);

INSERT INTO matieres (id,ordre,cle,nom,colles,cdt,docs,notes,colles_protection,cdt_protection)
  VALUES (1, 1, '$cle_matiere', '$nom_matiere', 0, 0, 0, 0, 0, 0);

INSERT INTO reps (id,parent,parents,matiere,nom,nbrep,nbrep_v,nbdoc,nbdoc_v,protection,menu)
  VALUES (1, 0, '0', 0, 'Général', 0, 0, 0, 0, 0, 0),
         (2, 0, '0', 1, '$nom_matiere', 0, 0, 0, 0, 0, 0);

INSERT INTO pages (ordre,cle,nom,titre,bandeau,protection)
  VALUES (1, 'accueil', 'Accueil', '$titre', 'Dernières informations importantes', 0);

INSERT INTO `cdt-types` (matiere,ordre,cle,titre,deb_fin_pour)
  VALUES (1, 1, 'cours', 'Cours', 1),
         (1, 2, 'TD', 'Séance de travaux dirigés', 1),
         (1, 3, 'TP', 'Séance de travaux pratiques', 1),
         (1, 4, 'DS', 'Devoir surveillé', 1),
         (1, 5, 'interros', 'Interrogation de cours', 0),
         (1, 6, 'distributions', 'Distribution de document', 0),
         (1, 7, 'DM', 'Devoir maison', 2);

INSERT INTO semaines (debut) VALUES ('2014-09-02'),('2014-09-08'),('2014-09-15'),('2014-09-22'),('2014-09-29'),
  ('2014-10-06'),('2014-10-13'),('2014-10-20'),('2014-10-27'),('2014-11-03'),('2014-11-10'),('2014-11-17'),('2014-11-24'),
  ('2014-12-01'),('2014-12-08'),('2014-12-15'),('2014-12-22'),('2014-12-29'),('2015-01-05'),('2015-01-12'),('2015-01-19'),('2015-01-26'),
  ('2015-02-02'),('2015-02-09'),('2015-02-16'),('2015-02-23'),('2015-03-02'),('2015-03-09'),('2015-03-16'),('2015-03-23'),('2015-03-30'),
  ('2015-04-07'),('2015-04-13'),('2015-04-20'),('2015-04-27'),('2015-05-04'),('2015-05-11'),('2015-05-18'),('2015-05-26'),
  ('2015-06-01'),('2015-06-08'),('2015-06-15'),('2015-06-22'),('2015-06-29');
UPDATE semaines SET colle = 1;

FIN;
?>
