<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php');

//////////////////////////////////////////////////////
// Validation de la requête : répertoire ou matière //
//////////////////////////////////////////////////////

// Récupération des données du répertoire demandé
$mysqli = premiere_connexion();
$requete = 'SELECT r.id, r.nom, r.parent, r.parents, r.nbrep_v + r.nbdoc_v AS nb, r.protection, m.cle, m.nom AS mat
            FROM reps AS r LEFT JOIN matieres AS m ON r.matiere = m.id';
// Requête non nulle : soit un numéro de répertoire, soit une clé de matière
if ( isset($_REQUEST['rep']) && is_numeric($rid = $_REQUEST['rep']) )  {
  $resultat = $mysqli->query("$requete WHERE r.protection < 4 AND r.id = $rid");
  if ( $resultat->num_rows )  {
    $rep = $resultat->fetch_assoc();
    $resultat->free();
  }
}
elseif ( !empty($_REQUEST) )  {
  $resultat = $mysqli->query("$requete WHERE r.protection < 4 AND r.parent = 0");
  if ( $resultat->num_rows )  {
    while ( $r = $resultat->fetch_assoc() )
      if ( isset($_REQUEST[$r['cle']]) )  {
        $rep = $r;
        $rid = $r['id'];
        break;
      }
    $resultat->free();
  }
}
// Valeur par défaut : répertoire "Général", id = 1 (même si non visible)
if ( !isset($rep) )  {
  $resultat = $mysqli->query("$requete WHERE r.id = 1");
  $rep = $resultat->fetch_assoc();
  $resultat->free();
  $rid = 1;
}

// Répertoires parents
$resultat = $mysqli->query("SELECT id, nom, IF(parent,'next','home') AS icone,
                            IF(protection>$autorisation,'-lock','') AS protection
                            FROM reps WHERE FIND_IN_SET(id,'${rep['parents']},$rid')");
$parents = '  <div class="item" id="parents">';
while ( $r = $resultat->fetch_assoc() )
  $parents .= "\n    <a href=\"?rep=${r['id']}\"><img class=\"icone\" src=\"icones/${r['icone']}${r['protection']}.png\">${r['nom']}</a>";
$resultat->free();
$parents .= "\n  </div>";

//////////
// HTML //
//////////
if ( is_null($rep['cle']) )  {
  $t = 'Documents à télécharger';
  $p = 'docs';
}
else  {
  $t = "Documents à télécharger - ${rep['mat']}";
  $p = "docs?${rep['cle']}";
}

// Si le répertoire est protégé et l'utilisateur non autorisé
while ( $rep['protection'] > $autorisation )
  include('login.php');

// Haut de page, menu et message
include('haut.php');

// Affichage des répertoires parents et des demandes d'ordre
echo <<<FIN
  
$parents
  
  <div id="ordre">
    <span>Ordre alphabétique&nbsp;<a href="?rep=$rid&amp;ordre=alpha"><img src="icones/down.png" alt="croissant"></a>&nbsp;<a href="?rep=$rid&amp;ordre=alpha-r"><img src="icones/up.png" alt="décroissant"></a></span>
    <span>Ordre chronologique&nbsp;<a href="?rep=$rid&amp;ordre=chrono"><img src="icones/down.png" alt="croissant"></a>&nbsp;<a href="?rep=$rid&amp;ordre=chrono-r"><img src="icones/up.png" alt="décroissant"></a></span>
  </div>

FIN;

// Affichage du répertoire et de son contenu
if ( $rep['nb'] )  {
  
  // Liste des icônes pour affichage
  $icones = array(
    '.pdf' => 'pdf',
    '.doc' => 'doc', '.odt' => 'doc', '.docx' => 'doc',
    '.xls' => 'xls', '.ods' => 'xls', '.xlsx' => 'xls',
    '.ppt' => 'ppt', '.odp' => 'ppt', '.pptx' => 'ppt',
    '.jpg' => 'jpg', '.jpeg' => 'jpg', '.png' => 'jpg', '.gif' => 'jpg', '.svg' => 'jpg', '.tif' => 'jpg', '.tiff' => 'jpg', '.bmp' => 'jpg', '.ps' => 'jpg', '.eps' => 'jpg',
    '.py' => 'python',
    '.avi' => 'avi', '.mpeg' => 'avi', '.mpg' => 'avi', '.wmv' => 'avi', '.mp4' => 'avi', '.ogv' => 'avi', '.qt' => 'avi', '.mov' => 'avi', '.mkv' => 'avi', 'flv' => 'avi',
    '.mp3' => 'mp3', '.ogg' => 'mp3', '.oga' => 'mp3', '.wma' => 'mp3', '.wav' => 'mp3', '.ra' => 'mp3', '.rm' => 'mp3',
    '.txt' => 'txt', '.rtf' => 'txt',
    '.zip' => 'zip', '.rar' => 'zip', '.7z' => 'zip',
    '.exe' => 'exe', '.sh' => 'exe', '.ml' => 'exe', '.mw' => 'exe', '' => 'exe'
  );
  
  // Ordre d'affichage demandé
  if ( isset($_REQUEST['ordre']) )  {
    $ordre = array('alpha'=>'ORDER BY nom_nat ASC','alpha-r'=>'ORDER BY nom_nat DESC',
                   'chrono'=>'ORDER BY docs.upload ASC','chrono-r'=>' ORDER BY docs.upload DESC');
    $ordre = array_key_exists($_REQUEST['ordre'],$ordre) ? $ordre[$_REQUEST['ordre']] : '';
  }
  else
    $ordre = '';

  function affichage($mysqli, $rid, $n, $autorisation)  {
    $indent = str_pad('',2*$n);

    // Sous-répertoires et récursivité
    $resultat = $mysqli->query("SELECT id, nom, nbrep_v AS nbrep, nbdoc_v AS nbdoc,
                                IF(protection>$autorisation,1,0) AS protection
                                FROM reps WHERE parent = $rid AND protection < 4");
    if ( $resultat->num_rows )  {
      while ( $r = $resultat->fetch_assoc() )  {
        // Affichage du contenu si autorisé
        if ( $r['protection'] )
          echo <<<FIN

$indent<div class="rep">
$indent  <p class="rep lock"><img class="icone" src="icones/rep-lock.png"><a href="?rep=${r['id']}">${r['nom']}</a></p>
$indent</div>\n
FIN;
        else  {
          if ( $r['nbrep']+$r['nbdoc'] )
            $contenu = str_replace(array('0 répertoire,',', 0 document'),'',"(${r['nbrep']} répertoire".( ( $r['nbrep'] > 1 ) ? 's' : '' ).", ${r['nbdoc']} document".( ( $r['nbdoc'] > 1 ) ? 's' : '' ).'&nbsp;)');
          else
            $contenu = '(vide)';
          echo <<<FIN

$indent<div class="rep">
$indent  <p class="rep open"><img class="icone" src="icones/rep-open.png"><a href="?rep=${r['id']}">${r['nom']}</a> $contenu</p>
FIN;
          affichage($mysqli,$r['id'],$n+1,$autorisation);
          echo "\n$indent</div>\n";
        }
      }
      $resultat->free();
    }

    // Documents
    $resultat = $mysqli->query("SELECT id, nom, taille, DATE_FORMAT(upload,'%d/%m/%Y') AS upload,
                                LOWER(ext) AS ext, IF(protection>$autorisation,'-lock','') AS protection
                                FROM docs WHERE parent = $rid AND protection < 4 ${GLOBALS['ordre']}");
    if ( $resultat->num_rows )  {
      $icones = $GLOBALS['icones'];
      while ( $r = $resultat->fetch_assoc() )  {
        $icone = array_key_exists($r['ext'],$icones) ? $icones[$r['ext']] : 'defaut';
        echo "
$indent<p class=\"fic\"><a href=\"download?id=${r['id']}\"><img class=\"icone\" src=\"icones/$icone${r['protection']}.png\">${r['nom']}</a> (${r['upload']}, ${r['taille']})</p>";
      }
      $resultat->free();
    }
  }

  // Lancement de la fonction récursive sur le répertoire à afficher
  affichage($mysqli,$rid,1,$autorisation);
  
}
else
  echo "\n  <h3 class=\"warning\">Ce répertoire est vide.</h3>\n\n";


$mysqli->close();
?>


  <script type="text/javascript">
$( function() {
  $('p.rep:not(.lock) img').css('cursor','pointer').click( function () {
    var p = $(this).parent();
    p.toggleClass('open');
    p.parent().children('.fic,div.rep').toggle();
    $(this).attr('src',function(i,val){ return val.replace(p.is('.open')?'rep':'rep-open',p.is('.open')?'rep-open':'rep'); });
  });
  $('p.rep:not(.lock) img').attr('src',function(i,val){return val.replace('rep-open','rep');}).parent().removeClass('open');
  $('div.rep .fic,div.rep div.rep').hide();
});
  </script>
  
<?php
// Bas de page
include('bas.php');
?>
