<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par un script autorisé
if ( !defined('OK') )  exit();

// La connexion MySQL (lien $mysqli) doit être obligatoirement établie par le script appelant.
// $t et $p doivent être réglés par le script appelant
// $t = titre de la page, $p = cle de la page
?><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
  <title><?php echo $t; ?></title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <link rel="stylesheet" href="css/style.css?v=4" type="text/css" media="screen">
  <link rel="stylesheet" href="css/print.css" type="text/css" media="print">
  <link rel="stylesheet" href="css/couleurs.css?v=4" type="text/css" media="screen">
  <script type="text/javascript" src="js/jquery.js"></script>
  <script type="text/javascript" src="/MathJax/MathJax.js?config=TeX-AMS-MML_HTMLorMML"></script>
  <link rel="alternate" type="application/rss+xml" title="Flux RSS" href="http://cahier-de-prepa.fr/$site/documents/<?php echo sha1($base); ?>/rss.xml">
  <script type="text/x-mathjax-config">
    MathJax.Hub.Config({tex2jax: {inlineMath: [["$","$"],["\\(","\\)"]]}});
  </script>
</head>
<body>
<div id="global">

<h1><?php echo $t; ?></h1>

<div id="colonne">

  <div id="menu">
<?php
// Récupération et affichage des pages
$menu = '    <div>';
$resultat = $mysqli->query('SELECT cle, nom FROM pages WHERE mat = 0');
while ( $r = $resultat->fetch_assoc() )
  $menu .= "\n      <a href=\".?${r['cle']}\">${r['nom']}</a>";
$resultat->free();
// Page de téléchargement
$menu .= "\n      <a href=\"docs\">Documents à télécharger</a>";
$resultat = $mysqli->query("SELECT id, nom FROM reps WHERE matiere = 0 AND menu = 1");
if ( $resultat->num_rows )  {
  while ( $r = $resultat->fetch_assoc() )
    $menu .= "\n        <a class=\"menurep\" href=\"docs?rep=${r['id']}\">${r['nom']}</a>";        
  $resultat->free();
}
$menu .= "\n    </div>";

// Récupération et affichage des matières
$resultat = $mysqli->query('SELECT m.id, m.cle, m.nom, m.colles, m.cdt, m.docs,
                            GROUP_CONCAT(CONCAT(m.cle,\'/\',p.cle) SEPARATOR \'//\') AS pcle,
                            GROUP_CONCAT(p.nom SEPARATOR \'//\') AS pnom
                            FROM matieres AS m LEFT JOIN pages AS p ON p.mat = m.id
                            WHERE m.colles+m.cdt+m.docs OR p.nom IS NOT NULL GROUP BY m.id ORDER BY m.ordre, p.ordre');
if ( $resultat->num_rows )  {
  while ( $r = $resultat->fetch_assoc() )  {
    $menu .= "\n    <div>\n      <h3>${r['nom']}</h3>";
    if ( !is_null($r['pcle']) )  {
      $pcle = explode('//',$r['pcle']);
      $pnom = explode('//',$r['pnom']);
      $nom = $pnom[0];
      foreach ( $pcle as $cle )  {
        $menu .= "\n      <a href=\".?$cle\">$nom</a>";
        $nom = next($pnom);
      }
    }
    if ( $r['colles'] )
      $menu .= "\n      <a href=\"colles?${r['cle']}\">Programme de colles</a>";
    if ( $r['cdt'] )
      $menu .= "\n      <a href=\"cdt?${r['cle']}\">Cahier de texte</a>";
    if ( $r['docs'] )  {
      $menu .= "\n      <a href=\"docs?${r['cle']}\">Documents à télécharger</a>";
      $resultat_doc = $mysqli->query("SELECT id, nom FROM reps WHERE matiere = ${r['id']} AND menu = 1 AND protection < 4");
      if ( $resultat_doc->num_rows )  {
        while ( $d = $resultat_doc->fetch_assoc() )
          $menu .= "\n        <a class=\"menurep\" href=\"docs?rep=${d['id']}\">${d['nom']}</a>";        
        $resultat_doc->free();
      }
    }
    $menu .= "\n    </div>";
  }
  $resultat->free();
}

// Liens vers l'espace utilisateur
switch ( $autorisation )  {
  // Si pas encore connecté
  case 0:
    $menu .= "
    <div>
      <h3>Espace utilisateur</h3>
      <a href=\"connect\">Se connecter</a>
    </div>";
    break;
  // Si compte élève
  case 1:
    $notes = '';
    $resultat = $mysqli->query("SELECT cle, nom FROM matieres WHERE notes ORDER BY ordre");
    while ( $r = $resultat->fetch_assoc() )
      $notes .= "\n      <a href=\"notes?${r['cle']}\">Mes notes de colles en ${r['nom']}</a>";
    $resultat->free();
    $menu .= "
    <div>
      <h3>Espace utilisateur</h3>
      <a href=\"prefs\">Mes préférences</a>$notes
      <a href=\"connect?deconnexion\">Se déconnecter</a>
      
    </div>";
    break;
  // Si compte colleur/professeur
  default:
    // Si une seule matière, pas de matière à spécifier pour l'ajout de notes de colles
    if ( is_numeric($_SESSION['matieres']) )  {
      if ( substr($p,0,5) == 'notes' )
        $p = 'notes';
      $notes = "\n      <a href=\"notes\">Ajouter des notes de colles</a>";
    }
    else  {
      $notes = '';
      $resultat = $mysqli->query("SELECT cle, nom FROM matieres WHERE FIND_IN_SET(id,'${_SESSION['matieres']}')
                                  ORDER BY FIND_IN_SET(id,'${_SESSION['matieres']}')");
      while ( $r = $resultat->fetch_assoc() )
        $notes .= "\n      <a href=\"notes?${r['cle']}\">Ajouter des notes de colles en ${r['nom']}</a>";
      $resultat->free();
    }
    $menu .= "
    <div>
      <h3>Espace utilisateur</h3>
      <a href=\"prefs\">Mes préférences</a>$notes
      <a href=\"connect?deconnexion\">Se déconnecter</a>
      
    </div>";
}

// Affichage du menu
echo str_replace("a href=\"$p\"","a id=\"actuel\" href=\"$p\"",$menu);
?>

    <div>
      <a href="admin/">Administration du site</a>
    </div>
  </div>

<?php
// Affichage des informations récentes
$resultat = $mysqli->query('SELECT titre, lien FROM recents WHERE DATEDIFF(NOW(),heure) < 10 LIMIT 20');
if ( $resultat->num_rows )  {
  $aff = '';
  while ( $r = $resultat->fetch_assoc() )
    $aff .= "\n    <a href=\"${r['lien']}\" title=\"".substr($r['titre'],strpos($r['titre'],'>')+2)."\">${r['titre']}</a>";
  $resultat->free();
  echo <<<FIN
  <div id="recent">
    <h3><a href="rss" id="rss"><img class="icone" src="icones/rss.png" alt="Flux RSS"></a> Infos récentes </h3>$aff
  </div>


FIN;
}
?>
</div>

<div id="contenu">
<?php
// Conditionnement du message éventuel
if ( isset($message) )
  echo "\n  <div class=\"warning\">$message</div>\n";
?>
