<?php
// Script d'installation de Cahier de Prépa
// Aide à l'installation et à la configuration
// Vérifie l'existence de la base de données et des répertoires

// Headers HTML
$header = <<<FIN
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
  <title>Cahier de Prépa : installation</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <link rel="stylesheet" href="css/style.css" type="text/css" media="screen">
  <link rel="stylesheet" href="css/couleurs.css" type="text/css" media="screen">
  <script type="text/javascript" src="js/jquery.js"></script>
</head>
<body style="padding: 0px 5%;">

<h1>Cahier de Prépa&nbsp;: installation</h1>

FIN;
$footer = <<<FIN

</body>
</html>
FIN;

// Recharge de la page si elle est lancée par un autre script (donc config.php déjà appelé)
if ( defined('OK') )  {
  $proto = ( $GLOBALS['https'] ) ? 'https://' : 'http://';
  header("Location: $proto${GLOBALS['site']}/installation");
  exit();
}

///////////////////////////////
// Première vérifications, bloquantes : le fichier de configuration est ok
///////////////////////////////
if ( file_exists('config.php') && is_readable('config.php') )
  include('config.php');
else
  exit($header.'<h3 class="warning admin">Le fichier de configuration n\'existe pas ou n\'est pas lisible. Il doit s\'appeler config.php, se trouver au même endroit que l\'ensemble des fichiers constituant le site et être lisible par l\'utilisateur d\'Apache (<code>'.`whoami | tr -d '\n'`.'</code>).</h3>'.$footer);
// Vérification des données du fichier de configuration
if ( !isset($site) || !isset($https) || !isset($serveur) || !isset($base) || !isset($mdp) )
  exit($header.'<h3 class="warning admin">Le fichier de configuration est incomplet, il manque des données nécessaire au fonctionnement du site. Il faut le modifier manuellement.</h3>'.$footer);
if ( strlen($base) > 12 )
  exit($header.'<h3 class="warning admin">Le nom de la base de données est trop long. Il ne doit pas être supérieur à 12 caractères. Il faut corriger cela dans le fichier de configuration manuellement.</h3>'.$footer);

///////////////////////////////
// Connexion obligatoire à partir d'ici, en entrant le mot de passe du fichier de configuration
///////////////////////////////
session_name(md5("$site-install"));
session_set_cookie_params(0,strchr($site,'/').'/',str_replace(strchr($site,'/'),'',$site));
session_start();
if ( isset($_REQUEST['motdepasse']) && ( $_REQUEST['motdepasse'] == $mdp ) )  {
  // Interdiction de garder son identifiant de session
  session_regenerate_id(true);
  $_SESSION = array();
  // Pour vérification aux connexions ultérieures
  $_SESSION[md5("$site")] = true;
  $_SESSION['client'] = $_SERVER['HTTP_USER_AGENT'];
  $_SESSION['ip'] = $_SERVER['REMOTE_ADDR'];
  $_SESSION['time'] = time()+600;
}
elseif ( !isset($_SESSION[md5("$site")]) || ( $_SESSION['time'] < time() ) || isset($_REQUEST['deconnexion']) || ( $_SESSION['client'] != $_SERVER['HTTP_USER_AGENT'] ) || ( $_SESSION['ip'] != $_SERVER['REMOTE_ADDR'] ) )  {
  // Suppression du cookie et des données de session
  $_SESSION = array();
  setcookie(session_name(),'',time()-3600);
  session_regenerate_id(true);
  echo <<<FIN
$header

<div class="item">
  <h3>Bienvenue sur <a href="http://cahier-de-prepa.fr">Cahier de Prépa</a> et merci d'essayer ce gestionnaire de site&nbsp;!</h3>
  <p><a href="http://cahier-de-prepa.fr">Cahier de Prépa</a> est un gestionnaire de sites web pour la communication des professeurs vers leurs élèves de CPGE. Il permet de&nbsp;:</p>
  <ul>
    <li>Faire passer des informations de façon rapide sur des thèmes précis grâce à des pages dédiées</li>
    <li>Annoncer le programme de colle (pour les élèves et les colleurs)</li>
    <li>Tenir à jour le cahier de texte</li>
    <li>Mettre à disposition les documents distribués ou non, de façon sécurisée</li>
    <li>Saisir et consulter des notes de colles</li>
  </ul>
</div>

<form class="warning admin" action="" method="post">
<h3>Pour aller plus loin, vous devez entrer le mot de passe contenu dans le fichier de configuration.</h3>
<p><input type="password" name="motdepasse"> <input type="submit" name="Ok" value="Envoyer"></p>
</form>
FIN;
  exit($footer);
}
// Tout est ok : session valide pendant 10 minutes
else
  $_SESSION['time'] = time()+600;

////////////////////////////
// Fabrication de la base //
////////////////////////////

// Vérification de la connexion. Pas de connexion signifie qu'il faut réaliser l'installation
$mysqli = new mysqli($serveur,$base,$mdp);
if ( $mysqli->connect_errno || !($mysqli->select_db($base)) )  {
  $message = '';
  
  //////////////////////////////
  // Récupération des données //
  //////////////////////////////
  if ( isset($_REQUEST['mdproot']) )  {
    // Vérification du mot de passe root
    $mysqli = new mysqli($serveur,'root',$_REQUEST['mdproot'],'mysql');
    if ( $mysqli->connect_errno )
      $message = '<div class="warning">La connexion à la base de données est impossible. Le mot de passe root est certainement incorrect. Erreur MySQL n°'.$mysqli->connect_errno.', «'.$mysqli->connect_error.'».</div>';
    else  {
      // Validation des données
      $mysqli->set_charset('utf8');
      $genre = ( in_array($_REQUEST['genre'],array(1,2,3)) ) ? $_REQUEST['genre']+5 : 5;
      $prenom = mb_convert_case($mysqli->real_escape_string($_REQUEST['prenom']),MB_CASE_TITLE,'UTF-8');
      $nom = mb_convert_case($mysqli->real_escape_string($_REQUEST['nom']),MB_CASE_TITLE,'UTF-8');
      $mail = strtolower($mysqli->real_escape_string($_REQUEST['mail']));
      $mot_de_passe = sha1($_REQUEST['mot_de_passe']);
      // Login automatiquement généré
      $login = mb_strtolower(mb_substr($prenom,0,1,'UTF-8').str_replace(' ','_',$nom),'UTF-8');
      $nom_matiere = $mysqli->real_escape_string($_REQUEST['nom_matiere']);
      $cle_matiere = $mysqli->real_escape_string($_REQUEST['cle_matiere']);
      $titre = $mysqli->real_escape_string($_REQUEST['titre']);
      if ( !strlen($prenom) || !strlen($nom) || !filter_var($mail,FILTER_VALIDATE_EMAIL) || !strlen($mot_de_passe) || !strlen($nom_matiere) || !strlen($cle_matiere) || !strlen($titre) )
        $message = '<div class="warning">Toutes les données sont obligatoires. L\'adresse mail doit être valide.</div>';
      else  {
        // Traitement des données
        include('def_sql.php');
        $mysqli->set_charset('utf8');
        $mysqli->multi_query($requete);
        if ( $mysqli->errno )  {
          $message = 'Quelque chose n\'a pas fonctionné. Erreur MySQL n°'.$mysqli->errno.', «'.$mysqli->error.'».';
          $mysqli->close();
        }
        else  {
          $mysqli->close();
          sleep(1);
          $mysqli = new mysqli($serveur,$base,$mdp,$base);
        }
        if ( $mysqli->connect_errno )
          $message = '<div class="warning">La requête semble avoir fonctionné, mais la connexion à la base n\'est pas possible. Erreur MySQL n°'.$mysqli->connect_errno.', «'.$mysqli->connect_error.'».</div>';
      }
    }
  }

  ////////////////////////////////////////////
  // Formulaire de récupération des données //
  ////////////////////////////////////////////
  if ( !isset($_REQUEST['mdproot']) || strlen($message) )  {
    echo <<<FIN
$header
$message
<form action="" method="post">
<div class="item"><input class="bouton" type="submit" name="ok" value="Envoyer"></div>

<div class="item">
  <h3>Mot de passe root MySQL</h3>
  <p>La création des tables de la base de données nécessite les droits d'administrateur sur le serveur. Inscrivez ci-dessous le mot de passe root du serveur <code>MySQL</code>. Ce mot de passe n'est noté ni envoyé nulle part (à part au serveur MySQL défini dans le fichier de configuration).</p>
</div>

<div class="warning">
  <p class="ligne"><label for="mdproot">Mot de passe root du serveur MySQL&nbsp;: </label><input type="password" name="mdproot" id="mdproot"></p>
</div>

<div class="item">
  <h3>Création d'un compte professeur</h3>
  <p>Entrez ci-dessous les coordonnées d'un des professeurs de la classe. Il pourra, une fois connecté, créer les autres comptes</p>
</div>

<div class="warning">
  <p class="ligne"><label for="genre">M&nbsp;/&nbsp;Mme&nbsp;/&nbsp;Melle&nbsp;:</label>
    <select name="genre" id="genre">
      <option value="1">M.</option>
      <option value="2">Mme</option>
      <option value="3">Melle</option>
    </select>
  </p>
  <p class="ligne"><label for="prenom">Prénom&nbsp;: </label><input type="text" id="prenom" name="prenom" value="" size="50"></p>
  <p class="ligne"><label for="nom">Nom&nbsp;: </label><input type="text" id="nom" name="nom" value="" size="50"></p>
  <p class="ligne"><label for="mail">Adresse mail&nbsp;: </label><input type="text" id="mail" name="mail" value="" size="50"></p>
  <p class="ligne"><label for="mot_de_passe">Mot de passe temporaire&nbsp;: </label><input type="text" id="mot_de_passe" name="mot_de_passe" value=""></p>
  <p>Le mot de passe ci-dessus reste affiché en clair : il est temporaire, sera obligatoirement modifié à la première connexion de l'utilisateur. On peut se permettre de mettre un mot de passe simple.</p>
</div>

<div class="item">
  <h3>Création d'une première matière</h3>
  <p>Afin de faciliter la première rencontre avec l'interface d'administration, nous allons créer une matière qui sera associée au compte défini ci-dessus.</p>
  <ul>
    <li>Le <em>nom complet</em> s'affichera dans le menu et dans les titres des pages. Mettez une majuscule au début.</li>
    <li>La <em>clé dans l'adresse</em> est un mot-clé utilisé uniquement dans l'adresse des pages associées à la matière. Il vaut mieux que ce soit un mot unique, court et sans majuscule. Par exemple, «&nbsp;maths&nbsp;», «&nbsp;phys&nbsp;»...</li>
  </ul>
</div>

<div class="warning">
  <p class="ligne"><label for="nom_matiere">Nom complet&nbsp;: </label><input type="text" id="nom_matiere" name="nom_matiere" value="" size="50"></p>
  <p class="ligne"><label for="cle_matiere">Clé dans l'adresse&nbsp;: </label><input type="text" id="cle_matiere" name="cle_matiere" value=""" size="30"></p>
</div>

<div class="item">
  <h3>Titre du site</h3>
  <p>Il faut enfin renseigner ici le titre du site, qui sera aussi celui de la page d'accueil. Il sera modifiable par les professeurs après la création.</p>
</div>

<div class="warning">
  <p class="ligne"><label for="titre">Titre du site&nbsp;: </label><input type="text" id="titre" name="titre" value="" size="80"></p>
</div>

<div class="item"><input class="bouton" type="submit" name="ok" value="Envoyer"></div>
</form>
$footer
FIN;
  exit();
  }
}

/////////////////////////////////////
// Vérifications de l'installation //
/////////////////////////////////////
function affiche($message,$status)  {
  if ( $status )
    echo "\n<div class=\"item admin cdt\"><p><img class=\"icone\" src=\"icones/ok.png\">$message</p></div>\n";
  else
    echo "\n<div class=\"item admin cdt\"><p><img class=\"icone\" src=\"icones/no.png\">$message</p></div>\n";
}

// Si on est arrivé ici, la base est nécessairement créée.
echo <<<FIN
$header
<div class="warning admin">
  <p>Votre Cahier de Prépa semble correctement installé. Vous pouvez vous en servir immédiatement&nbsp;:</p>
  <p>Partie publique&nbsp;: <a href="http://$site">http://$site/</a></p>
  <p>Interface d'adminstration&nbsp;: <a href="http://$site/admin/">http://$site/admin/</a></p>
</div>

FIN;

// Récupération du login si on vient de créer la base
$resultat = $mysqli->query('SELECT login FROM utilisateurs WHERE id = 1 AND genre > 5');
if ( $resultat->num_rows )  {
  $r = $resultat->fetch_assoc();
  echo "\n<div class=\"item admin cdt\"><p>L'identifiant du compte professeur créé est ${r['login']} (sans majucule).</p></div>\n";
  $resultat->free();
}

// Connexion en lecture
affiche('Connexion à la base de donnée en lecture',1);

// Connexion en écriture
$mysqli->close();
$mysqli = new mysqli($serveur,"$base-adm",$mdp,$base);
affiche('Connexion à la base de donnée en écriture', !($mysqli->connect_errno));
if ( !($mysqli->connect_errno) )
  $mysqli = new mysqli($serveur,$base,$mdp,$base);

// Tables dans la base de données
$resultat = $mysqli->query('SHOW TABLES');
$tables = array('cdt','cdt-seances','cdt-types','colles','docs','infos','matieres','notes','pages','recents','reps','semaines','utilisateurs');
if ( $resultat->num_rows )  {
  while ( $r = $resultat->fetch_row() )  $tables = array_diff($tables,$r);
  $resultat->free();
}
affiche('Définition des tables',empty($tables));

// La base de données doit contenir au moins un utilisateur
$resultat = $mysqli->query('SELECT id FROM utilisateurs WHERE autorisation = 3 LIMIT 1');
affiche('Présence d\'au moins un utilisateur de type professeur',$resultat->num_rows);
$resultat->free();

// La base de données doit contenir la page d'identifiant 1
$resultat = $mysqli->query('SELECT id FROM pages WHERE id = 1');
affiche('Présence de la page d\'accueil',$resultat->num_rows);
$resultat->free();

// La base de données doit contenir la page d'identifiant 1
$resultat = $mysqli->query('SELECT id FROM reps WHERE id = 1');
affiche('Présence du répertoire Général',$resultat->num_rows);
$resultat->free();

// La base de données doit contenir 44 semaines en 2014
$resultat = $mysqli->query('SELECT id FROM semaines WHERE debut > \'2014-08-01\' AND debut < \'2015-08-01\'');
affiche('Définition des semaines',$resultat->num_rows == 44);
$resultat->free();
$mysqli->close();

// Vérification du répertoire "documents"
if ( !is_dir('documents') )
  affiche('Le répertoire «&nbsp;documents&nbsp;» n\'existe pas à la racine du site web.',0);
elseif ( !is_readable('documents') || !is_executable('documents') || !is_writable('documents') )
  affiche('Le répertoire «&nbsp;documents&nbsp;» n\'a pas les bons droits d\'accès. Il doit être accessible en lecture et en écriture. Vous pouvez taper en console&nbsp;:<br>
  <code>cd '.dirname($_SERVER['SCRIPT_FILENAME']).' && sudo chgrp '.`id -gn | tr -d '\n'`.' documents && sudo chmod g+w documents</code>',0);
else 
  affiche('Répertoire «&nbsp;documents&nbsp;» accessible en lecture et écriture',1);

// Vérification du répertoire "sauvegarde"
if ( !is_dir('sauvegarde') )
  affiche('Le répertoire «&nbsp;sauvegarde&nbsp;» n\'existe pas à la racine du site web.',0);
elseif ( !is_readable('sauvegarde') || !is_executable('sauvegarde') || !is_writable('sauvegarde') )
  affiche('Le répertoire «&nbsp;sauvegarde&nbsp;» n\'a pas les bons droits d\'accès. Il doit être accessible en lecture et en écriture. Vous pouvez taper en console&nbsp;:<br>
  <code>cd '.dirname($_SERVER['SCRIPT_FILENAME']).' && sudo chgrp '.`id -gn | tr -d '\n'`.' sauvegarde && sudo chmod g+w sauvegarde</code>',0);
else 
  affiche('Répertoire «&nbsp;sauvegarde&nbsp;» accessible en lecture et écriture',1);

// Vérification de la quantité de données téléchargeable
if ( '2M' == ini_get('upload_max_filesize') )
  affiche('Les documents envoyés ne pourront excéder 2&nbsp;Mo, ce qui est plutôt faible. Il serait bien d\'augmenter cette limite. Plus d\'informations sur la page <a href="http://cahier-de-prepa.fr/technique">technique</a> de cahier-de-prepa.fr.',0);
else
  affiche('La taille des documents envoyés peut aller jusqu\'à'.ini_get('upload_max_filesize').'o. Cela est modifiable dans la configuration du serveur web. Plus d\'informations sur la page <a href="http://cahier-de-prepa.fr/technique">technique</a> de cahier-de-prepa.fr.',1);

exit($footer);
?>
