<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php');

// L'accès est différent selon le type d'utilisateur, mais la connexion est obligatoire
$mysqli = premiere_connexion();
if ( !$autorisation )  {
  $p = 'notes';
  $t = 'Notes de colles';
  include('login.php');
}

////////////////////////////////////////
// Validation de la requête : matière //
////////////////////////////////////////

// Recherche de la matière concernée (affichage seulement si des notes existent)
$mysqli = premiere_connexion();
$requete = ( $autorisation > 1 ) ? "SELECT id, cle, nom FROM matieres WHERE FIND_IN_SET(id,'${_SESSION['matieres']}')" : 'SELECT id, cle, nom FROM matieres WHERE notes';
$resultat = $mysqli->query($requete);
if ( $resultat->num_rows )  {
  if ( !empty($_REQUEST) )
    while ( $r = $resultat->fetch_assoc() )
      if ( isset($_REQUEST[$r['cle']]) )  {
        $matiere = $r;
        break;
      }
  // Matière par défaut : la première
  if ( !isset($matiere) )  {
    $resultat->data_seek(0);
    $matiere = $resultat->fetch_assoc();
  }
  $resultat->free();
}
// Si aucune note n'est enregistrée pour aucune matière
else  {
  $mysqli->close();
  exit('Cette page ne contient aucune information.');
}

// Si colleurs/profs : ajout de notes de colles -> admin/notes-saisie.php
// Si élèves : on continue ici
if ( $autorisation > 1 )  {
  $mid = $matiere['id'];
  include('admin/fonctions.php');
  include('admin/notes-saisie.php');
  $mysqli->close();
  // Aide et javascript pour le pliage et les boutons
?>

  <div class="item aide">
    <h3>Aide et explications</h3>
    <p>Vous pouvez ajouter ou modifier des notes. Attention, un élève ne peut avoir plus d'une note dans la même matière une même semaine&nbsp;: si vous ajouter une telle note, elle ne sera pas validée.</p>
    <p>Pour ajouter des notes sur une nouvelle semaine, vous devez obligatoirement sélectionner une semaine où vous n'avez pas encore mis de note. Il n'y a pas de limite de nombre d'élèves collés par semaine (toutes les notes d'une semaine sont à entrer en une seule fois).</p>
    <p>Les notes déjà mises peuvent être modifiées&nbsp;: soit déplacées à une autre semaine, soit modifiées sur place, soit les deux simultanément.</p>
    <p>Il est aussi possible de <em>supprimer</em> l'ensemble des notes d'une semaine.</p>
  </div>
<?php
  echo $aff;
?>

<script type="text/javascript">
$( function() {
  // Pliage des items
  $('.item h3').append(' <span>déplier</span>');
  $('span').click( function () {
    $(this).parent().parent().children(':not(h3)').toggle();
    $(this).text($(this).text() == 'déplier' ? 'replier' : 'déplier');
  });
  // Premier pliage
  $('.item form, .aide').children(':not(h3)').hide();
  
});
</script>

<?php
  // Bas de page
  include('bas.php');
  exit();
}
else  {
  // Fonction d'affichage des semaines
  function format_date($date)  {
    $semaine = array('dimanche','lundi','mardi','mercredi','jeudi','vendredi','samedi');
    $mois = array('','janvier','février','mars','avril','mai','juin','juillet','août','septembre','octobre','novembre','décembre');
    return $semaine[substr($date,0,1)].' '.substr($date,7).' '.$mois[intval(substr($date,5,2))].' '.substr($date,1,4);
  }
}

////////////
/// HTML ///
////////////
$p = "notes?${matiere['cle']}";
$t = "Mes notes en ${matiere['nom']}";

// Haut de page, menu et message
include('haut.php');

// Récupération de l'ensemble des notes, semaines, colleurs
$resultat = $mysqli->query("SELECT DATE_FORMAT(s.debut,'%w%Y%m%e') AS d, n.note,
                            CONCAT( CASE MOD(u.genre,5) WHEN 1 THEN 'M. ' WHEN 2 THEN 'Mme ' WHEN 3 THEN 'Melle ' END, u.nom ) AS c
                            FROM notes AS n LEFT JOIN semaines AS s ON n.semaine=s.id LEFT JOIN utilisateurs AS u ON n.colleur=u.id
                            WHERE n.eleve = ${_SESSION['id']} AND n.matiere = ${matiere['id']} ORDER BY s.id");

// Affichage des notes concernées
if ( $resultat->num_rows )  {
  while ( $r = $resultat->fetch_assoc() )
    echo '  <div class="item"><h3>Semaine du '.format_date($r['d'])."</h3><p>${r['note']} (${r['c']})</p></div>\n\n";
  $resultat->free();
}
else
  echo "  <h2>Vous n'avez encore aucune note cette année en ${matiere['nom']}.</h2>\n\n";
$mysqli->close();

// Bas de page
include('bas.php');
?>
