<?php
// Sécurité et récupération des données de configuration
define('OK',1);
include('debut.php');

$p = 'prefs';
$t = 'Cahier de Prépa - Mon compte';
$mysqli = premiere_connexion();
// Vérification que l'on est bien connecté
if ( !$autorisation )
  include('login.php');

// Récupération des données de l'utilisateur
$resultat = $mysqli->query("SELECT login, nom, prenom, mdp, genre, mail, timeout
                            FROM utilisateurs WHERE id = '${_SESSION['id']}'");
$u = $resultat->fetch_assoc();
$resultat->free();

///////////////////
// Modifications //
///////////////////
if ( isset($_REQUEST['modifie']) )  {

  // Vérification du mot de passe
  if ( ( sha1($_REQUEST['mdp0']) != $u['mdp'] ) && ( $u['mdp'] != 'pas de mot de passe' ) )
    $message = 'Le mot de passe fourni est incorrect. Les modifications n\'ont pas été effectuées.';
  else  {

    // Fonctions de connexion/enregistrement
    include('admin/fonctions.php');

    $requete = array();
    $modif = array();
    // Validation des données envoyées
    $login = $mysqli->real_escape_string($_REQUEST['login']);
    $prenom = mb_convert_case($mysqli->real_escape_string($_REQUEST['prenom']),MB_CASE_TITLE,'UTF-8');
    $nom = mb_convert_case($mysqli->real_escape_string($_REQUEST['nom']),MB_CASE_TITLE,'UTF-8');
    $mail = strtolower($mysqli->real_escape_string($_REQUEST['mail']));
    if ( in_array($genre = $_REQUEST['genre'],array(1,2,3)) && ( $genre != $u['genre'] ) )  {
      $u['genre'] = $genre;
      $requete[] = "genre = $genre";
      $modif[] = 'genre';
    }
    if ( strlen($login) && ( $login != $u['login'] ) )  {
      // Vérification que le login n'existe pas déjà
      $resultat = $mysqli->query("SELECT id FROM utilisateurs WHERE login = '$login'");
      if ( $resultat->num_rows )
        $resultat->free();
      else  {
        $u['login'] = $login;
        $requete[] = "login = '$login'";
        $modif[] = 'identifiant';
        $_SESSION['login'] = $login;
      }
    }
    if ( strlen($nom) && ( $nom != $u['nom'] ) )  {
      $u['nom'] = $nom;
      $requete[] = "nom = '$nom'";
      $modif[] = 'nom';
    }
    if ( strlen($prenom) && ( $prenom != $u['prenom'] ) )  {
      $u['prenom'] = $prenom;
      $requete[] = "prenom = '$prenom'";
      $modif[] = 'prénom';
    }
    if ( ( $mail != $u['mail'] ) && ( filter_var($mail,FILTER_VALIDATE_EMAIL) || !strlen($mail) ) )  {
      $u['mail'] = $mail;
      $requete[] = "mail = '$mail'";
      $modif[] = 'mail';
    }
    if ( strlen($mdp1 = $_REQUEST['mdp1']) && ( $mdp1 == $_REQUEST['mdp2'] ) && ( ( $mdp1 = sha1($mdp1) ) != $u['mdp'] ) )  {
      $u['mdp'] = $mdp1;
      $requete[] = "mdp = '$mdp1'";
      $modif[] = 'mot de passe';
    }
    if ( is_numeric( $timeout = $_REQUEST['timeout'] ) && ( $timeout != $u['timeout'] ) )  {
      if ( $timeout < 60 )
        $timeout = 60;
      $u['timeout'] = $timeout;
      $requete[] = "timeout = $timeout";
      $modif[] = 'temps de connexion';
      $_SESSION['timeout'] = $timeout;
    }
    if ( !empty($requete) )  {
      $requete = implode(', ',$requete);
      $modif = implode(', ',$modif);
      // Connexion à la base de données avec les droits d'écriture
      $mysqli->close();
      $mysqli = mysql_ecriture();
      if ( requete('utilisateurs',"UPDATE utilisateurs SET $requete WHERE id = ${_SESSION['id']}") )
        $message = "Les modifications ($modif) ont bien été réalisées.";
    }
  }
}

//////////////
//// HTML ////
//////////////

// Plus de mot de passe : remise à zéro suite à une demande de mot de passe oublié
if ( $u['mdp'] == 'pas de mot de passe' )  {
  $message = 'IMPORTANT : votre mot de passe a été réinitialisé. Vous devez absolument le redéfinir ci-dessous.';
  $mdp0 = '    <input type="hidden" name="mdp0" value="réinitialisé">';
  $mdp_message = '';
}
else  {
  $mdp0 = '    <p class="ligne"><label for="mdp0">Mot de passe actuel&nbsp;: </label><input type="password" id="mdp0" name="mdp0" value=""></p>';
  $mdp_message = '    <p>Le mot de passe actuel doit être obligatoirement fourni.</p>';
}

// Haut de page, menu et message
include('haut.php');
$mysqli->close();

// Formulaire des données
$select_genre = str_replace("\"${u['genre']}\"","\"${u['genre']}\" selected",'
        <option value="1">M.</option>
        <option value="2">Mme</option>
        <option value="3">Melle</option>');

echo <<<FIN
  <div class="item admin">
  <form action="" method="post">
    <input class="bouton" type="submit" name="modifie" value="Valider" title="Valider les modifications">
    <h3>Modifier mon compte</h3>
    <p class="ligne"><label for="genre">M-Mme-Melle&nbsp;:</label>
      <select name="genre" id="genre">$select_genre
      </select>
    </p>
    <p class="ligne"><label for="login">Identifiant&nbsp;: </label><input type="text" id="login" name="login" value="${u['login']}" size="50"></p>
    <p class="ligne"><label for="prenom">Prénom&nbsp;: </label><input type="text" id="prenom" name="prenom" value="${u['prenom']}" size="50"></p>
    <p class="ligne"><label for="nom">Nom&nbsp;: </label><input type="text" id="nom" name="nom" value="${u['nom']}" size="50"></p>
    <p class="ligne"><label for="mail">Adresse mail&nbsp;: </label><input type="text" id="mail" name="mail" value="${u['mail']}" size="50"></p>
$mdp0
    <p class="ligne"><label for="mdp1">Nouveau mot de passe&nbsp;: </label><input type="password" id="mdp1" name="mdp1" value=""></p>
    <p class="ligne"><label for="mdp2">Confirmation&nbsp;: </label><input type="password" id="mdp2" name="mdp2" value=""></p>
    <p class="ligne"><label for="timeout">Temps de déconnexion&nbsp;: </label><input type="text" id="timeout" name="timeout" value="${u['timeout']}" size="5"></p>
  </form>
$mdp_message
  </div>


FIN;

// Bas de page
include('bas.php');
?>
